/*
 * Decompiled with CFR 0.152.
 */
package p11cat;

import java.io.File;
import p11cat.Constants;
import p11cat.controller.EnableAction;
import p11cat.view.P11CAT;
import p11cat.view.SlotTable;
import p11cat.view.StatusTable;

public class StatusInfo {
    private P11CAT p11cat;
    private StatusTable statusTable;
    private SlotTable slotTable;
    private File lastDirectory = null;

    public StatusInfo(P11CAT p11CAT, StatusTable statusTable, SlotTable slotTable) {
        this.p11cat = p11CAT;
        this.statusTable = statusTable;
        this.slotTable = slotTable;
    }

    public void registerActionAtSlotTable(EnableAction enableAction) {
        this.slotTable.registerAction(enableAction);
    }

    public File getLastDirectory() {
        return this.lastDirectory;
    }

    public void setLastDirectory(File file) {
        this.lastDirectory = file;
    }

    public long getSelectedSlotId() {
        return this.slotTable.getSelectedSlotId();
    }

    public long getActiveSlotId() {
        return this.slotTable.getActiveSlotId();
    }

    public Constants.InitStatus getTokenInitStatus() {
        return this.slotTable.getCurrentTokenInitStatus();
    }

    public Constants.InitStatus getPinInitStatus() {
        return this.slotTable.getCurrentPinInitStatus();
    }

    public long getLoginStatus() {
        return SlotTable.getCurrentAuthState();
    }

    public void setLoginStatus(long l) {
        this.slotTable.updateLoginStatus(l);
    }

    public void update() {
        this.slotTable.updateSelectedRow();
    }

    public void printInfo(String string, long l) {
        this.statusTable.printInfo(string, l);
    }

    public void printError(String string, long l) {
        this.statusTable.printError(string, l);
    }

    public void printException(Exception exception, long l) {
        this.statusTable.printException(exception, l);
        if (exception.getMessage().indexOf("CKR_USER_NOT_LOGGED_IN") >= 0) {
            this.slotTable.logout(false);
        }
    }

    public void setWaitCursor() {
        this.p11cat.setWaitCursor();
    }

    public void setDefaultCursor() {
        this.p11cat.setDefaultCursor();
    }

    public void enableSlotTable(boolean bl) {
        this.slotTable.setEnabled(bl);
    }

    public void softlockSlotTable(boolean bl) {
        this.slotTable.setSoftlocked(bl);
    }
}

