/*
 * Decompiled with CFR 0.152.
 */
package cat;

import cat.CAT;
import cat.CSJApi;
import cat.Global;
import cat.IniSettings;
import cat.SessionTimer;
import cat.Tools;
import cat.ToolsThread;
import java.awt.Color;
import java.awt.SystemColor;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutionException;
import javax.swing.SwingWorker;

public class StatusNew {
    static ToolsThread tools_thread = new ToolsThread();
    IniSettings ini = new IniSettings();
    Tools tools = new Tools();
    static SessionTimer sess_timer = new SessionTimer();
    static Timer timer = new Timer(true);
    String strCurrentCSAddress;
    String strAnswGetState;
    String strAnswBattState;
    String strAnswShowAuth;
    String strAnswListFiles;
    String strAnswNTPConfig;
    boolean b_bootloader;
    boolean b_maintenance;
    boolean b_alarm;
    boolean b_batt_problem;
    boolean b_NTP_available;
    String strTemperature;
    String strMode;
    String strAlarm;
    String strBattery;
    String strAuthState;
    String strCSModel;
    int n_temperature;

    public void setNewValuesToStatusBar() {
        SwingWorker<Boolean, Integer> swingWorker = new SwingWorker<Boolean, Integer>(){

            @Override
            protected Boolean doInBackground() throws Exception {
                this.publish(1);
                if (!StatusNew.this.getConnection()) {
                    this.publish(0);
                    return false;
                }
                StatusNew.this.callCSFunctions();
                this.publish(0);
                return true;
            }

            @Override
            protected void process(List<Integer> list) {
                Integer n = list.get(list.size() - 1);
                tools_thread.start_stop_ProgBar(n);
            }

            @Override
            protected void done() {
                try {
                    if (!((Boolean)this.get()).booleanValue()) {
                        timer.cancel();
                        StatusNew.this.setInvalidHandleState();
                        return;
                    }
                    StatusNew.this.getInfFromCS();
                    StatusNew.this.checkSession();
                    CAT.SetHandleStatus(true);
                    CAT.SetLoginStatus(StatusNew.this.strAnswShowAuth);
                    StatusNew.this.setValuesToStausBar();
                    StatusNew.this.setBootloaderMaintenanceMode();
                    StatusNew.this.setAlarmColorAndMenu();
                    StatusNew.this.setTemperatureColor();
                    StatusNew.this.setBatteryColor();
                    StatusNew.this.setMenuEntryState();
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
                catch (ExecutionException executionException) {
                    executionException.printStackTrace();
                }
            }
        };
        swingWorker.execute();
    }

    private boolean getConnection() {
        this.strCurrentCSAddress = this.ini.GetCSCurrentDevice();
        if (this.strCurrentCSAddress.length() == 0) {
            return false;
        }
        this.strAnswGetState = CSJApi.CSGetState();
        return this.strAnswGetState.indexOf("Error") != 0;
    }

    private void callCSFunctions() {
        this.strAnswBattState = CSJApi.CSGetBattStateEx();
        this.strAnswShowAuth = CSJApi.CSShowAuthState();
        this.strAnswListFiles = CSJApi.CSListFiles();
        this.strAnswNTPConfig = CSJApi.CSNTPGetConfig();
        Global.cs_model = CSJApi.CSGetModel();
    }

    private void getInfFromCS() {
        this.b_bootloader = this.tools.GetBootloaderMode(this.strAnswGetState);
        this.b_maintenance = this.tools.GetMaintenanceMode(this.strAnswGetState);
        this.b_alarm = this.tools.GetAlarmState(this.strAnswGetState);
        this.b_batt_problem = this.tools.GetBatteryProblem(this.strAnswBattState);
        this.b_NTP_available = this.tools.GetNTPMdlState(this.strAnswNTPConfig);
        this.strTemperature = this.tools.GetCSTemperatureValueEx(this.strAnswGetState);
        this.strMode = this.tools.GetCSMode(this.strAnswGetState);
        this.strAlarm = this.tools.GetAlarmStateText(this.strAnswGetState);
        this.strBattery = this.tools.GetBatteryState(this.strAnswBattState);
        this.strAuthState = this.tools.GetAuthState(this.strAnswShowAuth);
    }

    private void setValuesToStausBar() {
        CAT.jTxtStatCSMode.setText(this.strMode);
        CAT.jTxtAuthState.setText(this.strAuthState);
        CAT.jTxtStatCSTemp.setText(this.strTemperature);
        CAT.jTxtStatCSAlarm.setText(this.strAlarm);
        CAT.jTxtStatCSBatt.setText(this.strBattery);
    }

    private void setInvalidHandleState() {
        CAT.jTxtStatCSMode.setText("-------");
        CAT.jTxtAuthState.setText("--------");
        CAT.jtxtSessionTime.setText("--------");
        CAT.jTxtStatCSTemp.setText("--------");
        CAT.jTxtStatCSAlarm.setText("--------");
        CAT.jTxtStatCSBatt.setText("--------");
        CAT.jTxtStatCSBatt.setBackground(SystemColor.control);
        CAT.jTxtStatCSAlarm.setBackground(SystemColor.control);
        CAT.jTxtStatCSTemp.setBackground(SystemColor.control);
        CAT.SetHandleStatus(false);
    }

    private void checkSession() {
        if (this.strAuthState.indexOf("00000000") == -1 && this.strAuthState.indexOf("--------") == -1) {
            StatusNew.sess_timer.internal_timer = timer;
            StatusNew.sess_timer.count = 898;
            timer.cancel();
            sess_timer = new SessionTimer();
            timer = new Timer(true);
            timer.schedule((TimerTask)sess_timer, 0L, 1000L);
        } else {
            timer.cancel();
            CAT.jTxtAuthState.setText(this.strAuthState);
            CAT.jtxtSessionTime.setForeground(Color.BLACK);
            CAT.jtxtSessionTime.setText("Session: ---");
        }
    }

    private void setBootloaderMaintenanceMode() {
        if (this.b_bootloader) {
            CAT.SetBootloaderStatus();
        }
        if (this.b_maintenance) {
            CAT.SetMaintenanceStatus();
        }
    }

    private void setAlarmColorAndMenu() {
        if (this.b_alarm) {
            CAT.jTxtStatCSAlarm.setBackground(Color.red);
            if (Global.b_20000000_login || Global.b_02000000_login) {
                CAT.jMenuItemResetAlarm.setEnabled(true);
            }
        } else {
            CAT.jTxtStatCSAlarm.setBackground(SystemColor.control);
            CAT.jMenuItemResetAlarm.setEnabled(false);
        }
    }

    private void setTemperatureColor() {
        this.n_temperature = this.tools.GetCSTemperatureValue(this.strAnswGetState);
        if (this.n_temperature != -1) {
            if (this.n_temperature < Global.temperature_low_red || this.n_temperature > Global.temperature_high_red) {
                CAT.jTxtStatCSTemp.setBackground(Color.red);
            } else if (this.n_temperature < Global.temperature_low_orange || this.n_temperature > Global.temperature_high_orange) {
                CAT.jTxtStatCSTemp.setBackground(Color.orange);
            } else {
                CAT.jTxtStatCSTemp.setBackground(SystemColor.control);
            }
        }
    }

    private void setBatteryColor() {
        if (this.b_batt_problem) {
            CAT.jTxtStatCSBatt.setBackground(Color.red);
        } else {
            CAT.jTxtStatCSBatt.setBackground(SystemColor.control);
        }
    }

    private void setMenuEntryState() {
        CAT.jMenuItemAudit.setEnabled(true);
        CAT.jMenuManagAuditLog.setEnabled(true);
        CAT.jMenuItemAuditConfig.setEnabled(true);
    }
}

