/*
 * Decompiled with CFR 0.152.
 */
package cat;

import cat.CAT;
import cat.CSJApi;
import cat.GUILock;
import cat.Tools;
import cat.ToolsThread;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingWorker;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.DefaultCaret;

public class SmartCardMgmt
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JTabbedPane jTabbedPane = null;
    private JButton jBtClose = null;
    private JButton jBtAction = null;
    Tools tools = new Tools();
    static ToolsThread tools_thread = new ToolsThread();
    CAT admin;
    int key_type;
    int key_size;
    String str_Owner;
    int n_Backups;
    final String connectPPReader = "Please connect the PIN pad reader to the host PC.";
    final String pinPadReady = "\u2014 Ready \u2014";
    final String howToCancel = "To cancel the operation, press CANCEL on the PIN pad.";

    public SmartCardMgmt(CAT cAT) {
        super(cAT);
        this.admin = cAT;
        this.initialize();
    }

    private void initialize() {
        this.setSize(633, 448);
        this.setMinimumSize(new Dimension(600, 350));
        this.setTitle("Smartcard Token Management");
        this.setContentPane(this.getJContentPane());
        this.key_type = 1;
        this.key_size = 2048;
        this.str_Owner = "";
        this.n_Backups = 1;
    }

    private JPanel getJContentPane() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.setPreferredSize(new Dimension(600, 400));
        jPanel.setMinimumSize(new Dimension(468, 350));
        jPanel.add((Component)this.getJPanelNorth(), "North");
        jPanel.add((Component)this.getJPanelWest(), "West");
        jPanel.add((Component)this.getJPanelEast(), "East");
        jPanel.add((Component)this.getJPanelSouth(), "South");
        jPanel.add((Component)this.getJPanelCenter(), "Center");
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SmartCardMgmt.this.setVisible(false);
            }
        };
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0);
        jPanel.registerKeyboardAction(actionListener, keyStroke, 2);
        WindowAdapter windowAdapter = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                SmartCardMgmt.this.dispose();
            }
        };
        this.addWindowListener(windowAdapter);
        return jPanel;
    }

    private JPanel getJPanelNorth() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setPreferredSize(new Dimension(10, 10));
        return jPanel;
    }

    private JPanel getJPanelWest() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setPreferredSize(new Dimension(10, 10));
        return jPanel;
    }

    private JPanel getJPanelEast() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setPreferredSize(new Dimension(10, 10));
        return jPanel;
    }

    private JPanel getJPanelSouth() {
        FlowLayout flowLayout = new FlowLayout();
        flowLayout.setAlignment(2);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(flowLayout);
        jPanel.setPreferredSize(new Dimension(10, 43));
        jPanel.add((Component)this.getJBtAction(), null);
        jPanel.add((Component)this.getJBtClose(), null);
        return jPanel;
    }

    private JPanel getJPanelCenter() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridx = 0;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setPreferredSize(new Dimension(600, 400));
        jPanel.add((Component)this.getJTabbedPane(), gridBagConstraints);
        return jPanel;
    }

    private JTabbedPane getJTabbedPane() {
        if (this.jTabbedPane != null) {
            return this.jTabbedPane;
        }
        this.jTabbedPane = new JTabbedPane();
        this.jTabbedPane.setPreferredSize(new Dimension(480, 360));
        this.jTabbedPane.addTab("Generate with Backup", null, this.getJPanelGen(), null);
        this.jTabbedPane.addTab("Restore RSA", null, this.getJPanelRestoreRSA(), null);
        this.jTabbedPane.addTab("Restore EC", null, this.getJPanelRestoreEC(), null);
        this.jTabbedPane.addTab("Copy", null, this.getJPanelCopy(), null);
        this.jTabbedPane.addTab("Generate on Card", null, this.getJPanelGenOnCard(), null);
        this.jTabbedPane.addTab("Change PIN", null, this.getJPanelPIN(), null);
        this.jTabbedPane.addTab("Info", null, this.getJPanelInfo(), null);
        return this.jTabbedPane;
    }

    private JPanel getJPanelGen() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.insets = new Insets(8, 8, 15, 8);
        gridBagConstraints.gridx = 0;
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridwidth = 2;
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.insets = new Insets(0, 0, 15, 0);
        gridBagConstraints2.gridy = 6;
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.fill = 1;
        gridBagConstraints3.gridy = 5;
        gridBagConstraints3.weightx = 1.0;
        gridBagConstraints3.anchor = 17;
        gridBagConstraints3.insets = new Insets(0, 0, 0, 250);
        gridBagConstraints3.gridx = 1;
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridx = 0;
        gridBagConstraints4.insets = new Insets(0, 8, 0, 15);
        gridBagConstraints4.anchor = 17;
        gridBagConstraints4.gridy = 5;
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.gridx = 1;
        gridBagConstraints5.insets = new Insets(15, 0, 25, 15);
        gridBagConstraints5.anchor = 17;
        gridBagConstraints5.gridwidth = 3;
        gridBagConstraints5.weightx = 1.0;
        gridBagConstraints5.fill = 2;
        gridBagConstraints5.gridy = 1;
        GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
        gridBagConstraints6.gridx = 0;
        gridBagConstraints6.anchor = 17;
        gridBagConstraints6.insets = new Insets(15, 8, 25, 15);
        gridBagConstraints6.gridy = 1;
        GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
        gridBagConstraints7.fill = 1;
        gridBagConstraints7.gridy = 4;
        gridBagConstraints7.weightx = 1.0;
        gridBagConstraints7.insets = new Insets(0, 0, 10, 250);
        gridBagConstraints7.gridx = 1;
        GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
        gridBagConstraints8.gridx = 0;
        gridBagConstraints8.insets = new Insets(0, 8, 10, 15);
        gridBagConstraints8.anchor = 17;
        gridBagConstraints8.gridy = 4;
        GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
        gridBagConstraints9.gridx = 0;
        gridBagConstraints9.insets = new Insets(0, 8, 10, 15);
        gridBagConstraints9.anchor = 17;
        gridBagConstraints9.gridy = 3;
        GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
        gridBagConstraints10.gridwidth = 3;
        gridBagConstraints10.fill = 1;
        gridBagConstraints10.gridy = 3;
        gridBagConstraints10.weightx = 1.0;
        gridBagConstraints10.insets = new Insets(0, 0, 10, 8);
        gridBagConstraints10.gridx = 1;
        int[] nArray = new int[9];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = 1024 + i * 128;
        }
        JComboBox jComboBox = this.getJCbRSASize(nArray);
        JRadioButton jRadioButton = this.getJRdRSA(jComboBox);
        JRadioButton jRadioButton2 = this.getJRdEC();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEtchedBorder(1));
        jPanel.add((Component)this.getJTxtKeyInfo(), gridBagConstraints10);
        jPanel.add((Component)new JLabel("Key-Info"), gridBagConstraints9);
        jPanel.add((Component)new JLabel("RSA Key Length (bits)"), gridBagConstraints8);
        jPanel.add((Component)jComboBox, gridBagConstraints7);
        jPanel.add((Component)jRadioButton, gridBagConstraints6);
        jPanel.add((Component)jRadioButton2, gridBagConstraints5);
        jPanel.add((Component)new JLabel("Number of Backups"), gridBagConstraints4);
        jPanel.add((Component)this.getJCbNoBackups(), gridBagConstraints3);
        jPanel.add((Component)new JLabel("(2 smartcards per backup)"), gridBagConstraints2);
        jPanel.add((Component)this.getJScrollPaneMsgGen(this.getJTextArea()), gridBagConstraints);
        jPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent componentEvent) {
                SmartCardMgmt.this.jBtAction.setText("Generate");
            }
        });
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton);
        buttonGroup.add(jRadioButton2);
        return jPanel;
    }

    private JPanel getJPanelGenOnCard() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.insets = new Insets(8, 8, 15, 8);
        gridBagConstraints.gridx = 0;
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.insets = new Insets(15, 0, 25, 15);
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.gridwidth = 3;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.gridy = 1;
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.anchor = 17;
        gridBagConstraints3.insets = new Insets(15, 8, 25, 15);
        gridBagConstraints3.gridy = 1;
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.fill = 1;
        gridBagConstraints4.gridy = 4;
        gridBagConstraints4.weightx = 1.0;
        gridBagConstraints4.insets = new Insets(0, 0, 10, 250);
        gridBagConstraints4.gridx = 1;
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.gridx = 0;
        gridBagConstraints5.insets = new Insets(0, 8, 10, 15);
        gridBagConstraints5.anchor = 17;
        gridBagConstraints5.gridy = 4;
        GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
        gridBagConstraints6.gridx = 0;
        gridBagConstraints6.insets = new Insets(0, 8, 10, 15);
        gridBagConstraints6.anchor = 17;
        gridBagConstraints6.gridy = 3;
        GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
        gridBagConstraints7.gridwidth = 3;
        gridBagConstraints7.fill = 1;
        gridBagConstraints7.gridy = 3;
        gridBagConstraints7.weightx = 1.0;
        gridBagConstraints7.insets = new Insets(0, 0, 10, 8);
        gridBagConstraints7.gridx = 1;
        int[] nArray = new int[]{1024, 1280, 1536, 1984, 2048};
        JComboBox jComboBox = this.getJCbRSASize(nArray);
        JRadioButton jRadioButton = this.getJRdRSA(jComboBox);
        JRadioButton jRadioButton2 = this.getJRdEC();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEtchedBorder(1));
        jPanel.add((Component)this.getJTxtKeyInfo(), gridBagConstraints7);
        jPanel.add((Component)new JLabel("Key-Info"), gridBagConstraints6);
        jPanel.add((Component)new JLabel("RSA Key Length (bits)"), gridBagConstraints5);
        jPanel.add((Component)jComboBox, gridBagConstraints4);
        jPanel.add((Component)jRadioButton, gridBagConstraints3);
        jPanel.add((Component)jRadioButton2, gridBagConstraints2);
        jPanel.add((Component)this.getJScrollPaneMsgGen(this.getJTextAreaGenOnCard()), gridBagConstraints);
        jPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent componentEvent) {
                SmartCardMgmt.this.jBtAction.setText("Generate");
            }
        });
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton);
        buttonGroup.add(jRadioButton2);
        return jPanel;
    }

    private JScrollPane getJScrollPaneMsgGen(JTextArea jTextArea) {
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(1));
        jScrollPane.setPreferredSize(new Dimension(257, 300));
        jScrollPane.setViewportView(jTextArea);
        return jScrollPane;
    }

    private JTextArea getJTextArea() {
        DefaultCaret defaultCaret = new DefaultCaret();
        defaultCaret.x = 0;
        defaultCaret.width = 0;
        defaultCaret.y = 0;
        JTextArea jTextArea = new JTextArea();
        String string = "This command generates an RSA or Elliptic Curve key and stores it in on a smartcard. For backup purposes, XOR shares of the generated key may be stored on different smartcards. A key name must be specified in the 'Key-Info' text box to identify the key.\r\nExisting keys on the smartcard will be overwritten by this procedure!\r\nPlease connect the PIN pad reader to the host PC.\r\n\r\nGenerating a key:\r\n   1. Insert a smartcard into the PIN pad reader.\r\n   2. Enter the PIN for the smartcard using the PIN pad.\r\n\r\nCreating a key backup:\r\n   1. Insert the backup smartcard for the first XOR share.\r\n   2. Enter the PIN for the first smartcard.\r\n   3. Insert the backup smartcard for the second XOR share.\r\n   4. Enter the PIN for the second smartcard.\r\n   \u2014 Ready \u2014\r\n\r\n   To cancel the operation, press CANCEL on the PIN pad.";
        jTextArea.setFont(new Font("Dialog", 0, 11));
        jTextArea.setText(string);
        jTextArea.setEditable(false);
        jTextArea.setCaretPosition(0);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setMargin(new Insets(4, 4, 4, 4));
        jTextArea.setLocation(new Point(0, 0));
        jTextArea.setSize(new Dimension(257, 200));
        jTextArea.setOpaque(true);
        return jTextArea;
    }

    private JTextArea getJTextAreaGenOnCard() {
        DefaultCaret defaultCaret = new DefaultCaret();
        defaultCaret.x = 0;
        defaultCaret.width = 0;
        defaultCaret.y = 0;
        JTextArea jTextArea = new JTextArea();
        String string = "This command generates an RSA or Elliptic Curve key on a smartcard. The backup of such keys is not possible, the authentication key never leaves the smartcard. A key name must be specified in the 'Key-Info' text box to identify the key.\r\nExisting keys on the smartcard will be overwritten by this procedure!\r\nPlease connect the PIN pad reader to the host PC.\r\n\r\nGenerating a key:\r\n   1. Insert a smartcard into the PIN pad reader.\r\n   2. Enter the PIN for the smartcard using the PIN pad.\r\n   \u2014 Ready \u2014\r\n\r\n   To cancel the operation, press CANCEL on the PIN pad.";
        jTextArea.setFont(new Font("Dialog", 0, 11));
        jTextArea.setText(string);
        jTextArea.setEditable(false);
        jTextArea.setCaretPosition(0);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setMargin(new Insets(4, 4, 4, 4));
        jTextArea.setLocation(new Point(0, 0));
        jTextArea.setSize(new Dimension(257, 200));
        jTextArea.setOpaque(true);
        return jTextArea;
    }

    private JTextField getJTxtKeyInfo() {
        final JTextField jTextField = new JTextField();
        jTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                int n = 64;
                if (keyEvent.getKeyChar() == '\b') {
                    return;
                }
                if (jTextField.getText().length() > n - 1) {
                    keyEvent.consume();
                }
            }
        });
        jTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                SmartCardMgmt.this.str_Owner = jTextField.getText();
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                SmartCardMgmt.this.str_Owner = jTextField.getText();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                SmartCardMgmt.this.str_Owner = jTextField.getText();
            }
        });
        jTextField.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
                SmartCardMgmt.this.str_Owner = jTextField.getText();
            }
        });
        return jTextField;
    }

    private JComboBox getJCbRSASize(int[] nArray) {
        final JComboBox<Object> jComboBox = new JComboBox<Object>();
        jComboBox.setMinimumSize(new Dimension(60, 20));
        jComboBox.setPreferredSize(new Dimension(60, 20));
        for (int i = 0; i < nArray.length; ++i) {
            jComboBox.addItem(this.makeObj(Integer.toString(nArray[i])));
        }
        jComboBox.setSelectedIndex(jComboBox.getItemCount() - 1);
        jComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                SmartCardMgmt.this.key_size = Integer.parseInt(jComboBox.getSelectedItem().toString());
            }
        });
        jComboBox.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
                SmartCardMgmt.this.key_size = Integer.parseInt(jComboBox.getSelectedItem().toString());
            }
        });
        return jComboBox;
    }

    private Object makeObj(final String string) {
        return new Object(){

            public String toString() {
                return string;
            }
        };
    }

    private JRadioButton getJRdRSA(final JComboBox jComboBox) {
        final JRadioButton jRadioButton = new JRadioButton();
        jRadioButton.setText("RSA");
        jRadioButton.setSelected(true);
        jRadioButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (jRadioButton.isSelected()) {
                    SmartCardMgmt.this.key_type = 1;
                    jComboBox.setEnabled(true);
                } else {
                    jComboBox.setEnabled(false);
                }
            }
        });
        return jRadioButton;
    }

    private JRadioButton getJRdEC() {
        final JRadioButton jRadioButton = new JRadioButton();
        jRadioButton.setText("Elliptic Curve (DP: brainpoolP320t1)");
        jRadioButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (jRadioButton.isSelected()) {
                    SmartCardMgmt.this.key_type = 2;
                }
            }
        });
        return jRadioButton;
    }

    private JComboBox getJCbNoBackups() {
        final JComboBox<Object> jComboBox = new JComboBox<Object>();
        jComboBox.setPreferredSize(new Dimension(60, 20));
        jComboBox.setMinimumSize(new Dimension(60, 20));
        for (int i = 0; i <= 10; ++i) {
            jComboBox.addItem(this.makeObj(Integer.toString(i)));
        }
        jComboBox.setSelectedIndex(1);
        jComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                SmartCardMgmt.this.n_Backups = jComboBox.getSelectedIndex();
            }
        });
        return jComboBox;
    }

    private JPanel getJPanelRestoreRSA() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(8, 8, 15, 8);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridy = 0;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)this.getJPanelMsgRestoreRSA(), gridBagConstraints);
        jPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent componentEvent) {
                SmartCardMgmt.this.jBtAction.setText("Restore RSA");
            }
        });
        return jPanel;
    }

    private JPanel getJPanelMsgRestoreRSA() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEtchedBorder(1));
        jPanel.setPreferredSize(new Dimension(447, 220));
        jPanel.add((Component)this.getJTextAreaRestoreRSA(), gridBagConstraints);
        return jPanel;
    }

    private JTextArea getJTextAreaRestoreRSA() {
        JTextArea jTextArea = new JTextArea();
        jTextArea.setFont(new Font("Dialog", 0, 11));
        String string = "This command restores a user's RSA key onto a smartcard from two backup smartcards containing XOR key shares.\r\nAn existing RSA key on the target smartcard will be overwritten by this procedure!\r\nPlease connect the PIN pad reader to the host PC.\r\n\r\nRestoring an RSA key:\r\n   1. Insert the first backup smartcard into the PIN pad reader.\r\n   2. Enter the PIN for the first smartcard using the PIN pad.\r\n   3. Insert the second backup smartcard.\r\n   4. Enter the PIN for the second smartcard.\r\n   5. Insert the target smartcard for the user's RSA key.\r\n   6. Enter the PIN for the user's smartcard.\r\n   \u2014 Ready \u2014\r\n\r\n   To cancel the operation, press CANCEL on the PIN pad.";
        jTextArea.setText(string);
        jTextArea.setEditable(false);
        jTextArea.setEnabled(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setPreferredSize(new Dimension(435, 220));
        jTextArea.setMargin(new Insets(4, 4, 4, 4));
        jTextArea.setLineWrap(true);
        return jTextArea;
    }

    private JPanel getJPanelRestoreEC() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(8, 8, 15, 8);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridy = 0;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)this.getJPanelMsgRestoreEC(), gridBagConstraints);
        jPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent componentEvent) {
                SmartCardMgmt.this.jBtAction.setText("Restore EC");
            }
        });
        return jPanel;
    }

    private JPanel getJPanelMsgRestoreEC() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEtchedBorder(1));
        jPanel.setPreferredSize(new Dimension(447, 220));
        jPanel.add((Component)this.getJTextAreaRestoreEC(), gridBagConstraints);
        return jPanel;
    }

    private JTextArea getJTextAreaRestoreEC() {
        JTextArea jTextArea = new JTextArea();
        jTextArea.setFont(new Font("Dialog", 0, 11));
        String string = "This command restores a user's Elliptic Curve key onto a smartcard from two backup smartcards containing XOR key shares.\r\nAn existing EC key on the target smartcard will be overwritten by this procedure!\r\nPlease connect the PIN pad reader to the host PC.\r\n\r\nRestoring an Elliptic Curve key:\r\n   1. Insert the first backup smartcard into the PIN pad reader.\r\n   2. Enter the PIN for the first smartcard using the PIN pad.\r\n   3. Insert the second backup smartcard.\r\n   4. Enter the PIN for the second smartcard.\r\n   5. Insert the target smartcard for the user's EC key.\r\n   6. Enter the PIN for the user's smartcard.\r\n   \u2014 Ready \u2014\r\n\r\n   To cancel the operation, press CANCEL on the PIN pad.";
        jTextArea.setText(string);
        jTextArea.setEditable(false);
        jTextArea.setEnabled(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setPreferredSize(new Dimension(435, 220));
        jTextArea.setMargin(new Insets(4, 4, 4, 4));
        jTextArea.setLineWrap(true);
        return jTextArea;
    }

    private JPanel getJPanelCopy() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(8, 8, 15, 8);
        gridBagConstraints.ipady = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridy = 0;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setPreferredSize(new Dimension(463, 300));
        jPanel.add((Component)this.getJPanelMsgCopy(), gridBagConstraints);
        jPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent componentEvent) {
                SmartCardMgmt.this.jBtAction.setText("Copy");
            }
        });
        return jPanel;
    }

    private JPanel getJPanelMsgCopy() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEtchedBorder(1));
        jPanel.setPreferredSize(new Dimension(447, 170));
        jPanel.add((Component)this.getJTextAreaCopy(), gridBagConstraints);
        return jPanel;
    }

    private JTextArea getJTextAreaCopy() {
        JTextArea jTextArea = new JTextArea();
        jTextArea.setFont(new Font("Dialog", 0, 11));
        String string = "This command copies RSA and Elliptic Curve backup key shares from one smartcard to another.\r\nExisting key backup shares will be overwritten by this procedure!\r\nPlease connect the PIN pad reader to the host PC.\r\n\r\nCopying backup shares:\r\n   1. Insert the source smartcard into the PIN pad reader.\r\n   2. Enter the PIN for the source smartcard using the PIN pad.\r\n   3. Insert the target smartcard.\r\n   4. Enter the PIN for the target smartcard.\r\n   \u2014 Ready \u2014\r\n\r\n   To cancel the operation, press CANCEL on the PIN pad.";
        jTextArea.setText(string);
        jTextArea.setEditable(false);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setPreferredSize(new Dimension(435, 120));
        jTextArea.setMargin(new Insets(4, 4, 4, 4));
        jTextArea.setLineWrap(true);
        return jTextArea;
    }

    private JPanel getJPanelPIN() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(8, 8, 15, 8);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridy = 0;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)this.getJPanelMsgPIN(), gridBagConstraints);
        jPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent componentEvent) {
                SmartCardMgmt.this.jBtAction.setText("Change PIN");
            }
        });
        return jPanel;
    }

    private JPanel getJPanelMsgPIN() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 1.0;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setPreferredSize(new Dimension(447, 40));
        jPanel.setBorder(BorderFactory.createEtchedBorder(1));
        jPanel.add((Component)this.getJTextAreaPIN(), gridBagConstraints);
        return jPanel;
    }

    private JTextArea getJTextAreaPIN() {
        JTextArea jTextArea = new JTextArea();
        jTextArea.setFont(new Font("Dialog", 0, 11));
        String string = "This command changes the PIN of a smartcard.\r\nThe new PIN must consist of 6 to 12 digits.\r\nPlease connect the PIN pad reader to the host PC.\r\n\r\nChanging a smartcard's PIN:\r\n   1. Insert the smartcard into the PIN pad reader.\r\n   2. Enter the current PIN using the PIN pad.\r\n   3. Enter a new PIN.\r\n   4. Re-enter the new PIN to confirm it.\r\n   \u2014 Ready \u2014\r\n\r\n   To cancel the operation, press CANCEL on the PIN pad.";
        jTextArea.setText(string);
        jTextArea.setEditable(false);
        jTextArea.setEnabled(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setPreferredSize(new Dimension(435, 28));
        jTextArea.setMargin(new Insets(4, 4, 4, 4));
        jTextArea.setLineWrap(true);
        return jTextArea;
    }

    private JPanel getJPanelInfo() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(8, 8, 15, 8);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridy = 0;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setPreferredSize(new Dimension(447, 40));
        jPanel.add((Component)this.getJPanelMsgInfo(), gridBagConstraints);
        jPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent componentEvent) {
                SmartCardMgmt.this.jBtAction.setText("Show Info");
            }
        });
        return jPanel;
    }

    private JPanel getJPanelMsgInfo() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 1.0;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEtchedBorder(1));
        jPanel.setPreferredSize(new Dimension(447, 47));
        jPanel.add((Component)this.getJTextAreaInfo(), gridBagConstraints);
        return jPanel;
    }

    private JTextArea getJTextAreaInfo() {
        JTextArea jTextArea = new JTextArea();
        jTextArea.setFont(new Font("Dialog", 0, 11));
        String string = "This command displays information about the keys stored on a smartcard.\r\nThese can be RSA or Elliptic Curve keys, backup key shares or key shares of Master Backup keys.\r\nSome cards request PIN entry for information about the user keys and/or the MBK. In this case, enter the PIN using the PIN pad, possibly twice.\r\nPlease connect the PIN pad reader to the host PC.\r\n\r\nDisplaying the contents of a smartcard:\r\n   1. Insert the smartcard into PIN pad reader.\r\n   2. Press OK on the PIN pad.\r\n   3. Press OK again.\r\n   \u2014 Ready \u2014\r\n\r\n   To cancel the operation, press CANCEL on the PIN pad.";
        jTextArea.setText(string);
        jTextArea.setEditable(false);
        jTextArea.setEnabled(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setPreferredSize(new Dimension(435, 28));
        jTextArea.setMargin(new Insets(4, 4, 4, 4));
        jTextArea.setLineWrap(true);
        return jTextArea;
    }

    private JButton getJBtClose() {
        if (this.jBtClose == null) {
            this.jBtClose = new JButton();
            this.jBtClose.setText("Close");
            this.jBtClose.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SmartCardMgmt.this.dispose();
                }
            });
        }
        return this.jBtClose;
    }

    private JButton getJBtAction() {
        if (this.jBtAction == null) {
            this.jBtAction = new JButton();
            this.jBtAction.setText("Action");
            this.jBtAction.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (GUILock.isLocked()) {
                        return;
                    }
                    if (SmartCardMgmt.this.jTabbedPane.getSelectedIndex() == 0) {
                        if (SmartCardMgmt.this.str_Owner.length() < 1) {
                            SmartCardMgmt.this.tools.DisplayInfoMsg(SmartCardMgmt.this, "Key-Info must have a minimal length of 1 character!");
                            return;
                        }
                        tools_thread.SetMethodForThread(SmartCardMgmt.this, "CSGenerateSC");
                    } else if (SmartCardMgmt.this.jTabbedPane.getSelectedIndex() == 1) {
                        SmartCardMgmt.this.CSRestoreRSASC();
                    } else if (SmartCardMgmt.this.jTabbedPane.getSelectedIndex() == 2) {
                        SmartCardMgmt.this.CSRestoreECSC();
                    } else if (SmartCardMgmt.this.jTabbedPane.getSelectedIndex() == 3) {
                        SmartCardMgmt.this.CSCopySC();
                    } else if (SmartCardMgmt.this.jTabbedPane.getSelectedIndex() == 4) {
                        if (SmartCardMgmt.this.str_Owner.length() < 1) {
                            SmartCardMgmt.this.tools.DisplayInfoMsg(SmartCardMgmt.this, "Key-Info must have a minimal length of 1 character!");
                            return;
                        }
                        tools_thread.SetMethodForThread(SmartCardMgmt.this, "CSGenerateOnSC");
                    } else if (SmartCardMgmt.this.jTabbedPane.getSelectedIndex() == 5) {
                        SmartCardMgmt.this.CSChangePIN();
                    } else if (SmartCardMgmt.this.jTabbedPane.getSelectedIndex() == 6) {
                        SmartCardMgmt.this.CSGetCardInfo();
                    }
                }
            });
        }
        return this.jBtAction;
    }

    public void CSGenerateSC() {
        tools_thread.setInfoField(this.tools.PrepareText("", "Generate keytoken smartcard"));
        final String string = this.tools.GetKeySCToken(this.admin);
        if (string == null) {
            tools_thread.setInfoField("Create smartcard keytoken failed");
            return;
        }
        SwingWorker<Boolean, Integer> swingWorker = new SwingWorker<Boolean, Integer>(){
            String strCSReply;

            @Override
            protected Boolean doInBackground() throws Exception {
                this.publish(1);
                GUILock.lock();
                this.strCSReply = CSJApi.CSGenAdminSmartCard(string, SmartCardMgmt.this.key_type, SmartCardMgmt.this.key_size, SmartCardMgmt.this.str_Owner, SmartCardMgmt.this.n_Backups);
                GUILock.unlock();
                this.publish(0);
                return true;
            }

            @Override
            protected void process(List<Integer> list) {
                Integer n = list.get(list.size() - 1);
                tools_thread.start_stop_ProgBar(n);
            }

            @Override
            protected void done() {
                if (this.strCSReply.indexOf("Error") == -1) {
                    SmartCardMgmt.this.tools.DisplayInfoMsg(SmartCardMgmt.this, "Smartcard keytoken successfully generated");
                    tools_thread.setInfoField("Smartcard keytoken successfully generated");
                } else {
                    SmartCardMgmt.this.tools.DisplayErrorMsg(SmartCardMgmt.this, this.strCSReply);
                    tools_thread.setInfoField(this.strCSReply);
                }
                tools_thread.setStatusBar();
            }
        };
        swingWorker.execute();
    }

    public void CSGenerateOnSC() {
        tools_thread.setInfoField(this.tools.PrepareText("", "Generate keytoken on smartcard"));
        final String string = this.tools.GetKeySCToken(this.admin);
        if (string == null) {
            tools_thread.setInfoField("Creating keytoken on smartcard failed");
            return;
        }
        SwingWorker<Boolean, Integer> swingWorker = new SwingWorker<Boolean, Integer>(){
            String strCSReply;

            @Override
            protected Boolean doInBackground() throws Exception {
                this.publish(1);
                GUILock.lock();
                this.strCSReply = CSJApi.CSGenKeyOnSmartCard(string, SmartCardMgmt.this.key_type, SmartCardMgmt.this.key_size, SmartCardMgmt.this.str_Owner);
                GUILock.unlock();
                this.publish(0);
                return true;
            }

            @Override
            protected void process(List<Integer> list) {
                Integer n = list.get(list.size() - 1);
                tools_thread.start_stop_ProgBar(n);
            }

            @Override
            protected void done() {
                if (this.strCSReply.indexOf("Error") == -1) {
                    SmartCardMgmt.this.tools.DisplayInfoMsg(SmartCardMgmt.this, "Smartcard keytoken successfully generated");
                    tools_thread.setInfoField("Smartcard keytoken successfully generated");
                } else {
                    if (this.strCSReply.contains("B906A00B")) {
                        this.strCSReply = this.strCSReply + "\nThis functionality is supported only on new Utimaco smartcards from version 2.0.0.0 onwards.\nThe first digits of the serial number printed on the smartcard indicate the Utimaco smartcard version. (e.g. JC20-XXXXXX is 2.0, so supporting in-board generation)";
                    }
                    SmartCardMgmt.this.tools.DisplayErrorMsg(SmartCardMgmt.this, this.strCSReply);
                    tools_thread.setInfoField(this.strCSReply);
                }
                tools_thread.setStatusBar();
            }
        };
        swingWorker.execute();
    }

    private void CSRestoreRSASC() {
        final String string = this.tools.GetKeySCToken(this.admin);
        if (string == null) {
            tools_thread.setInfoField("Cannot find information about smartcard token");
            return;
        }
        tools_thread.setInfoField(this.tools.PrepareText("", "Create RSA keytoken smartcard with backup smartcards"));
        SwingWorker<Boolean, Integer> swingWorker = new SwingWorker<Boolean, Integer>(){
            String strCSReply;
            int overwrite = 1;

            @Override
            protected Boolean doInBackground() throws Exception {
                this.publish(1);
                GUILock.lock();
                this.strCSReply = CSJApi.CSRSABackupToSmartCard(string, this.overwrite);
                GUILock.unlock();
                this.publish(0);
                return true;
            }

            @Override
            protected void process(List<Integer> list) {
                Integer n = list.get(list.size() - 1);
                tools_thread.start_stop_ProgBar(n);
            }

            @Override
            protected void done() {
                if (this.strCSReply.indexOf("Error") == -1) {
                    SmartCardMgmt.this.tools.DisplayInfoMsg(SmartCardMgmt.this, "RSA Smartcard keytoken successfully created");
                    tools_thread.setInfoField("Create RSA keytoken smartcard with backup smartcards successful");
                } else {
                    SmartCardMgmt.this.tools.DisplayErrorMsg(SmartCardMgmt.this, this.strCSReply);
                    tools_thread.setInfoField(this.strCSReply);
                }
                tools_thread.setStatusBar();
            }
        };
        swingWorker.execute();
    }

    private void CSRestoreECSC() {
        final String string = this.tools.GetKeySCToken(this.admin);
        if (string == null) {
            tools_thread.setInfoField("Cannot find information about smartcard token");
            return;
        }
        tools_thread.setInfoField(this.tools.PrepareText("", "Create EC keytoken smartcard with backup smartcards"));
        SwingWorker<Boolean, Integer> swingWorker = new SwingWorker<Boolean, Integer>(){
            String strCSReply;

            @Override
            protected Boolean doInBackground() throws Exception {
                this.publish(1);
                GUILock.lock();
                this.strCSReply = CSJApi.CSECBackupToSmartCard(string, 1);
                GUILock.unlock();
                this.publish(0);
                return true;
            }

            @Override
            protected void process(List<Integer> list) {
                Integer n = list.get(list.size() - 1);
                tools_thread.start_stop_ProgBar(n);
            }

            @Override
            protected void done() {
                if (this.strCSReply.indexOf("Error") == -1) {
                    SmartCardMgmt.this.tools.DisplayInfoMsg(SmartCardMgmt.this, "EC Smartcard keytoken successfully created");
                    tools_thread.setInfoField("Create EC keytoken smartcard with backup smartcards successful");
                } else {
                    SmartCardMgmt.this.tools.DisplayErrorMsg(SmartCardMgmt.this, this.strCSReply);
                    tools_thread.setInfoField(this.strCSReply);
                }
                tools_thread.setStatusBar();
            }
        };
        swingWorker.execute();
    }

    public void CSCopySC() {
        tools_thread.setInfoField(this.tools.PrepareText("", "Copy backup smartcard"));
        final String string = this.tools.GetKeySCToken(this.admin);
        if (string == null) {
            tools_thread.setInfoField("Cannot find information about smartcard token");
            return;
        }
        SwingWorker<Boolean, Integer> swingWorker = new SwingWorker<Boolean, Integer>(){
            String strCSReply;

            @Override
            protected Boolean doInBackground() throws Exception {
                this.publish(1);
                GUILock.lock();
                this.strCSReply = CSJApi.CSCopyBackupSC(string);
                GUILock.unlock();
                this.publish(0);
                return true;
            }

            @Override
            protected void process(List<Integer> list) {
                Integer n = list.get(list.size() - 1);
                tools_thread.start_stop_ProgBar(n);
            }

            @Override
            protected void done() {
                if (this.strCSReply.indexOf("Error") == -1) {
                    SmartCardMgmt.this.tools.DisplayInfoMsg(SmartCardMgmt.this, "Backup part of smartcard successfully copied");
                    tools_thread.setInfoField("Copy backup smartcard successful");
                } else {
                    SmartCardMgmt.this.tools.DisplayErrorMsg(SmartCardMgmt.this, this.strCSReply);
                    tools_thread.setInfoField(this.strCSReply);
                }
            }
        };
        swingWorker.execute();
    }

    public void CSGetCardInfo() {
        tools_thread.setInfoField(this.tools.PrepareText("", "Show smartcard Info"));
        final String string = this.tools.GetKeySCToken(this.admin);
        if (string == null) {
            tools_thread.setInfoField("Cannot find information about smartcard token");
            return;
        }
        SwingWorker<Boolean, Integer> swingWorker = new SwingWorker<Boolean, Integer>(){
            String strCSReply;

            @Override
            protected Boolean doInBackground() throws Exception {
                this.publish(1);
                GUILock.lock();
                this.strCSReply = CSJApi.CSGetCardInfo(string);
                GUILock.unlock();
                this.publish(0);
                return true;
            }

            @Override
            protected void process(List<Integer> list) {
                Integer n = list.get(list.size() - 1);
                tools_thread.start_stop_ProgBar(n);
            }

            @Override
            protected void done() {
                if (this.strCSReply.indexOf("Error") == -1) {
                    SmartCardMgmt.this.tools.DisplayInfoMsg(SmartCardMgmt.this, this.strCSReply);
                    tools_thread.setInfoField("Show smartcard Info successful");
                } else {
                    SmartCardMgmt.this.tools.DisplayErrorMsg(SmartCardMgmt.this, this.strCSReply);
                    tools_thread.setInfoField(this.strCSReply);
                }
            }
        };
        swingWorker.execute();
    }

    public void CSChangePIN() {
        tools_thread.setInfoField(this.tools.PrepareText("", "Change PIN of smartcard"));
        final String string = this.tools.GetKeySCToken(this.admin);
        if (string == null) {
            tools_thread.setInfoField("Cannot find information about smartcard token");
            return;
        }
        SwingWorker<Boolean, Integer> swingWorker = new SwingWorker<Boolean, Integer>(){
            String strCSReply;

            @Override
            protected Boolean doInBackground() throws Exception {
                this.publish(1);
                GUILock.lock();
                this.strCSReply = CSJApi.CSChangePIN(string);
                GUILock.unlock();
                this.publish(0);
                return true;
            }

            @Override
            protected void process(List<Integer> list) {
                Integer n = list.get(list.size() - 1);
                tools_thread.start_stop_ProgBar(n);
            }

            @Override
            protected void done() {
                if (this.strCSReply.indexOf("Error") != 0) {
                    SmartCardMgmt.this.tools.DisplayInfoMsg(SmartCardMgmt.this, "PIN of smartcard successfully changed");
                    tools_thread.setInfoField("Change PIN of smartcard successful");
                } else {
                    SmartCardMgmt.this.tools.DisplayErrorMsg(SmartCardMgmt.this, this.strCSReply);
                    tools_thread.setInfoField(this.strCSReply);
                }
            }
        };
        swingWorker.execute();
    }
}

