/*
 * Decompiled with CFR 0.152.
 */
package cat;

import cat.CAT;
import cat.CSJApi;
import cat.Global;
import cat.IniSettings;
import cat.Tools;
import cat.ToolsThread;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingWorker;

public class SetupCS
extends JDialog {
    Tools tools = new Tools();
    IniSettings ini = new IniSettings();
    CAT admin;
    String strPPInfoText;
    String strAdminTokenType;
    String strKeyTokenSC = "Smartcard";
    String strKeyTokenFile = "Keyfile";
    String strSetupCS = "Setup CryptoServer";
    String strPassword;
    String strPackagePath;
    String strLicensePath;
    boolean b_new_install;
    boolean b_needLANPwd = false;
    int package_flag = 0;
    int ForceClear = 1;
    int PKG_SWAPCOM_DETECT = 0x30000000;
    String strPPInfoAdmin = "Information about PIN pad dialogs\r\n   1. insert administrator smartcard for authorization and press confirmation key\r\n   2. type in PIN  for administrator smartcard and press confirmation key\r\n   --- Ready ---\r\n\r\n   To cancel operation press abort key at PIN pad";
    static ToolsThread tools_thread = new ToolsThread();
    private static final long serialVersionUID = -7032795112119552109L;
    private JPanel jContentPane = null;
    private JPanel jPanelNorth = null;
    private JPanel jPanelWest = null;
    private JPanel jPanelEast = null;
    private JPanel jPanelSouth = null;
    private JPanel jPanelCenter = null;
    private JLabel jLabel = null;
    private JTextField jTextPath = null;
    private JButton jButtonPath = null;
    private JRadioButton jRadioUpdate = null;
    private JRadioButton jRadioNewInstall = null;
    private final ButtonGroup btnGrpInstall = new ButtonGroup();
    private JButton jButtonSetup = null;
    private JButton jButtonCancel = null;
    private JLabel jLabel1 = null;
    private JTextField jTxtLicPath = null;
    private JButton jBtLicPath = null;
    private JButton jButtonInfo = null;
    private JLabel lblCsModel;
    private JTextField jtxtCSModel;

    public SetupCS(CAT cAT) {
        super(cAT);
        this.setPreferredSize(new Dimension(720, 300));
        this.admin = cAT;
        this.initialize();
    }

    private void initialize() {
        this.setSize(720, 300);
        this.setResizable(true);
        this.setTitle("Setup CryptoServer");
        this.setContentPane(this.getJContentPane());
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent windowEvent) {
                SetupCS.this.jButtonSetup.requestFocusInWindow();
            }
        });
        this.jRadioUpdate.setSelected(true);
        this.jRadioNewInstall.setSelected(false);
        if (this.ini.GetLicenceFilePath().endsWith(".slf")) {
            this.jTxtLicPath.setText(this.ini.GetLicenceFilePath());
        } else {
            this.jTxtLicPath.setText("");
        }
        this.jTextPath.setText(this.ini.GetPackageFilePath());
        this.setCSModel();
        this.checkLANBoxPwd();
    }

    private void setCSModel() {
        switch (Global.cs_model) {
            case 1: {
                this.jtxtCSModel.setText("C/S-Series (Classic)");
                break;
            }
            case 2: {
                this.jtxtCSModel.setText("Se-Series");
                break;
            }
            case 3: {
                this.jtxtCSModel.setText("C/S-Series (NQ3)");
                break;
            }
            case 4: {
                this.jtxtCSModel.setText("CSe-Series");
                break;
            }
            case 5: {
                this.jtxtCSModel.setText("Se-Series Gen2");
                break;
            }
            default: {
                this.jtxtCSModel.setText("unknown");
            }
        }
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.setPreferredSize(new Dimension(720, 300));
            this.jContentPane.add((Component)this.getJPanelNorth(), "North");
            this.jContentPane.add((Component)this.getJPanelWest(), "West");
            this.jContentPane.add((Component)this.getJPanelEast(), "East");
            this.jContentPane.add((Component)this.getJPanelSouth(), "South");
            this.jContentPane.add((Component)this.getJPanelCenter(), "Center");
            ActionListener actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SetupCS.this.setVisible(false);
                }
            };
            KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0);
            this.jContentPane.registerKeyboardAction(actionListener, keyStroke, 2);
            WindowAdapter windowAdapter = new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent windowEvent) {
                    SetupCS.this.dispose();
                }
            };
            this.addWindowListener(windowAdapter);
        }
        return this.jContentPane;
    }

    private JPanel getJPanelNorth() {
        if (this.jPanelNorth == null) {
            this.jPanelNorth = new JPanel();
        }
        return this.jPanelNorth;
    }

    private JPanel getJPanelWest() {
        if (this.jPanelWest == null) {
            this.jPanelWest = new JPanel();
        }
        return this.jPanelWest;
    }

    private JPanel getJPanelEast() {
        if (this.jPanelEast == null) {
            this.jPanelEast = new JPanel();
        }
        return this.jPanelEast;
    }

    private JPanel getJPanelSouth() {
        if (this.jPanelSouth == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setAlignment(2);
            this.jPanelSouth = new JPanel();
            this.jPanelSouth.setLayout(flowLayout);
            this.jPanelSouth.add((Component)this.getJButtonSetup(), null);
            this.jPanelSouth.add((Component)this.getJButtonInfo(), null);
            this.jPanelSouth.add((Component)this.getJButtonCancel(), null);
        }
        return this.jPanelSouth;
    }

    private JPanel getJPanelCenter() {
        if (this.jPanelCenter == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 2;
            gridBagConstraints.insets = new Insets(5, 0, 5, 0);
            gridBagConstraints.gridy = 1;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.gridy = 1;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.insets = new Insets(5, 0, 5, 5);
            gridBagConstraints2.gridx = 1;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.anchor = 17;
            gridBagConstraints3.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints3.gridy = 1;
            this.jLabel1 = new JLabel();
            this.jLabel1.setText("License File");
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 1;
            gridBagConstraints4.anchor = 17;
            gridBagConstraints4.insets = new Insets(0, 0, 10, 5);
            gridBagConstraints4.gridy = 4;
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.gridx = 1;
            gridBagConstraints5.anchor = 17;
            gridBagConstraints5.insets = new Insets(5, 0, 5, 5);
            gridBagConstraints5.gridy = 3;
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.gridx = 2;
            gridBagConstraints6.insets = new Insets(5, 0, 5, 0);
            gridBagConstraints6.gridy = 2;
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.fill = 2;
            gridBagConstraints7.gridy = 2;
            gridBagConstraints7.weightx = 1.0;
            gridBagConstraints7.insets = new Insets(5, 0, 5, 5);
            gridBagConstraints7.gridx = 1;
            GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
            gridBagConstraints8.gridx = 0;
            gridBagConstraints8.insets = new Insets(5, 5, 5, 10);
            gridBagConstraints8.gridy = 2;
            this.jLabel = new JLabel();
            this.jLabel.setText("Package File");
            this.jPanelCenter = new JPanel();
            GridBagLayout gridBagLayout = new GridBagLayout();
            gridBagLayout.columnWeights = new double[]{0.0, 1.0, 0.0};
            this.jPanelCenter.setLayout(gridBagLayout);
            this.jPanelCenter.setPreferredSize(new Dimension(720, 300));
            this.jPanelCenter.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Setup", 0, 0, null, null));
            GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
            gridBagConstraints9.anchor = 17;
            gridBagConstraints9.insets = new Insets(0, 5, 5, 5);
            gridBagConstraints9.gridx = 0;
            gridBagConstraints9.gridy = 0;
            this.jPanelCenter.add((Component)this.getLblCsModel(), gridBagConstraints9);
            GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
            gridBagConstraints10.fill = 2;
            gridBagConstraints10.insets = new Insets(0, 0, 5, 5);
            gridBagConstraints10.gridx = 1;
            gridBagConstraints10.gridy = 0;
            this.jPanelCenter.add((Component)this.getJtxtCSModel(), gridBagConstraints10);
            this.jPanelCenter.add((Component)this.jLabel, gridBagConstraints8);
            this.jPanelCenter.add((Component)this.getJTextPath(), gridBagConstraints7);
            this.jPanelCenter.add((Component)this.getJButtonPath(), gridBagConstraints6);
            this.jPanelCenter.add((Component)this.getJRadioUpdate(), gridBagConstraints5);
            this.jPanelCenter.add((Component)this.getJRadioNewInstall(), gridBagConstraints4);
            this.jPanelCenter.add((Component)this.jLabel1, gridBagConstraints3);
            this.jPanelCenter.add((Component)this.getJTxtLicPath(), gridBagConstraints2);
            this.jPanelCenter.add((Component)this.getJBtLicPath(), gridBagConstraints);
        }
        return this.jPanelCenter;
    }

    private JTextField getJTextPath() {
        if (this.jTextPath == null) {
            this.jTextPath = new JTextField();
        }
        return this.jTextPath;
    }

    private JTextField getJTxtLicPath() {
        if (this.jTxtLicPath == null) {
            this.jTxtLicPath = new JTextField();
        }
        return this.jTxtLicPath;
    }

    private JRadioButton getJRadioUpdate() {
        if (this.jRadioUpdate == null) {
            this.jRadioUpdate = new JRadioButton();
            this.jRadioUpdate.setText("Update (installs only new firmware)");
            this.btnGrpInstall.add(this.jRadioUpdate);
        }
        return this.jRadioUpdate;
    }

    private JRadioButton getJRadioNewInstall() {
        if (this.jRadioNewInstall == null) {
            this.jRadioNewInstall = new JRadioButton();
            this.jRadioNewInstall.setText("New Installation (deletes all files; installs new firmware package)");
            this.btnGrpInstall.add(this.jRadioNewInstall);
        }
        return this.jRadioNewInstall;
    }

    private JLabel getLblCsModel() {
        if (this.lblCsModel == null) {
            this.lblCsModel = new JLabel("Model");
        }
        return this.lblCsModel;
    }

    private JTextField getJtxtCSModel() {
        if (this.jtxtCSModel == null) {
            this.jtxtCSModel = new JTextField();
            this.jtxtCSModel.setEditable(false);
            this.jtxtCSModel.setColumns(10);
        }
        return this.jtxtCSModel;
    }

    private JButton getJButtonSetup() {
        if (this.jButtonSetup == null) {
            this.jButtonSetup = new JButton();
            this.jButtonSetup.setText("Setup...");
            this.jButtonSetup.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SetupCS.this.makeSetup();
                }
            });
        }
        return this.jButtonSetup;
    }

    private JButton getJButtonCancel() {
        if (this.jButtonCancel == null) {
            this.jButtonCancel = new JButton();
            this.jButtonCancel.setText("Close");
            this.jButtonCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    CAT.jTextArea.setCursor(new Cursor(0));
                    SetupCS.this.getParent().setCursor(new Cursor(0));
                    SetupCS.this.dispose();
                }
            });
        }
        return this.jButtonCancel;
    }

    private JButton getJButtonPath() {
        if (this.jButtonPath == null) {
            this.jButtonPath = new JButton();
            this.jButtonPath.setText("...");
            this.jButtonPath.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    String string = SetupCS.this.tools.ShowOpenDlg(SetupCS.this, "Open CryptoServer Firmware Package", SetupCS.this.ini.GetPackageFilePath(), ".mpkg", "Package (*.mpkg)");
                    if (string.isEmpty() || !string.endsWith(".mpkg")) {
                        return;
                    }
                    SetupCS.this.jTextPath.setText(string);
                    SetupCS.this.setPathForPackage();
                }
            });
        }
        return this.jButtonPath;
    }

    private JButton getJBtLicPath() {
        if (this.jBtLicPath == null) {
            this.jBtLicPath = new JButton();
            this.jBtLicPath.setText("...");
            this.jBtLicPath.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    String string = SetupCS.this.tools.ShowOpenDlg(SetupCS.this, "Open CryptoServer License File", SetupCS.this.ini.GetLicenceFilePath(), ".slf", "License File (*.slf)");
                    if (string.isEmpty() || !string.endsWith(".slf")) {
                        return;
                    }
                    SetupCS.this.jTxtLicPath.setText(string);
                    SetupCS.this.setPathForLicense();
                }
            });
        }
        return this.jBtLicPath;
    }

    private void setPathForLicense() {
        this.strLicensePath = this.jTxtLicPath.getText();
        if (this.strLicensePath.endsWith(".slf")) {
            this.ini.SetLicenceFilePath(this.strLicensePath);
        } else {
            this.strLicensePath = "";
        }
        if (this.strLicensePath.isEmpty()) {
            this.strLicensePath = null;
        }
    }

    private void setPathForPackage() {
        if (this.jTextPath.getText().isEmpty() || !this.jTextPath.getText().endsWith(".mpkg")) {
            return;
        }
        this.ini.SetPackageFilePath(this.jTextPath.getText());
    }

    private JButton getJButtonInfo() {
        if (this.jButtonInfo == null) {
            this.jButtonInfo = new JButton();
            this.jButtonInfo.setText("Info...");
            this.jButtonInfo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    String string = "\r\n--- License File ---\r\nThe CryptoServer uses a Signed Licence File concept to regulate\r\nthe availablity of certain features and performances\r\n(for instance the speed of certain cryptographic algorithms) in a customer-specific way.\r\nThese regulations do in no case produce security-relevant changes to the software.\r\n\r\n--- Package File ---\r\nA package file \"*.mpkg\" (e. g. MTCs) as well as\r\nother files in a packed form. Package files are intended to give the user a facile\r\npossibility to download or update a set of several firmware modules and/or files into\r\nthe CryptoServer in only one step.";
                    SetupCS.this.tools.DisplayInfoMsg(SetupCS.this.admin, string);
                }
            });
        }
        return this.jButtonInfo;
    }

    private boolean setupPreparations() {
        String string;
        if (this.jRadioUpdate.isSelected()) {
            string = "Do you really want to update the CryptoServer Firmware?";
            this.b_new_install = false;
        } else {
            string = "Do you really want a new installation of CryptoServer?\r\nAll data stored so far will be deleted!";
            this.b_new_install = true;
        }
        int n = this.tools.DisplayYesNoMsg(this, string);
        if (n != 0) {
            return false;
        }
        this.strPackagePath = this.jTextPath.getText();
        if (this.strPackagePath.compareTo("") == 0) {
            return false;
        }
        this.strAdminTokenType = this.ini.GetKindOfToken(this);
        this.strPPInfoText = this.strAdminTokenType.compareTo(this.strKeyTokenSC) == 0 ? this.strPPInfoAdmin : "";
        if (this.b_new_install) {
            this.package_flag = this.ForceClear;
        }
        this.package_flag |= this.PKG_SWAPCOM_DETECT;
        this.tools.SetInfoField(this.tools.PrepareText("", "CryptoServer Setup"));
        if (this.b_needLANPwd) {
            this.strPassword = this.tools.ShowPwdInputDlg(this, "Password Input for CryptoServer LAN Access");
            if (this.strPassword == null) {
                this.tools.SetInfoField(this.tools.PrepareText("", "Setup of CS LAN canceled"));
            }
            if (this.strPassword.length() == 0) {
                this.strPassword = null;
            }
        }
        return true;
    }

    private void checkLANBoxPwd() {
        SwingWorker<Boolean, String> swingWorker = new SwingWorker<Boolean, String>(){

            @Override
            protected Boolean doInBackground() throws Exception {
                this.publish("start progress bar");
                if (CSJApi.CSLANNeedsPassword()) {
                    SetupCS.this.b_needLANPwd = true;
                    this.publish("start progress bar");
                    this.publish("Password Input for CryptoServer LAN Access");
                } else {
                    SetupCS.this.b_needLANPwd = false;
                }
                tools_thread.setStatusBar();
                this.publish("end progress bar");
                return true;
            }

            @Override
            protected void process(List<String> list) {
                if (list.get(0).compareTo("start progress bar") == 0) {
                    tools_thread.start_stop_ProgBar(1);
                }
                if (list.get(0).compareTo("end progress bar") == 0) {
                    tools_thread.start_stop_ProgBar(0);
                }
            }

            @Override
            protected void done() {
            }
        };
        swingWorker.execute();
    }

    private void showLoadPkgInfo() {
        SwingWorker<Boolean, String> swingWorker = new SwingWorker<Boolean, String>(){
            String new_buffer = "";
            String strMsgBuffer = "";
            int count_down = 10;

            @Override
            protected Boolean doInBackground() throws Exception {
                this.publish("start progress bar");
                for (int i = this.count_down; i > 0; --i) {
                    this.new_buffer = CSJApi.CSGetMsg();
                    SetupCS.this.tools.Sleep(50);
                    if (this.new_buffer.length() == 0 && i == 1) {
                        this.publish("end progress bar");
                        return true;
                    }
                    i = this.count_down;
                    this.strMsgBuffer = this.new_buffer.length() >= 0 ? this.new_buffer : "";
                    this.publish(this.strMsgBuffer);
                    SetupCS.this.tools.Sleep(250);
                }
                return true;
            }

            @Override
            protected void process(List<String> list) {
                if (list.get(0).compareTo("start progress bar") == 0) {
                    tools_thread.start_stop_ProgBar(1);
                } else if (list.get(0).compareTo("end progress bar") == 0) {
                    tools_thread.start_stop_ProgBar(0);
                } else {
                    SetupCS.this.tools.SetInfoField(list.get(0));
                }
            }

            @Override
            protected void done() {
            }
        };
        swingWorker.execute();
    }

    private void makeSetup() {
        if (!this.setupPreparations()) {
            return;
        }
        SwingWorker<Boolean, Integer> swingWorker = new SwingWorker<Boolean, Integer>(){
            String strCSReply;

            @Override
            protected Boolean doInBackground() throws Exception {
                this.publish(1);
                SetupCS.this.showLoadPkgInfo();
                this.strCSReply = CSJApi.CSLoadPkg(SetupCS.this.strPackagePath, SetupCS.this.strLicensePath, SetupCS.this.package_flag, SetupCS.this.strPassword);
                tools_thread.Sleep(1000);
                CSJApi.CSOpen(Global.strCurrentCSAddr);
                tools_thread.setStatusBar();
                this.publish(0);
                SetupCS.this.strPassword = "";
                return true;
            }

            @Override
            protected void process(List<Integer> list) {
                Integer n = list.get(list.size() - 1);
                tools_thread.start_stop_ProgBar(n);
            }

            @Override
            protected void done() {
                SetupCS.this.tools.SetInfoField(this.strCSReply);
                if (this.strCSReply.indexOf("Error") != -1) {
                    SetupCS.this.tools.DisplayErrorMsg(SetupCS.this, this.strCSReply);
                    SetupCS.this.setPathForLicense();
                    SetupCS.this.setPathForPackage();
                } else {
                    SetupCS.this.tools.DisplayInfoMsg(SetupCS.this, this.strCSReply);
                }
            }
        };
        swingWorker.execute();
        this.dispose();
    }
}

