/*
 * Decompiled with CFR 0.152.
 */
package cat;

import cat.CAT;
import cat.CSJApi;
import cat.DateTimeThread;
import cat.Tools;
import cat.ToolsThread;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingWorker;

public class NTP
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JPanel jPanelNorth = null;
    private JPanel jPanelWest = null;
    private JPanel jPanelEast = null;
    private JPanel jPanelSouth = null;
    private JPanel jPanelCenter = null;
    private JLabel jLabel = null;
    private JLabel jLabel1 = null;
    private JLabel jLabel2 = null;
    private JLabel jLabel3 = null;
    private JLabel jLabel4 = null;
    private JTextField jTxtTimePerDay = null;
    private JTextField jTxtTimePerOp = null;
    private JRadioButton jRdNTPEnabled = null;
    private JRadioButton jRdNTPDisabled = null;
    private JButton jBtApply = null;
    private JButton jBtClose = null;
    private JButton jBtOK = null;
    static ToolsThread tools_thread = new ToolsThread();
    Tools tools = new Tools();
    CAT admin;
    DateTimeThread dt_thread = null;
    ButtonGroup group;
    String strMaxTimePerDay = "";
    String strMaxTimePerOp = "";
    String strNewTime;
    int activation;
    long max_time_per_day;
    long max_time_per_op;
    Boolean b_start = true;
    String strOldDayValue;
    String strOldOpValue;
    boolean b_stop = false;

    public NTP(CAT cAT) {
        super(cAT);
        this.admin = cAT;
        this.initialize();
        this.GetConfig();
    }

    private void initialize() {
        this.setSize(461, 240);
        this.setTitle("Network Time Protocol (NTP) Configuration");
        this.setContentPane(this.getJContentPane());
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.setPreferredSize(new Dimension(650, 460));
            this.jContentPane.add((Component)this.getJPanelNorth(), "North");
            this.jContentPane.add((Component)this.getJPanelWest(), "West");
            this.jContentPane.add((Component)this.getJPanelEast(), "East");
            this.jContentPane.add((Component)this.getJPanelSouth(), "South");
            this.jContentPane.add((Component)this.getJPanelCenter(), "Center");
            ActionListener actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    NTP.this.setVisible(false);
                }
            };
            KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0);
            this.jContentPane.registerKeyboardAction(actionListener, keyStroke, 2);
            WindowAdapter windowAdapter = new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent windowEvent) {
                    NTP.this.dispose();
                }
            };
            this.addWindowListener(windowAdapter);
        }
        return this.jContentPane;
    }

    private JPanel getJPanelNorth() {
        if (this.jPanelNorth == null) {
            this.jPanelNorth = new JPanel();
            this.jPanelNorth.setLayout(new GridBagLayout());
            this.jPanelNorth.setPreferredSize(new Dimension(10, 10));
        }
        return this.jPanelNorth;
    }

    private JPanel getJPanelWest() {
        if (this.jPanelWest == null) {
            this.jPanelWest = new JPanel();
            this.jPanelWest.setLayout(new GridBagLayout());
            this.jPanelWest.setPreferredSize(new Dimension(10, 10));
        }
        return this.jPanelWest;
    }

    private JPanel getJPanelEast() {
        if (this.jPanelEast == null) {
            this.jPanelEast = new JPanel();
            this.jPanelEast.setLayout(new GridBagLayout());
            this.jPanelEast.setPreferredSize(new Dimension(10, 10));
        }
        return this.jPanelEast;
    }

    private JPanel getJPanelSouth() {
        if (this.jPanelSouth == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setAlignment(2);
            this.jPanelSouth = new JPanel();
            this.jPanelSouth.setLayout(flowLayout);
            this.jPanelSouth.setPreferredSize(new Dimension(10, 33));
            this.jPanelSouth.add((Component)this.getJBtOK(), null);
            this.jPanelSouth.add((Component)this.getJBtClose(), null);
            this.jPanelSouth.add((Component)this.getJBtApply(), null);
        }
        return this.jPanelSouth;
    }

    private JPanel getJPanelCenter() {
        if (this.jPanelCenter == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 2;
            gridBagConstraints.insets = new Insets(10, 0, 0, 0);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridy = 2;
            this.jLabel4 = new JLabel();
            this.jLabel4.setText("msec");
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 2;
            gridBagConstraints2.insets = new Insets(30, 0, 0, 0);
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2.gridy = 1;
            this.jLabel3 = new JLabel();
            this.jLabel3.setText("msec");
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 3;
            gridBagConstraints3.gridy = 2;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 3;
            gridBagConstraints4.fill = 0;
            gridBagConstraints4.insets = new Insets(10, 0, 0, 8);
            gridBagConstraints4.gridy = 0;
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.gridx = 2;
            gridBagConstraints5.insets = new Insets(0, 0, 10, 0);
            gridBagConstraints5.gridy = 7;
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.gridx = 2;
            gridBagConstraints6.anchor = 17;
            gridBagConstraints6.insets = new Insets(5, 0, 0, 0);
            gridBagConstraints6.weightx = 1.0;
            gridBagConstraints6.gridy = 0;
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.gridx = 1;
            gridBagConstraints7.anchor = 17;
            gridBagConstraints7.insets = new Insets(5, 8, 0, 0);
            gridBagConstraints7.gridwidth = 0;
            gridBagConstraints7.gridy = 0;
            GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
            gridBagConstraints8.fill = 1;
            gridBagConstraints8.gridy = 2;
            gridBagConstraints8.weightx = 1.0;
            gridBagConstraints8.insets = new Insets(10, 10, 0, 10);
            gridBagConstraints8.gridwidth = 1;
            gridBagConstraints8.gridx = 1;
            GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
            gridBagConstraints9.gridx = 0;
            gridBagConstraints9.anchor = 13;
            gridBagConstraints9.insets = new Insets(10, 8, 0, 0);
            gridBagConstraints9.gridy = 2;
            this.jLabel2 = new JLabel();
            this.jLabel2.setText("Max. time to set per operation");
            this.jLabel2.setFont(new Font("Dialog", 0, 11));
            GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
            gridBagConstraints10.fill = 1;
            gridBagConstraints10.gridy = 1;
            gridBagConstraints10.weightx = 1.0;
            gridBagConstraints10.insets = new Insets(30, 10, 0, 10);
            gridBagConstraints10.anchor = 17;
            gridBagConstraints10.gridheight = 1;
            gridBagConstraints10.gridwidth = 1;
            gridBagConstraints10.gridx = 1;
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            gridBagConstraints11.gridx = 0;
            gridBagConstraints11.anchor = 13;
            gridBagConstraints11.insets = new Insets(30, 8, 0, 0);
            gridBagConstraints11.gridy = 1;
            this.jLabel1 = new JLabel();
            this.jLabel1.setText("Max. time to set per day");
            this.jLabel1.setFont(new Font("Dialog", 0, 11));
            GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
            gridBagConstraints12.gridx = 0;
            gridBagConstraints12.insets = new Insets(5, 8, 0, 0);
            gridBagConstraints12.anchor = 13;
            gridBagConstraints12.gridy = 0;
            this.jLabel = new JLabel();
            this.jLabel.setText("NTP-Status");
            this.jLabel.setFont(new Font("Dialog", 0, 11));
            this.jPanelCenter = new JPanel();
            this.jPanelCenter.setLayout(new GridBagLayout());
            this.jPanelCenter.setPreferredSize(new Dimension(630, 400));
            this.jPanelCenter.setFont(new Font("Dialog", 1, 11));
            this.jPanelCenter.add((Component)this.jLabel, gridBagConstraints12);
            this.jPanelCenter.add((Component)this.jLabel1, gridBagConstraints11);
            this.jPanelCenter.add((Component)this.getJTxtTimePerDay(), gridBagConstraints10);
            this.jPanelCenter.add((Component)this.jLabel2, gridBagConstraints9);
            this.jPanelCenter.add((Component)this.getJTxtTimePerOp(), gridBagConstraints8);
            this.jPanelCenter.add((Component)this.getJRdNTPEnabled(), gridBagConstraints7);
            this.jPanelCenter.add((Component)this.getJRdNTPDisabled(), gridBagConstraints6);
            this.jPanelCenter.add((Component)this.jLabel3, gridBagConstraints2);
            this.jPanelCenter.add((Component)this.jLabel4, gridBagConstraints);
            this.group = new ButtonGroup();
            this.group.add(this.jRdNTPDisabled);
            this.group.add(this.jRdNTPEnabled);
        }
        return this.jPanelCenter;
    }

    private JButton getJBtOK() {
        if (this.jBtOK == null) {
            this.jBtOK = new JButton();
            this.jBtOK.setText("OK");
            this.jBtOK.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    NTP.this.activation = NTP.this.jRdNTPEnabled.isSelected() ? 1 : 0;
                    NTP.this.SetNTPSettings();
                    if (!NTP.this.b_stop) {
                        NTP.this.dispose();
                    }
                }
            });
        }
        return this.jBtOK;
    }

    private JButton getJBtApply() {
        if (this.jBtApply == null) {
            this.jBtApply = new JButton();
            this.jBtApply.setText("Apply");
            this.jBtApply.setEnabled(false);
            this.jBtApply.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    NTP.this.activation = NTP.this.jRdNTPEnabled.isSelected() ? 1 : 0;
                    NTP.this.SetNTPSettings();
                }
            });
        }
        return this.jBtApply;
    }

    private JButton getJBtClose() {
        if (this.jBtClose == null) {
            this.jBtClose = new JButton();
            this.jBtClose.setText("Cancel");
            this.jBtClose.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    NTP.this.dispose();
                }
            });
        }
        return this.jBtClose;
    }

    private JTextField getJTxtTimePerDay() {
        if (this.jTxtTimePerDay == null) {
            this.jTxtTimePerDay = new JTextField();
            this.jTxtTimePerDay.setHorizontalAlignment(4);
            this.jTxtTimePerDay.addKeyListener(new KeyAdapter(){

                @Override
                public void keyTyped(KeyEvent keyEvent) {
                    int n = 10;
                    if (keyEvent.getKeyChar() == '\b') {
                        return;
                    }
                    if (!NTP.this.tools.TestDezString(keyEvent.getKeyChar())) {
                        keyEvent.consume();
                    }
                    if (NTP.this.jTxtTimePerDay.getText().length() > n - 1) {
                        keyEvent.consume();
                    }
                }

                @Override
                public void keyReleased(KeyEvent keyEvent) {
                    if (NTP.this.strOldDayValue.compareTo(NTP.this.jTxtTimePerDay.getText()) != 0) {
                        NTP.this.jBtApply.setEnabled(true);
                    }
                    NTP.this.strOldDayValue = NTP.this.jTxtTimePerDay.getText();
                }
            });
        }
        return this.jTxtTimePerDay;
    }

    private JTextField getJTxtTimePerOp() {
        if (this.jTxtTimePerOp == null) {
            this.jTxtTimePerOp = new JTextField();
            this.jTxtTimePerOp.setHorizontalAlignment(11);
            this.jTxtTimePerOp.addKeyListener(new KeyAdapter(){

                @Override
                public void keyTyped(KeyEvent keyEvent) {
                    int n = 10;
                    if (keyEvent.getKeyChar() == '\b') {
                        return;
                    }
                    if (!NTP.this.tools.TestDezString(keyEvent.getKeyChar())) {
                        keyEvent.consume();
                    }
                    if (NTP.this.jTxtTimePerOp.getText().length() > n - 1) {
                        keyEvent.consume();
                    }
                }

                @Override
                public void keyReleased(KeyEvent keyEvent) {
                    if (NTP.this.strOldOpValue.compareTo(NTP.this.jTxtTimePerOp.getText()) != 0) {
                        NTP.this.jBtApply.setEnabled(true);
                    }
                    NTP.this.strOldOpValue = NTP.this.jTxtTimePerOp.getText();
                }
            });
        }
        return this.jTxtTimePerOp;
    }

    private JRadioButton getJRdNTPEnabled() {
        if (this.jRdNTPEnabled == null) {
            this.jRdNTPEnabled = new JRadioButton();
            this.jRdNTPEnabled.setText("Enabled");
            this.jRdNTPEnabled.setFont(new Font("Dialog", 0, 11));
            this.jRdNTPEnabled.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (!NTP.this.b_start.booleanValue()) {
                        NTP.this.jBtApply.setEnabled(true);
                    }
                    if (NTP.this.jRdNTPEnabled.isSelected()) {
                        if (!NTP.this.b_start.booleanValue()) {
                            NTP.this.GetConfig();
                            NTP.this.jTxtTimePerDay.setEnabled(true);
                            NTP.this.jTxtTimePerOp.setEnabled(true);
                            NTP.this.jTxtTimePerDay.setText(NTP.this.strMaxTimePerDay);
                            NTP.this.jTxtTimePerOp.setText(NTP.this.strMaxTimePerOp);
                        }
                    } else {
                        NTP.this.jTxtTimePerDay.setEnabled(false);
                        NTP.this.jTxtTimePerOp.setEnabled(false);
                    }
                    NTP.this.b_start = false;
                }
            });
        }
        return this.jRdNTPEnabled;
    }

    private JRadioButton getJRdNTPDisabled() {
        if (this.jRdNTPDisabled == null) {
            this.jRdNTPDisabled = new JRadioButton();
            this.jRdNTPDisabled.setText("Disabled");
            this.jRdNTPDisabled.setFont(new Font("Dialog", 0, 11));
            this.jRdNTPDisabled.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (!NTP.this.b_start.booleanValue()) {
                        NTP.this.jBtApply.setEnabled(true);
                    }
                    if (NTP.this.jRdNTPEnabled.isSelected()) {
                        NTP.this.jTxtTimePerDay.setEnabled(true);
                        NTP.this.jTxtTimePerOp.setEnabled(true);
                    } else {
                        NTP.this.jTxtTimePerDay.setEnabled(false);
                        NTP.this.jTxtTimePerOp.setEnabled(false);
                    }
                    NTP.this.b_start = false;
                }
            });
        }
        return this.jRdNTPDisabled;
    }

    void SetNTPSettings() {
        if (this.jRdNTPDisabled.isSelected()) {
            this.b_stop = false;
        }
        if (this.activation == 1) {
            if (this.jTxtTimePerDay.getText().length() == 0) {
                this.tools.DisplayErrorMsg(this, "Input value for -" + this.jLabel1.getText() + "- necessary.");
                this.b_stop = true;
            }
            if (this.jTxtTimePerOp.getText().length() == 0) {
                this.tools.DisplayErrorMsg(this, "Input value for -" + this.jLabel2.getText() + "- necessary.");
                this.b_stop = true;
            }
            if (this.b_stop) {
                return;
            }
            this.max_time_per_day = Long.parseLong(this.jTxtTimePerDay.getText());
            this.max_time_per_op = Long.parseLong(this.jTxtTimePerOp.getText());
            if (this.max_time_per_day > 0xFFFFFFFFL) {
                this.tools.DisplayErrorMsg(this, "Maximum input value for -" + this.jLabel1.getText() + "- is 4,294,967,295");
                this.b_stop = true;
            }
            if (this.max_time_per_op > 0xFFFFFFFFL) {
                this.tools.DisplayErrorMsg(this, "Maximum input value for -" + this.jLabel2.getText() + "- is 4,294,967,295");
                this.b_stop = true;
            }
            if (this.b_stop) {
                return;
            }
        }
        tools_thread.SetMethodForThread(this, "CSNTPSetConfig");
    }

    public void CSNTPSetConfig() {
        String string = CSJApi.CSNTPActivation(this.activation);
        if (this.activation == 1) {
            string = CSJApi.CSNTPSetConfig(this.max_time_per_day, this.max_time_per_op);
        }
        tools_thread.DefaultEnd(string, "", this);
    }

    private void GetConfig() {
        SwingWorker<Boolean, Integer> swingWorker = new SwingWorker<Boolean, Integer>(){
            String strCSReply;

            @Override
            protected Boolean doInBackground() throws Exception {
                this.publish(1);
                this.strCSReply = CSJApi.CSNTPGetConfig();
                this.publish(0);
                return true;
            }

            @Override
            protected void process(List<Integer> list) {
                Integer n = list.get(list.size() - 1);
                tools_thread.start_stop_ProgBar(n);
            }

            @Override
            protected void done() {
                NTP.this.setNTPConfig(this.strCSReply);
                tools_thread.setStatusBar();
            }
        };
        swingWorker.execute();
    }

    public void CSNTPGetConfig() {
        String string = CSJApi.CSNTPGetConfig();
        this.setNTPConfig(string);
    }

    public void setNTPConfig(String string) {
        if (this.jRdNTPEnabled.isSelected() && string.indexOf("Error") != -1) {
            this.jTxtTimePerDay.setText("30000");
            this.jTxtTimePerOp.setText("3000");
            return;
        }
        if (string.indexOf("B09A0006") != -1) {
            this.jRdNTPDisabled.setSelected(true);
            this.jRdNTPEnabled.setSelected(false);
            this.jTxtTimePerDay.setText("---");
            this.jTxtTimePerOp.setText("---");
        } else {
            if (string.indexOf("Error") != -1) {
                this.tools.DisplayErrorMsg(this, string);
                this.dispose();
                return;
            }
            this.jRdNTPDisabled.setSelected(false);
            this.jRdNTPEnabled.setSelected(true);
            int n = string.indexOf(";;");
            this.strMaxTimePerOp = string.substring(0, n);
            this.strMaxTimePerDay = string.substring(n + 2, string.length());
            this.jTxtTimePerDay.setText(this.strMaxTimePerDay);
            this.jTxtTimePerOp.setText(this.strMaxTimePerOp);
        }
        if (this.jRdNTPEnabled.isSelected()) {
            this.jTxtTimePerDay.setEnabled(true);
            this.jTxtTimePerOp.setEnabled(true);
        } else {
            this.jTxtTimePerDay.setEnabled(false);
            this.jTxtTimePerOp.setEnabled(false);
        }
        this.strOldDayValue = this.jTxtTimePerDay.getText();
        this.strOldOpValue = this.jTxtTimePerOp.getText();
    }
}

