/*
 * Decompiled with CFR 0.152.
 */
package cat;

import cat.CAT;
import cat.CSJApi;
import cat.CSThread;
import cat.DateTime;
import cat.Global;
import cat.IniSettings;
import cat.MBKRemoteMgmt;
import cat.Tools;
import cat.ToolsThread;
import cat.UserLogin;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;

public class CloneWizard
extends JDialog {
    private static final long serialVersionUID = 1L;
    CAT admin;
    Tools tools = new Tools();
    static ToolsThread tools_thread = new ToolsThread();
    IniSettings ini = new IniSettings();
    String strSourceAddr;
    String strTargetAddr;
    String strCSAddress;
    String strSourceFW;
    String strTargetFW;
    String strCheckModules = "CheckModules";
    String strDBCloning = "DBCloning";
    String strSourceDBName = "Available Databases";
    String strTargetDBName = "Selected Databases ";
    String strInfoSource1 = "Source CryptoServer ";
    String strInfoSource2 = "Backup Directory      ";
    String strInfoTarget1 = "Target CryptoServer ";
    String strInfoTarget2 = "Backup Directory      ";
    boolean b_error = false;
    boolean b_ShowModulesActive = false;
    boolean b_first = true;
    boolean b_start = false;
    boolean b_back_thr_ended = false;
    Object[] rowData = new Object[1];
    String[] strSelDBs;
    String strBackupDir = "";
    boolean open_failed;
    boolean b_bootloader;
    boolean b_maintenance;
    String strCSStat;
    String strCSTemp;
    String strCSAlarm;
    String strCSBatt;
    String strAuthStatePlain;
    String strAuthState;
    int temp;
    private JPanel jContentPane = null;
    private JPanel jPanelWest = null;
    private JPanel jPanelEast = null;
    private JPanel jPanelSouth = null;
    private JPanel jPanelCenter = null;
    private JLabel jLabHeadline = null;
    private JPanel jPanelSettings = null;
    private JLabel jLabTargetCS = null;
    private JComboBox jCbTargetAddr = null;
    private JLabel jLabSourceCS = null;
    private JComboBox jCbSourceAddr = null;
    private JLabel jLabBackupDir = null;
    private JTextField jTxtBackupDir = null;
    private JLabel jLabSteps = null;
    private JLabel jLabStep1 = null;
    private JLabel jLabStep2 = null;
    private JLabel jLabStep3 = null;
    private JLabel jLabStep4 = null;
    private JLabel jLabStep5 = null;
    private JButton jBtCancel = null;
    private JButton jBtNext = null;
    private JLabel jLabDummy1 = null;
    private JPanel jPanelCommand = null;
    private JRadioButton jRdSource2Backup = null;
    private JRadioButton jRdSource2Target = null;
    private JRadioButton jRdBackup2Target = null;
    private JButton jBtDirPath = null;
    private JPanel jPanelTables = null;
    private JPanel jPanelLeftTab = null;
    private JLabel jLabAvailFiles = null;
    private JScrollPane jSPSource = null;
    private JTable jTabSource = null;
    private JPanel jPanelMid = null;
    private JButton jBtAddAll = null;
    private JButton jBtAdd = null;
    private JButton jBtRemove = null;
    private JButton jBtRemoveAll = null;
    private JPanel jPanelRightTab = null;
    private JLabel jLabTargetFiles = null;
    private JScrollPane jSpTarget = null;
    private JTable jTabTarget = null;
    CSThread fw_thread = null;
    CSThread exp_thread = null;
    DefaultTableModel model_source = new DefaultTableModel(){
        private static final long serialVersionUID = 1L;

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    };
    DefaultTableModel model_target = new DefaultTableModel(){
        private static final long serialVersionUID = 1L;

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    };

    public CloneWizard(CAT cAT) {
        super(cAT);
        this.admin = cAT;
        this.b_start = false;
        this.initialize();
        this.init_addr_cb();
        this.b_start = true;
        this.FillSourceTable(this.strSourceDBName);
        this.FillTargetTable(this.strTargetDBName);
        this.jTxtBackupDir.setText(this.ini.GetDBBackupFilePath());
        this.jLabStep1.setEnabled(true);
        this.jLabStep2.setText("2. ADMIN Login (Source)");
        this.jLabStep2.setEnabled(true);
        this.jLabStep3.setEnabled(false);
        this.jLabStep4.setEnabled(false);
        this.jLabStep5.setEnabled(false);
    }

    public CloneWizard(Frame frame) {
        super(frame);
        this.initialize();
    }

    private void initialize() {
        this.setSize(830, 700);
        this.setTitle("CryptoServer Database Backup/Restore Wizard");
        this.setPreferredSize(new Dimension(800, 700));
        this.setMinimumSize(new Dimension(800, 700));
        this.setContentPane(this.getJContentPane());
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.setPreferredSize(new Dimension(820, 700));
            this.jContentPane.add((Component)this.getJPanelWest(), "West");
            this.jContentPane.add((Component)this.getJPanelEast(), "East");
            this.jContentPane.add((Component)this.getJPanelSouth(), "South");
            this.jContentPane.add((Component)this.getJPanelCenter(), "Center");
            ActionListener actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    CloneWizard.this.setVisible(false);
                }
            };
            KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0);
            this.jContentPane.registerKeyboardAction(actionListener, keyStroke, 2);
            WindowAdapter windowAdapter = new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent windowEvent) {
                    CloneWizard.this.dispose();
                }
            };
            this.addWindowListener(windowAdapter);
        }
        return this.jContentPane;
    }

    private JPanel getJPanelWest() {
        if (this.jPanelWest == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.gridy = 7;
            this.jLabDummy1 = new JLabel();
            this.jLabDummy1.setText("                                              ");
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.anchor = 18;
            gridBagConstraints2.insets = new Insets(10, 0, 0, 0);
            gridBagConstraints2.weighty = 0.0;
            gridBagConstraints2.gridy = 6;
            this.jLabStep5 = new JLabel();
            this.jLabStep5.setText("5. Import MBK");
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.anchor = 18;
            gridBagConstraints3.insets = new Insets(10, 0, 0, 0);
            gridBagConstraints3.gridy = 5;
            this.jLabStep4 = new JLabel();
            this.jLabStep4.setText("4. Set Time");
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.anchor = 18;
            gridBagConstraints4.insets = new Insets(10, 0, 0, 0);
            gridBagConstraints4.gridy = 4;
            this.jLabStep3 = new JLabel();
            this.jLabStep3.setText("3. ADMIN Login (Target)");
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.gridx = 0;
            gridBagConstraints5.anchor = 18;
            gridBagConstraints5.insets = new Insets(10, 0, 0, 0);
            gridBagConstraints5.gridy = 2;
            this.jLabStep2 = new JLabel();
            this.jLabStep2.setText("2. ADMIN Login (Source)");
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.gridx = 0;
            gridBagConstraints6.anchor = 18;
            gridBagConstraints6.insets = new Insets(10, 0, 0, 0);
            gridBagConstraints6.weighty = 0.0;
            gridBagConstraints6.gridy = 1;
            this.jLabStep1 = new JLabel();
            this.jLabStep1.setText("1. Select Databases");
            this.jLabStep1.setFont(new Font("Dialog", 0, 11));
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.gridx = 0;
            gridBagConstraints7.fill = 2;
            gridBagConstraints7.anchor = 18;
            gridBagConstraints7.insets = new Insets(10, 0, 5, 0);
            gridBagConstraints7.weighty = 0.0;
            gridBagConstraints7.gridy = 0;
            this.jLabSteps = new JLabel();
            this.jLabSteps.setText("User Steps");
            this.jLabSteps.setBorder(BorderFactory.createTitledBorder(null, "", 0, 0, null, null));
            this.jLabSteps.setFont(new Font("Dialog", 1, 14));
            GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
            gridBagConstraints8.gridx = 0;
            gridBagConstraints8.anchor = 10;
            gridBagConstraints8.gridy = 0;
            this.jPanelWest = new JPanel();
            this.jPanelWest.setLayout(new GridBagLayout());
            this.jPanelWest.setPreferredSize(new Dimension(190, 315));
            this.jPanelWest.setMinimumSize(new Dimension(150, 315));
            this.jPanelWest.setBorder(BorderFactory.createCompoundBorder(null, null));
            this.jPanelWest.setBackground(Color.white);
            this.jPanelWest.add((Component)this.jLabSteps, gridBagConstraints7);
            this.jPanelWest.add((Component)this.jLabStep1, gridBagConstraints6);
            this.jPanelWest.add((Component)this.jLabStep2, gridBagConstraints5);
            this.jPanelWest.add((Component)this.jLabStep3, gridBagConstraints4);
            this.jPanelWest.add((Component)this.jLabStep4, gridBagConstraints3);
            this.jPanelWest.add((Component)this.jLabStep5, gridBagConstraints2);
            this.jPanelWest.add((Component)this.jLabDummy1, gridBagConstraints);
        }
        return this.jPanelWest;
    }

    private JPanel getJPanelEast() {
        if (this.jPanelEast == null) {
            this.jPanelEast = new JPanel();
            this.jPanelEast.setLayout(new GridBagLayout());
            this.jPanelEast.setMinimumSize(new Dimension(10, 315));
            this.jPanelEast.setPreferredSize(new Dimension(10, 315));
        }
        return this.jPanelEast;
    }

    private JPanel getJPanelSouth() {
        if (this.jPanelSouth == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setAlignment(2);
            this.jPanelSouth = new JPanel();
            this.jPanelSouth.setLayout(flowLayout);
            this.jPanelSouth.setPreferredSize(new Dimension(740, 45));
            this.jPanelSouth.setMinimumSize(new Dimension(740, 45));
            this.jPanelSouth.setBorder(BorderFactory.createLineBorder(SystemColor.textHighlight, 1));
            this.jPanelSouth.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
            this.jPanelSouth.add((Component)this.getJBtCancel(), null);
            this.jPanelSouth.add((Component)this.getJBNext(), null);
        }
        return this.jPanelSouth;
    }

    private JPanel getJPanelCenter() {
        if (this.jPanelCenter == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(5, 10, 0, 10);
            gridBagConstraints.gridwidth = 3;
            gridBagConstraints.gridy = 4;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 1;
            gridBagConstraints2.insets = new Insets(10, 10, 0, 10);
            gridBagConstraints2.gridwidth = 0;
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2.gridy = 2;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 1;
            gridBagConstraints3.fill = 1;
            gridBagConstraints3.gridwidth = 3;
            gridBagConstraints3.insets = new Insets(20, 10, 10, 10);
            gridBagConstraints3.weighty = 1.0;
            gridBagConstraints3.weightx = 1.0;
            gridBagConstraints3.gridy = 6;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.fill = 2;
            gridBagConstraints4.anchor = 17;
            gridBagConstraints4.gridwidth = 4;
            gridBagConstraints4.insets = new Insets(10, 10, 0, 10);
            gridBagConstraints4.gridy = 1;
            this.jLabHeadline = new JLabel();
            this.jLabHeadline.setText("Select Databases for Backup/Restore");
            this.jLabHeadline.setBorder(BorderFactory.createTitledBorder(null, "", 0, 0, null, null));
            this.jLabHeadline.setFont(new Font("Dialog", 1, 14));
            this.jPanelCenter = new JPanel();
            this.jPanelCenter.setLayout(new GridBagLayout());
            this.jPanelCenter.setPreferredSize(new Dimension(500, 600));
            this.jPanelCenter.setMinimumSize(new Dimension(540, 325));
            this.jPanelCenter.add((Component)this.jLabHeadline, gridBagConstraints4);
            this.jPanelCenter.add((Component)this.getJPanelTables(), gridBagConstraints3);
            this.jPanelCenter.add((Component)this.getJPanelCommand(), gridBagConstraints2);
            this.jPanelCenter.add((Component)this.getJPanelSettings(), gridBagConstraints);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.jRdSource2Backup);
            buttonGroup.add(this.jRdBackup2Target);
            buttonGroup.add(this.jRdSource2Target);
        }
        return this.jPanelCenter;
    }

    private JPanel getJPanelCommand() {
        if (this.jPanelCommand == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(5, 10, 0, 0);
            gridBagConstraints.gridy = 1;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridx = 0;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 2;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.insets = new Insets(5, 10, 0, 0);
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.anchor = 17;
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.gridy = 0;
            gridBagConstraints3.fill = 2;
            gridBagConstraints3.gridwidth = 1;
            gridBagConstraints3.weightx = 1.0;
            gridBagConstraints3.insets = new Insets(5, 10, 0, 0);
            this.jPanelCommand = new JPanel();
            this.jPanelCommand.setLayout(new GridBagLayout());
            this.jPanelCommand.setBorder(new TitledBorder(new EtchedBorder(1, null, null), "Command", 1, 2, null, Color.BLACK));
            this.jPanelCommand.add((Component)this.getJRdSource(), gridBagConstraints3);
            this.jPanelCommand.add((Component)this.getJRdTargetCS(), gridBagConstraints);
            this.jPanelCommand.add((Component)this.getJRdSource2Target(), gridBagConstraints2);
        }
        return this.jPanelCommand;
    }

    private JPanel getJPanelSettings() {
        if (this.jPanelSettings == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(10, 0, 10, 10);
            gridBagConstraints.gridy = 2;
            gridBagConstraints.gridx = 2;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.fill = 1;
            gridBagConstraints2.gridx = 1;
            gridBagConstraints2.gridy = 2;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.insets = new Insets(10, 10, 10, 5);
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.fill = 1;
            gridBagConstraints3.gridx = 1;
            gridBagConstraints3.gridy = 2;
            gridBagConstraints3.weightx = 1.0;
            gridBagConstraints3.insets = new Insets(10, 10, 0, 5);
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.anchor = 17;
            gridBagConstraints4.insets = new Insets(10, 10, 10, 0);
            gridBagConstraints4.gridy = 2;
            this.jLabBackupDir = new JLabel();
            this.jLabBackupDir.setText("Backup directory");
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.anchor = 10;
            gridBagConstraints5.insets = new Insets(10, 10, 0, 5);
            gridBagConstraints5.gridx = 1;
            gridBagConstraints5.gridy = 1;
            gridBagConstraints5.weightx = 1.0;
            gridBagConstraints5.fill = 1;
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.anchor = 17;
            gridBagConstraints6.gridx = 0;
            gridBagConstraints6.insets = new Insets(10, 10, 0, 0);
            gridBagConstraints6.gridy = 1;
            this.jLabTargetCS = new JLabel();
            this.jLabTargetCS.setText("Target CryptoServer");
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.fill = 1;
            gridBagConstraints7.gridwidth = 1;
            gridBagConstraints7.gridx = -1;
            gridBagConstraints7.gridy = -1;
            gridBagConstraints7.weightx = 1.0;
            gridBagConstraints7.insets = new Insets(5, 10, 0, 5);
            GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
            gridBagConstraints8.anchor = 17;
            gridBagConstraints8.insets = new Insets(5, 10, 0, 0);
            gridBagConstraints8.fill = 0;
            this.jLabSourceCS = new JLabel();
            this.jLabSourceCS.setText("Source CryptoServer");
            this.jPanelSettings = new JPanel();
            this.jPanelSettings.setLayout(new GridBagLayout());
            this.jPanelSettings.setBorder(new TitledBorder(new EtchedBorder(1, null, null), "Settings", 4, 2, null, Color.BLACK));
            this.jPanelSettings.add((Component)this.jLabSourceCS, gridBagConstraints8);
            this.jPanelSettings.add((Component)this.getJCbSourceAddr(), gridBagConstraints7);
            this.jPanelSettings.add((Component)this.jLabTargetCS, gridBagConstraints6);
            this.jPanelSettings.add((Component)this.getJCbTargetAddr(), gridBagConstraints5);
            this.jPanelSettings.add((Component)this.jLabBackupDir, gridBagConstraints4);
            this.jPanelSettings.add((Component)this.getJTxtBackupDir(), gridBagConstraints2);
            this.jPanelSettings.add((Component)this.getJBtDirPath(), gridBagConstraints);
        }
        return this.jPanelSettings;
    }

    private JPanel getJPanelTables() {
        if (this.jPanelTables == null) {
            this.jPanelTables = new JPanel();
            this.jPanelTables.setLayout(new BoxLayout(this.getJPanelTables(), 0));
            this.jPanelTables.add((Component)this.getJPanelLeftTab(), null);
            this.jPanelTables.add((Component)this.getJPanelMid(), null);
            this.jPanelTables.add((Component)this.getJPanelRightTab(), null);
        }
        return this.jPanelTables;
    }

    private JPanel getJPanelLeftTab() {
        if (this.jPanelLeftTab == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(5, 10, 5, 0);
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.gridy = 0;
            this.jLabAvailFiles = new JLabel();
            this.jLabAvailFiles.setText("Source CryptoServer");
            this.jLabAvailFiles.setFont(new Font("Dialog", 1, 11));
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.fill = 1;
            gridBagConstraints2.weighty = 1.0;
            gridBagConstraints2.gridy = 1;
            gridBagConstraints2.weightx = 2.0;
            this.jPanelLeftTab = new JPanel();
            this.jPanelLeftTab.setLayout(new GridBagLayout());
            this.jPanelLeftTab.setName("jPanelLeftTab");
            this.jPanelLeftTab.add((Component)this.jLabAvailFiles, gridBagConstraints);
            this.jPanelLeftTab.add((Component)this.getJSPSource(), gridBagConstraints2);
        }
        return this.jPanelLeftTab;
    }

    private JPanel getJPanelMid() {
        if (this.jPanelMid == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(30, 20, 0, 20);
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2.insets = new Insets(10, 20, 0, 20);
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.gridy = 3;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.anchor = 17;
            gridBagConstraints3.insets = new Insets(20, 20, 0, 20);
            gridBagConstraints3.fill = 2;
            gridBagConstraints3.gridy = 2;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.anchor = 17;
            gridBagConstraints4.insets = new Insets(10, 20, 0, 20);
            gridBagConstraints4.fill = 2;
            gridBagConstraints4.gridy = 1;
            this.jPanelMid = new JPanel();
            this.jPanelMid.setLayout(new GridBagLayout());
            this.jPanelMid.setName("jPanelMid");
            this.jPanelMid.add((Component)this.getJBtAddAll(), gridBagConstraints);
            this.jPanelMid.add((Component)this.getJBtAdd(), gridBagConstraints4);
            this.jPanelMid.add((Component)this.getJBtRemove(), gridBagConstraints3);
            this.jPanelMid.add((Component)this.getJBtRemoveAll(), gridBagConstraints2);
        }
        return this.jPanelMid;
    }

    private JPanel getJPanelRightTab() {
        if (this.jPanelRightTab == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(5, 10, 5, 0);
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.gridy = 0;
            this.jLabTargetFiles = new JLabel();
            this.jLabTargetFiles.setText("Backup Directory   ");
            this.jLabTargetFiles.setFont(new Font("Dialog", 1, 11));
            this.jLabTargetFiles.setName("");
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.fill = 1;
            gridBagConstraints2.weighty = 1.0;
            gridBagConstraints2.gridx = 2;
            gridBagConstraints2.gridy = 1;
            gridBagConstraints2.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints2.weightx = 2.0;
            this.jPanelRightTab = new JPanel();
            this.jPanelRightTab.setLayout(new GridBagLayout());
            this.jPanelRightTab.add((Component)this.jLabTargetFiles, gridBagConstraints);
            this.jPanelRightTab.add((Component)this.getJSpTarget(), gridBagConstraints2);
        }
        return this.jPanelRightTab;
    }

    private JRadioButton getJRdSource() {
        if (this.jRdSource2Backup == null) {
            this.jRdSource2Backup = new JRadioButton();
            this.jRdSource2Backup.setText("Backup databases from source CryptoServer to backup directory");
            this.jRdSource2Backup.setSelected(true);
            this.jRdSource2Backup.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (CloneWizard.this.jRdSource2Backup.isSelected()) {
                        CloneWizard.this.jCbTargetAddr.setEnabled(false);
                        CloneWizard.this.FillSourceTable(CloneWizard.this.strSourceDBName);
                        CloneWizard.this.jLabAvailFiles.setText(CloneWizard.this.strInfoSource1);
                        CloneWizard.this.jLabTargetFiles.setText(CloneWizard.this.strInfoTarget2);
                        CloneWizard.this.CleanTargetTable();
                        CloneWizard.this.jLabStep1.setEnabled(true);
                        CloneWizard.this.jLabStep2.setText("2. ADMIN Login (Source)");
                        CloneWizard.this.jLabStep2.setEnabled(true);
                        CloneWizard.this.jLabStep3.setEnabled(false);
                        CloneWizard.this.jLabStep4.setEnabled(false);
                        CloneWizard.this.jLabStep5.setEnabled(false);
                    } else {
                        CloneWizard.this.jCbTargetAddr.setEnabled(true);
                    }
                }
            });
        }
        return this.jRdSource2Backup;
    }

    private JRadioButton getJRdSource2Target() {
        if (this.jRdSource2Target == null) {
            this.jRdSource2Target = new JRadioButton();
            this.jRdSource2Target.setText("Copy databases from source CryptoServer to target CryptoServer");
            this.jRdSource2Target.setSelected(false);
            this.jRdSource2Target.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (CloneWizard.this.jRdSource2Target.isSelected()) {
                        CloneWizard.this.jTxtBackupDir.setEnabled(false);
                        CloneWizard.this.jBtDirPath.setEnabled(false);
                        CloneWizard.this.FillSourceTable(CloneWizard.this.strSourceDBName);
                        CloneWizard.this.jLabAvailFiles.setText(CloneWizard.this.strInfoSource1);
                        CloneWizard.this.jLabTargetFiles.setText(CloneWizard.this.strInfoTarget1);
                        CloneWizard.this.CleanTargetTable();
                        CloneWizard.this.jLabStep1.setEnabled(true);
                        CloneWizard.this.jLabStep2.setText("2. ADMIN Login (Source)");
                        CloneWizard.this.jLabStep2.setEnabled(true);
                        CloneWizard.this.jLabStep3.setEnabled(true);
                        CloneWizard.this.jLabStep4.setEnabled(true);
                        CloneWizard.this.jLabStep5.setEnabled(true);
                    } else {
                        CloneWizard.this.jTxtBackupDir.setEnabled(true);
                        CloneWizard.this.jBtDirPath.setEnabled(true);
                    }
                }
            });
        }
        return this.jRdSource2Target;
    }

    private JRadioButton getJRdTargetCS() {
        if (this.jRdBackup2Target == null) {
            this.jRdBackup2Target = new JRadioButton();
            this.jRdBackup2Target.setText("Restore databases from backup directory to target CryptoServer");
            this.jRdBackup2Target.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (CloneWizard.this.jRdBackup2Target.isSelected()) {
                        CloneWizard.this.jCbSourceAddr.setEnabled(false);
                        CloneWizard.this.ShowDBFiles();
                        CloneWizard.this.jLabAvailFiles.setText(CloneWizard.this.strInfoSource2);
                        CloneWizard.this.jLabTargetFiles.setText(CloneWizard.this.strInfoTarget1);
                        CloneWizard.this.CleanTargetTable();
                        CloneWizard.this.jLabStep1.setEnabled(true);
                        CloneWizard.this.jLabStep2.setText("2. ADMIN Login (Target)");
                        CloneWizard.this.jLabStep2.setEnabled(true);
                        CloneWizard.this.jLabStep3.setEnabled(false);
                        CloneWizard.this.jLabStep4.setEnabled(false);
                        CloneWizard.this.jLabStep5.setEnabled(false);
                    } else {
                        CloneWizard.this.jCbSourceAddr.setEnabled(true);
                    }
                }
            });
        }
        return this.jRdBackup2Target;
    }

    private JTextField getJTxtBackupDir() {
        if (this.jTxtBackupDir == null) {
            this.jTxtBackupDir = new JTextField();
        }
        return this.jTxtBackupDir;
    }

    private JComboBox getJCbTargetAddr() {
        if (this.jCbTargetAddr == null) {
            this.jCbTargetAddr = new JComboBox();
            this.jCbTargetAddr.setEditable(true);
            this.jCbTargetAddr.setEnabled(false);
            this.jCbTargetAddr.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (CloneWizard.this.jCbTargetAddr.getSelectedItem().toString().trim().length() == 0) {
                        return;
                    }
                    CloneWizard.this.strTargetAddr = CloneWizard.this.jCbTargetAddr.getSelectedItem().toString();
                    if (CloneWizard.this.jRdBackup2Target.isSelected() || CloneWizard.this.jRdSource2Target.isSelected()) {
                        CloneWizard.this.SetNewDevice(CloneWizard.this.strTargetAddr);
                    }
                }
            });
        }
        return this.jCbTargetAddr;
    }

    private JComboBox getJCbSourceAddr() {
        if (this.jCbSourceAddr == null) {
            this.jCbSourceAddr = new JComboBox();
            this.jCbSourceAddr.setEditable(true);
            this.jCbSourceAddr.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (CloneWizard.this.jCbSourceAddr.getSelectedItem().toString().trim().length() == 0) {
                        return;
                    }
                    if (CloneWizard.this.b_start) {
                        CloneWizard.this.CleanTargetTable();
                        CloneWizard.this.FillSourceTable(CloneWizard.this.strSourceDBName);
                    }
                }
            });
        }
        return this.jCbSourceAddr;
    }

    private void init_addr_cb() {
        String string = "";
        int n = 0;
        string = this.ini.GetCSCurrentDevice();
        this.jCbSourceAddr.removeAllItems();
        this.jCbTargetAddr.removeAllItems();
        String string2 = string;
        this.jCbSourceAddr.addItem(this.makeObj(string2));
        this.jCbTargetAddr.addItem(this.makeObj(string2));
        String string3 = this.ini.GetCSDeviceList();
        Object[] objectArray = string3.split(";;");
        n = objectArray.length;
        Arrays.sort(objectArray);
        for (int i = 0; i < n; ++i) {
            if (string2.compareTo((String)objectArray[i]) == 0) continue;
            this.jCbSourceAddr.addItem(this.makeObj((String)objectArray[i]));
            this.jCbTargetAddr.addItem(this.makeObj((String)objectArray[i]));
        }
    }

    private JButton getJBtDirPath() {
        if (this.jBtDirPath == null) {
            this.jBtDirPath = new JButton();
            this.jBtDirPath.setText("...");
            this.jBtDirPath.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    CloneWizard.this.strBackupDir = CloneWizard.this.tools.ShowSelectPathDlg(CloneWizard.this, "CryptoServer Database Backup Directory", CloneWizard.this.ini.GetDBBackupFilePath());
                    if (CloneWizard.this.strBackupDir == "") {
                        return;
                    }
                    CloneWizard.this.ini.SetDBBackupFilePath(CloneWizard.this.strBackupDir);
                    CloneWizard.this.jTxtBackupDir.setText(CloneWizard.this.strBackupDir);
                    if (CloneWizard.this.jRdBackup2Target.isSelected()) {
                        CloneWizard.this.ShowDBFiles();
                    }
                }
            });
        }
        return this.jBtDirPath;
    }

    private JButton getJBtAddAll() {
        if (this.jBtAddAll == null) {
            this.jBtAddAll = new JButton();
            this.jBtAddAll.setText("Add All >>");
            this.jBtAddAll.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = CloneWizard.this.model_source.getRowCount();
                    CloneWizard.this.CleanTargetTable();
                    for (int i = 0; i < n; ++i) {
                        CloneWizard.this.rowData[0] = CloneWizard.this.jTabSource.getValueAt(i, 0).toString();
                        CloneWizard.this.model_target.addRow(CloneWizard.this.rowData);
                    }
                }
            });
        }
        return this.jBtAddAll;
    }

    private JButton getJBtAdd() {
        if (this.jBtAdd == null) {
            this.jBtAdd = new JButton();
            this.jBtAdd.setText("Add >>");
            this.jBtAdd.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Object[] objectArray = new Object[1];
                    Object[] objectArray2 = new Object[1];
                    ListSelectionModel listSelectionModel = CloneWizard.this.jTabSource.getSelectionModel();
                    int n = CloneWizard.this.model_source.getRowCount();
                    boolean bl = false;
                    for (int i = 1; i <= n; ++i) {
                        if (!listSelectionModel.isSelectedIndex(i - 1)) continue;
                        int n2 = CloneWizard.this.model_target.getRowCount();
                        objectArray2[0] = CloneWizard.this.jTabSource.getValueAt(i - 1, 0).toString();
                        for (int j = 1; j <= n2; ++j) {
                            objectArray[0] = CloneWizard.this.jTabTarget.getValueAt(j - 1, 0).toString();
                            if (objectArray2[0].equals(objectArray[0])) {
                                bl = true;
                                break;
                            }
                            bl = false;
                        }
                        if (bl) continue;
                        CloneWizard.this.model_target.addRow(objectArray2);
                    }
                }
            });
        }
        return this.jBtAdd;
    }

    private JButton getJBtRemove() {
        if (this.jBtRemove == null) {
            this.jBtRemove = new JButton();
            this.jBtRemove.setText("Remove");
            this.jBtRemove.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ListSelectionModel listSelectionModel = CloneWizard.this.jTabTarget.getSelectionModel();
                    int n = CloneWizard.this.model_target.getRowCount();
                    for (int i = 1; i <= n; ++i) {
                        if (!listSelectionModel.isSelectedIndex(i - 1)) continue;
                        CloneWizard.this.model_target.removeRow(i - 1);
                        --i;
                    }
                }
            });
        }
        return this.jBtRemove;
    }

    private JButton getJBtRemoveAll() {
        if (this.jBtRemoveAll == null) {
            this.jBtRemoveAll = new JButton();
            this.jBtRemoveAll.setText("Remove All");
            this.jBtRemoveAll.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    CloneWizard.this.CleanTargetTable();
                }
            });
        }
        return this.jBtRemoveAll;
    }

    private JButton getJBtCancel() {
        if (this.jBtCancel == null) {
            this.jBtCancel = new JButton();
            this.jBtCancel.setText("Close");
            this.jBtCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    CloneWizard.this.dispose();
                }
            });
        }
        return this.jBtCancel;
    }

    private JButton getJBNext() {
        if (this.jBtNext == null) {
            this.jBtNext = new JButton();
            this.jBtNext.setText("Execute");
            this.jBtNext.setEnabled(true);
            this.jBtNext.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    String string = "No entry for Target CryptoServer in Settings section";
                    int n = 0;
                    n = CloneWizard.this.ReadTargetTable();
                    if (n <= 0) {
                        CloneWizard.this.tools.DisplayInfOptMsg(CloneWizard.this, "No database(s) selected");
                        return;
                    }
                    if (CloneWizard.this.jRdSource2Backup.isSelected()) {
                        CloneWizard.this.strSourceAddr = CloneWizard.this.jCbSourceAddr.getSelectedItem().toString();
                        if (!Global.b_22000000_login) {
                            CloneWizard.this.UserLogin("Login User for Source CryptoServer (" + CloneWizard.this.strSourceAddr + ")");
                        }
                        if (!Global.b_22000000_login) {
                            CloneWizard.this.tools.DisplayErrorMsg(CloneWizard.this, "Invalid login state (necessary: 22000000)");
                            return;
                        }
                        CloneWizard.this.ExportDatabases();
                    } else if (CloneWizard.this.jRdBackup2Target.isSelected()) {
                        CloneWizard.this.strTargetAddr = CloneWizard.this.jCbTargetAddr.getSelectedItem().toString();
                        if (CloneWizard.this.strTargetAddr.length() <= 0) {
                            CloneWizard.this.tools.DisplayInfOptMsg(CloneWizard.this, string);
                            return;
                        }
                        CloneWizard.this.ImportDatabases();
                    } else {
                        CloneWizard.this.strTargetAddr = CloneWizard.this.jCbTargetAddr.getSelectedItem().toString();
                        if (CloneWizard.this.strTargetAddr.length() <= 0) {
                            CloneWizard.this.tools.DisplayInfOptMsg(CloneWizard.this, string);
                            return;
                        }
                        try {
                            CloneWizard.this.CloningProcess();
                        }
                        catch (InterruptedException interruptedException) {
                            interruptedException.printStackTrace();
                        }
                    }
                }
            });
        }
        return this.jBtNext;
    }

    private JScrollPane getJSpTarget() {
        if (this.jSpTarget == null) {
            this.jSpTarget = new JScrollPane();
            this.jSpTarget.setViewportView(this.getJTabTarget());
        }
        return this.jSpTarget;
    }

    private JTable getJTabTarget() {
        if (this.jTabTarget == null) {
            this.jTabTarget = new JTable(this.model_target);
            this.jTabTarget.setRowHeight(20);
            this.jTabTarget.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    if (mouseEvent.getClickCount() > 1) {
                        ListSelectionModel listSelectionModel = CloneWizard.this.jTabTarget.getSelectionModel();
                        int n = CloneWizard.this.model_target.getRowCount();
                        for (int i = 1; i <= n; ++i) {
                            if (!listSelectionModel.isSelectedIndex(i - 1)) continue;
                            CloneWizard.this.model_target.removeRow(i - 1);
                        }
                    }
                }
            });
            JLabel jLabel = (JLabel)((Object)this.jTabTarget.getDefaultRenderer(Object.class));
            jLabel.setHorizontalAlignment(0);
            this.jTabTarget.getTableHeader().setReorderingAllowed(false);
        }
        return this.jTabTarget;
    }

    private JScrollPane getJSPSource() {
        if (this.jSPSource == null) {
            this.jSPSource = new JScrollPane();
            this.jSPSource.setViewportView(this.getJTabSource());
        }
        return this.jSPSource;
    }

    private JTable getJTabSource() {
        if (this.jTabSource == null) {
            this.jTabSource = new JTable(this.model_source);
            this.jTabSource.setRowHeight(20);
            this.jTabSource.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    if (mouseEvent.getClickCount() > 1) {
                        Object[] objectArray = new Object[1];
                        Object[] objectArray2 = new Object[1];
                        ListSelectionModel listSelectionModel = CloneWizard.this.jTabSource.getSelectionModel();
                        int n = CloneWizard.this.model_source.getRowCount();
                        boolean bl = false;
                        for (int i = 1; i <= n; ++i) {
                            if (!listSelectionModel.isSelectedIndex(i - 1)) continue;
                            int n2 = CloneWizard.this.model_target.getRowCount();
                            objectArray2[0] = CloneWizard.this.jTabSource.getValueAt(i - 1, 0).toString();
                            for (int j = 1; j <= n2; ++j) {
                                objectArray[0] = CloneWizard.this.jTabTarget.getValueAt(j - 1, 0).toString();
                                if (objectArray2[0].equals(objectArray[0])) {
                                    bl = true;
                                    break;
                                }
                                bl = false;
                            }
                            if (bl) continue;
                            CloneWizard.this.model_target.addRow(objectArray2);
                        }
                    }
                }
            });
            JLabel jLabel = (JLabel)((Object)this.jTabSource.getDefaultRenderer(Object.class));
            jLabel.setHorizontalAlignment(0);
            this.jTabSource.getTableHeader().setReorderingAllowed(false);
        }
        return this.jTabSource;
    }

    public void ShowLeftListResult() {
        if (!this.b_start) {
            return;
        }
        String[] stringArray = this.strSourceFW.split("\n");
        for (int i = 0; i < stringArray.length; ++i) {
            int n = stringArray[i].indexOf(".db");
            if (n == -1) continue;
            String string = stringArray[i].substring(0, n += 3);
            int n2 = string.indexOf("\\") + 1;
            this.rowData[0] = stringArray[i].substring(n2, n);
            if (this.rowData[0].toString().compareTo("MBK.db") == 0 || this.rowData[0].toString().compareTo("VMBK1.db") == 0 || this.rowData[0].toString().compareTo("sess_obj.db") == 0 || this.rowData[0].toString().compareTo("KUUREG.db") == 0) continue;
            this.model_source.addRow(this.rowData);
        }
    }

    private void CleanTargetTable() {
        for (int i = this.model_target.getRowCount(); i > 0; --i) {
            this.model_target.removeRow(i - 1);
        }
    }

    private void CleanSourceTable() {
        for (int i = this.model_source.getRowCount(); i > 0; --i) {
            this.model_source.removeRow(i - 1);
        }
    }

    public void FillSourceTable(String string) {
        this.CleanSourceTable();
        int n = this.model_source.getRowCount();
        if (this.b_first && n == 0) {
            this.model_source.addColumn(string);
            this.b_first = false;
        }
        this.strSourceAddr = this.jCbSourceAddr.getSelectedItem().toString();
        Global.b_UpdateCBCSAddr = true;
        this.admin.jCbStatCSAddr.setSelectedItem(this.makeObj("Device: " + this.strSourceAddr));
        Global.b_UpdateCBCSAddr = false;
        this.strSourceAddr = this.strSourceAddr.toString();
        if (this.strSourceAddr.length() == 0) {
            this.tools.DisplayErrorMsg(this, "Invalid source address");
            return;
        }
        this.b_ShowModulesActive = false;
        tools_thread.SetMethodForThread(this, "CSCheckModules");
    }

    public void CSCheckModules() {
        String string;
        tools_thread.waitStart();
        if (this.b_ShowModulesActive) {
            CSJApi.CSClose();
            if (Global.strCurrentCSAddr != this.strTargetAddr && (string = CSJApi.CSOpen(this.strTargetAddr)).indexOf("Error") == 0) {
                Global.strCurrentCSAddr = "";
                tools_thread.waitEnd();
                this.tools.DisplayErrorMsg(this, "Cannot get connection to target CryptoServer");
                this.b_error = true;
                return;
            }
            Global.strCurrentCSAddr = this.strTargetAddr;
            this.strTargetFW = CSJApi.CSListModulesActive();
            if (this.strTargetFW.indexOf("Error") == 0) {
                tools_thread.waitEnd();
                this.tools.DisplayErrorMsg(this, "List Firmware command to target CryptoServer failed");
                this.b_error = true;
                return;
            }
        }
        if (Global.strCurrentCSAddr.compareTo(this.strSourceAddr) != 0) {
            CSJApi.CSClose();
            string = CSJApi.CSOpen(this.strSourceAddr);
            if (string.indexOf("Error") == 0) {
                Global.strCurrentCSAddr = "";
                tools_thread.waitStart();
                this.tools.DisplayErrorMsg(this, "Cannot get connection to source CryptoServer");
                this.b_error = true;
                return;
            }
        }
        Global.strCurrentCSAddr = this.strSourceAddr;
        this.strSourceFW = this.b_ShowModulesActive ? CSJApi.CSListModulesActive() : CSJApi.CSListFiles();
        if (this.strSourceFW.indexOf("Error") == 0) {
            tools_thread.waitEnd();
            this.tools.DisplayErrorMsg(this, "List Firmware/Files command to source CryptoServer failed");
            this.b_error = true;
            return;
        }
        this.b_error = false;
        if (this.b_ShowModulesActive) {
            try {
                while (true) {
                    Thread.sleep(3000L);
                }
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                tools_thread.waitEnd();
                return;
            }
        }
        this.ShowLeftListResult();
        tools_thread.waitEnd();
    }

    public void FillTargetTable(String string) {
        this.CleanTargetTable();
        this.model_target.addColumn(string);
    }

    public int ReadTargetTable() {
        int n = this.model_target.getRowCount();
        this.strSelDBs = new String[n];
        for (int i = 0; i < n; ++i) {
            this.strSelDBs[i] = this.jTabTarget.getValueAt(i, 0).toString();
        }
        return n;
    }

    private Object makeObj(final String string) {
        return new Object(){

            public String toString() {
                return string;
            }
        };
    }

    private void ShowDBFiles() {
        String string = this.jTxtBackupDir.getText();
        this.strSourceFW = "";
        ArrayList<File> arrayList = new ArrayList<File>();
        File file = new File(string);
        File[] fileArray = file.listFiles(new FileNameFilter(".db"));
        if (fileArray == null) {
            return;
        }
        for (int i = 0; i < fileArray.length; ++i) {
            arrayList.add(fileArray[i]);
        }
        for (File file2 : arrayList) {
            try {
                this.strSourceFW = this.strSourceFW + file2.getCanonicalFile().getName() + "\n";
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        this.CleanSourceTable();
        this.ShowLeftListResult();
    }

    public void ImportDatabases() {
        this.strBackupDir = this.jTxtBackupDir.getText();
        if (this.strBackupDir.length() == 0) {
            this.tools.DisplayInfoMsg(this, "Invalid entry for Backup directory");
        }
        if (!Global.b_22000000_login) {
            this.UserLogin("Login User for Target CryptoServer (" + this.strTargetAddr + ")");
        }
        tools_thread.SetMethodForThread(this, "CSImportDBs");
    }

    public void CSImportDBs() {
        String string = "";
        boolean bl = false;
        tools_thread.waitStart();
        for (int i = 0; i < this.strSelDBs.length; ++i) {
            String string2 = this.strBackupDir + "/" + this.strSelDBs[i];
            String string3 = CSJApi.CSImpDatabase(string2);
            if (string3.indexOf("B906C001") != -1) {
                this.tools.DisplayInfoMsg(this, "There are no CryptoServer database entries in --- " + this.strSelDBs[i] + " --- !");
                continue;
            }
            if (string3.compareTo("") == 0) {
                string = string + "      - " + this.strSelDBs[i] + "\r\n";
                bl = true;
                continue;
            }
            tools_thread.waitEnd();
            if (string3.indexOf("B0870024") != -1) {
                this.tools.DisplayErrorMsg(this, "There is no MBK in target CryptoServer available!\r\nCryptoServer cannot decrypt a MBK encrypted database file.");
                continue;
            }
            int n = this.tools.DisplayYesNoMsg(this, "Cannot import --- " + this.strSelDBs[i] + " --- database!\r\n" + string3 + "\r\nDo you want to continue?");
            if (n != 0) break;
        }
        tools_thread.Sleep(100);
        tools_thread.waitEnd();
        if (bl) {
            this.tools.DisplayOutput(this, "Database Import", "Imported Databases", string);
        }
    }

    public void ExportDatabases() {
        this.strBackupDir = this.jTxtBackupDir.getText();
        if (this.strBackupDir.length() == 0) {
            this.tools.DisplayInfoMsg(this, "Invalid entry for Backup directory");
        }
        this.strBackupDir = this.strBackupDir + "/";
        tools_thread.SetMethodForThread(this, "CSExportDBs");
    }

    public void CSExportDBs() {
        String string = "";
        boolean bl = false;
        tools_thread.waitStart();
        this.b_back_thr_ended = false;
        for (int i = 0; i < this.strSelDBs.length; ++i) {
            if (!this.tools.FileOverwrite(this, this.strBackupDir + this.strSelDBs[i])) continue;
            String string2 = CSJApi.CSExpDatabase(this.strBackupDir, this.strSelDBs[i]);
            if (string2.compareTo("") == 0) {
                string = string + "      - " + this.strSelDBs[i] + "\r\n";
                bl = true;
                continue;
            }
            tools_thread.waitEnd();
            if (string2.indexOf("B0870024") != -1) {
                this.tools.DisplayErrorMsg(this, "There is no MBK in source CryptoServer available!\r\nCryptoServer cannot create a MBK encrypted database file.");
                tools_thread.waitEnd();
                return;
            }
            int n = this.tools.DisplayYesNoMsg(this, "Cannot export --- " + this.strSelDBs[i] + " --- database!\r\n" + string2 + "\r\nDo you want to continue?");
            if (n != 0) break;
        }
        tools_thread.Sleep(800);
        tools_thread.waitEnd();
        if (bl) {
            this.tools.DisplayOutput(this, "Database Export", "Exported Databases", string);
        }
        this.b_back_thr_ended = true;
        tools_thread.waitEnd();
    }

    public void UserLogin(String string) {
        UserLogin userLogin = new UserLogin(this.admin, string, this);
        userLogin.setLocationRelativeTo(this);
        userLogin.setModal(true);
        userLogin.pack();
        userLogin.setVisible(true);
    }

    public void SetNewDevice(String string) {
        this.strCSAddress = string;
        if (Global.strCurrentCSAddr == string) {
            return;
        }
        Global.b_UpdateCBCSAddr = true;
        this.admin.jCbStatCSAddr.setSelectedItem(this.makeObj("Device: " + string));
        Global.b_UpdateCBCSAddr = false;
        String string2 = "SettingsAddr";
        CSThread cSThread = new CSThread(this.admin, this, string2);
        cSThread.start();
    }

    public int CompareModules() {
        this.strSourceFW = this.strSourceFW.trim();
        this.strTargetFW = this.strTargetFW.trim();
        String string = "Firmware comparison\r\nSource CS (" + this.strSourceAddr + ") --> Target CS (" + this.strTargetAddr + ")\r\n\r\n";
        if (this.strSourceFW.compareTo(this.strTargetFW) != 0) {
            int n = this.tools.DisplayYesNoMsg(this, string = string + "The firmware or the firmware state of the target CryptoServer is different to the source CryptoServer!\r\nDo you want to continue?");
            if (n != 0) {
                return -1;
            }
            return 0;
        }
        string = "Firmware comparison\r\nSource CS (" + this.strSourceAddr + ") == Target CS (" + this.strTargetAddr + ")\r\n\r\nOK!";
        this.tools.DisplayInfoMsg(this, string);
        return 0;
    }

    public void CloningProcess() throws InterruptedException {
        this.strSourceAddr = this.jCbSourceAddr.getSelectedItem().toString();
        this.strTargetAddr = this.jCbTargetAddr.getSelectedItem().toString();
        if (this.strSourceAddr.length() == 0) {
            this.tools.DisplayErrorMsg(this, "Invalid source address");
            return;
        }
        if (this.strTargetAddr.length() == 0) {
            this.tools.DisplayErrorMsg(this, "Invalid target address");
            return;
        }
        this.strBackupDir = System.getProperty("user.home");
        this.strBackupDir = this.strBackupDir + "//";
        tools_thread.SetMethodForThread(this, "CSDBCloning");
    }

    public void CSDBCloning() {
        String string;
        String string2;
        boolean bl = false;
        String string3 = "Successful export of the following databases:\r\n\r\n";
        tools_thread.waitStart();
        if (Global.strCurrentCSAddr != this.strTargetAddr) {
            CSJApi.CSClose();
            string2 = CSJApi.CSOpen(this.strTargetAddr);
            if (string2.indexOf("Error") == 0) {
                Global.strCurrentCSAddr = "";
                tools_thread.waitEnd();
                this.tools.DisplayErrorMsg(this, "Cannot get connection to target CryptoServer");
                return;
            }
        }
        Global.strCurrentCSAddr = this.strTargetAddr;
        this.strTargetFW = CSJApi.CSListModulesActive();
        if (this.strTargetFW.indexOf("Error") == 0) {
            tools_thread.waitEnd();
            this.tools.DisplayErrorMsg(this, "List Firmware command to target CryptoServer failed");
            return;
        }
        if (Global.strCurrentCSAddr != this.strSourceAddr) {
            CSJApi.CSClose();
            string2 = CSJApi.CSOpen(this.strSourceAddr);
            if (string2.indexOf("Error") == 0) {
                Global.strCurrentCSAddr = "";
                tools_thread.waitEnd();
                this.tools.DisplayErrorMsg(this, "Cannot get connection to source CryptoServer");
                return;
            }
        }
        Global.strCurrentCSAddr = this.strSourceAddr;
        this.strSourceFW = CSJApi.CSListModulesActive();
        if (this.strSourceFW.indexOf("Error") == 0) {
            tools_thread.waitEnd();
            this.tools.DisplayErrorMsg(this, "List Firmware command to source CryptoServer failed");
            return;
        }
        tools_thread.waitEnd();
        if (this.CompareModules() != 0) {
            tools_thread.waitEnd();
            return;
        }
        tools_thread.waitEnd();
        if (!Global.b_22000000_login) {
            this.UserLogin("User login for Source CryptoServer (" + this.strSourceAddr + ")");
            tools_thread.Sleep(300);
        }
        if (!Global.b_22000000_login) {
            this.tools.DisplayErrorMsg(this, "Invalid login state (necessary: 22000000)");
            return;
        }
        for (int i = 0; i < this.strSelDBs.length; ++i) {
            string = CSJApi.CSExpDatabase(this.strBackupDir, this.strSelDBs[i]);
            if (string.compareTo("") != 0) {
                tools_thread.waitEnd();
                this.tools.DisplayErrorMsg(this, "Cannot export --- " + this.strSelDBs[i] + " --- database!\r\n" + string);
                return;
            }
            string3 = string3 + "      - " + this.strSelDBs[i] + "\r\n";
            bl = true;
        }
        tools_thread.Sleep(100);
        CSJApi.CSClose();
        string2 = CSJApi.CSOpen(this.strTargetAddr);
        if (string2.indexOf("Error") == 0) {
            Global.strCurrentCSAddr = "";
            tools_thread.waitEnd();
            this.tools.DisplayErrorMsg(this, "Cannot get connection to target CryptoServer");
            return;
        }
        this.UserLogin("User login for Target CryptoServer (" + this.strTargetAddr + ")");
        if (!Global.b_22000000_login) {
            this.tools.DisplayErrorMsg(this, "Invalid login state (necessary: 22000000)");
            return;
        }
        Global.b_Group6_Level2 = true;
        Global.b_ClockActive = true;
        DateTime dateTime = new DateTime(this.admin, this.strTargetAddr);
        dateTime.setLocationRelativeTo(this);
        dateTime.setModal(true);
        dateTime.setVisible(true);
        Global.b_ClockActive = false;
        dateTime.setVisible(false);
        this.admin.repaint();
        MBKRemoteMgmt mBKRemoteMgmt = new MBKRemoteMgmt(this.admin, this.strTargetAddr);
        mBKRemoteMgmt.setLocationRelativeTo(this);
        mBKRemoteMgmt.setModal(true);
        mBKRemoteMgmt.pack();
        mBKRemoteMgmt.setVisible(true);
        bl = false;
        string3 = "Source CS (" + this.strSourceAddr + ") --> Target CS (" + this.strTargetAddr + ")\r\n\r\n";
        for (int i = 0; i < this.strSelDBs.length; ++i) {
            String string4 = this.strBackupDir + "//" + this.strSelDBs[i];
            string = CSJApi.CSImpDatabase(string4);
            this.tools.DeleteFile(string4);
            if (string.indexOf("B906C001") != -1) {
                this.tools.DisplayInfoMsg(this, "There are no CryptoServer database entries in --- " + this.strSelDBs[i] + " --- !");
                continue;
            }
            if (string.compareTo("") == 0) {
                string3 = string3 + "      - " + this.strSelDBs[i] + "\r\n";
                bl = true;
                continue;
            }
            tools_thread.waitEnd();
            if (string.indexOf("B0870024") != -1) {
                this.tools.DisplayErrorMsg(this, "There is no MBK in target CryptoServer available!\r\nCryptoServer cannot decrypt a MBK encrypted database file.");
                continue;
            }
            int n = this.tools.DisplayYesNoMsg(this, "Cannot import --- " + this.strSelDBs[i] + " --- database!\r\n" + string + "\r\nDo you want to continue?");
            if (n != 0) break;
        }
        tools_thread.Sleep(100);
        tools_thread.waitEnd();
        if (bl) {
            this.tools.DisplayOutput(this, "Database Export", "Exported Databases", string3);
        }
    }

    public void RefreshStatusBar(String string) {
        this.open_failed = string.indexOf("Error") == 0;
        if (!this.open_failed) {
            this.b_bootloader = this.tools.GetBootloaderMode(string);
            this.b_maintenance = this.tools.GetMaintenanceMode(string);
            this.temp = this.tools.GetCSTemperatureValue(string);
            this.strCSTemp = this.temp == -1 ? "Temp.: ---" : "Temp.: " + this.tools.GetCSTemperature(string, 0) + "   " + this.tools.GetCSTemperature(string, 1);
            this.strCSStat = this.tools.GetCSMode(string);
            Global.b_alarm = this.tools.GetAlarmState(string);
            this.strCSAlarm = this.tools.GetAlarmStateText(string);
            this.strCSBatt = CSJApi.CSGetBattStateEx();
            this.strCSBatt = this.tools.GetBatteryState(this.strCSBatt);
            Global.b_batt_problem = this.strCSBatt.indexOf("absence") != -1 || this.strCSBatt.indexOf("low") != -1;
            this.strAuthStatePlain = string = CSJApi.CSShowAuthState();
            this.tools.PrintDbgLn("AUTH STATE: " + this.strAuthStatePlain, this.admin);
            this.strAuthState = string.indexOf("Error") == 0 ? "Login State: --------" : "Login State: " + string.substring(0, 8);
            string = CSJApi.CSListFiles();
            string = CSJApi.CSNTPGetConfig();
            Global.b_NTP_Present = string.indexOf("B0830006") == -1;
        }
        if (!this.open_failed) {
            CAT.jTxtStatCSMode.setText(this.strCSStat);
            CAT.jTxtAuthState.setText(this.strAuthState);
            CAT.SetHandleStatus(true);
            CAT.SetLoginStatus(this.strAuthStatePlain);
            if (this.b_bootloader) {
                CAT.SetBootloaderStatus();
            }
            if (this.b_maintenance) {
                CAT.SetMaintenanceStatus();
            }
            CAT.jTxtStatCSTemp.setText(this.strCSTemp);
            if (this.temp != -1) {
                if (this.temp < 6 || this.temp > 57) {
                    CAT.jTxtStatCSTemp.setBackground(Color.red);
                } else if (this.temp < 11 || this.temp > 52) {
                    CAT.jTxtStatCSTemp.setBackground(Color.orange);
                } else {
                    CAT.jTxtStatCSTemp.setBackground(SystemColor.control);
                }
            }
            CAT.jTxtStatCSAlarm.setText(this.strCSAlarm);
            if (Global.b_alarm) {
                CAT.jTxtStatCSAlarm.setBackground(Color.red);
            } else {
                CAT.jTxtStatCSAlarm.setBackground(SystemColor.control);
            }
            CAT.jTxtStatCSBatt.setText(this.strCSBatt);
            if (Global.b_batt_problem) {
                CAT.jTxtStatCSBatt.setBackground(Color.red);
            } else {
                CAT.jTxtStatCSBatt.setBackground(SystemColor.control);
            }
            CAT.jMenuItemAudit.setEnabled(true);
        } else {
            CAT.SetHandleStatus(false);
            CAT.jTxtStatCSMode.setText("-------");
            CAT.jTxtAuthState.setText("--------");
            CAT.jTxtStatCSTemp.setText("--------");
            CAT.jTxtStatCSAlarm.setText("--------");
            CAT.jTxtStatCSBatt.setText("--------");
            CAT.jTxtStatCSBatt.setBackground(SystemColor.control);
            CAT.jTxtStatCSAlarm.setBackground(SystemColor.control);
            CAT.jTxtStatCSTemp.setBackground(SystemColor.control);
        }
    }

    static final class FileNameFilter
    implements FilenameFilter {
        private String filter;

        public FileNameFilter(String string) {
            this.filter = string;
        }

        @Override
        public boolean accept(File file, String string) {
            return string.contains(this.filter);
        }
    }
}

