/*
 * Decompiled with CFR 0.152.
 */
package cat;

import cat.CAT;
import cat.CSJApi;
import cat.Global;
import cat.Tools;
import cat.ToolsThread;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.InvocationTargetException;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class AuditLogConfig
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JPanel jPanelNorth = null;
    private JPanel jPanelWest = null;
    private JPanel jPanelEast = null;
    private JPanel jPanelSouth = null;
    private JPanel jPanelCenter = null;
    private JPanel jPanelFunctions = null;
    private JButton jBtApply = null;
    private JButton jBtCancel = null;
    private JButton jBtOK = null;
    private JLabel jLabel = null;
    private JLabel jLabel2 = null;
    private JLabel jLabel3 = null;
    private JLabel jLabel1 = null;
    private JComboBox jCbNoLogFiles = null;
    private JTextField jTxtFileSize = null;
    private JRadioButton jRdRotateFile = null;
    private JRadioButton jRdStopLog = null;
    private JCheckBox jChkFirmManag = null;
    private JCheckBox jChkUserManag = null;
    private JCheckBox jChkDateTimeAdmin = null;
    private JCheckBox jChkAuditLogManag = null;
    private JCheckBox jChkMBKManag = null;
    private JCheckBox jChkStartupMass = null;
    private JCheckBox jChkFailLogAtt = null;
    private JCheckBox jChkAllLogAtt = null;
    private JCheckBox jChkKeyManag = null;
    private JCheckBox jChkBackupRestore = null;
    private JCheckBox jChkOperatingSystemEvents = null;
    private JCheckBox jChkActionNeeded = null;
    Tools tools = new Tools();
    static ToolsThread tools_thread = new ToolsThread();
    CAT admin;
    ButtonGroup group;
    String strCSReply;
    int nfiles = 0;
    int filesize = 0;
    int rotate = 0;
    int class_mask = 0;
    int os_audit_class_firmware = 1;
    int os_audit_class_user = 2;
    int os_audit_class_time = 4;
    int os_audit_class_startup = 8;
    int os_audit_class_audit = 16;
    int os_audit_class_mbk = 32;
    int os_audit_class_key = 64;
    int os_audit_class_auth_success = 128;
    int os_audit_class_auth_failed = 256;
    int os_audit_class_backup_restore = 512;
    int os_audit_class_system = 1024;
    int os_audit_class_action_needed = 2048;
    String strNFiles = "nFiles=";
    String strRotate = "Rotate=";
    String strFileSize = "FileSize=";
    String strFirmwareManagement = "Firmware Management";
    String strUserManagement = "User Management";
    String strDateTimeManagement = "Date/Time Management";
    String strStartupMessages = "Startup Messages";
    String strAuditLogManagement = "Audit Log Management";
    String strMBKManagement = "MBK Management";
    String strKeyManagement = "Key Management";
    String strAllLoginAttempts = "All Login Attempts";
    String strFailedLoginAttempts = "Failed Login Attempts";
    String strBackupRestore = "Backup/Restore";
    String strOperatingSystemEvents = "Operating system events";
    String strActionNeeded = "Action Needed";

    public AuditLogConfig(CAT cAT) {
        super(cAT);
        this.admin = cAT;
        this.initialize();
    }

    public AuditLogConfig(Frame frame) {
        super(frame);
        this.initialize();
    }

    private void initialize() {
        this.setSize(499, 409);
        this.setPreferredSize(new Dimension(460, 380));
        this.setTitle("Audit Log Configuration");
        this.setContentPane(this.getJContentPane());
        if (!Global.b_22000000_login) {
            this.jBtApply.setEnabled(false);
            this.jBtOK.setEnabled(false);
            this.jCbNoLogFiles.setEnabled(false);
            this.jTxtFileSize.setEditable(false);
            this.jRdRotateFile.setEnabled(false);
            this.jRdStopLog.setEnabled(false);
            this.jChkAllLogAtt.setEnabled(false);
            this.jChkAuditLogManag.setEnabled(false);
            this.jChkBackupRestore.setEnabled(false);
            this.jChkDateTimeAdmin.setEnabled(false);
            this.jChkFailLogAtt.setEnabled(false);
            this.jChkFirmManag.setEnabled(false);
            this.jChkKeyManag.setEnabled(false);
            this.jChkMBKManag.setEnabled(false);
            this.jChkStartupMass.setEnabled(false);
            this.jChkUserManag.setEnabled(false);
            this.jChkOperatingSystemEvents.setEnabled(false);
            this.jChkActionNeeded.setEnabled(false);
        } else {
            this.jBtApply.setEnabled(true);
            this.jBtOK.setEnabled(true);
        }
        tools_thread.SetMethodForThread(this, "CSGetAuditConfig");
    }

    public void CSGetAuditConfig() {
        tools_thread.waitStart();
        try {
            EventQueue.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    AuditLogConfig.this.strCSReply = CSJApi.CSGetAuditConfig();
                    if (AuditLogConfig.this.strCSReply.indexOf("B0830006") != -1) {
                        tools_thread.waitStart();
                        AuditLogConfig.this.tools.DisplayErrorMsg(AuditLogConfig.this, "An ADM module with version >= 3.0.4.4 is required to support this function");
                    }
                    if (AuditLogConfig.this.strCSReply.indexOf("Error") == -1) {
                        AuditLogConfig.this.ShowAuditLogConfig(AuditLogConfig.this.strCSReply);
                    }
                }
            });
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
        tools_thread.waitEnd();
        if (this.strCSReply.indexOf("B0830006") != -1) {
            this.dispose();
            return;
        }
        if (this.strCSReply.indexOf("Error") != -1) {
            this.tools.fipsErrorState(this, this.strCSReply, "Audit Log Configuration");
            this.dispose();
            return;
        }
        tools_thread.DefaultEnd(this.strCSReply, "", this);
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.setPreferredSize(new Dimension(460, 380));
            this.jContentPane.add((Component)this.getJPanelNorth(), "North");
            this.jContentPane.add((Component)this.getJPanelWest(), "West");
            this.jContentPane.add((Component)this.getJPanelEast(), "East");
            this.jContentPane.add((Component)this.getJPanelSouth(), "South");
            this.jContentPane.add((Component)this.getJPanelCenter(), "Center");
            ActionListener actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AuditLogConfig.this.setVisible(false);
                }
            };
            KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0);
            this.jContentPane.registerKeyboardAction(actionListener, keyStroke, 2);
            WindowAdapter windowAdapter = new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent windowEvent) {
                    AuditLogConfig.this.dispose();
                }
            };
            this.addWindowListener(windowAdapter);
            this.group = new ButtonGroup();
            this.group.add(this.jRdRotateFile);
            this.group.add(this.jRdStopLog);
        }
        return this.jContentPane;
    }

    private JPanel getJPanelNorth() {
        if (this.jPanelNorth == null) {
            this.jPanelNorth = new JPanel();
            this.jPanelNorth.setLayout(new GridBagLayout());
            this.jPanelNorth.setPreferredSize(new Dimension(10, 10));
        }
        return this.jPanelNorth;
    }

    private JPanel getJPanelWest() {
        if (this.jPanelWest == null) {
            this.jPanelWest = new JPanel();
            this.jPanelWest.setLayout(new GridBagLayout());
            this.jPanelWest.setPreferredSize(new Dimension(10, 10));
        }
        return this.jPanelWest;
    }

    private JPanel getJPanelEast() {
        if (this.jPanelEast == null) {
            this.jPanelEast = new JPanel();
            this.jPanelEast.setLayout(new GridBagLayout());
            this.jPanelEast.setPreferredSize(new Dimension(10, 10));
        }
        return this.jPanelEast;
    }

    private JPanel getJPanelSouth() {
        if (this.jPanelSouth == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setAlignment(2);
            this.jPanelSouth = new JPanel();
            this.jPanelSouth.setLayout(flowLayout);
            this.jPanelSouth.setPreferredSize(new Dimension(200, 43));
            this.jPanelSouth.add((Component)this.getJBtOK(), null);
            this.jPanelSouth.add((Component)this.getJBtCancel(), null);
            this.jPanelSouth.add((Component)this.getJBtApply(), null);
        }
        return this.jPanelSouth;
    }

    private JPanel getJPanelCenter() {
        if (this.jPanelCenter == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridwidth = 3;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(15, 0, 0, 0);
            gridBagConstraints.gridy = 3;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 2;
            gridBagConstraints2.insets = new Insets(10, 0, 0, 0);
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.gridy = 2;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 1;
            gridBagConstraints3.insets = new Insets(10, 0, 0, 0);
            gridBagConstraints3.fill = 0;
            gridBagConstraints3.gridy = 2;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.insets = new Insets(10, 8, 0, 10);
            gridBagConstraints4.anchor = 17;
            gridBagConstraints4.gridy = 2;
            this.jLabel3 = new JLabel();
            this.jLabel3.setText("When all log files are full");
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.gridx = 2;
            gridBagConstraints5.insets = new Insets(10, 5, 0, 0);
            gridBagConstraints5.anchor = 17;
            gridBagConstraints5.gridy = 1;
            this.jLabel2 = new JLabel();
            this.jLabel2.setText("kB");
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.fill = 1;
            gridBagConstraints6.gridy = 1;
            gridBagConstraints6.weightx = 1.0;
            gridBagConstraints6.insets = new Insets(10, 0, 0, 0);
            gridBagConstraints6.gridx = 1;
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.gridx = 0;
            gridBagConstraints7.insets = new Insets(10, 8, 0, 10);
            gridBagConstraints7.anchor = 17;
            gridBagConstraints7.gridy = 1;
            this.jLabel1 = new JLabel();
            this.jLabel1.setText("File size (max. 240)");
            GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
            gridBagConstraints8.fill = 1;
            gridBagConstraints8.gridy = 0;
            gridBagConstraints8.weightx = 1.0;
            gridBagConstraints8.insets = new Insets(7, 0, 0, 0);
            gridBagConstraints8.gridx = 1;
            GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
            gridBagConstraints9.gridx = 0;
            gridBagConstraints9.insets = new Insets(7, 8, 0, 10);
            gridBagConstraints9.anchor = 17;
            gridBagConstraints9.gridy = 0;
            this.jLabel = new JLabel();
            this.jLabel.setText("Number of audit log files");
            this.jPanelCenter = new JPanel();
            this.jPanelCenter.setLayout(new GridBagLayout());
            this.jPanelCenter.setPreferredSize(new Dimension(460, 380));
            this.jPanelCenter.add((Component)this.jLabel, gridBagConstraints9);
            this.jPanelCenter.add((Component)this.getJCbNoLogFiles(), gridBagConstraints8);
            this.jPanelCenter.add((Component)this.jLabel1, gridBagConstraints7);
            this.jPanelCenter.add((Component)this.getJTxtFileSize(), gridBagConstraints6);
            this.jPanelCenter.add((Component)this.jLabel2, gridBagConstraints5);
            this.jPanelCenter.add((Component)this.jLabel3, gridBagConstraints4);
            this.jPanelCenter.add((Component)this.getJRdRotateFile(), gridBagConstraints3);
            this.jPanelCenter.add((Component)this.getJRdStopLog(), gridBagConstraints2);
            this.jPanelCenter.add((Component)this.getJPanelFunctions(), gridBagConstraints);
        }
        return this.jPanelCenter;
    }

    private JButton getJBtApply() {
        if (this.jBtApply == null) {
            this.jBtApply = new JButton();
            this.jBtApply.setText("Apply");
            this.jBtApply.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AuditLogConfig.this.SetValues();
                }
            });
        }
        return this.jBtApply;
    }

    private JButton getJBtCancel() {
        if (this.jBtCancel == null) {
            this.jBtCancel = new JButton();
            this.jBtCancel.setText("Cancel");
            this.jBtCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AuditLogConfig.this.dispose();
                }
            });
        }
        return this.jBtCancel;
    }

    private JButton getJBtOK() {
        if (this.jBtOK == null) {
            this.jBtOK = new JButton();
            this.jBtOK.setText("OK");
            this.jBtOK.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (AuditLogConfig.this.SetValues() >= 0) {
                        AuditLogConfig.this.dispose();
                    }
                }
            });
        }
        return this.jBtOK;
    }

    private JComboBox getJCbNoLogFiles() {
        if (this.jCbNoLogFiles == null) {
            this.jCbNoLogFiles = new JComboBox();
            this.jCbNoLogFiles.setSelectedIndex(-1);
            for (int i = 2; i < 11; ++i) {
                String string = Integer.toString(i);
                this.jCbNoLogFiles.addItem(this.makeObj(string));
            }
        }
        return this.jCbNoLogFiles;
    }

    private Object makeObj(final String string) {
        return new Object(){

            public String toString() {
                return string;
            }
        };
    }

    private JTextField getJTxtFileSize() {
        if (this.jTxtFileSize == null) {
            this.jTxtFileSize = new JTextField();
            this.jTxtFileSize.addKeyListener(new KeyAdapter(){

                @Override
                public void keyTyped(KeyEvent keyEvent) {
                    int n = 3;
                    if (keyEvent.getKeyChar() == '\b') {
                        return;
                    }
                    if (!AuditLogConfig.this.tools.TestDezString(keyEvent.getKeyChar())) {
                        keyEvent.consume();
                    }
                    if (AuditLogConfig.this.jTxtFileSize.getText().length() > n - 1) {
                        keyEvent.consume();
                    }
                }
            });
        }
        return this.jTxtFileSize;
    }

    private JRadioButton getJRdRotateFile() {
        if (this.jRdRotateFile == null) {
            this.jRdRotateFile = new JRadioButton();
            this.jRdRotateFile.setText("Rotate file");
        }
        return this.jRdRotateFile;
    }

    private JRadioButton getJRdStopLog() {
        if (this.jRdStopLog == null) {
            this.jRdStopLog = new JRadioButton();
            this.jRdStopLog.setText("Stop logging");
            this.jRdStopLog.setEnabled(true);
        }
        return this.jRdStopLog;
    }

    private JPanel getJPanelFunctions() {
        if (this.jPanelFunctions == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridy = 5;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2.gridy = 5;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 1;
            gridBagConstraints3.anchor = 17;
            gridBagConstraints3.gridy = 4;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 1;
            gridBagConstraints4.anchor = 17;
            gridBagConstraints4.gridy = 2;
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.anchor = 17;
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.gridx = 1;
            gridBagConstraints6.anchor = 17;
            gridBagConstraints6.gridy = 3;
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.gridx = 0;
            gridBagConstraints7.anchor = 17;
            gridBagConstraints7.gridy = 3;
            GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
            gridBagConstraints8.gridx = 0;
            gridBagConstraints8.anchor = 17;
            gridBagConstraints8.gridy = 4;
            GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
            gridBagConstraints9.gridx = 0;
            gridBagConstraints9.anchor = 17;
            gridBagConstraints9.gridy = 2;
            GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
            gridBagConstraints10.gridx = 1;
            gridBagConstraints10.anchor = 17;
            gridBagConstraints10.gridy = 1;
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            gridBagConstraints11.gridx = 0;
            gridBagConstraints11.anchor = 17;
            gridBagConstraints11.gridy = 1;
            GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
            gridBagConstraints12.gridx = 1;
            gridBagConstraints12.anchor = 17;
            gridBagConstraints12.gridy = 0;
            this.jPanelFunctions = new JPanel();
            this.jPanelFunctions.setLayout(new GridBagLayout());
            this.jPanelFunctions.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Events", 0, 0, null, null));
            this.jPanelFunctions.add((Component)this.getJChkFirmManag(), gridBagConstraints5);
            this.jPanelFunctions.add((Component)this.getJChkUserManag(), gridBagConstraints12);
            this.jPanelFunctions.add((Component)this.getJChkDateTimeAdmin(), gridBagConstraints11);
            this.jPanelFunctions.add((Component)this.getJChkAuditLogManag(), gridBagConstraints10);
            this.jPanelFunctions.add((Component)this.getJChkMBKManag(), gridBagConstraints9);
            this.jPanelFunctions.add((Component)this.getJChkStartupMass(), gridBagConstraints8);
            this.jPanelFunctions.add((Component)this.getJChkFailLogAtt(), gridBagConstraints7);
            this.jPanelFunctions.add((Component)this.getJChkAllLogAtt(), gridBagConstraints6);
            this.jPanelFunctions.add((Component)this.getJChkKeyManag(), gridBagConstraints4);
            this.jPanelFunctions.add((Component)this.getJChkBackupRestore(), gridBagConstraints3);
            this.jPanelFunctions.add((Component)this.getJChkOperatingSystemEvents(), gridBagConstraints);
            this.jPanelFunctions.add((Component)this.getJChkActionNeeded(), gridBagConstraints2);
        }
        return this.jPanelFunctions;
    }

    private JCheckBox getJChkFirmManag() {
        if (this.jChkFirmManag == null) {
            this.jChkFirmManag = new JCheckBox();
            this.jChkFirmManag.setText("Firmware management");
        }
        return this.jChkFirmManag;
    }

    private JCheckBox getJChkUserManag() {
        if (this.jChkUserManag == null) {
            this.jChkUserManag = new JCheckBox();
            this.jChkUserManag.setText("User management");
        }
        return this.jChkUserManag;
    }

    private JCheckBox getJChkDateTimeAdmin() {
        if (this.jChkDateTimeAdmin == null) {
            this.jChkDateTimeAdmin = new JCheckBox();
            this.jChkDateTimeAdmin.setText("Date/Time management");
        }
        return this.jChkDateTimeAdmin;
    }

    private JCheckBox getJChkAuditLogManag() {
        if (this.jChkAuditLogManag == null) {
            this.jChkAuditLogManag = new JCheckBox();
            this.jChkAuditLogManag.setText("Audit log management");
        }
        return this.jChkAuditLogManag;
    }

    private JCheckBox getJChkMBKManag() {
        if (this.jChkMBKManag == null) {
            this.jChkMBKManag = new JCheckBox();
            this.jChkMBKManag.setText("MBK management");
        }
        return this.jChkMBKManag;
    }

    private JCheckBox getJChkStartupMass() {
        if (this.jChkStartupMass == null) {
            this.jChkStartupMass = new JCheckBox();
            this.jChkStartupMass.setText("Startup messages");
        }
        return this.jChkStartupMass;
    }

    private JCheckBox getJChkFailLogAtt() {
        if (this.jChkFailLogAtt == null) {
            this.jChkFailLogAtt = new JCheckBox();
            this.jChkFailLogAtt.setText("Failed login attempts");
        }
        return this.jChkFailLogAtt;
    }

    private JCheckBox getJChkAllLogAtt() {
        if (this.jChkAllLogAtt == null) {
            this.jChkAllLogAtt = new JCheckBox();
            this.jChkAllLogAtt.setText("Successful login attempts");
        }
        return this.jChkAllLogAtt;
    }

    private JCheckBox getJChkKeyManag() {
        if (this.jChkKeyManag == null) {
            this.jChkKeyManag = new JCheckBox();
            this.jChkKeyManag.setText("Key management");
        }
        return this.jChkKeyManag;
    }

    private JCheckBox getJChkBackupRestore() {
        if (this.jChkBackupRestore == null) {
            this.jChkBackupRestore = new JCheckBox();
            this.jChkBackupRestore.setText("Backup/Restore");
        }
        return this.jChkBackupRestore;
    }

    private JCheckBox getJChkOperatingSystemEvents() {
        if (this.jChkOperatingSystemEvents == null) {
            this.jChkOperatingSystemEvents = new JCheckBox();
            this.jChkOperatingSystemEvents.setText("Operating system events");
        }
        return this.jChkOperatingSystemEvents;
    }

    private JCheckBox getJChkActionNeeded() {
        if (this.jChkActionNeeded == null) {
            this.jChkActionNeeded = new JCheckBox();
            this.jChkActionNeeded.setText("Action needed");
        }
        return this.jChkActionNeeded;
    }

    public void ShowAuditLogConfig(String string) {
        String string2 = "";
        int n = string.indexOf(this.strNFiles) + this.strNFiles.length();
        if (n == -1) {
            this.tools.DisplayErrorMsg(this, "Invalid Audit Log Configuration (nFile, pos1)");
            return;
        }
        int n2 = string.indexOf(";;", n);
        if (n2 == -1) {
            this.tools.DisplayErrorMsg(this, "Invalid Audit Log Configuration (nFile, pos2)");
            return;
        }
        string2 = string.substring(n, n2);
        int n3 = Integer.valueOf(string2);
        this.jCbNoLogFiles.setSelectedIndex(n3 - 2);
        n = string.indexOf(this.strFileSize) + this.strFileSize.length();
        if (n == -1) {
            this.tools.DisplayErrorMsg(this, "Invalid Audit Log Configuration (FileSize, pos1)");
            return;
        }
        n2 = string.indexOf(";;", n);
        if (n2 == -1) {
            this.tools.DisplayErrorMsg(this, "Invalid Audit Log Configuration (FileSize, pos2)");
            return;
        }
        string2 = string.substring(n, n2);
        this.filesize = Integer.valueOf(string2) / 1000;
        this.jTxtFileSize.setText(String.valueOf(this.filesize));
        n = string.indexOf(this.strRotate) + this.strRotate.length();
        if (n == -1) {
            this.tools.DisplayErrorMsg(this, "Invalid Audit Log Configuration (Rotate, pos1)");
            return;
        }
        n2 = string.indexOf(";;", n);
        if (n2 == -1) {
            this.tools.DisplayErrorMsg(this, "Invalid Audit Log Configuration (Rotate, pos2)");
            return;
        }
        string2 = string.substring(n, n2);
        if (string2.compareTo("yes") == 0) {
            this.jRdRotateFile.setSelected(true);
            this.jRdStopLog.setSelected(false);
        } else {
            this.jRdRotateFile.setSelected(false);
            this.jRdStopLog.setSelected(true);
        }
        if (string.indexOf(this.strFirmwareManagement) != -1) {
            this.jChkFirmManag.setSelected(true);
        } else {
            this.jChkFirmManag.setSelected(false);
        }
        if (string.indexOf(this.strUserManagement) != -1) {
            this.jChkUserManag.setSelected(true);
        } else {
            this.jChkUserManag.setSelected(false);
        }
        if (string.indexOf(this.strDateTimeManagement) != -1) {
            this.jChkDateTimeAdmin.setSelected(true);
        } else {
            this.jChkDateTimeAdmin.setSelected(false);
        }
        if (string.indexOf(this.strStartupMessages) != -1) {
            this.jChkStartupMass.setSelected(true);
        } else {
            this.jChkStartupMass.setSelected(false);
        }
        if (string.indexOf(this.strAuditLogManagement) != -1) {
            this.jChkAuditLogManag.setSelected(true);
        } else {
            this.jChkAuditLogManag.setSelected(false);
        }
        if (string.indexOf(this.strMBKManagement) != -1) {
            this.jChkMBKManag.setSelected(true);
        } else {
            this.jChkMBKManag.setSelected(false);
        }
        if (string.indexOf(this.strKeyManagement) != -1) {
            this.jChkKeyManag.setSelected(true);
        } else {
            this.jChkKeyManag.setSelected(false);
        }
        if (string.indexOf(this.strAllLoginAttempts) != -1) {
            this.jChkAllLogAtt.setSelected(true);
        } else {
            this.jChkAllLogAtt.setSelected(false);
        }
        if (string.indexOf(this.strFailedLoginAttempts) != -1) {
            this.jChkFailLogAtt.setSelected(true);
        } else {
            this.jChkFailLogAtt.setSelected(false);
        }
        if (string.indexOf(this.strBackupRestore) != -1) {
            this.jChkBackupRestore.setSelected(true);
        } else {
            this.jChkBackupRestore.setSelected(false);
        }
        if (string.indexOf(this.strOperatingSystemEvents) != -1) {
            this.jChkOperatingSystemEvents.setSelected(true);
        } else {
            this.jChkOperatingSystemEvents.setSelected(false);
        }
        if (string.indexOf(this.strActionNeeded) != -1) {
            this.jChkActionNeeded.setSelected(true);
        } else {
            this.jChkActionNeeded.setSelected(false);
        }
    }

    public int SetValues() {
        this.class_mask = 0;
        this.nfiles = this.jCbNoLogFiles.getSelectedIndex() + 2;
        String string = this.jTxtFileSize.getText();
        if (string.length() == 0) {
            this.tools.DisplayErrorMsg(this, "No entry for -File size-.");
            return -1;
        }
        this.filesize = Integer.valueOf(string) * 1000;
        if (this.filesize > 240000) {
            this.tools.DisplayErrorMsg(this, "The maximum  -File size- value is 240 kB.");
            return -1;
        }
        this.rotate = this.jRdRotateFile.isSelected() ? 1 : 0;
        if (this.jChkFirmManag.isSelected()) {
            this.class_mask += this.os_audit_class_firmware;
        }
        if (this.jChkUserManag.isSelected()) {
            this.class_mask += this.os_audit_class_user;
        }
        if (this.jChkDateTimeAdmin.isSelected()) {
            this.class_mask += this.os_audit_class_time;
        }
        if (this.jChkAuditLogManag.isSelected()) {
            this.class_mask += this.os_audit_class_audit;
        }
        if (this.jChkMBKManag.isSelected()) {
            this.class_mask += this.os_audit_class_mbk;
        }
        if (this.jChkKeyManag.isSelected()) {
            this.class_mask += this.os_audit_class_key;
        }
        if (this.jChkFailLogAtt.isSelected()) {
            this.class_mask += this.os_audit_class_auth_failed;
        }
        if (this.jChkAllLogAtt.isSelected()) {
            this.class_mask += this.os_audit_class_auth_success;
        }
        if (this.jChkStartupMass.isSelected()) {
            this.class_mask += this.os_audit_class_startup;
        }
        if (this.jChkBackupRestore.isSelected()) {
            this.class_mask += this.os_audit_class_backup_restore;
        }
        if (this.jChkOperatingSystemEvents.isSelected()) {
            this.class_mask += this.os_audit_class_system;
        }
        if (this.jChkActionNeeded.isSelected()) {
            this.class_mask += this.os_audit_class_action_needed;
        }
        tools_thread.SetMethodForThread(this, "CSSetAuditConfig");
        return 0;
    }

    public void CSSetAuditConfig() {
        tools_thread.waitStart();
        String string = CSJApi.CSSetAuditConfig(this.nfiles, this.filesize, this.rotate, this.class_mask);
        tools_thread.waitEnd();
        tools_thread.DefaultEnd(string, "", this);
    }
}

