#include "string.h"

int xmssmt_str_to_oid(unsigned char *oid, const char *s)
{
    if (!strcmp(s, "XMSSMT-SHA2_20/2_256")) {
        *oid = 0x00000001;
    }
    else if (!strcmp(s, "XMSSMT-SHA2_20/4_256")) {
        *oid = 0x00000002;
    }
    else if (!strcmp(s, "XMSSMT-SHA2_40/2_256")) {
        *oid = 0x00000003;
    }
    else if (!strcmp(s, "XMSSMT-SHA2_40/4_256")) {
        *oid = 0x00000004;
    }
    else if (!strcmp(s, "XMSSMT-SHA2_40/8_256")) {
        *oid = 0x00000005;
    }
    else if (!strcmp(s, "XMSSMT-SHA2_60/3_256")) {
        *oid = 0x00000006;
    }
    else if (!strcmp(s, "XMSSMT-SHA2_60/6_256")) {
        *oid = 0x00000007;
    }
    else if (!strcmp(s, "XMSSMT-SHA2_60/12_256")) {
        *oid = 0x00000008;
    }
    else if (!strcmp(s, "XMSSMT-SHA2_20/2_512")) {
        *oid = 0x00000009;
    }
    else if (!strcmp(s, "XMSSMT-SHA2_20/4_512")) {
        *oid = 0x0000000a;
    }
    else if (!strcmp(s, "XMSSMT-SHA2_40/2_512")) {
        *oid = 0x0000000b;
    }
    else if (!strcmp(s, "XMSSMT-SHA2_40/4_512")) {
        *oid = 0x0000000c;
    }
    else if (!strcmp(s, "XMSSMT-SHA2_40/8_512")) {
        *oid = 0x0000000d;
    }
    else if (!strcmp(s, "XMSSMT-SHA2_60/3_512")) {
        *oid = 0x0000000e;
    }
    else if (!strcmp(s, "XMSSMT-SHA2_60/6_512")) {
        *oid = 0x0000000f;
    }
    else if (!strcmp(s, "XMSSMT-SHA2_60/12_512")) {
        *oid = 0x00000010;
    }
    else if (!strcmp(s, "XMSSMT-SHAKE_20/2_256")) {
        *oid = 0x00000011;
    }
    else if (!strcmp(s, "XMSSMT-SHAKE_20/4_256")) {
        *oid = 0x00000012;
    }
    else if (!strcmp(s, "XMSSMT-SHAKE_40/2_256")) {
        *oid = 0x00000013;
    }
    else if (!strcmp(s, "XMSSMT-SHAKE_40/4_256")) {
        *oid = 0x00000014;
    }
    else if (!strcmp(s, "XMSSMT-SHAKE_40/8_256")) {
        *oid = 0x00000015;
    }
    else if (!strcmp(s, "XMSSMT-SHAKE_60/3_256")) {
        *oid = 0x00000016;
    }
    else if (!strcmp(s, "XMSSMT-SHAKE_60/6_256")) {
        *oid = 0x00000017;
    }
    else if (!strcmp(s, "XMSSMT-SHAKE_60/12_256")) {
        *oid = 0x00000018;
    }
    else if (!strcmp(s, "XMSSMT-SHAKE_20/2_512")) {
        *oid = 0x00000019;
    }
    else if (!strcmp(s, "XMSSMT-SHAKE_20/4_512")) {
        *oid = 0x0000001a;
    }
    else if (!strcmp(s, "XMSSMT-SHAKE_40/2_512")) {
        *oid = 0x0000001b;
    }
    else if (!strcmp(s, "XMSSMT-SHAKE_40/4_512")) {
        *oid = 0x0000001c;
    }
    else if (!strcmp(s, "XMSSMT-SHAKE_40/8_512")) {
        *oid = 0x0000001d;
    }
    else if (!strcmp(s, "XMSSMT-SHAKE_60/3_512")) {
        *oid = 0x0000001e;
    }
    else if (!strcmp(s, "XMSSMT-SHAKE_60/6_512")) {
        *oid = 0x0000001f;
    }
    else if (!strcmp(s, "XMSSMT-SHAKE_60/12_512")) {
        *oid = 0x00000020;
    }
    else if (!strcmp(s, "XMSSMT-SHA2_20/2_192")) {
        *oid = 0x00000021;
    }
    else if (!strcmp(s, "XMSSMT-SHA2_20/4_192")) {
        *oid = 0x00000022;
    }
    else if (!strcmp(s, "XMSSMT-SHA2_40/2_192")) {
        *oid = 0x00000023;
    }
    else if (!strcmp(s, "XMSSMT-SHA2_40/4_192")) {
        *oid = 0x00000024;
    }
    else if (!strcmp(s, "XMSSMT-SHA2_40/8_192")) {
        *oid = 0x00000025;
    }
    else if (!strcmp(s, "XMSSMT-SHA2_60/3_192")) {
        *oid = 0x00000026;
    }
    else if (!strcmp(s, "XMSSMT-SHA2_60/6_192")) {
        *oid = 0x00000027;
    }
    else if (!strcmp(s, "XMSSMT-SHA2_60/12_192")) {
        *oid = 0x00000028;
    }
    else if (!strcmp(s, "XMSSMT-SHAKE256_20/2_256")) {
        *oid = 0x00000029;
    }
    else if (!strcmp(s, "XMSSMT-SHAKE256_20/4_256")) {
        *oid = 0x0000002a;
    }
    else if (!strcmp(s, "XMSSMT-SHAKE256_40/2_256")) {
        *oid = 0x0000002b;
    }
    else if (!strcmp(s, "XMSSMT-SHAKE256_40/4_256")) {
        *oid = 0x0000002c;
    }
    else if (!strcmp(s, "XMSSMT-SHAKE256_40/8_256")) {
        *oid = 0x0000002d;
    }
    else if (!strcmp(s, "XMSSMT-SHAKE256_60/3_256")) {
        *oid = 0x0000002e;
    }
    else if (!strcmp(s, "XMSSMT-SHAKE256_60/6_256")) {
        *oid = 0x0000002f;
    }
    else if (!strcmp(s, "XMSSMT-SHAKE256_60/12_256")) {
        *oid = 0x00000030;
    }
    else if (!strcmp(s, "XMSSMT-SHAKE256_20/2_192")) {
        *oid = 0x00000031;
    }
    else if (!strcmp(s, "XMSSMT-SHAKE256_20/4_192")) {
        *oid = 0x00000032;
    }
    else if (!strcmp(s, "XMSSMT-SHAKE256_40/2_192")) {
        *oid = 0x00000033;
    }
    else if (!strcmp(s, "XMSSMT-SHAKE256_40/4_192")) {
        *oid = 0x00000034;
    }
    else if (!strcmp(s, "XMSSMT-SHAKE256_40/8_192")) {
        *oid = 0x00000035;
    }
    else if (!strcmp(s, "XMSSMT-SHAKE256_60/3_192")) {
        *oid = 0x00000036;
    }
    else if (!strcmp(s, "XMSSMT-SHAKE256_60/6_192")) {
        *oid = 0x00000037;
    }
    else if (!strcmp(s, "XMSSMT-SHAKE256_60/12_192")) {
        *oid = 0x00000038;
    }
    else {
        return -1;
    }
    return 0;
}

int xmss_str_to_oid(unsigned long *is_mt, unsigned char *oid, const unsigned char *s_in)
{
    *is_mt = 0;

    const char * s = (const char *)s_in;

    if (strncmp(s, "XMSSMT", 6) == 0) {
        *is_mt = 1;
        return xmssmt_str_to_oid(oid, s);
    }

    if (!strcmp(s, "XMSS-SHA2_10_256")) {
        *oid = 0x00000001;
    }
    else if (!strcmp(s, "XMSS-SHA2_16_256")) {
        *oid = 0x00000002;
    }
    else if (!strcmp(s, "XMSS-SHA2_20_256")) {
        *oid = 0x00000003;
    }
    else if (!strcmp(s, "XMSS-SHA2_10_512")) {
        *oid = 0x00000004;
    }
    else if (!strcmp(s, "XMSS-SHA2_16_512")) {
        *oid = 0x00000005;
    }
    else if (!strcmp(s, "XMSS-SHA2_20_512")) {
        *oid = 0x00000006;
    }
    else if (!strcmp(s, "XMSS-SHAKE_10_256")) {
        *oid = 0x00000007;
    }
    else if (!strcmp(s, "XMSS-SHAKE_16_256")) {
        *oid = 0x00000008;
    }
    else if (!strcmp(s, "XMSS-SHAKE_20_256")) {
        *oid = 0x00000009;
    }
    else if (!strcmp(s, "XMSS-SHAKE_10_512")) {
        *oid = 0x0000000a;
    }
    else if (!strcmp(s, "XMSS-SHAKE_16_512")) {
        *oid = 0x0000000b;
    }
    else if (!strcmp(s, "XMSS-SHAKE_20_512")) {
        *oid = 0x0000000c;
    }
    else if (!strcmp(s, "XMSS-SHA2_10_192")) {
        *oid = 0x0000000d;
    }
    else if (!strcmp(s, "XMSS-SHA2_16_192")) {
        *oid = 0x0000000e;
    }
    else if (!strcmp(s, "XMSS-SHA2_20_192")) {
        *oid = 0x0000000f;
    }
    else if (!strcmp(s, "XMSS-SHAKE256_10_256")) {
        *oid = 0x00000010;
    }
    else if (!strcmp(s, "XMSS-SHAKE256_16_256")) {
        *oid = 0x00000011;
    }
    else if (!strcmp(s, "XMSS-SHAKE256_20_256")) {
        *oid = 0x00000012;
    }
    else if (!strcmp(s, "XMSS-SHAKE256_10_192")) {
        *oid = 0x00000013;
    }
    else if (!strcmp(s, "XMSS-SHAKE256_16_192")) {
        *oid = 0x00000014;
    }
    else if (!strcmp(s, "XMSS-SHAKE256_20_192")) {
        *oid = 0x00000015;
    }
    else {
        return -1;
    }
    return 0;
}

