#include <qptool2.h>
#include <pkcs11t.h>

extern int test_case_mlkem(CK_FUNCTION_LIST_PTR pFunctions, CK_SESSION_HANDLE hSession, struct PPARMS *parms) {
    int err = 0x0;

    printf("\n\n--> Test Entry <--\n");

    err = mlkem_vdx_test(pFunctions, hSession,
        parms->gen, parms->encap, parms->decap, parms->encdec,
        parms->keytype, parms->astoken,
        parms->loopcount
    );
    if (err != CKR_OK) {
        printf("Out of test, see previous failure message.\n");
    }

    printf("\n\n--> Test Exit <--\n");

    return err;
}

extern int test_case_mldsa(CK_FUNCTION_LIST_PTR pFunctions, CK_SESSION_HANDLE hSession, struct PPARMS * parms)
{
    int err = 0x0;

    printf("\n\n--> Test Entry <--\n");

    err = mldsa_vdx_test(pFunctions, hSession,
        parms->gen, parms->sign, parms->verify, parms->signverify,
        parms->keytype, parms->astoken,
        parms->loopcount
    );
    if (err != CKR_OK) {
        printf("Out of test, see previous failure message.\n");
    }

    printf("\n\n--> Test Exit <--\n");

    return err;
}

#ifdef IF_INCLUDE_LATTICE_IPD
extern int test_case_kyber(CK_FUNCTION_LIST_PTR pFunctions, CK_SESSION_HANDLE hSession, struct PPARMS *parms) {
    int err = 0x0;

    printf("\n\n--> Test Entry <--\n");
    
    err = kyber_vdx_test(pFunctions, hSession,
        parms->gen, parms->sign, parms->verify, parms->signverify,
        parms->keytype, parms->r3_variant, parms->astoken,
        parms->loopcount
    );
    if (err != CKR_OK) {
        printf("Out of test, see previous failure message.\n");
    }

    printf("\n\n--> Test Exit <--\n");

    return err;
}

extern int test_case_dilithium(CK_FUNCTION_LIST_PTR pFunctions, CK_SESSION_HANDLE hSession, struct PPARMS * parms)
{
    int err = 0x0;

    printf("\n\n--> Test Entry <--\n");
    
    err = dilithium_vdx_test(pFunctions, hSession,
        parms->gen, parms->sign, parms->verify, parms->signverify,
        parms->keytype, parms->r3_variant, parms->astoken,
        parms->loopcount
    );
    if (err != CKR_OK) {
        printf("Out of test, see previous failure message.\n");
    }

    printf("\n\n--> Test Exit <--\n");

    return err;
}
#endif

extern int test_case_lms(CK_FUNCTION_LIST_PTR pFunctions, CK_SESSION_HANDLE hSession, struct PPARMS * parms)
{
    int err = 0;

    printf("\n\n--> Test Entry <--\n");

    err = lms_vdx_test(pFunctions, hSession,
        parms->gen, parms->sign, parms->verify, parms->signverify,
        parms->keytype, parms->astoken,
        parms->loopcount
    );
    if (err != CKR_OK) {
        printf("Out of test, see previous failure message.\n");
    }

    printf("\n\n--> Test Exit <--\n");

    return err;
}

extern int test_case_hss(CK_FUNCTION_LIST_PTR pFunctions, CK_SESSION_HANDLE hSession, struct PPARMS * parms)
{
    int err = 0;

    printf("\n\n--> Test Entry <--\n");

    err = hss_vdx_test(pFunctions, hSession,
        parms->gen, parms->sign, parms->verify, parms->signverify,
        parms->keytype, parms->astoken,
        parms->loopcount
    );
    if (err != CKR_OK) {
        printf("Out of test, see previous failure message.\n");
    }

    printf("\n\n--> Test Exit <--\n");

    return err;
}

extern int test_case_xmss(CK_FUNCTION_LIST_PTR pFunctions, CK_SESSION_HANDLE hSession, struct PPARMS * parms)
{
    int err = 0;

    printf("\n\n--> Test Entry <--\n");

    err = xmss_vdx_test(pFunctions, hSession,
        parms->gen, parms->sign, parms->verify, parms->signverify,
        parms->keytype, parms->astoken,
        parms->loopcount
    );
    if (err != CKR_OK) {
        printf("Out of test, see previous failure message.\n");
    }

    printf("\n\n--> Test Exit <--\n");

    return err;
}

