#include "template_util.h"

#undef TRACE_TUTIL

#define T_MRK  0x7E367A7E
#define E_NO_MEM 0xB4057001
#define E_TMPL_INVALID 0xB4057002

void free_template(CK_ATTRIBUTE_PTR template) {
    unsigned int *iret = (unsigned int *)template;
    if (template != NULL) {
        if (*iret++ == T_MRK) {
            unsigned int sz = 4 + 4 + (*iret++ * sizeof(CK_ATTRIBUTE));
            memset(template, 0, sz);
#ifdef TRACE_TUTIL
            printf("%p: free\n", template);
#endif
            free(template);
            return;
        }
    }
    printf("Attempt to free template that was not allocated\n");
}

CK_ATTRIBUTE_PTR allocate_template(unsigned int ct) {
    CK_ATTRIBUTE_PTR ret = NULL;
    unsigned int *iret = NULL;
    int len = (ct * sizeof(CK_ATTRIBUTE)) + 4 + 4;
    ret = malloc(len);
    if (ret == NULL) {
        return ret;
    }
#ifdef TRACE_TUTIL
    printf("%p:  allocated %d * %zd + 4 + 4 = %d bytes for template\n", ret, ct, sizeof(CK_ATTRIBUTE), len);
#endif
    iret = (unsigned int *)ret;
    *iret++ = (unsigned int)T_MRK;
    *iret++ = (unsigned int)ct;
    return ret;
}

CK_ATTRIBUTE_PTR get_template(CK_ATTRIBUTE_PTR template) {
    unsigned int *iret = (unsigned int *)template;
    unsigned char *cret = (unsigned char *)template;

    if (template != NULL) {
        if (*iret++ == T_MRK) {
            return (CK_ATTRIBUTE_PTR)(cret + 4 + 4);
        }
    }
    return 0;
}

CK_ULONG get_template_len(CK_ATTRIBUTE_PTR template) {
    unsigned int *iret = (unsigned int *)template;

    if (template != NULL) {
        if (*iret++ == T_MRK) {
            return (CK_ULONG)*iret;
        }
    }
    return 0;
}

void set_attribute(CK_ATTRIBUTE_PTR ptr, int offset, CK_ATTRIBUTE_TYPE type, CK_VOID_PTR pValue, CK_ULONG ulValueLen) {
    int *iret = (int *)ptr;
    unsigned char *p = (unsigned char *)ptr + 4 + 4;

    iret++;
    if(offset < *iret) {
        p += (sizeof(CK_ATTRIBUTE) * offset);
        CK_ATTRIBUTE_PTR pp = (CK_ATTRIBUTE_PTR)p;
        pp->type = type;
        pp->pValue = pValue;
        pp->ulValueLen = ulValueLen;
#ifdef TRACE_TUTIL
        printf("%p: Added attribute %d\n", ptr, offset);
#endif
    } else {
        printf("%p:  Attempt to write attribute beyond space allocated (%d vs %d)\n", ptr, offset, *iret);
    }
    return;
}

