/* 
 * 03c autogenerated 2024-03-13T09:16:18.3139792 using 
 * CS_SdkVpl version 0.0.5
 * Source XML Document version 01c,2024-03-11,riw
 * 
 * Copyright included by reference, please see Utimaco_Demo_License.txt
 */

/* This is the C implementation for the struct CxiKeyAttributes_imp */
//#include <any.h>
#include <CxiKeyAttributes.h>

#ifdef OS_SMOS
#include <cmds.h>
#include <os_mem.h>
#include <os_str.h>
#else
#include <stdlib.h>
#include <memory.h>
#ifndef NO_CSXAPI
#include <csxapi.h>
#endif
#ifdef WIN32
#define os_mem_cpy(d,s,l) memcpy_s(d,l,s,l)
#else
#define os_mem_cpy(d,s,l) memcpy(d,s,l)
#endif
#endif
#ifndef WIN32
#include <stddef.h>
#endif
#include <load_store.h>

//#DEFS_ALLOCATION_METHODS#
//#DEFS_FREE_METHODS#

/*****************************************************************************************
 * cxikeyattributes_length - Compute the serialized length of the data in the structure
 */
unsigned int cxikeyattributes_length(const _P_CXIKEYATTRIBUTES s) {
    unsigned int len = 0;
    
    len += 4; // flags - u4

    len += 1 + s->l_name; // v1

    len += 1 + s->l_group; // v1

    len += 4; // spec - u4

    len += 4; // algo - u4

    len += 4; // usage - u4

    len += 4; // export - u4

    len += 2 + s->l_mdata; // v2

    return len;
}

/*****************************************************************************************
 * cxikeyattributes_serialize - Serialize data in struct for wire-transmittal
 */
unsigned int cxikeyattributes_serialize (
  const _P_CXIKEYATTRIBUTES s,
  unsigned int l_answ, 
  unsigned char * p_answ
) {
  
  unsigned int err = 0;
  unsigned int chk = 0;
  unsigned char * pp_answ = p_answ;
  
  // flags UINT4_T
  chk     += 4;
  if (l_answ < chk) return E_ANY_SERIALIZATION + 1;
  store_int4(s->flags, pp_answ);
  pp_answ += 4; 

  // name VLEN1_T
  chk     += 1 + s->l_name;
  if (l_answ < chk) return E_ANY_SERIALIZATION + 2;
  store_int1(s->l_name, pp_answ);
  pp_answ += 1;
  os_mem_cpy(pp_answ, s->p_name, s->l_name);
  pp_answ += s->l_name; 

  // group VLEN1_T
  chk     += 1 + s->l_group;
  if (l_answ < chk) return E_ANY_SERIALIZATION + 3;
  store_int1(s->l_group, pp_answ);
  pp_answ += 1;
  os_mem_cpy(pp_answ, s->p_group, s->l_group);
  pp_answ += s->l_group; 

  // spec UINT4_T
  chk     += 4;
  if (l_answ < chk) return E_ANY_SERIALIZATION + 4;
  store_int4(s->spec, pp_answ);
  pp_answ += 4; 

  // algo UINT4_T
  chk     += 4;
  if (l_answ < chk) return E_ANY_SERIALIZATION + 5;
  store_int4(s->algo, pp_answ);
  pp_answ += 4; 

  // usage UINT4_T
  chk     += 4;
  if (l_answ < chk) return E_ANY_SERIALIZATION + 6;
  store_int4(s->usage, pp_answ);
  pp_answ += 4; 

  // export UINT4_T
  chk     += 4;
  if (l_answ < chk) return E_ANY_SERIALIZATION + 7;
  store_int4(s->export, pp_answ);
  pp_answ += 4; 

  // mdata VLEN2_T
  chk     += 2 + s->l_mdata;
  if (l_answ < chk) return E_ANY_SERIALIZATION + 8;
  store_int2(s->l_mdata, pp_answ);
  pp_answ += 2;
  os_mem_cpy(pp_answ, s->p_mdata, s->l_mdata);
  pp_answ += s->l_mdata; 

  return err;
}

/*****************************************************************************************
 * cxikeyattributes_scanf - Containerized cmds_scanf
 */
unsigned int cxikeyattributes_scanf (
  _P_CXIKEYATTRIBUTES s,
  unsigned int l_data, 
  unsigned char *p_data
) {
  int ret = 0x0;

#ifdef OS_SMOS
  /* Note: This wraps 'cmds_scanf()', see the mdl_CMDS pdf for more information. */
  ret = cmds_scanf(l_data, p_data, "u4v1v1u4u4u4u4v2", sizeof(CXIKEYATTRIBUTES), s);

#else
#ifdef NO_CSXAPI
  ret = 0xB1A0A021;
#else
  /* Note: This wraps csxapi 'cs_scanp()', see the SDK Dev Guide, chapter 2.15
   * for more information.  
   * The scanp method populates a CS_PARAM struct (uint val or len and pointer) for 
   * each field.
   * The data in those structs are then transcribed to the input struct CXIKEYATTRIBUTES 
   * pointed to by s.
   */

  struct {
    CS_PARAM flags;           // u4
    CS_PARAM name;           // v1
    CS_PARAM group;           // v1
    CS_PARAM spec;           // u4
    CS_PARAM algo;           // u4
    CS_PARAM usage;           // u4
    CS_PARAM export;           // u4
    CS_PARAM mdata;           // v2
  } args;

  if ((ret = cs_scanp(l_data, p_data, "u4v1v1u4u4u4u4v2", sizeof(args), &args)) != 0x0) 
  {
    return ret;
  }

  s->flags = args.flags.i;

  s->l_name = args.name.i;
  s->p_name = args.name.p;

  s->l_group = args.group.i;
  s->p_group = args.group.p;

  s->spec = args.spec.i;

  s->algo = args.algo.i;

  s->usage = args.usage.i;

  s->export = args.export.i;

  s->l_mdata = args.mdata.i;
  s->p_mdata = args.mdata.p;

#endif
#endif

  return ret;     
}

#ifdef OS_SMOS
/*****************************************************************************************
 * cxikeyattributes_calloc - Copy-Alloc
 */
unsigned int cxikeyattributes_calloc(void * rec, unsigned int *l_data, void **pp_data, unsigned int os_mem_type)
{
    unsigned int err = 0x0;
    unsigned char *p_answ = NULL;
    unsigned int   l_answ = *l_data;

	if (*l_data == 0x0) {
		CXIKEYATTRIBUTES empty;
		os_mem_set(&empty, 0, sizeof(empty));
		l_answ = cxikeyattributes_length(&empty);
	}		
	
	p_answ = os_mem_new(l_answ, 
		(os_mem_type == OS_MEM_TYPE_SECURE) ? OS_MEM_TYPE_SECURE : OS_MEM_TYPE_SD
		);
	if (p_answ == 0x0) return E_ANY_MALLOC;
	
	if (*l_data == 0x0) {
		os_mem_set(p_answ, 0, l_answ);
	} else {
		os_mem_cpy(p_answ, *pp_data, l_answ);
	}

	err = cxikeyattributes_scanf(rec, l_answ, p_answ);
	if (err) return err;
	
	*l_data = l_answ;
	*pp_data = p_answ;		
    
    return err;
}

/*****************************************************************************************
 * cxikeyattributes_alloc_answ - Containerized cmds_alloc_answ
 */
unsigned int cxikeyattributes_alloc_answ(void * ctxt, _P_CXIKEYATTRIBUTES p_obj)
{
    unsigned int err = 0x0;
    unsigned char *p_answ;
    unsigned int   l_answ;

    l_answ = cxikeyattributes_length(p_obj);
    if ((err = cmds_alloc_answ(ctxt, l_answ, &p_answ)) != 0)
        return err;

    err = cxikeyattributes_serialize(p_obj, l_answ, p_answ);

    return err;
}
#else
// the Data falls immediately after the struct
typedef struct cxikeyattributes_CONTAINER {
        CXIKEYATTRIBUTES obj;
        unsigned int l_buffer;
} c_cxikeyattributes;
typedef c_cxikeyattributes * cp_cxikeyattributes;
unsigned int cxikeyattributes_new (
    _P_CXIKEYATTRIBUTES *s,
    unsigned int l_data,
    unsigned char *p_data
) {
    unsigned int err = 0x0;
    cp_cxikeyattributes container = NULL;
    unsigned char * locator = NULL;
    unsigned int pad_between = 0;

    unsigned int struct_area = sizeof(c_cxikeyattributes);
    unsigned int total_size = 0;

    pad_between = (4 - (struct_area % 4)) % 4;
    struct_area += pad_between;

    total_size = struct_area + l_data + ((4 - (l_data %4)) % 4);

    container = (cp_cxikeyattributes)malloc(total_size);
    if (container == 0) { return 0xB1000004; } // E_EXMP_MALLOC 

    container->l_buffer = l_data;
    memset(container, 0x0, struct_area);

    locator = (unsigned char *)container + struct_area;
    memset(locator + l_data - 4, 0x0, 4); 
    memcpy(locator, p_data, l_data);

    err = cxikeyattributes_scanf(&(container->obj), l_data, locator);
    
    *s = (err == 0x0) ? (_P_CXIKEYATTRIBUTES)container : NULL;

    return err;
}
unsigned int cxikeyattributes_raw_len ( _P_CXIKEYATTRIBUTES s ) {
    if (s == NULL) return 0;
    cp_cxikeyattributes container = (cp_cxikeyattributes)s;
    return container->l_buffer;
}
unsigned char * cxikeyattributes_raw ( _P_CXIKEYATTRIBUTES s ) {
    if (s == NULL) return NULL;
    unsigned char * locator = (unsigned char *)s;
    unsigned int struct_area = sizeof(c_cxikeyattributes);
    locator += struct_area + ((4 - (struct_area % 4)) % 4);
    return locator;
}
void cxikeyattributes_free ( _P_CXIKEYATTRIBUTES s ) {
    if (s == NULL) { return; }
    free(s);
}
#endif

// #include "exfiles/CxiKeyAttributes_ex.c"
