/*******************************************************************************
 *
 * $File Identification                    $
 * $Filename          : pqmi.h             $
 * $SecurityServer Rel: 4.51               $
 * $Module version    :  0.00.0.1            $
 * $Module name       : PQMI               $
 * $Release Date      : 2024-04-01         $
 *
 * Author             : Utimaco IS GmbH
 *                      Utimaco IS Inc
 *
 * Description        : Global header file of CryptoServer module PQMI
 *                      Must be included in every CryptoServer software that uses
 *                      functions of this module
 *
 **************************************************************************************************/
#ifndef __PQMI_H_PUB_INCLUDED__
  #define __PQMI_H_PUB_INCLUDED__

  //-----------------------------------------------------------------------------
  // Hash Defines:
  //-----------------------------------------------------------------------------
#define PQMI_MODE_REAL_RND                       0x00000000			/* Use DRBG Real Random */
#define PQMI_MODE_PSEUDO_RND                     0x00000100			/* Use Pseudo Random generator */
#define PQMI_MODE_INT_RND                        0x00000200			/* Use Internal Random generator */
#define PQMI_MODE_DETERMINISTIC                  0x00000300			/* Use deterministic mode */
#define PQMI_MODE_RND_MASK                       0x00000300			/* RND MODE MASK */
#define PQMI_KEY_EXTERNAL                        0x01000000			/* External key blob */
#define PQMI_KEY_OVERWRITE						0x02000000			/* Overwrite internal key stored in pqmi.db */
#define PQMI_KEY_STORE_OP						0x80000000
#define PQMI_KEY_LOAD_FROM_STORE                 0x01000000			/* Find internal key in pqmi.db */
#define PQMI_KEY_GET_PUBLIC_KEY                  0x02000000			/* Get public part of internal key in pqmi.db */
#define PQMI_KEY_DROP_FROM_STORE                 0x04000000			/* Drop internal key in pqmi.db */
#define PQMI_KEY_LIST_FROM_STORE                 0x08000000			/* List internal keys in pqmi.db */
#define PQMI_FLAG_INIT                           0x00000100			/* Start of some process (sign/verify) */
#define PQMI_FLAG_CONT                           0x00000200			/* process is continuing (sign/verify) */
#define PQMI_FLAG_FINALIZE                       0x00000400			/* Finalize the process (sign/verify) */
#define PQMI_KG_RET_BLOB                         0x4242			// BB Return Backup blob 
#define PQMI_KG_RET_HDL                          0x4B48			// KH Return handle 
#define PQMI_KG_RET_CXI                          0x4B42			// KB Return Key blob 

#define PQMI_DILITHIUM_KT_FLAG                   0x10			/* Delithium Keytype Flag */
#define PQMI_DILITHIUM_MODE_SIG_PACKED           0x00010000			/* Packed signature handling */
#define PQMI_DILITHIUM_MODE_SIG_RAW              0x00020000			/* Raw signature handling */
#define PQMI_DILITHIUM_MODE_SIG_RFU              0x00030000			/* SIG MODE RFU */
#define PQMI_DILITHIUM_MODE_SIG_MASK             0x00030000			/* SIG MODE MASK */
#define PQMI_DILITHIUM_4X4_R3                    1			/* Dilithium 4x4 (round 3) */
#define PQMI_DILITHIUM_4X4_AES_R3                2			/* Dilithium 4x4 (round 3) */
#define PQMI_DILITHIUM_6X5_R3                    3			/* Dilithium 4x4 (round 3) */
#define PQMI_DILITHIUM_6X5_AES_R3                4			/* Dilithium 4x4 (round 3) */
#define PQMI_DILITHIUM_8X7_R3                    5			/* Dilithium 4x4 (round 3) */
#define PQMI_DILITHIUM_8X7_AES_R3                6			/* Dilithium 4x4 (round 3) */
#define PQMI_DILITHIUM_4X4_R3_PUB_LEN            1312			/* Dilithium 4x4 (round 3) public keysize */
#define PQMI_DILITHIUM_4X4_AES_R3_PUB_LEN        1312			/* Dilithium 4x4 AES (round 3) public keysize */
#define PQMI_DILITHIUM_6X5_R3_PUB_LEN            1952			/* Dilithium 6x5 (round 3) public keysize */
#define PQMI_DILITHIUM_6X5_AES_R3_PUB_LEN        1952			/* Dilithium 6x5 AES (round 3) public keysize */
#define PQMI_DILITHIUM_8X7_R3_PUB_LEN            2592			/* Dilithium 8x7 (round 3) public keysize */
#define PQMI_DILITHIUM_8X7_AES_R3_PUB_LEN        2592			/* Dilithium 8x7 AES (round 3) public keysize */
#define PQMI_DILITHIUM_4X4_R3_PRV_LEN            2528			/* Dilithium 4x4 (round 3) private keysize */
#define PQMI_DILITHIUM_4X4_AES_R3_PRV_LEN        2528			/* Dilithium 4x4 AES (round 3) private keysize */
#define PQMI_DILITHIUM_6X5_R3_PRV_LEN            4000			/* Dilithium 6x5 (round 3) private keysize */
#define PQMI_DILITHIUM_6X5_AES_R3_PRV_LEN        4000			/* Dilithium 6x5 AES (round 3) private keysize */
#define PQMI_DILITHIUM_8X7_R3_PRV_LEN            4864			/* Dilithium 8x7 (round 3) private keysize */
#define PQMI_DILITHIUM_8X7_AES_R3_PRV_LEN        4864			/* Dilithium 8x7 AES (round 3) private keysize */
#define PQMI_DILITHIUM_4X4_R3_SIG_LEN            2420			/* Dilithium 4x4 (round 3) sig len */
#define PQMI_DILITHIUM_4X4_AES_R3_SIG_LEN        2420			/* Dilithium 4x4 AES (round 3) sig len */
#define PQMI_DILITHIUM_6X5_R3_SIG_LEN            3293			/* Dilithium 6x5 (round 3) sig len */
#define PQMI_DILITHIUM_6X5_AES_R3_SIG_LEN        3293			/* Dilithium 6x5 AES (round 3) sig len */
#define PQMI_DILITHIUM_8X7_R3_SIG_LEN            4595			/* Dilithium 8x7 (round 3) sig len */
#define PQMI_DILITHIUM_8X7_AES_R3_SIG_LEN        4595			/* Dilithium 8x7 AES (round 3) sig len */
#define PQMI_KYBER_KT_FLAG                       0x20			/* Kyber Keytype Flag */
#define PQMI_KYBER_512                           1			/* Kyber 512 (round 3) public keysize */
#define PQMI_KYBER_768                           2			/* Kyber 768 (round 3) public keysize */
#define PQMI_KYBER_1024                          3			/* Kyber 1024 (round 3) public keysize */
#define PQMI_KYBER_512_90S                       4			/* Kyber 512 90S public keysize */
#define PQMI_KYBER_768_90S                       5			/* Kyber 768 90S public keysize */
#define PQMI_KYBER_1024_90S                      6			/* Kyber 1024 90S public keysize */
#define PQMI_KYBER_512_R3_PUB_LEN                800			/* Kyber 512 (round 3) public keysize */
#define PQMI_KYBER_768_R3_PUB_LEN                1184			/* Kyber 768 (round 3) public keysize */
#define PQMI_KYBER_1024_R3_PUB_LEN               1568			/* Kyber 1024 (round 3) public keysize */
#define PQMI_KYBER_512_90S_PUB_LEN               800			/* Kyber 512 90S public keysize */
#define PQMI_KYBER_768_90S_PUB_LEN               1184			/* Kyber 758 90S public keysize */
#define PQMI_KYBER_1024_90S_PUB_LEN              1568			/* Kyber 1024 90S public keysize */
#define PQMI_KYBER_512_R3_PRV_LEN                1632			/* Kyber 512 (round 3) private keysize */
#define PQMI_KYBER_768_R3_PRV_LEN                2400			/* Kyber 768 (round 3) private keysize */
#define PQMI_KYBER_1024_R3_PRV_LEN               3168			/* Kyber 1024 (round 3) private keysize */
#define PQMI_KYBER_512_90S_PRV_LEN               1632			/* Kyber 512 90S private keysize */
#define PQMI_KYBER_768_90S_PRV_LEN               2400			/* Kyber 758 90S private keysize */
#define PQMI_KYBER_1024_90S_PRV_LEN              3168			/* Kyber 1024 90S private keysize */
#define PQMI_KYBER_512_R3_COMP_LEN               768			/* Kyber 512 (round 3) comp len */
#define PQMI_KYBER_768_R3_COMP_LEN               1088			/* Kyber 768 (round 3) comp len */
#define PQMI_KYBER_1024_R3_COMP_LEN              1568			/* Kyber 1024 (round 3) comp len */
#define PQMI_KYBER_512_90S_COMP_LEN              768			/* Kyber 512 90S comp len */
#define PQMI_KYBER_768_90S_COMP_LEN              1088			/* Kyber 758 90S comp len */
#define PQMI_KYBER_1024_90S_COMP_LEN             1568			/* Kyber 1024 90S comp len */
#define PQMI_KYBER_512_R3_SECRET_LEN             768			/* Kyber 512 (round 3) secret len */
#define PQMI_KYBER_768_R3_SECRET_LEN             1088			/* Kyber 768 (round 3) secret len */
#define PQMI_KYBER_1024_R3_SECRET_LEN            1568			/* Kyber 1024 (round 3) secret len */
#define PQMI_KYBER_512_90S_SECRET_LEN            768			/* Kyber 512 90S secret len */
#define PQMI_KYBER_768_90S_SECRET_LEN            1088			/* Kyber 758 90S secret len */
#define PQMI_KYBER_1024_90S_SECRET_LEN           1568			/* Kyber 1024 90S secret len */
#define HBS_HSS_MIN_LEVELS 1
#define HBS_HSS_MAX_LEVELS 8
#define PQMI_HBS_LEVELS_1                        1			/* Use when parameters are for XMSS */
#define PQMI_HBS_LEVELS_2                        2			/* Use when parameters are for 2 Levels HSS */
#define PQMI_HBS_LEVELS_3                        3			/* Use when parameters are for 3 Levels HSS */
#define PQMI_HBS_LEVELS_4                        4			/* Use when parameters are for 4 Levels HSS */
#define PQMI_HBS_LEVELS_5                        5			/* Use when parameters are for 5 Levels HSS */
#define PQMI_HBS_LEVELS_6                        6			/* Use when parameters are for 6 Levels HSS */
#define PQMI_HBS_LEVELS_7                        7			/* Use when parameters are for 7 Levels HSS */
#define PQMI_HBS_LEVELS_8                        8			/* Use when parameters are for 8 Levels HSS */
#define PQMI_HBS_XMSS_SINGLETREE_GEN             0			/* Generate Single-tree XMSS */
#define PQMI_HBS_XMSS_MULTITREE_GEN              1			/* Generate Multi-tree XMSS */
#define PQMI_HBS_OPT_FORCE_DELETE_KEY_INTERVALS  0x0001			/* Delete previous key intervals */
#define PQMI_HBS_OPT_FORCE_DELETE_KEY_COUNTERS   0x0002			/* Delete previous key counters */
#define PQMI_HBS_LMS_SHA256_N32_H5               0x00000005			/* Height of the Merkle tree = 5, SHA-256/256 */
#define PQMI_HBS_LMS_SHA256_N32_H10              0x00000006			/* Height of the Merkle tree = 10, SHA-256/256 */
#define PQMI_HBS_LMS_SHA256_N32_H15              0x00000007			/* Height of the Merkle tree = 15, SHA-256/256 */
#define PQMI_HBS_LMS_SHA256_N32_H20              0x00000008			/* Height of the Merkle tree = 20, SHA-256/256 */
#define PQMI_HBS_LMS_SHA256_N32_H25              0x00000009			/* Height of the Merkle tree = 25, SHA-256/256 */
#define PQMI_HBS_LMS_SHA256_N24_H5               0x0000000A			/* Height of the Merkle tree = 5, SHA-256/192 */
#define PQMI_HBS_LMS_SHA256_N24_H10              0x0000000B			/* Height of the Merkle tree = 10, SHA-256/192 */
#define PQMI_HBS_LMS_SHA256_N24_H15              0x0000000C			/* Height of the Merkle tree = 15, SHA-256/192 */
#define PQMI_HBS_LMS_SHA256_N24_H20              0x0000000D			/* Height of the Merkle tree = 20, SHA-256/192 */
#define PQMI_HBS_LMS_SHA256_N24_H25              0x0000000E			/* Height of the Merkle tree = 25, SHA-256/192 */
#define PQMI_HBS_LMS_SHAKE256_N32_H5             0x0000000F   /* Height of the Merkle tree = 5, SHAKE-256/256 */
#define PQMI_HBS_LMS_SHAKE256_N32_H10            0x00000010   /* Height of the Merkle tree = 10, SHAKE-256/256 */
#define PQMI_HBS_LMS_SHAKE256_N32_H15            0x00000011   /* Height of the Merkle tree = 15, SHAKE-256/256 */
#define PQMI_HBS_LMS_SHAKE256_N32_H20            0x00000012   /* Height of the Merkle tree = 20, SHAKE-256/256 */
#define PQMI_HBS_LMS_SHAKE256_N32_H25            0x00000013   /* Height of the Merkle tree = 25, SHAKE-256/256 */
#define PQMI_HBS_LMS_SHAKE256_N24_H5             0x00000014   /* Height of the Merkle tree = 5, SHAKE-256/192 */
#define PQMI_HBS_LMS_SHAKE256_N24_H10            0x00000015   /* Height of the Merkle tree = 10, SHAKE-256/192 */
#define PQMI_HBS_LMS_SHAKE256_N24_H15            0x00000016   /* Height of the Merkle tree = 15, SHAKE-256/192 */
#define PQMI_HBS_LMS_SHAKE256_N24_H20            0x00000017   /* Height of the Merkle tree = 20, SHAKE-256/192 */
#define PQMI_HBS_LMS_SHAKE256_N24_H25            0x00000018   /* Height of the Merkle tree = 25, SHAKE-256/192 */

#define PQMI_HBS_LMOTS_SHA256_N32_W1             0x00000001			/* Winternitz parameter = 1, SHA-256/256 */
#define PQMI_HBS_LMOTS_SHA256_N32_W2             0x00000002			/* Winternitz parameter = 2, SHA-256/256 */
#define PQMI_HBS_LMOTS_SHA256_N32_W4             0x00000003			/* Winternitz parameter = 4, SHA-256/256 */
#define PQMI_HBS_LMOTS_SHA256_N32_W8             0x00000004			/* Winternitz parameter = 8, SHA-256/256 */
#define PQMI_HBS_LMOTS_SHA256_N24_W1             0x00000005			/* Winternitz parameter = 1, SHA-256/192 */
#define PQMI_HBS_LMOTS_SHA256_N24_W2             0x00000006			/* Winternitz parameter = 2, SHA-256/192 */
#define PQMI_HBS_LMOTS_SHA256_N24_W4             0x00000007			/* Winternitz parameter = 4, SHA-256/192 */
#define PQMI_HBS_LMOTS_SHA256_N24_W8             0x00000008			/* Winternitz parameter = 8, SHA-256/192 */
#define PQMI_HBS_LMOTS_SHAKE256_N32_W1           0x00000009		/* Winternitz parameter = 1, SHAKE-256/256 */
#define PQMI_HBS_LMOTS_SHAKE256_N32_W2           0x0000000A		/* Winternitz parameter = 2, SHAKE-256/256 */
#define PQMI_HBS_LMOTS_SHAKE256_N32_W4           0x0000000B		/* Winternitz parameter = 4, SHAKE-256/256 */
#define PQMI_HBS_LMOTS_SHAKE256_N32_W8           0x0000000C		/* Winternitz parameter = 8, SHAKE-256/256 */
#define PQMI_HBS_LMOTS_SHAKE256_N24_W1           0x0000000D		/* Winternitz parameter = 1, SHAKE-256/192 */
#define PQMI_HBS_LMOTS_SHAKE256_N24_W2           0x0000000E		/* Winternitz parameter = 2, SHAKE-256/192 */
#define PQMI_HBS_LMOTS_SHAKE256_N24_W4           0x0000000F		/* Winternitz parameter = 4, SHAKE-256/192 */
#define PQMI_HBS_LMOTS_SHAKE256_N24_W8           0x00000010		/* Winternitz parameter = 8, SHAKE-256/192 */

/* NIST SP 800-208 */
#define PQMI_HBS_LMS_SHA256_M32_H5               0x00000005		/* Height of the Merkle tree = 5, SHA-256/256 */
#define PQMI_HBS_LMS_SHA256_M32_H10              0x00000006		/* Height of the Merkle tree = 10, SHA-256/256 */
#define PQMI_HBS_LMS_SHA256_M32_H15              0x00000007		/* Height of the Merkle tree = 15, SHA-256/256 */
#define PQMI_HBS_LMS_SHA256_M32_H20              0x00000008		/* Height of the Merkle tree = 20, SHA-256/256 */
#define PQMI_HBS_LMS_SHA256_M32_H25              0x00000009		/* Height of the Merkle tree = 25, SHA-256/256 */
#define PQMI_HBS_LMS_SHA256_M24_H5               0x0000000A		/* Height of the Merkle tree = 5, SHA-256/192 */
#define PQMI_HBS_LMS_SHA256_M24_H10              0x0000000B		/* Height of the Merkle tree = 10, SHA-256/192 */
#define PQMI_HBS_LMS_SHA256_M24_H15              0x0000000C		/* Height of the Merkle tree = 15, SHA-256/192 */
#define PQMI_HBS_LMS_SHA256_M24_H20              0x0000000D		/* Height of the Merkle tree = 20, SHA-256/192 */
#define PQMI_HBS_LMS_SHA256_M24_H25              0x0000000E		/* Height of the Merkle tree = 25, SHA-256/192 */
#define PQMI_HBS_LMS_SHAKE_M32_H5                0x0000000F   /* Height of the Merkle tree = 5, SHAKE-256/256 */
#define PQMI_HBS_LMS_SHAKE_M32_H10               0x00000010   /* Height of the Merkle tree = 10, SHAKE-256/256 */
#define PQMI_HBS_LMS_SHAKE_M32_H15               0x00000011   /* Height of the Merkle tree = 15, SHAKE-256/256 */
#define PQMI_HBS_LMS_SHAKE_M32_H20               0x00000012   /* Height of the Merkle tree = 20, SHAKE-256/256 */
#define PQMI_HBS_LMS_SHAKE_M32_H25               0x00000013   /* Height of the Merkle tree = 25, SHAKE-256/256 */
#define PQMI_HBS_LMS_SHAKE_M24_H5                0x00000014   /* Height of the Merkle tree = 5, SHAKE-256/192 */
#define PQMI_HBS_LMS_SHAKE_M24_H10               0x00000015   /* Height of the Merkle tree = 10, SHAKE-256/192 */
#define PQMI_HBS_LMS_SHAKE_M24_H15               0x00000016   /* Height of the Merkle tree = 15, SHAKE-256/192 */
#define PQMI_HBS_LMS_SHAKE_M24_H20               0x00000017   /* Height of the Merkle tree = 20, SHAKE-256/192 */
#define PQMI_HBS_LMS_SHAKE_M24_H25               0x00000018   /* Height of the Merkle tree = 25, SHAKE-256/192 */

#define PQMI_HBS_LMOTS_SHAKE_N32_W1              0x00000009		/* Winternitz parameter = 1, SHAKE-256/256 */
#define PQMI_HBS_LMOTS_SHAKE_N32_W2              0x0000000A		/* Winternitz parameter = 2, SHAKE-256/256 */
#define PQMI_HBS_LMOTS_SHAKE_N32_W4              0x0000000B		/* Winternitz parameter = 4, SHAKE-256/256 */
#define PQMI_HBS_LMOTS_SHAKE_N32_W8              0x0000000C		/* Winternitz parameter = 8, SHAKE-256/256 */
#define PQMI_HBS_LMOTS_SHAKE_N24_W1              0x0000000D		/* Winternitz parameter = 1, SHAKE-256/192 */
#define PQMI_HBS_LMOTS_SHAKE_N24_W2              0x0000000E		/* Winternitz parameter = 2, SHAKE-256/192 */
#define PQMI_HBS_LMOTS_SHAKE_N24_W4              0x0000000F		/* Winternitz parameter = 4, SHAKE-256/192 */
#define PQMI_HBS_LMOTS_SHAKE_N24_W8              0x00000010		/* Winternitz parameter = 8, SHAKE-256/192 */


#define PQMI_HBS_XMSS_SHA2_10_256                0x00000001			/* SHA256, n=32, w=16, h=10 */
#define PQMI_HBS_XMSS_SHA2_16_256                0x00000002			/* SHA256, n=32, w=16, h=16 */
#define PQMI_HBS_XMSS_SHA2_20_256                0x00000003			/* SHA256, n=32, w=16, h=20 */
#define PQMI_HBS_XMSS_SHA2_10_512                0x00000004			/* SHA512, n=64, w=16, h=10 */
#define PQMI_HBS_XMSS_SHA2_16_512                0x00000005			/* SHA512, n=64, w=16, h=16 */
#define PQMI_HBS_XMSS_SHA2_20_512                0x00000006			/* SHA512, n=64, w=16, h=20 */
#define PQMI_HBS_XMSS_SHAKE_10_256               0x00000007			/* SHAKE128, n=32, w=16, h=10 */
#define PQMI_HBS_XMSS_SHAKE_16_256               0x00000008			/* SHAKE128, n=32, w=16, h=16 */
#define PQMI_HBS_XMSS_SHAKE_20_256               0x00000009			/* SHAKE128, n=32, w=16, h=20 */
#define PQMI_HBS_XMSS_SHAKE_10_512               0x0000000A			/* SHAKE256, n=64, w=16, h=10 */
#define PQMI_HBS_XMSS_SHAKE_16_512               0x0000000B			/* SHAKE256, n=64, w=16, h=16 */
#define PQMI_HBS_XMSS_SHAKE_20_512               0x0000000C			/* SHAKE256, n=64, w=16, h=20 */
#define PQMI_HBS_XMSS_SHA2_10_192                0x0000000D			/* SHA256/192, n=24, w=16, h=10 */
#define PQMI_HBS_XMSS_SHA2_16_192                0x0000000E			/* SHA256/192, n=24, w=16, h=16 */
#define PQMI_HBS_XMSS_SHA2_20_192                0x0000000F			/* SHA256/192, n=24, w=16, h=20 */
#define PQMI_HBS_XMSS_SHAKE256_10_256            0x00000010			/* SHAKE256, n=32, w=16, h=10 */
#define PQMI_HBS_XMSS_SHAKE256_16_256            0x00000011			/* SHAKE256, n=32, w=16, h=16 */
#define PQMI_HBS_XMSS_SHAKE256_20_256            0x00000012			/* SHAKE256, n=32, w=16, h=20 */
#define PQMI_HBS_XMSS_SHAKE256_10_192            0x00000013			/* SHAKE256, n=24, w=16, h=10 */
#define PQMI_HBS_XMSS_SHAKE256_16_192            0x00000014			/* SHAKE256, n=24, w=16, h=16 */
#define PQMI_HBS_XMSS_SHAKE256_20_192            0x00000015			/* SHAKE256, n=24, w=16, h=20 */
#define PQMI_HBS_XMSSMT_SHA2_20_2_256            0x00000001			/* SHA256, n=32, w=16, h=20, d=2 */
#define PQMI_HBS_XMSSMT_SHA2_20_4_256            0x00000002			/* SHA256, n=32, w=16, h=20, d=4 */
#define PQMI_HBS_XMSSMT_SHA2_40_2_256            0x00000003			/* SHA256, n=32, w=16, h=40, d=2 */
#define PQMI_HBS_XMSSMT_SHA2_40_4_256            0x00000004			/* SHA256, n=32, w=16, h=40, d=4 */
#define PQMI_HBS_XMSSMT_SHA2_40_8_256            0x00000005			/* SHA256, n=32, w=16, h=40, d=8 */
#define PQMI_HBS_XMSSMT_SHA2_60_3_256            0x00000006			/* SHA256, n=32, w=16, h=60, d=3 */
#define PQMI_HBS_XMSSMT_SHA2_60_6_256            0x00000007			/* SHA256, n=32, w=16, h=60, d=6 */
#define PQMI_HBS_XMSSMT_SHA2_60_12_256           0x00000008			/* SHA256, n=32, w=16, h=60, d=12 */
#define PQMI_HBS_XMSSMT_SHA2_20_2_512            0x00000009			/* SHA512, n=64, w=16, h=20, d=2 */
#define PQMI_HBS_XMSSMT_SHA2_20_4_512            0x0000000A			/* SHA512, n=64, w=16, h=20, d=4 */
#define PQMI_HBS_XMSSMT_SHA2_40_2_512            0x0000000B			/* SHA512, n=64, w=16, h=40, d=2 */
#define PQMI_HBS_XMSSMT_SHA2_40_4_512            0x0000000C			/* SHA512, n=64, w=16, h=40, d=4 */
#define PQMI_HBS_XMSSMT_SHA2_40_8_512            0x0000000D			/* SHA512, n=64, w=16, h=40, d=8 */
#define PQMI_HBS_XMSSMT_SHA2_60_3_512            0x0000000E			/* SHA512, n=64, w=16, h=60, d=3 */
#define PQMI_HBS_XMSSMT_SHA2_60_6_512            0x0000000F			/* SHA512, n=64, w=16, h=60, d=6 */
#define PQMI_HBS_XMSSMT_SHA2_60_12_512           0x00000010			/* SHA512, n=64, w=16, h=60, d=12 */
#define PQMI_HBS_XMSSMT_SHAKE_20_2_256           0x00000011			/* SHAKE128, n=32, w=16, h=20, d=2 */
#define PQMI_HBS_XMSSMT_SHAKE_20_4_256           0x00000012			/* SHAKE128, n=32, w=16, h=20, d=4 */
#define PQMI_HBS_XMSSMT_SHAKE_40_2_256           0x00000013			/* SHAKE128, n=32, w=16, h=40, d=2 */
#define PQMI_HBS_XMSSMT_SHAKE_40_4_256           0x00000014			/* SHAKE128, n=32, w=16, h=40, d=4 */
#define PQMI_HBS_XMSSMT_SHAKE_40_8_256           0x00000015			/* SHAKE128, n=32, w=16, h=40, d=8 */
#define PQMI_HBS_XMSSMT_SHAKE_60_3_256           0x00000016			/* SHAKE128, n=32, w=16, h=60, d=3 */
#define PQMI_HBS_XMSSMT_SHAKE_60_6_256           0x00000017			/* SHAKE128, n=32, w=16, h=60, d=6 */
#define PQMI_HBS_XMSSMT_SHAKE_60_12_256          0x00000018			/* SHAKE128, n=32, w=16, h=60, d=12 */
#define PQMI_HBS_XMSSMT_SHAKE_20_2_512           0x00000019			/* SHAKE256, n=64, w=16, h=20, d=2 */
#define PQMI_HBS_XMSSMT_SHAKE_20_4_512           0x0000001A			/* SHAKE256, n=64, w=16, h=20, d=4 */
#define PQMI_HBS_XMSSMT_SHAKE_40_2_512           0x0000001B			/* SHAKE256, n=64, w=16, h=40, d=2 */
#define PQMI_HBS_XMSSMT_SHAKE_40_4_512           0x0000001C			/* SHAKE256, n=64, w=16, h=40, d=4 */
#define PQMI_HBS_XMSSMT_SHAKE_40_8_512           0x0000001D			/* SHAKE256, n=64, w=16, h=40, d=8 */
#define PQMI_HBS_XMSSMT_SHAKE_60_3_512           0x0000001E			/* SHAKE256, n=64, w=16, h=60, d=3 */
#define PQMI_HBS_XMSSMT_SHAKE_60_6_512           0x0000001F			/* SHAKE256, n=64, w=16, h=60, d=6 */
#define PQMI_HBS_XMSSMT_SHAKE_60_12_512          0x00000020			/* SHAKE256, n=64, w=16, h=60, d=12 */
#define PQMI_HBS_XMSSMT_SHA2_20_2_192            0x00000021			/* SHA256/192, n=24, w=16, h=20, d=2 */
#define PQMI_HBS_XMSSMT_SHA2_20_4_192            0x00000022			/* SHA256/192, n=24, w=16, h=20, d=4 */
#define PQMI_HBS_XMSSMT_SHA2_40_2_192            0x00000023			/* SHA256/192, n=24, w=16, h=40, d=2 */
#define PQMI_HBS_XMSSMT_SHA2_40_4_192            0x00000024			/* SHA256/192, n=24, w=16, h=40, d=4 */
#define PQMI_HBS_XMSSMT_SHA2_40_8_192            0x00000025			/* SHA256/192, n=24, w=16, h=40, d=8 */
#define PQMI_HBS_XMSSMT_SHA2_60_3_192            0x00000026			/* SHA256/192, n=24, w=16, h=60, d=3 */
#define PQMI_HBS_XMSSMT_SHA2_60_6_192            0x00000027			/* SHA256/192, n=24, w=16, h=60, d=6 */
#define PQMI_HBS_XMSSMT_SHA2_60_12_192           0x00000028			/* SHA256/192, n=24, w=16, h=60, d=12 */
#define PQMI_HBS_XMSSMT_SHAKE256_20_2_256        0x00000029			/* SHAKE256, n=32, w=16, h=20, d=2 */
#define PQMI_HBS_XMSSMT_SHAKE256_20_4_256        0x0000002A			/* SHAKE256, n=32, w=16, h=20, d=4 */
#define PQMI_HBS_XMSSMT_SHAKE256_40_2_256        0x0000002B			/* SHAKE256, n=32, w=16, h=40, d=2 */
#define PQMI_HBS_XMSSMT_SHAKE256_40_4_256        0x0000002C			/* SHAKE256, n=32, w=16, h=40, d=4 */
#define PQMI_HBS_XMSSMT_SHAKE256_40_8_256        0x0000002D			/* SHAKE256, n=32, w=16, h=40, d=8 */
#define PQMI_HBS_XMSSMT_SHAKE256_60_3_256        0x0000002E			/* SHAKE256, n=32, w=16, h=60, d=3 */
#define PQMI_HBS_XMSSMT_SHAKE256_60_6_256        0x0000002F			/* SHAKE256, n=32, w=16, h=60, d=6 */
#define PQMI_HBS_XMSSMT_SHAKE256_60_12_256       0x00000030			/* SHAKE256, n=32, w=16, h=60, d=12 */
#define PQMI_HBS_XMSSMT_SHAKE256_20_2_192        0x00000031			/* SHAKE256, n=24, w=16, h=20, d=2 */
#define PQMI_HBS_XMSSMT_SHAKE256_20_4_192        0x00000032			/* SHAKE256, n=24, w=16, h=20, d=4 */
#define PQMI_HBS_XMSSMT_SHAKE256_40_2_192        0x00000033			/* SHAKE256, n=24, w=16, h=40, d=2 */
#define PQMI_HBS_XMSSMT_SHAKE256_40_4_192        0x00000034			/* SHAKE256, n=24, w=16, h=40, d=4 */
#define PQMI_HBS_XMSSMT_SHAKE256_40_8_192        0x00000035			/* SHAKE256, n=24, w=16, h=40, d=8 */
#define PQMI_HBS_XMSSMT_SHAKE256_60_3_192        0x00000036			/* SHAKE256, n=24, w=16, h=60, d=3 */
#define PQMI_HBS_XMSSMT_SHAKE256_60_6_192        0x00000037			/* SHAKE256, n=24, w=16, h=60, d=6 */
#define PQMI_HBS_XMSSMT_SHAKE256_60_12_192       0x00000038			/* SHAKE256, n=24, w=16, h=60, d=12 */

  //-----------------------------------------------------------------------------
  // Error Codes:  (0xB0000000 | (PQMI_MDL_ID << 16) | (errno))
  //-----------------------------------------------------------------------------

// --- BEGIN ERROR CODES ---

#define E_PQMI                          0xB1a0          // CryptoServer module PQMI

#define C_PQMI_INCLUDE_STD_ERRORS
#ifdef C_PQMI_INCLUDE_STD_ERRORS
/** @addtogroup pqmi_err_codes
  * @{
  *
  * \def E_PQMI_PERMISSION_DENIED
  * <b>Error code</b>\n
  * permission denied
  *
  * \def E_PQMI_PARAM
  * <b>Error code</b>\n
  * invalid parameter
  *
  * \def E_PQMI_PARAM_LEN
  * <b>Error code</b>\n
  * invalid parameter length
  *
  * \def E_PQMI_MALLOC
  * <b>Error code</b>\n
  * memory allocation failed
  *
  * \def E_PQMI_MODE
  * <b>Error code</b>\n
  * invalid mode
  *
  * \def E_PQMI_ITEM_NOT_FOUND
  * <b>Error code</b>\n
  * item not found
  *
  * \def E_PQMI_MODULE_DEP
  * <b>Error code</b>\n
  * unresolved module dependency
  *
  * \def E_PQMI_FILE_IO
  * <b>Error code</b>\n
  * file IO error
  */

  /**@}*/

#define E_PQMI_PERMISSION_DENIED        0xB1a0F001      // permission denied
#define E_PQMI_PARAM                    0xB1a0F002      // invalid parameter
#define E_PQMI_PARAM_LEN                0xB1a0F003      // invalid parameter length
#define E_PQMI_MALLOC                   0xB1a0F004      // memory allocation failed
#define E_PQMI_MODE                     0xB1a0F005      // invalid mode
#define E_PQMI_ITEM_NOT_FOUND           0xB1a0F006      // item not found
#define E_PQMI_MODULE_DEP               0xB1a0F007      // unresolved module dependency
#define E_PQMI_FILE_IO                  0xB1a0F008      // file I/O error
#endif

#define E_PQMI_SERIALIZATION                 0xB1a00E00 /* buffer martialing error */
#define E_PQMI_SERIALIZAT_IN                 0xB1a00E01 /* buffer deserialization error */
#define E_PQMI_SERIALIZAT_OUT                0xB1a00E02 /* buffer serialization error */
#define E_PQMI_NOT_IMPLEMENTED               0xB1a00A21 /* function not implemented or is deprecated/removed */
#define E_PQMI_NOT_SUPPORTED                 0xB1a00A22 /* method/mode/algo/keysize/etc not supported */
#define E_PQMI_MEM                           0xB1a00001 /* memory allocation error */
#define E_PQMI_INV_FLAG                      0xB1a00002 /* invalid flag parameter value */
#define E_PQMI_INV_KEY_TYPE                  0xB1a00003 /* invalid key type parameter value */
#define E_PQMI_BUFFER_TOO_SMALL              0xB1a00004 /* Length of output buffer too small */
#define E_PQMI_INV_SEED                      0xB1a00005 /* Invalid seed length or seed not set */
#define E_PQMI_INV_KEY_LEN                   0xB1a00006 /* Invalid key length */
#define E_PQMI_INV_PARAM                     0xB1a00007 /* Invalid Parameter */
#define E_PQMI_INV_SIGNATURE                 0xB1a00008 /* Invalid Signature */
#define E_PQMI_INV_CHECKSUM                  0xB1a00009 /* Invalid checksum on backup blob */
#define E_PQMI_GENERAL_ERR                   0xB1a00A00 /* undifferentiated error thrown by this module. Contact Development. */

#define MDL_ERROR(x) ((PQMI_MDL_ID << 16) | (x))


// --- END ERROR CODES ---

// --- Begin Subfunction Codes ---
/* For host-side use */
#define PQMI_SFC_ECHO 0
#define PQMI_SFC_RNGSEED 1
#define PQMI_SFC_DILITHIUM_KEYGEN 2
#define PQMI_SFC_DILITHIUM_SIGN 3
#define PQMI_SFC_DILITHIUM_VERIFY 4
#define PQMI_SFC_KYBER_KEYGEN 5
#define PQMI_SFC_KYBER_ENC 6
#define PQMI_SFC_KYBER_DEC 7
#define PQMI_SFC_KYBER_MUTUAL_AKE_HANDSHAKE 8
#define PQMI_SFC_KYBER_UNILATERAL_AKE_HANDSHAKE 9
#define PQMI_SFC_KEYSTORE 10
#define PQMI_SFC_HBS_KEYGEN 11
#define PQMI_SFC_HBS_GET_PUBKEY 12
#define PQMI_SFC_HBS_SIGN 13
#define PQMI_SFC_HBS_VERIFY 14
#define PQMI_SFC_HBS_REPLICATE 15
#define PQMI_SFC_HBS_APPORTION 16
#define PQMI_SFC_LIST_KEYS 17
/* << sfc_list_defines_C */

// --- END Subfunction Codes ---

#endif // __PQMI_H_PUB_INCLUDED__
