/******************************************************************************
 *
 *  Filename      : cs_core.h
 *
 *
 *  Description   : Headerfile for essential types needed by higher level libs
 *
 ******************************************************************************/
#ifndef CS_CORE_H_INCL
#define CS_CORE_H_INCL

// Structure for cs_get_driver_info() (or CSA_IOC_GET_INFOX ioctl()) call:
typedef struct
{
  unsigned int  len;    // (I/O) size of buffer / length of data
  unsigned char *buff;  // (O)   pointer to buffer
}
CSA_INFOX;

enum MODEL_TYPES
{
  MODEL_NULL = 0,
  MODEL_CS2 = 1,        // CS2 (C/S-Series)
  MODEL_CS3,            // CS3 (Se-Series)
  MODEL_NQ3,            // NQ3
  MODEL_CS4,            // CS4 (C/Se-Series)
  MODEL_CS5,            // CS5 (Se-Series Gen2)
  MODEL_CS6,            // CS6 (doesn't exist)
  MODEL_CS7,            // CS7 (CSAR-Series)
  MODEL_CS8,            // CS8 (CSAR-Series >= 7.3)
  MODEL_MAX = MODEL_CS8
};

typedef struct
{
  unsigned int i;
  unsigned char *p;
}
CS_PARAM;

int cs_scanp
(
  unsigned int        l_cmd,   // (I) length of command block
  const unsigned char *p_cmd,  // (I) pointer to command block
  const char          *p_fmt,  // (I) format string
  unsigned int        size,    // (I) sizeof(*p_out)
  void                *p_out   // (O) parsed data
);

#endif
