/* 
 * 03c autogenerated 2024-11-06T12:45:14.3574036 using 
 * CS_SdkVpl version 0.0.6
 * Template version 0002
 * Source XML Document version 01d,2024-03-26,riw
 * 
 * Copyright included by reference, please see Utimaco_Demo_License.txt
 *
 */

/* This is the C implementation for the struct MLKEM_Response_imp */

#ifndef _mlkem_response_h_0_0_0_0
  #define _mlkem_response_h_0_0_0_0

/* Defines -------------------------------------------------------------- */

/*
::IFDEF:: DECS_ALLOCATION_METHODS
#DECS_ALLOCATION_METHODS#
#DECS_FREE_METHODS#
::ENDIF::
*/

/* Declarations for Pattern u4v2v2 */
typedef struct mlkem_response { 
    unsigned int    flags;		// u4
    unsigned int    l_cyphertext;		// v2
    unsigned char * p_cyphertext; 
    unsigned int    l_secret;		// v2
    unsigned char * p_secret; 
} MLKEM_RESPONSE;
#define mlkem_response_PATTERN u4v2v2
#define MLKEM_RESPONSE_PATTERN "u4v2v2"
typedef MLKEM_RESPONSE * _P_MLKEM_RESPONSE;
#define MLKEM_RESPONSE_SER_LEN_MAX 131076

#ifdef DEBUG
/*****************************************************************************************
 * mlkem_response_tell - Output the current state of SECRET variable, if set
 * ------------------
 * Pattern: u4v2v2
 * ------------------
 *
 * const _P_MLKEM_RESPONSE * s   | I
 * 
 * Returns: void.  Output goes to cmds_[x]print, ONLY IN DEBUG MODE
 */
unsigned int mlkem_response_tell ( const _P_MLKEM_RESPONSE s );
#endif

/*****************************************************************************************
 * mlkem_response_length - Compute the serialized length of the data in the structure
 * ------------------
 * Pattern: u4v2v2
 * ------------------
 *
 * 
 * const _P_MLKEM_RESPONSE * s   | I
 * 
 * Returns: unsigned int, wire-length of the data in the struct pointed to.
 */
unsigned int mlkem_response_length ( const _P_MLKEM_RESPONSE );

/*****************************************************************************************
 * mlkem_response_serialize - Serialize data in struct for wire-transmittal
 * ------------------
 * Pattern: u4v2v2
 * ------------------
 *
 * 
 * MLKEM_RESPONSE * s   | I
 * unsigned int   l_answ    | I Length of destination buffer provided
 * unsigned char *p_answ    | I Destination buffer for serialized data
 *
 * Returns: 0x0, or 
 * Errors:  E_PQMI_SERIALIZATION -- 
 */
 unsigned int mlkem_response_serialize (
  const _P_MLKEM_RESPONSE, 
  unsigned int, 
  unsigned char *
);

/*****************************************************************************************
 * mlkem_response_scanf - Containerized cmds_scanf
 * ------------------
 * Pattern: u4v2v2
 * ------------------
 *
 * 
 * _P_MLKEM_RESPONSE * s             | I 
 * const unsigned int l_data          | I 
 * const unsigned char *p_data        | I 
 *
 * Returns: unsigned int, 0x0 or Error:
 * - (as returned by cmds_scanf)
 */
unsigned int mlkem_response_scanf (
  _P_MLKEM_RESPONSE, 
  unsigned int, 
  unsigned char *
);
#define mlkem_response_deserialize mlkem_response_scanf

#ifdef OS_SMOS
/*****************************************************************************************
 * mlkem_response_calloc - Copy-Alloc
 * ----------------------------
 *
 * Provided an object and a pointer to serialized data (ie, via l_cmd/p_cmd), this
 * method will allocate a new buffer, copy the data over, and then deserialize the
 * copy.  On output, the pp_data will be updated to point at the new buffer.
 *
 * if l_data is provided as 0x0, space will be allocated and zeroized.  Additionally:
 *
 * * u fields initialized to 0
 * * c field values point to a zeroized space of the correct width
 * * v and * field lengths are set to 0 and pointers to NULL
 *
 * Under normal conditions, caller is responsible for de-allocating the new buffer 
 * once finished with it.
 *
 * In the event this method will return non-zero, the value originally pointed to
 * is not changed.  If a NULL was passed in, the value is still NULL.  If a pointer
 * to an existing buffer (to be copied) was passed in, then that pointer still points
 * at the existing data. This may require changes to error handling in the caller.
 *
 *
 * _P_MLKEM_RESPONSE rec;
 * unsigned int l_data = l_cmd;
 * unsigned char *pp_data = p_cmd;
 * 
 * os_mem_set(&rec, 0, sizeof(rec));
 * err = mlkem_response_calloc(&rec, &l_data, &pp_data);
 * if (err == 0x0) {
 *     // use rec ...
 *     // u fields can be get/set directly
 *     // c fields can be get/set directly, space is reserved and pointed to
 *     // v and * fields must be handled carefully
 *     //   existing data can be used as is
 *     //   if new data is supplied, (ie l_/p_ fields updated), the alloc/dealloc 
 *     //     of that data must be handled separately.
 * }
 * if (pp_data != NULL) os_mem_del(pp_data);
 * 
 * _P_MLKEM_RESPONSE * s             		| I
 * unsigned int   *l_data       | IO 
 * unsigned char **pp_data      | IO
 * unsigned int    os_mem_type  | I one of OS_MEM_TYPE_* or 0 (default OS_MEM_TYPE_SD)
 *
 * Returns: unsigned int, 0x0 or Error:
 * - (as returned by cmds_scanf) 
 *    or E_QSR2MUX_MALLOC
 */
unsigned int mlkem_response_calloc(void *, unsigned int *, void **, unsigned int);

/*****************************************************************************************
 * mlkem_response_sdata_store - serialize data and store in some db record, in secret area
 * ----------------------------
 *
 * _P_MLKEM_RESPONSE * s             		| I
 * DB *                         | I 
 * unsigned char  *index        | I - used as is, make sure it matches the DB's index length
 * unsigned int    l_secret     | I - Note: The associated SECRET data
 * unsigned char  *p_secret     | I - Note: The associated SECRET data
 *
 * Returns: unsigned int, 0x0 or Error:
 * - (as returned by db module) 
 *    or E_QSR2MUX_MALLOC
 */
unsigned int mlkem_response_pdata_store(
     void * p_rec, void * p_db, unsigned char *db_ndx,
     unsigned int l_secret, unsigned char *p_secret);

/*****************************************************************************************
 * mlkem_response_pdata_store - serialize data and store in some db record, in public area
 * ----------------------------
 *
 * _P_MLKEM_RESPONSE * s             		| I
 * DB *                         | I 
 * unsigned char  *index        | I - used as is, make sure it matches the DB's index length
 * unsigned int    l_public     | I - Note: The associated PUBLIC data
 * unsigned char  *p_public     | I - Note: The associated PUBLIC data
 *
 * Returns: unsigned int, 0x0 or Error:
 * - (as returned by db module) 
 *    or E_QSR2MUX_MALLOC
 */
unsigned int mlkem_response_pdata_store(
     void * p_rec, void * p_db, unsigned char *db_ndx,
     unsigned int l_public, unsigned char *p_public);

/*****************************************************************************************
 * mlkem_response_alloc_answ - Containerized cmds_alloc_answ
 * ----------------------------
 *
 * void *       ctxt | I 
 * _P_MLKEM_RESPONSE p_obj    | I
 *
 * Returns: unsigned int, 0x0 or Error:
 *    from cmds
 *    or E_QSR2MUX_MALLOC
 */
unsigned int mlkem_response_alloc_answ ( void *, _P_MLKEM_RESPONSE);
#else
unsigned int mlkem_response_new (
    _P_MLKEM_RESPONSE *,
    unsigned int,
    unsigned char *
); 
unsigned int    mlkem_response_raw_len   ( _P_MLKEM_RESPONSE );
unsigned char * mlkem_response_raw       ( _P_MLKEM_RESPONSE );

void mlkem_response_free ( _P_MLKEM_RESPONSE );
#endif

/***********************************************************************
 * Non-autogenerated methods follow.
 */

//  "exfiles/mlkem_response_ex.h"
#endif