/* 
 * 03c autogenerated 2024-11-06T12:45:06.503739 using 
 * CS_SdkVpl version 0.0.6
 * Template version 0002
 * Source XML Document version 01d,2024-03-26,riw
 * 
 * Copyright included by reference, please see Utimaco_Demo_License.txt
 *
 */

/* This is the C implementation for the struct MLDSA_Verify_imp */

#ifndef _mldsa_verify_h_0_0_0_0
  #define _mldsa_verify_h_0_0_0_0

/* Defines -------------------------------------------------------------- */

#define FLAG_MASK 0xF2040000 /* ML-DSA Define mask */
#define FLAG_HAS_CTXT 0xF2040000 /* Signature will include AAD/Context Information */
#define FLAG_PRE_HASH 0xF2040001 /* Input msg is a hash of the message data */
#define FLAG_SIG_PACKED 0xF2040002 /* Signature is packed version */
#define SWALLOW_BAD_VER_EXCEPTION 0xF2040004 /* Return False instead of verify exception */

/*
::IFDEF:: DECS_ALLOCATION_METHODS
#DECS_ALLOCATION_METHODS#
#DECS_FREE_METHODS#
::ENDIF::
*/

/* Declarations for Pattern u4u4v2v4v1v4v2 */
typedef struct mldsa_verify { 
    unsigned int    flags;		// u4
    unsigned int    type;		// u4
    unsigned int    l_key;		// v2
    unsigned char * p_key; 
    unsigned int    l_msg;		// v4
    unsigned char * p_msg; 
    unsigned int    l_ctxt;		// v1
    unsigned char * p_ctxt; 
    unsigned int    l_state;		// v4
    unsigned char * p_state; 
    unsigned int    l_sig;		// v2
    unsigned char * p_sig; 
} MLDSA_VERIFY;
#define mldsa_verify_PATTERN u4u4v2v4v1v4v2
#define MLDSA_VERIFY_PATTERN "u4u4v2v4v1v4v2"
typedef MLDSA_VERIFY * _P_MLDSA_VERIFY;
#define MLDSA_VERIFY_SER_LEN_MAX 262143

#ifdef DEBUG
/*****************************************************************************************
 * mldsa_verify_tell - Output the current state of SIG variable, if set
 * ------------------
 * Pattern: u4u4v2v4v1v4v2
 * ------------------
 *
 * const _P_MLDSA_VERIFY * s   | I
 * 
 * Returns: void.  Output goes to cmds_[x]print, ONLY IN DEBUG MODE
 */
unsigned int mldsa_verify_tell ( const _P_MLDSA_VERIFY s );
#endif

/*****************************************************************************************
 * mldsa_verify_length - Compute the serialized length of the data in the structure
 * ------------------
 * Pattern: u4u4v2v4v1v4v2
 * ------------------
 *
 * 
 * const _P_MLDSA_VERIFY * s   | I
 * 
 * Returns: unsigned int, wire-length of the data in the struct pointed to.
 */
unsigned int mldsa_verify_length ( const _P_MLDSA_VERIFY );

/*****************************************************************************************
 * mldsa_verify_serialize - Serialize data in struct for wire-transmittal
 * ------------------
 * Pattern: u4u4v2v4v1v4v2
 * ------------------
 *
 * 
 * MLDSA_VERIFY * s   | I
 * unsigned int   l_answ    | I Length of destination buffer provided
 * unsigned char *p_answ    | I Destination buffer for serialized data
 *
 * Returns: 0x0, or 
 * Errors:  E_PQMI_SERIALIZATION -- 
 */
 unsigned int mldsa_verify_serialize (
  const _P_MLDSA_VERIFY, 
  unsigned int, 
  unsigned char *
);

/*****************************************************************************************
 * mldsa_verify_scanf - Containerized cmds_scanf
 * ------------------
 * Pattern: u4u4v2v4v1v4v2
 * ------------------
 *
 * 
 * _P_MLDSA_VERIFY * s             | I 
 * const unsigned int l_data          | I 
 * const unsigned char *p_data        | I 
 *
 * Returns: unsigned int, 0x0 or Error:
 * - (as returned by cmds_scanf)
 */
unsigned int mldsa_verify_scanf (
  _P_MLDSA_VERIFY, 
  unsigned int, 
  unsigned char *
);
#define mldsa_verify_deserialize mldsa_verify_scanf

#ifdef OS_SMOS
/*****************************************************************************************
 * mldsa_verify_calloc - Copy-Alloc
 * ----------------------------
 *
 * Provided an object and a pointer to serialized data (ie, via l_cmd/p_cmd), this
 * method will allocate a new buffer, copy the data over, and then deserialize the
 * copy.  On output, the pp_data will be updated to point at the new buffer.
 *
 * if l_data is provided as 0x0, space will be allocated and zeroized.  Additionally:
 *
 * * u fields initialized to 0
 * * c field values point to a zeroized space of the correct width
 * * v and * field lengths are set to 0 and pointers to NULL
 *
 * Under normal conditions, caller is responsible for de-allocating the new buffer 
 * once finished with it.
 *
 * In the event this method will return non-zero, the value originally pointed to
 * is not changed.  If a NULL was passed in, the value is still NULL.  If a pointer
 * to an existing buffer (to be copied) was passed in, then that pointer still points
 * at the existing data. This may require changes to error handling in the caller.
 *
 *
 * _P_MLDSA_VERIFY rec;
 * unsigned int l_data = l_cmd;
 * unsigned char *pp_data = p_cmd;
 * 
 * os_mem_set(&rec, 0, sizeof(rec));
 * err = mldsa_verify_calloc(&rec, &l_data, &pp_data);
 * if (err == 0x0) {
 *     // use rec ...
 *     // u fields can be get/set directly
 *     // c fields can be get/set directly, space is reserved and pointed to
 *     // v and * fields must be handled carefully
 *     //   existing data can be used as is
 *     //   if new data is supplied, (ie l_/p_ fields updated), the alloc/dealloc 
 *     //     of that data must be handled separately.
 * }
 * if (pp_data != NULL) os_mem_del(pp_data);
 * 
 * _P_MLDSA_VERIFY * s             		| I
 * unsigned int   *l_data       | IO 
 * unsigned char **pp_data      | IO
 * unsigned int    os_mem_type  | I one of OS_MEM_TYPE_* or 0 (default OS_MEM_TYPE_SD)
 *
 * Returns: unsigned int, 0x0 or Error:
 * - (as returned by cmds_scanf) 
 *    or E_QSR2MUX_MALLOC
 */
unsigned int mldsa_verify_calloc(void *, unsigned int *, void **, unsigned int);

/*****************************************************************************************
 * mldsa_verify_sdata_store - serialize data and store in some db record, in secret area
 * ----------------------------
 *
 * _P_MLDSA_VERIFY * s             		| I
 * DB *                         | I 
 * unsigned char  *index        | I - used as is, make sure it matches the DB's index length
 * unsigned int    l_secret     | I - Note: The associated SECRET data
 * unsigned char  *p_secret     | I - Note: The associated SECRET data
 *
 * Returns: unsigned int, 0x0 or Error:
 * - (as returned by db module) 
 *    or E_QSR2MUX_MALLOC
 */
unsigned int mldsa_verify_pdata_store(
     void * p_rec, void * p_db, unsigned char *db_ndx,
     unsigned int l_secret, unsigned char *p_secret);

/*****************************************************************************************
 * mldsa_verify_pdata_store - serialize data and store in some db record, in public area
 * ----------------------------
 *
 * _P_MLDSA_VERIFY * s             		| I
 * DB *                         | I 
 * unsigned char  *index        | I - used as is, make sure it matches the DB's index length
 * unsigned int    l_public     | I - Note: The associated PUBLIC data
 * unsigned char  *p_public     | I - Note: The associated PUBLIC data
 *
 * Returns: unsigned int, 0x0 or Error:
 * - (as returned by db module) 
 *    or E_QSR2MUX_MALLOC
 */
unsigned int mldsa_verify_pdata_store(
     void * p_rec, void * p_db, unsigned char *db_ndx,
     unsigned int l_public, unsigned char *p_public);

/*****************************************************************************************
 * mldsa_verify_alloc_answ - Containerized cmds_alloc_answ
 * ----------------------------
 *
 * void *       ctxt | I 
 * _P_MLDSA_VERIFY p_obj    | I
 *
 * Returns: unsigned int, 0x0 or Error:
 *    from cmds
 *    or E_QSR2MUX_MALLOC
 */
unsigned int mldsa_verify_alloc_answ ( void *, _P_MLDSA_VERIFY);
#else
unsigned int mldsa_verify_new (
    _P_MLDSA_VERIFY *,
    unsigned int,
    unsigned char *
); 
unsigned int    mldsa_verify_raw_len   ( _P_MLDSA_VERIFY );
unsigned char * mldsa_verify_raw       ( _P_MLDSA_VERIFY );

void mldsa_verify_free ( _P_MLDSA_VERIFY );
#endif

/***********************************************************************
 * Non-autogenerated methods follow.
 */

//  "exfiles/mldsa_verify_ex.h"
#endif