package com.utimaco.cs2.mdl.pqmi;
/* 
 * 03c autogenerated 2024-04-01T16:12:58.2521212 using 
 * CS_SdkVpl version 0.0.5
 * Source XML Document version 01d,2024-03-26,riw
 * 
 * Copyright included by reference, please see Utimaco_Demo_License.txt
 */

import java.nio.ByteBuffer;

import com.utimaco.cs2.mdl.SdkSequence;
import com.utimaco.cs2.mdl.DeserializationError;
import com.utimaco.cs2.mdl.SerializationError;
import com.utimaco.cs2.mdl.Utils;

public class PqmiPubInfoSeq extends SdkSequence {
    private static final int PqmiPubInfoSq_MAGIC = 0x21d8c5d3;
    
    // Auto-generated constructor stubs
    public PqmiPubInfoSeq (int maxSeqSize) {
        super(maxSeqSize);
    }
    
    public PqmiPubInfo get(int n) {
        try {
            PqmiPubInfo obj = (PqmiPubInfo)super.get(n);
            return obj;
        } catch (IndexOutOfBoundsException oob) { }
        return null;
    }
    
    public PqmiPubInfo get(String n) {
        return (PqmiPubInfo)super.get(n);
    }
    
    public boolean add(String n, PqmiPubInfo obj) {
        return super.add(n, obj);
    }
    
    public boolean deserialize (byte [] bff) throws DeserializationError {
        if (!seqSet(bff, PqmiPubInfoSq_MAGIC)) {
            throw new DeserializationError("Not a(n) PqmiPubInfoSeq (bad magic)");
        }
        int n = 0;
        ByteBuffer r = null;

        clear();
        while ((r = seqRec(n++)) != null) {
            byte uuidlen = r.get();
            byte [] uuid = new byte[uuidlen];
            r.get(uuid, 0, uuidlen);
            byte [] arr = r.slice().array();
            PqmiPubInfo obj = new PqmiPubInfo(arr);
            String uuidchk = obj.hexAsciiHash(false);
            String uuidstr = Utils.convertToHex(uuid);
            if (uuidchk.compareToIgnoreCase(uuidstr) == 0) {
                add(uuidchk, obj);
            }
        }
        return true;
    }
    
    public int getMaxSerLen () {
        int mlx = 0;
        for (int i = 0; i < count(); i++) {
            int len = ((PqmiPubInfo)get(i)).length();
            if (len > mlx) { mlx = len; }
        }
        return mlx;
    }
    
    public byte [] serialize () throws SerializationError {
        ByteBuffer seq = seqPrep(PqmiPubInfoSq_MAGIC);
        for (int i = 0; i < count(); i++) {
            PqmiPubInfo obj = get(i);
            String hexascii = obj.hexAsciiHash(false);
            seq.put(hexascii.getBytes());
            seq.put(obj.serialize());
        }
        return seq.array();
    }
}