package com.utimaco.cs2.mdl.pqmi;

/* 
 * 03c autogenerated 2024-04-01T16:12:58.2521212 using 
 * CS_SdkVpl version 0.0.5
 * Source XML Document version 01d,2024-03-26,riw
 * 
 * Copyright included by reference, please see Utimaco_Demo_License.txt
 */

import java.io.IOException;
import com.utimaco.cs2.mdl.I_SdkBuffer;
import CryptoServerAPI.CryptoServerException;
import CryptoServerCXI.CryptoServerCXI;
import java.nio.ByteBuffer;
import com.utimaco.cs2.mdl.SdkBuffer;
import com.utimaco.cs2.mdl.DeserializationError;
import com.utimaco.cs2.mdl.SerializationError;

// Typed parameters (if any)

/**
 * Pattern: v1v2u4u4u4u4u4c18c18u1c32c32v2*
 *
 * Field declarations
 * <pre>
 * group:  (v1) unsigned byte + ...[string]{}
 *   byte []           group                          = new byte[0];        // //  v1
 * pk:  (v2) unsigned short + ...[string]{}
 *   byte []           pk                             = new byte[0];        // //  v2

 * type:  (u4) unsigned int[string]{}
 *   int               type                           = (int)0x0;           //  from  u4

 * algo:  (u4) unsigned int[string]{}
 *   int               algo                           = (int)0x0;           //  from  u4

 * size:  (u4) unsigned int[string]{}
 *   int               size                           = (int)0x0;           //  from  u4

 * usage:  (u4) unsigned int[string]{}
 *   int               usage                          = (int)0x0;           //  from  u4

 * export:  (u4) unsigned int[string]{}
 *   int               export                         = (int)0x0;           //  from  u4

 * creat:  (c) octet array of fixed length[string]{}
 *   byte []           creat                          = new byte[0];        // //  c18

 * access:  (c) octet array of fixed length[string]{}
 *   byte []           access                         = new byte[0];        // //  c18

 * levels:  (u1) unsigned byte[string]{}
 *   byte              levels                         = (byte)0x0;          // //  u1

 * lm_array:  (c) octet array of fixed length[string]{}
 *   byte []           lm_array                       = new byte[0];        // //  c32

 * ots_array:  (c) octet array of fixed length[string]{}
 *   byte []           ots_array                      = new byte[0];        // //  c32

 * metad:  (v2) unsigned short + ...[string]{}
 *   byte []           metad                          = new byte[0];        // User-supplied data//  v2

 * data:  (*) additional bytes of unfixed length[string]{}
 *   byte []           data                           = new byte[0];        // RFU//  *

 * </pre>
 * @author SFCBUFFERS
 *
 */
public class PqmiPubInfo extends SdkBuffer implements I_SdkBuffer {
    int ModuleID = 0x087; // Default is 'echo' from ADM
    int SFC = 0; // Default is 'echo' from ADM
    protected static final String pattern = "v1v2u4u4u4u4u4c18c18u1c32c32v2*"; 

    // Interface specific defined def elements

    // Interface Fields
    byte [] group = new byte[0];
    byte [] pk = new byte[0];
    int type = 0x0;
    int algo = 0x0;
    int size = 0x0;
    int usage = 0x0;
    int export = 0x0;
    protected static final int _CLEN_CREAT = 18; // c18
    byte [] creat = new byte[_CLEN_CREAT];
    protected static final int _CLEN_ACCESS = 18; // c18
    byte [] access = new byte[_CLEN_ACCESS];
    byte levels = (byte)0x0;
    protected static final int _CLEN_LM_ARRAY = 32; // c32
    byte [] lm_array = new byte[_CLEN_LM_ARRAY];
    protected static final int _CLEN_OTS_ARRAY = 32; // c32
    byte [] ots_array = new byte[_CLEN_OTS_ARRAY];
    byte [] metad = new byte[0];
    byte [] data = new byte[0];

    // Static constructor stubs.
    //
    // PqmiPubInfo obj = new PqmiPubInfo ();
    // PqmiPubInfo obj = new PqmiPubInfo (cxi); // does not exec
    // PqmiPubInfo obj = new PqmiPubInfo (cxi, _in); // does not exec
    // PqmiPubInfo obj = new PqmiPubInfo (_resp); // decompose buffer received elsewhere
    // 

    /** 
     * Instantiate a PqmiPubInfo object (empty)
     */
    public PqmiPubInfo () { super(); }

    /**
     * Instantiate a PqmiPubInfo object, referencing an existing connection 
     * to a CryptoServer
     */
    public PqmiPubInfo (CryptoServerCXI _cxi) {
      this();
      cxi = _cxi;
    }

    /**
     * Instantiate a PqmiPubInfo object, referencing an existing connection 
     * to a CryptoServer, and targeting a specific Module/SFC
     */
    public PqmiPubInfo (CryptoServerCXI _cxi, int mid, int sfc) {
      super(mid, sfc);
      cxi = _cxi;
    }

    /**
     * Instantiate a PqmiPubInfo object, referencing an existing connection 
     * to a CryptoServer, and supplying the input values via deserializable
     * byte buffer.  
     */
    public PqmiPubInfo (CryptoServerCXI _cxi, byte [] _in) {
      this(_cxi);
      try { deserialize(_in); }
      catch (DeserializationError e) { e.printStackTrace(); }
    }

    /**
     * Instantiate a PqmiPubInfo object, without referencing a CryptoServer
     * This method deserializes a byte buffer that was received as the
     * response to an earlier issued command.
     */
    public PqmiPubInfo (byte [] _resp) {
      this();
      try { deserialize(_resp); }
      catch (DeserializationError e) { e.printStackTrace(); }
    }

    /**
     * Additional Constructors based on the Interface definition
     */
    // Java "Normal"
    public PqmiPubInfo ( 
        byte [] _group,
        byte [] _pk,
        int _type,
        int _algo,
        int _size,
        int _usage,
        int _export,
        byte [] _creat,
        byte [] _access,
        byte _levels,
        byte [] _lm_array,
        byte [] _ots_array,
        byte [] _metad,
        byte [] _data

    ) {
        group(_group); 
        pk(_pk); 
        type(_type); 
        algo(_algo); 
        size(_size); 
        usage(_usage); 
        export(_export); 
        creat(_creat); 
        access(_access); 
        levels(_levels); 
        lm_array(_lm_array); 
        ots_array(_ots_array); 
        metad(_metad); 
        data(_data); 
    }

    // Java Object

    // Command setters/getters 
    public byte []  group() { return group; } 
    public void     group (byte []  _in) { group = _in; }
    public void     groupFrom (byte []  _in) {
        group = new byte[_in.length];
        System.arraycopy(_in, 0, group, 0, _in.length);
    }
    public void     group (String _in) {
        group = _in.getBytes();
    }
    public byte []  pk() { return pk; } 
    public void     pk (byte []  _in) { pk = _in; }
    public void     pkFrom (byte []  _in) {
        pk = new byte[_in.length];
        System.arraycopy(_in, 0, pk, 0, _in.length);
    }
    public void     pk (String _in) {
        pk = _in.getBytes();
    }
    public int      type() { return type; } 
    public void     type (int      _in) { type = _in; }
    public int      algo() { return algo; } 
    public void     algo (int      _in) { algo = _in; }
    public int      size() { return size; } 
    public void     size (int      _in) { size = _in; }
    public int      usage() { return usage; } 
    public void     usage (int      _in) { usage = _in; }
    public int      export() { return export; } 
    public void     export (int      _in) { export = _in; }
    public byte []  creat() { return creat; } 
    public void     creat (byte []  _in) { creat = _in; }
    public void     creatFrom (byte []  _in) {
        creat = new byte[_in.length];
        System.arraycopy(_in, 0, creat, 0, _in.length);
    }
    public void     creat (String _in) {
        creat = _in.getBytes();
    }
    public byte []  access() { return access; } 
    public void     access (byte []  _in) { access = _in; }
    public void     accessFrom (byte []  _in) {
        access = new byte[_in.length];
        System.arraycopy(_in, 0, access, 0, _in.length);
    }
    public void     access (String _in) {
        access = _in.getBytes();
    }
    public byte     levels() { return levels; } 
    public void     levels (byte     _in) { levels = _in; }
    public void    levels (int _in) { levels = ( byte     )_in; }    public byte []  lm_array() { return lm_array; } 
    public void     lm_array (byte []  _in) { lm_array = _in; }
    public void     lm_arrayFrom (byte []  _in) {
        lm_array = new byte[_in.length];
        System.arraycopy(_in, 0, lm_array, 0, _in.length);
    }
    public void     lm_array (String _in) {
        lm_array = _in.getBytes();
    }
    public byte []  ots_array() { return ots_array; } 
    public void     ots_array (byte []  _in) { ots_array = _in; }
    public void     ots_arrayFrom (byte []  _in) {
        ots_array = new byte[_in.length];
        System.arraycopy(_in, 0, ots_array, 0, _in.length);
    }
    public void     ots_array (String _in) {
        ots_array = _in.getBytes();
    }
    public byte []  metad() { return metad; } 
    public void     metad (byte []  _in) { metad = _in; }
    public void     metadFrom (byte []  _in) {
        metad = new byte[_in.length];
        System.arraycopy(_in, 0, metad, 0, _in.length);
    }
    public void     metad (String _in) {
        metad = _in.getBytes();
    }
    public byte []  data() { return data; } 
    public void     data (byte []  _in) { data = _in; }
    public void     dataFrom (byte []  _in) {
        data = new byte[_in.length];
        System.arraycopy(_in, 0, data, 0, _in.length);
    }
    public void     data (String _in) {
        data = _in.getBytes();
    }

    // Exec
    /**
     * Executes the command to the param-supplied CryptoServer, using
     * using the supplied ModuleID and Sub-function code.
     * <p>
     * This command may result in SerializationError or DeserializationError
     * events, but these are swallowed and returned as 'false'.
     * <p>
     * Note: The subfunction code only supports SFCs in the range 0..255.
     * <p>
     * @param CryptoServerCXI 
     * @param module ID 
     * @param subfunction code to call
     * @return boolean - ok (0x0) otherwise invalid input/ser+deser errors
     * @throws IOException (CryptoServer not available)
     * @throws CryptoServerException (non-zero response from the CryptoServer
     */
    public boolean exec (CryptoServerCXI cxi, int mid, int sfc) throws IOException, CryptoServerException {
        if (cxi == null) {
            System.out.println("No CXI\n");
            return false;
        }
        if ((sfc < 0) || (sfc > 255)) { return false; }

        return exec(cxi, mid, sfc, this, null); // this variant has no return value awareness, just stored
    }

    /**
     * Executes the command to the param-supplied CryptoServer, using
     * using the supplied ModuleID and Sub-function code.
     * <p>
     * This command may result in SerializationError or DeserializationError
     * events, but these are swallowed and returned as 'false'.
     * <p>
     * Note: The subfunction code only supports SFCs in the range 0..255.
     * <p>
     * If an I_SdkBuffer object is supplied as a recipient, and the response from 
     * the CryptoServer is OK, the result buffer will be handed to it and an attempt
     * to deserialize the result will happen.  
     * <p>
     * @param CryptoServerCXI 
     * @param module ID 
     * @param subfunction code to call
     * @param I_SdkBuffer to receive/parse the result into if OK is returned
     * @return boolean - ok (0x0) otherwise invalid input/ser+deser errors
     * @throws IOException (CryptoServer not available)
     * @throws CryptoServerException (non-zero response from the CryptoServer
     * @throws DeserializationError if the result can not be deserialized by this recipient
     */
    public boolean exec (CryptoServerCXI cxi, int mid, int sfc, I_SdkBuffer recvr) throws IOException, CryptoServerException {
        if (cxi == null) {
            System.out.println("No CXI\n");
            return false;
        }
        if ((sfc < 0) || (sfc > 255)) { return false; }

        return exec(cxi, mid, sfc, this, recvr); // this variant tries to deserialize the response into another I_SdkBuffer
    }

    /**
     * Executes the command to the provided CryptoServer, using the
     * compiled in ModuleID and Sub-function code
     * <p>
     * This command may result in SerializationError or DeserializationError
     * events, but these are swallowed and returned as 'false'.
     * <p>
     * @param cxi - CryptoServerCXI for target HSM
     * @return boolean - ok (0x0) otherwise fail
     * @throws IOException (CryptoServer not available)
     * @throws CryptoServerException (non-zero response from the CryptoServer
     */
    public boolean exec (CryptoServerCXI _cxi) throws IOException, CryptoServerException {
        return exec(_cxi, ModuleID, SFC);
    }

    /**
     * Executes the command to the CryptoServer supplied on object
     * instantiation, using the compiled in ModuleID and Sub-function code
     * <p>
     * If this object was instantiated without a cxi object, returns
     * false.
     * <p>
     * This command may result in SerializationError or DeserializationError
     * events, but these are swallowed and returned as 'false'.
     * <p>
     * @return boolean - ok (0x0) otherwise fail
     * @throws IOException (CryptoServer not available)
     * @throws CryptoServerException (non-zero response from the CryptoServer
     */
    public boolean exec () throws IOException, CryptoServerException {
        return exec(cxi, ModuleID, SFC);
    }

    public byte [] serialize () throws SerializationError {
        int len = length();
        if (len == 0) { return new byte[0]; }
        try {
            ByteBuffer bb = ByteBuffer.allocate(len);
 			// this.group of kind v1
            if (this.group == null) {
                this.group = new byte[0];
            }
            bb.put((byte)(this.group.length & 0xFF)); 
           	bb.put(this.group);

 			// this.pk of kind v2
            if (this.pk == null) {
                this.pk = new byte[0];
            }
        bb.putShort((short)(this.pk.length & 0xFFFF));
           	bb.put(this.pk);

 			// this.type of kind u4
            bb.putInt(this.type);
 			// this.algo of kind u4
            bb.putInt(this.algo);
 			// this.size of kind u4
            bb.putInt(this.size);
 			// this.usage of kind u4
            bb.putInt(this.usage);
 			// this.export of kind u4
            bb.putInt(this.export);
 			// this.creat of kind c18
			if (this.creat.length < 18) {
            	byte [] t = new byte[18];
            	int tl = 18;
            	if (this.creat.length < tl) { tl = this.creat.length; }
            	System.arraycopy(this.creat, 0, t, 0, tl);
            	bb.put(t);
           	} else if (this.creat.length == 18) {
           	    bb.put(this.creat);
            } else {
           		throw new SerializationError("Field width: this.creat.length > 18");
            }

 			// this.access of kind c18
			if (this.access.length < 18) {
            	byte [] t = new byte[18];
            	int tl = 18;
            	if (this.access.length < tl) { tl = this.access.length; }
            	System.arraycopy(this.access, 0, t, 0, tl);
            	bb.put(t);
           	} else if (this.access.length == 18) {
           	    bb.put(this.access);
            } else {
           		throw new SerializationError("Field width: this.access.length > 18");
            }

 			// this.levels of kind u1
            bb.put(this.levels);
 			// this.lm_array of kind c32
			if (this.lm_array.length < 32) {
            	byte [] t = new byte[32];
            	int tl = 32;
            	if (this.lm_array.length < tl) { tl = this.lm_array.length; }
            	System.arraycopy(this.lm_array, 0, t, 0, tl);
            	bb.put(t);
           	} else if (this.lm_array.length == 32) {
           	    bb.put(this.lm_array);
            } else {
           		throw new SerializationError("Field width: this.lm_array.length > 32");
            }

 			// this.ots_array of kind c32
			if (this.ots_array.length < 32) {
            	byte [] t = new byte[32];
            	int tl = 32;
            	if (this.ots_array.length < tl) { tl = this.ots_array.length; }
            	System.arraycopy(this.ots_array, 0, t, 0, tl);
            	bb.put(t);
           	} else if (this.ots_array.length == 32) {
           	    bb.put(this.ots_array);
            } else {
           		throw new SerializationError("Field width: this.ots_array.length > 32");
            }

 			// this.metad of kind v2
            if (this.metad == null) {
                this.metad = new byte[0];
            }
        bb.putShort((short)(this.metad.length & 0xFFFF));
           	bb.put(this.metad);

 			// this.data of kind *
            if (this.data == null) {
                this.data = new byte[0];
            }
           	bb.put(this.data);

 
            return bb.array();
        } catch (Exception e) {
            throw new SerializationError();
        }
    }

    public void deserialize (byte [] bfr) throws DeserializationError {
        if (bfr.length == 0) { return; }
        ByteBuffer bb = ByteBuffer.wrap(bfr);
        int len = 0;
        try {
 			// this.group of kind v1
			len = bb.get();
			this.group = new byte[len];
			bb.get(this.group, 0, len);
  			// this.pk of kind v2
			len = bb.getShort();
			this.pk = new byte[len];
			bb.get(this.pk, 0, len);
  			// this.type of kind u4
			this.type = bb.getInt();
  			// this.algo of kind u4
			this.algo = bb.getInt();
  			// this.size of kind u4
			this.size = bb.getInt();
  			// this.usage of kind u4
			this.usage = bb.getInt();
  			// this.export of kind u4
			this.export = bb.getInt();
  			// this.creat of kind c18
			if (this.creat == null) { this.creat = new byte[18]; }
			bb.get(this.creat, 0, this.creat.length);
  			// this.access of kind c18
			if (this.access == null) { this.access = new byte[18]; }
			bb.get(this.access, 0, this.access.length);
  			// this.levels of kind u1
			this.levels = bb.get();
  			// this.lm_array of kind c32
			if (this.lm_array == null) { this.lm_array = new byte[32]; }
			bb.get(this.lm_array, 0, this.lm_array.length);
  			// this.ots_array of kind c32
			if (this.ots_array == null) { this.ots_array = new byte[32]; }
			bb.get(this.ots_array, 0, this.ots_array.length);
  			// this.metad of kind v2
			len = bb.getShort();
			this.metad = new byte[len];
			bb.get(this.metad, 0, len);
  			// this.data of kind *
			len = bb.remaining();
			this.data = new byte[len];
			bb.get(this.data, 0, this.data.length);
  			return;
        } catch (Exception e) {
            throw new DeserializationError();
        } finally {
            if (bb.hasRemaining()) {
            	throw new DeserializationError();
            }
        }
     }
        
    public int length () {
        int len = 0;
    
 		len += 1; // this.group of kind v1
		len += this.group.length;

 		len += 2; // this.pk of kind v2
		len += this.pk.length;

 		len += 4; // this.type of kind u4

 		len += 4; // this.algo of kind u4

 		len += 4; // this.size of kind u4

 		len += 4; // this.usage of kind u4

 		len += 4; // this.export of kind u4

         len += 18; // this.creat of kind c18

         len += 18; // this.access of kind c18

 		len += 1; // this.levels of kind u1

         len += 32; // this.lm_array of kind c32

         len += 32; // this.ots_array of kind c32

 		len += 2; // this.metad of kind v2
		len += this.metad.length;

 		len += this.data.length; // this.data of kind *

        return len;
    }

	// possible return values, based on module SFC responses for SFC using this as an interface
	public boolean responseAs(I_SdkBuffer buffer) {
	    if (resp == null) { return false; }
	    try {
		    buffer.deserialize(resp);
		    return true;
		} catch (DeserializationError doops) {
		}
		return false;
    }

    public String toString() {
        // The 8 means only display the first 8 lines 
        // of the entirely serialized data
        return toString("com.utimaco.cs2.mdl.pqmi.PqmiPubInfo >", 8);
    }

    public String toString(String note, int maxInitialLines) {
        maxInitialLines++;
        if (this.length() == 0) { return note; }
        try {
            StringBuilder r = new StringBuilder(String.format("Serialized using: '%s'\n", pattern));
            r.append(xtrace(note, this.serialize()));
            String [] strings = r.toString().split("\\n");
            if (strings.length > maxInitialLines) {
                r.setLength(0);
                for (int i = 0; i < maxInitialLines; i++) { r.append(strings[i] + "\n"); }
                r.append("\t\t...\n");
            }

 			if (this.group == null) { 
				r.append("group = {NULL}"); 
			} else {
				r.append(String.format("\ngroup = [Variable length field (v1) of length %d - (0x%x))", this.group.length, this.group.length));
                r.append("\n");
				r.append(xtrace(this.group, 4));
			}

 			if (this.pk == null) { 
				r.append("pk = {NULL}"); 
			} else {
				r.append(String.format("\npk = [Variable length field (v2) of length %d - (0x%x))", this.pk.length, this.pk.length));
                r.append("\n");
				r.append(xtrace(this.pk, 4));
			}

 			r.append(String.format("\ntype = %d\t\t(0x%0" + (4 * 2) + "x)", this.type, this.type));

 			r.append(String.format("\nalgo = %d\t\t(0x%0" + (4 * 2) + "x)", this.algo, this.algo));

 			r.append(String.format("\nsize = %d\t\t(0x%0" + (4 * 2) + "x)", this.size, this.size));

 			r.append(String.format("\nusage = %d\t\t(0x%0" + (4 * 2) + "x)", this.usage, this.usage));

 			r.append(String.format("\nexport = %d\t\t(0x%0" + (4 * 2) + "x)", this.export, this.export));

 			if (this.creat == null) { 
				r.append("creat = {NULL}"); 
			} else {
				r.append("\ncreat = [Fixed length field (c18)]");
                r.append("\n");
				r.append(xtrace(this.creat, 4));
			}

 			if (this.access == null) { 
				r.append("access = {NULL}"); 
			} else {
				r.append("\naccess = [Fixed length field (c18)]");
                r.append("\n");
				r.append(xtrace(this.access, 4));
			}

 			r.append(String.format("\nlevels = %d\t\t(0x%0" + (1 * 2) + "x)", this.levels, this.levels));

 			if (this.lm_array == null) { 
				r.append("lm_array = {NULL}"); 
			} else {
				r.append("\nlm_array = [Fixed length field (c32)]");
                r.append("\n");
				r.append(xtrace(this.lm_array, 4));
			}

 			if (this.ots_array == null) { 
				r.append("ots_array = {NULL}"); 
			} else {
				r.append("\nots_array = [Fixed length field (c32)]");
                r.append("\n");
				r.append(xtrace(this.ots_array, 4));
			}

 			if (this.metad == null) { 
				r.append("metad = {NULL}"); 
			} else {
				r.append(String.format("\nmetad = [Variable length field (v2) of length %d - (0x%x))", this.metad.length, this.metad.length));
                r.append("\n");
				r.append(xtrace(this.metad, 4));
			}

 			if (this.data == null) { 
				r.append("data = {NULL}"); 
			} else {
				r.append(String.format("\ndata = [Bulk Data (*)]"));
                r.append("\n");
				r.append(xtrace(this.data, 4));
			}

            r.append("\nUUID: " + hexAsciiHash(true) + "\n");
            r.append(String.format("\nTotal length of object: %d (0x%x)\n", length(), length()));

            return r.toString();
        } catch (Exception e) {
            e.printStackTrace();
        }
        return "com.utimaco.cs2.mdl.pqmi.PqmiPubInfo > exception in data.";
    }

    public String hexAsciiHash(boolean formatted) {
        StringBuilder sb = new StringBuilder("com.utimaco.cs2.mdl.pqmi.PqmiPubInfo");
            sb.append(pattern); 
            if (this.group != null) { sb.append(new String(this.group)).append(this.group.length); }
            if (this.pk != null) { sb.append(new String(this.pk)).append(this.pk.length); }
            sb.append(this.type).append(4);
            sb.append(this.algo).append(4);
            sb.append(this.size).append(4);
            sb.append(this.usage).append(4);
            sb.append(this.export).append(4);
            if (this.creat != null) { sb.append(new String(this.creat)).append(this.creat.length); }
            if (this.access != null) { sb.append(new String(this.access)).append(this.access.length); }
            sb.append(this.levels).append(1);
            if (this.lm_array != null) { sb.append(new String(this.lm_array)).append(this.lm_array.length); }
            if (this.ots_array != null) { sb.append(new String(this.ots_array)).append(this.ots_array.length); }
            if (this.metad != null) { sb.append(new String(this.metad)).append(this.metad.length); }
            if (this.data != null) { sb.append(new String(this.data)).append(this.data.length); }

            return SdkBuffer.hexAsciiHash(sb.toString(), formatted);
    }   
}