package com.utimaco.cs2.mdl.pqmi;

/* 
 * 03c autogenerated 2024-11-06T12:45:03.0747005 using 
 * CS_SdkVpl version 0.0.6
 * Source XML Document version 01d,2024-03-26,riw
 * 
 * Copyright included by reference, please see Utimaco_Demo_License.txt
 *
 */

import com.utimaco.cs2.mdl.I_SdkBuffer;
import java.nio.ByteBuffer;
import java.io.IOException;
import CryptoServerAPI.CryptoServerException;
import CryptoServerCXI.CryptoServerCXI;
import com.utimaco.cs2.mdl.SdkBuffer;
import com.utimaco.cs2.mdl.DeserializationError;
import com.utimaco.cs2.mdl.SerializationError;

// Typed parameters (if any)
import com.utimaco.cs2.mdl.any.CxiKeyAttributes;

/**
 * Pattern: u4u4v2*
 *
 * Field declarations
 * <pre>
 * flags:  (u4) unsigned int {}
 *   int               flags                          = (int)0x0;           // Flags from  u4

 * type:  (u4) unsigned int {}
 *   int               type                           = (int)0x0;           // key type from  u4

 * attributes:  (v2) unsigned short + data {}
 *   byte []           attributes                     = new byte[0];        // // CxiKeyAttributes v2

 * seed:  (*) additional bytes of unfixed length{}
 *   byte []           seed                           = new byte[0];        // //  *

 * </pre>
 * @author SFCBUFFERS
 *
 */
public class MLDSA_KeyGen extends SdkBuffer implements I_SdkBuffer {
    int ModuleID = 0x087; // Default is 'echo' from ADM
    int SFC = 0; // Default is 'echo' from ADM
    protected static final String pattern = "u4u4v2*"; 

    // Interface specific defined def elements

    // Interface Fields
    int flags = 0x0;
    int type = 0x0;
    byte [] attributes = new byte[0];
    byte [] seed = new byte[0];

    // Static constructor stubs.
    //
    // MLDSA_KeyGen obj = new MLDSA_KeyGen ();
    // MLDSA_KeyGen obj = new MLDSA_KeyGen (cxi); // does not exec
    // MLDSA_KeyGen obj = new MLDSA_KeyGen (cxi, _in); // does not exec
    // MLDSA_KeyGen obj = new MLDSA_KeyGen (_resp); // decompose buffer received elsewhere
    // MLDSA_KeyGen obj = new MLDSA_KeyGen (_resp, boolean); // decompose buffer received elsewhere, which may be longer than expected
    //                                                     // if true, do not accept this and throw SerializationError
    //                                                     // if false, accept this and ignore remaining bytes
    // 

    /** 
     * Instantiate a MLDSA_KeyGen object (empty)
     */
    public MLDSA_KeyGen () { super(); }

    /**
     * Instantiate a MLDSA_KeyGen object, referencing an existing connection 
     * to a CryptoServer
     */
    public MLDSA_KeyGen (CryptoServerCXI _cxi) {
      this();
      cxi = _cxi;
    }

    /**
     * Instantiate a MLDSA_KeyGen object, referencing an existing connection 
     * to a CryptoServer, and targeting a specific Module/SFC
     */
    public MLDSA_KeyGen (CryptoServerCXI _cxi, int mid, int sfc) {
      super(mid, sfc);
      cxi = _cxi;
    }

    /**
     * Instantiate a MLDSA_KeyGen object, referencing an existing connection 
     * to a CryptoServer, and supplying the input values via deserializable
     * byte buffer.  
     */
    public MLDSA_KeyGen (CryptoServerCXI _cxi, byte [] _in) {
      this(_cxi);
      try { deserialize(_in); }
      catch (DeserializationError e) { e.printStackTrace(); }
    }

    /**
     * Instantiate a MLDSA_KeyGen object, without referencing a CryptoServer
     * This method deserializes a byte buffer that was received as the
     * response to an earlier issued command.
     */
    public MLDSA_KeyGen (byte [] _resp) {
    	this(_resp, true);
    }
    
    /**
     * Instantiate a MLDSA_KeyGen object, without referencing a CryptoServer
     * This method deserializes a byte buffer that was received as the
     * response to an earlier issued command.  If there are remaining bytes
     * in the _resp array at the end of the interface deserialization, 
     * if assumeExactLenBuffer is true, throws SerializationError, else
     * does not throw.
     */
    public MLDSA_KeyGen (byte [] _resp, boolean assumeExactLenBuffer) {
      this();
      try { deserialize(_resp, assumeExactLenBuffer); }
      catch (DeserializationError e) { e.printStackTrace(); }
    }

    /**
     * Additional Constructors based on the Interface definition
     */
    // Java "Normal"
    public MLDSA_KeyGen ( 
        int _flags,
        int _type,
        byte [] _attributes,
        byte [] _seed

    ) {
        flags(_flags); 
        type(_type); 
        attributes(_attributes); 
        seed(_seed); 
    }

    // Java Object
    public MLDSA_KeyGen (
        int _flags, int _type, CxiKeyAttributes _attributes, byte [] _seed
    ) throws SerializationError {
        flags(_flags);
        type(_type);
        attributes(_attributes.serialize());
        seed(_seed);
    }

    // Command setters/getters 
    public int      flags() { return flags; } 
    public void     flags (int      _in) { flags = _in; }
    public int      type() { return type; } 
    public void     type (int      _in) { type = _in; }
    public byte []  attributes() { return attributes; } 
    public void     attributes (byte []  _in) { attributes = _in; }
    public void     attributesFrom (byte []  _in) {
        attributes = new byte[_in.length];
        System.arraycopy(_in, 0, attributes, 0, _in.length);
    }
    public void     attributes (String _in) {
        attributes = _in.getBytes();
    }
    public void     attributes (CxiKeyAttributes _in) throws SerializationError {
        attributes = _in.serialize();
    }
    


    public byte []  seed() { return seed; } 
    public void     seed (byte []  _in) { seed = _in; }
    public void     seedFrom (byte []  _in) {
        seed = new byte[_in.length];
        System.arraycopy(_in, 0, seed, 0, _in.length);
    }
    public void     seed (String _in) {
        seed = _in.getBytes();
    }

    // Exec
    /**
     * Executes the command to the param-supplied CryptoServer, using
     * using the supplied ModuleID and Sub-function code.
     * <p>
     * This command may result in SerializationError or DeserializationError
     * events, but these are swallowed and returned as 'false'.
     * <p>
     * Note: The subfunction code only supports SFCs in the range 0..255.
     * <p>
     * @param CryptoServerCXI 
     * @param module ID 
     * @param subfunction code to call
     * @return boolean - ok (0x0) otherwise invalid input/ser+deser errors
     * @throws IOException (CryptoServer not available)
     * @throws CryptoServerException (non-zero response from the CryptoServer
     */
    public boolean exec (CryptoServerCXI cxi, int mid, int sfc) throws IOException, CryptoServerException {
        if (cxi == null) {
            System.out.println("No CXI\n");
            return false;
        }
        if ((sfc < 0) || (sfc > 255)) { return false; }

        return exec(cxi, mid, sfc, this, null); // this variant has no return value awareness, just stored
    }

    /**
     * Executes the command to the param-supplied CryptoServer, using
     * using the supplied ModuleID and Sub-function code.
     * <p>
     * This command may result in SerializationError or DeserializationError
     * events, but these are swallowed and returned as 'false'.
     * <p>
     * Note: The subfunction code only supports SFCs in the range 0..255.
     * <p>
     * If an I_SdkBuffer object is supplied as a recipient, and the response from 
     * the CryptoServer is OK, the result buffer will be handed to it and an attempt
     * to deserialize the result will happen.  
     * <p>
     * @param CryptoServerCXI 
     * @param module ID 
     * @param subfunction code to call
     * @param I_SdkBuffer to receive/parse the result into if OK is returned
     * @return boolean - ok (0x0) otherwise invalid input/ser+deser errors
     * @throws IOException (CryptoServer not available)
     * @throws CryptoServerException (non-zero response from the CryptoServer
     * @throws DeserializationError if the result can not be deserialized by this recipient
     */
    public boolean exec (CryptoServerCXI cxi, int mid, int sfc, I_SdkBuffer recvr) throws IOException, CryptoServerException {
        if (cxi == null) {
            System.out.println("No CXI\n");
            return false;
        }
        if ((sfc < 0) || (sfc > 255)) { return false; }

        return exec(cxi, mid, sfc, this, recvr); // this variant tries to deserialize the response into another I_SdkBuffer
    }

    /**
     * Executes the command to the provided CryptoServer, using the
     * compiled in ModuleID and Sub-function code
     * <p>
     * This command may result in SerializationError or DeserializationError
     * events, but these are swallowed and returned as 'false'.
     * <p>
     * @param cxi - CryptoServerCXI for target HSM
     * @return boolean - ok (0x0) otherwise fail
     * @throws IOException (CryptoServer not available)
     * @throws CryptoServerException (non-zero response from the CryptoServer
     */
    public boolean exec (CryptoServerCXI _cxi) throws IOException, CryptoServerException {
        return exec(_cxi, ModuleID, SFC);
    }

    /**
     * Executes the command to the CryptoServer supplied on object
     * instantiation, using the compiled in ModuleID and Sub-function code
     * <p>
     * If this object was instantiated without a cxi object, returns
     * false.
     * <p>
     * This command may result in SerializationError or DeserializationError
     * events, but these are swallowed and returned as 'false'.
     * <p>
     * @return boolean - ok (0x0) otherwise fail
     * @throws IOException (CryptoServer not available)
     * @throws CryptoServerException (non-zero response from the CryptoServer
     */
    public boolean exec () throws IOException, CryptoServerException {
        return exec(cxi, ModuleID, SFC);
    }

    public byte [] serialize () throws SerializationError {
        int len = length();
        if (len == 0) { return new byte[0]; }
        try {
            ByteBuffer bb = ByteBuffer.allocate(len);
 			// this.flags of kind u4
            bb.putInt(this.flags);
 			// this.type of kind u4
            bb.putInt(this.type);
 			// this.attributes of kind v2
            if (this.attributes == null) {
                this.attributes = new byte[0];
            }
        bb.putShort((short)(this.attributes.length & 0xFFFF));
           	bb.put(this.attributes);

 			// this.seed of kind *
            if (this.seed == null) {
                this.seed = new byte[0];
            }
           	bb.put(this.seed);

 
            return bb.array();
        } catch (Exception e) {
            throw new SerializationError();
        }
    }

	public void deserialize (byte [] bfr) throws DeserializationError {
		deserialize(bfr, true);
	}
	
    public void deserialize (byte [] bfr, boolean assumeExactLenBuffer) throws DeserializationError {
        if (bfr.length == 0) { return; }
        ByteBuffer bb = ByteBuffer.wrap(bfr);
        int len = 0;
        try {
 			// this.flags of kind u4
			this.flags = bb.getInt();
  			// this.type of kind u4
			this.type = bb.getInt();
  			// this.attributes of kind v2
			len = bb.getShort();
			this.attributes = new byte[len];
			bb.get(this.attributes, 0, len);
  			// this.seed of kind *
			len = bb.remaining();
			this.seed = new byte[len];
			bb.get(this.seed, 0, this.seed.length);
  			return;
        } catch (Exception e) {
            throw new DeserializationError();
        } finally {
            if (bb.hasRemaining()) {
            	if (assumeExactLenBuffer) {
	            	throw new DeserializationError();
	            }
            }
        }
     }
        
    public int length () {
        int len = 0;
    
 		len += 4; // this.flags of kind u4

 		len += 4; // this.type of kind u4

 		len += 2; // this.attributes of kind v2
		len += this.attributes.length;

 		len += this.seed.length; // this.seed of kind *

        return len;
    }

	/**
	 * 
	 * @return byte [] copy of response received from cxi.exec call (if available)
	 */
	public byte [] getResponse () {
		if (resp == null) { return null; }
		
		byte [] r = new byte[resp.length];
		System.arraycopy(resp,0,r,0,resp.length);
		return r;
	}
		
	// possible return values, based on module SFC responses for SFC using this as an interface
	/**
	 * Deserialize result into provided SdkBuffer container
	 *
	 * @param buffer (I_SdkBuffer)
	 * @result boolean success
	 */
	public boolean responseAs(I_SdkBuffer buffer) {
	    if (resp == null) { return false; }
	    try {
		    buffer.deserialize(resp);
		    return true;
		} catch (DeserializationError doops) {
		}
		return false;
    }

    public String toString() {
        // The 8 means only display the first 8 lines 
        // of the entirely serialized data
        return toString("com.utimaco.cs2.mdl.pqmi.MLDSA_KeyGen >", 8);
    }

    public String toString(String note, int maxInitialLines) {
        maxInitialLines++;
        if (this.length() == 0) { return note; }
        try {
            StringBuilder r = new StringBuilder(String.format("Serialized using: '%s'\n", pattern));
            r.append(xtrace(note, this.serialize()));
            String [] strings = r.toString().split("\\n");
            if (strings.length > maxInitialLines) {
                r.setLength(0);
                for (int i = 0; i < maxInitialLines; i++) { r.append(strings[i] + "\n"); }
                r.append("\t\t...\n");
            }

 			r.append(String.format("\nflags = %d\t\t(0x%0" + (4 * 2) + "x)", this.flags, this.flags));

 			r.append(String.format("\ntype = %d\t\t(0x%0" + (4 * 2) + "x)", this.type, this.type));

 			if (this.attributes == null) { 
				r.append("attributes = {NULL}"); 
			} else {
				r.append(String.format("\nattributes = [Variable length field (v2) of length %d - (0x%x))", this.attributes.length, this.attributes.length));
                r.append("\n");
				r.append(xtrace(this.attributes, 4));
			}

 			if (this.seed == null) { 
				r.append("seed = {NULL}"); 
			} else {
				r.append(String.format("\nseed = [Bulk Data (*)]"));
                r.append("\n");
				r.append(xtrace(this.seed, 4));
			}

            r.append("\nUUID: " + hexAsciiHash(true) + "\n");
            r.append(String.format("\nTotal length of object: %d (0x%x)\n", length(), length()));

            return r.toString();
        } catch (Exception e) {
            e.printStackTrace();
        }
        return "com.utimaco.cs2.mdl.pqmi.MLDSA_KeyGen > exception in data.";
    }

    public String hexAsciiHash(boolean formatted) {
        StringBuilder sb = new StringBuilder("com.utimaco.cs2.mdl.pqmi.MLDSA_KeyGen");
            sb.append(pattern); 
            sb.append(this.flags).append(4);
            sb.append(this.type).append(4);
            if (this.attributes != null) { sb.append(new String(this.attributes)).append(this.attributes.length); }
            if (this.seed != null) { sb.append(new String(this.seed)).append(this.seed.length); }

            return hexAsciiHash(sb.toString(), formatted);
    }   
}