package com.utimaco.cs2.mdl.any;

/* 
 * 03c autogenerated 2024-09-27T15:20:47.733714 using 
 * CS_SdkVpl version 0.0.6
 * Source XML Document version asynchops:xmlv.0.1
 * 
 * Copyright (c) 2024 Utimaco Inc
 *
 */

import com.utimaco.cs2.mdl.I_SdkBuffer;
import java.nio.ByteBuffer;
import java.io.IOException;
import CryptoServerAPI.CryptoServerException;
import CryptoServerCXI.CryptoServerCXI;
import com.utimaco.cs2.mdl.SdkBuffer;
import com.utimaco.cs2.mdl.DeserializationError;
import com.utimaco.cs2.mdl.SerializationError;

// Typed parameters (if any)

/**
 * Pattern: c16u4c1u4c2c1c1u4v1v2c16*
 *
 * Field declarations
 * <pre>
 * name:  (c) octet array of fixed length[string]{}
 *   byte []           name                           = new byte[0];        // Task Name//  c16

 * t_id:  (u4) unsigned int[string]{}
 *   int               t_id                           = (int)0x0;           // Task ID from  u4

 * cmd_state:  (c) octet array of fixed length[string]{}
 *   byte []           cmd_state                      = new byte[0];        // [I] Command byte, or [O] current task state//  c1

 * flags:  (u4) unsigned int[string]{}
 *   int               flags                          = (int)0x0;           //  from  u4

 * mid:  (c) octet array of fixed length[string]{}
 *   byte []           mid                            = new byte[0];        // User defined//  c2

 * sfc:  (c) octet array of fixed length[string]{}
 *   byte []           sfc                            = new byte[0];        // User defined//  c1

 * rfu:  (c) octet array of fixed length[string]{}
 *   byte []           rfu                            = new byte[0];        // //  c1

 * retval:  (u4) unsigned int[string]{}
 *   int               retval                         = (int)0x0;           // Error code generated by spawned task from  u4

 * iv:  (v1) unsigned byte + ...[string]{}
 *   byte []           iv                             = new byte[0];        // iv for payload decryption//  v1
 * aad:  (v2) unsigned short + ...[string]{}
 *   byte []           aad                            = new byte[0];        // Additional Authenticated data for AES-GCM encrypted payload//  v2

 * tag:  (c) octet array of fixed length[string]{}
 *   byte []           tag                            = new byte[0];        // Validation tag for AES-GCM encrypted payload//  c16

 * payload:  (*) additional bytes of unfixed length[string]{}
 *   byte []           payload                        = new byte[0];        // Serialized payload//  *

 * </pre>
 * @author SFCBUFFERS
 *
 */
public class AsynchHSMCmd extends SdkBuffer implements I_SdkBuffer {
    int ModuleID = 0xa6; // Default is 'echo' from ADM  1A0 is Pqmi not signed by Utimaco
    int SFC = 0x18; // Default is 'echo' from ADM  0x18 (dec 24) is the asynch entry point
    protected static final String pattern = "c16u4c1u4c2c1c1u4v1v2c16*"; 

    // Interface specific defined def elements

    // Interface Fields
    protected static final int _CLEN_NAME = 16; // c16
    byte [] name = new byte[_CLEN_NAME];
    int t_id = 0x0;
    protected static final int _CLEN_CMD_STATE = 1; // c1
    byte [] cmd_state = new byte[_CLEN_CMD_STATE];
    int flags = 0x0;
    protected static final int _CLEN_MID = 2; // c2
    byte [] mid = new byte[_CLEN_MID];
    protected static final int _CLEN_SFC = 1; // c1
    byte [] sfc = new byte[_CLEN_SFC];
    protected static final int _CLEN_RFU = 1; // c1
    byte [] rfu = new byte[_CLEN_RFU];
    int retval = 0x0;
    byte [] iv = new byte[0];
    byte [] aad = new byte[0];
    protected static final int _CLEN_TAG = 16; // c16
    byte [] tag = new byte[_CLEN_TAG];
    byte [] payload = new byte[0];

    // Static constructor stubs.
    //
    // AsynchHSMCmd obj = new AsynchHSMCmd ();
    // AsynchHSMCmd obj = new AsynchHSMCmd (cxi); // does not exec
    // AsynchHSMCmd obj = new AsynchHSMCmd (cxi, _in); // does not exec
    // AsynchHSMCmd obj = new AsynchHSMCmd (_resp); // decompose buffer received elsewhere
    // AsynchHSMCmd obj = new AsynchHSMCmd (_resp, boolean); // decompose buffer received elsewhere, which may be longer than expected
    //                                                     // if true, do not accept this and throw SerializationError
    //                                                     // if false, accept this and ignore remaining bytes
    // 

    /** 
     * Instantiate a AsynchHSMCmd object (empty)
     */
    public AsynchHSMCmd () { super(); }

    /**
     * Instantiate a AsynchHSMCmd object, referencing an existing connection 
     * to a CryptoServer
     */
    public AsynchHSMCmd (CryptoServerCXI _cxi) {
      this();
      cxi = _cxi;
    }

    /**
     * Instantiate a AsynchHSMCmd object, referencing an existing connection 
     * to a CryptoServer, and targeting a specific Module/SFC
     */
    public AsynchHSMCmd (CryptoServerCXI _cxi, int mid, int sfc) {
      super(mid, sfc);
      cxi = _cxi;
    }

    /**
     * Instantiate a AsynchHSMCmd object, referencing an existing connection 
     * to a CryptoServer, and supplying the input values via deserializable
     * byte buffer.  
     */
    public AsynchHSMCmd (CryptoServerCXI _cxi, byte [] _in) {
      this(_cxi);
      try { deserialize(_in); }
      catch (DeserializationError e) { e.printStackTrace(); }
    }

    /**
     * Instantiate a AsynchHSMCmd object, without referencing a CryptoServer
     * This method deserializes a byte buffer that was received as the
     * response to an earlier issued command.
     */
    public AsynchHSMCmd (byte [] _resp) {
    	this(_resp, true);
    }
    
    /**
     * Instantiate a AsynchHSMCmd object, without referencing a CryptoServer
     * This method deserializes a byte buffer that was received as the
     * response to an earlier issued command.  If there are remaining bytes
     * in the _resp array at the end of the interface deserialization, 
     * if assumeExactLenBuffer is true, throws SerializationError, else
     * does not throw.
     */
    public AsynchHSMCmd (byte [] _resp, boolean assumeExactLenBuffer) {
      this();
      try { deserialize(_resp, assumeExactLenBuffer); }
      catch (DeserializationError e) { e.printStackTrace(); }
    }

    /**
     * Additional Constructors based on the Interface definition
     */
    // Java "Normal"
    public AsynchHSMCmd ( 
        byte [] _name,
        int _t_id,
        byte [] _cmd_state,
        int _flags,
        byte [] _mid,
        byte [] _sfc,
        byte [] _rfu,
        int _retval,
        byte [] _iv,
        byte [] _aad,
        byte [] _tag,
        byte [] _payload

    ) {
        name(_name); 
        t_id(_t_id); 
        cmd_state(_cmd_state); 
        flags(_flags); 
        mid(_mid); 
        sfc(_sfc); 
        rfu(_rfu); 
        retval(_retval); 
        iv(_iv); 
        aad(_aad); 
        tag(_tag); 
        payload(_payload); 
    }

    // Java Object

    public AsynchHSMCmd(AsynchHSMCmd tobj_ctor) throws DeserializationError, SerializationError {
    	deserialize(tobj_ctor.serialize());
	}

	// Command setters/getters 
    public byte []  name() { return name; } 
    public void     name (byte []  _in) { name = _in; }
    public void     nameFrom (byte []  _in) {
        name = new byte[_in.length];
        System.arraycopy(_in, 0, name, 0, _in.length);
    }
    public void     name (String _in) {
        name = _in.getBytes();
    }
    public int      t_id() { return t_id; } 
    public void     t_id (int      _in) { t_id = _in; }
    public byte []  cmd_state() { return cmd_state; } 
    public void     cmd_state (byte []  _in) { cmd_state = _in; }
    public void     cmd_stateFrom (byte []  _in) {
        cmd_state = new byte[_in.length];
        System.arraycopy(_in, 0, cmd_state, 0, _in.length);
    }
    public void     cmd_state (String _in) {
        cmd_state = _in.getBytes();
    }
    public int      flags() { return flags; } 
    public void     flags (int      _in) { flags = _in; }
    public byte []  mid() { return mid; } 
    public void     mid (byte []  _in) { mid = _in; }
    public void     midFrom (byte []  _in) {
        mid = new byte[_in.length];
        System.arraycopy(_in, 0, mid, 0, _in.length);
    }
    public void     mid (String _in) {
        mid = _in.getBytes();
    }
    public byte []  sfc() { return sfc; } 
    public void     sfc (byte []  _in) { sfc = _in; }
    public void     sfcFrom (byte []  _in) {
        sfc = new byte[_in.length];
        System.arraycopy(_in, 0, sfc, 0, _in.length);
    }
    public void     sfc (String _in) {
        sfc = _in.getBytes();
    }
    public byte []  rfu() { return rfu; } 
    public void     rfu (byte []  _in) { rfu = _in; }
    public void     rfuFrom (byte []  _in) {
        rfu = new byte[_in.length];
        System.arraycopy(_in, 0, rfu, 0, _in.length);
    }
    public void     rfu (String _in) {
        rfu = _in.getBytes();
    }
    public int      retval() { return retval; } 
    public void     retval (int      _in) { retval = _in; }
    public byte []  iv() { return iv; } 
    public void     iv (byte []  _in) { iv = _in; }
    public void     ivFrom (byte []  _in) {
        iv = new byte[_in.length];
        System.arraycopy(_in, 0, iv, 0, _in.length);
    }
    public void     iv (String _in) {
        iv = _in.getBytes();
    }
    public byte []  aad() { return aad; } 
    public void     aad (byte []  _in) { aad = _in; }
    public void     aadFrom (byte []  _in) {
        aad = new byte[_in.length];
        System.arraycopy(_in, 0, aad, 0, _in.length);
    }
    public void     aad (String _in) {
        aad = _in.getBytes();
    }
    public byte []  tag() { return tag; } 
    public void     tag (byte []  _in) { tag = _in; }
    public void     tagFrom (byte []  _in) {
        tag = new byte[_in.length];
        System.arraycopy(_in, 0, tag, 0, _in.length);
    }
    public void     tag (String _in) {
        tag = _in.getBytes();
    }
    public byte []  payload() { return payload; } 
    public void     payload (byte []  _in) { payload = _in; }
    public void     payloadFrom (byte []  _in) {
        payload = new byte[_in.length];
        System.arraycopy(_in, 0, payload, 0, _in.length);
    }
    public void     payload (String _in) {
        payload = _in.getBytes();
    }

    // Exec
    /**
     * Executes the command to the param-supplied CryptoServer, using
     * using the supplied ModuleID and Sub-function code.
     * <p>
     * This command may result in SerializationError or DeserializationError
     * events, but these are swallowed and returned as 'false'.
     * <p>
     * Note: The subfunction code only supports SFCs in the range 0..255.
     * <p>
     * @param CryptoServerCXI 
     * @param module ID 
     * @param subfunction code to call
     * @return boolean - ok (0x0) otherwise invalid input/ser+deser errors
     * @throws IOException (CryptoServer not available)
     * @throws CryptoServerException (non-zero response from the CryptoServer
     */
    public boolean exec (CryptoServerCXI cxi, int mid, int sfc) throws IOException, CryptoServerException {
        if (cxi == null) {
            System.out.println("No CXI\n");
            return false;
        }
        if ((sfc < 0) || (sfc > 255)) { return false; }

        return exec(cxi, mid, sfc, this, null); // this variant has no return value awareness, just stored
    }

    /**
     * Executes the command to the param-supplied CryptoServer, using
     * using the supplied ModuleID and Sub-function code.
     * <p>
     * This command may result in SerializationError or DeserializationError
     * events, but these are swallowed and returned as 'false'.
     * <p>
     * Note: The subfunction code only supports SFCs in the range 0..255.
     * <p>
     * If an I_SdkBuffer object is supplied as a recipient, and the response from 
     * the CryptoServer is OK, the result buffer will be handed to it and an attempt
     * to deserialize the result will happen.  
     * <p>
     * @param CryptoServerCXI 
     * @param module ID 
     * @param subfunction code to call
     * @param I_SdkBuffer to receive/parse the result into if OK is returned
     * @return boolean - ok (0x0) otherwise invalid input/ser+deser errors
     * @throws IOException (CryptoServer not available)
     * @throws CryptoServerException (non-zero response from the CryptoServer
     * @throws DeserializationError if the result can not be deserialized by this recipient
     */
    public boolean exec (CryptoServerCXI cxi, int mid, int sfc, I_SdkBuffer recvr) throws IOException, CryptoServerException {
        if (cxi == null) {
            System.out.println("No CXI\n");
            return false;
        }
        if ((sfc < 0) || (sfc > 255)) { return false; }

        return exec(cxi, mid, sfc, this, recvr); // this variant tries to deserialize the response into another I_SdkBuffer
    }

    /**
     * Executes the command to the provided CryptoServer, using the
     * compiled in ModuleID and Sub-function code
     * <p>
     * This command may result in SerializationError or DeserializationError
     * events, but these are swallowed and returned as 'false'.
     * <p>
     * @param cxi - CryptoServerCXI for target HSM
     * @return boolean - ok (0x0) otherwise fail
     * @throws IOException (CryptoServer not available)
     * @throws CryptoServerException (non-zero response from the CryptoServer
     */
    public boolean exec (CryptoServerCXI _cxi) throws IOException, CryptoServerException {
        return exec(_cxi, ModuleID, SFC);
    }

    /**
     * Executes the command to the CryptoServer supplied on object
     * instantiation, using the compiled in ModuleID and Sub-function code
     * <p>
     * If this object was instantiated without a cxi object, returns
     * false.
     * <p>
     * This command may result in SerializationError or DeserializationError
     * events, but these are swallowed and returned as 'false'.
     * <p>
     * @return boolean - ok (0x0) otherwise fail
     * @throws IOException (CryptoServer not available)
     * @throws CryptoServerException (non-zero response from the CryptoServer
     */
    public boolean exec () throws IOException, CryptoServerException {
        return exec(cxi, ModuleID, SFC);
    }

    public byte [] serialize () throws SerializationError {
        int len = length();
        if (len == 0) { return new byte[0]; }
        try {
            ByteBuffer bb = ByteBuffer.allocate(len);
 			// this.name of kind c16
			if (this.name.length < 16) {
            	byte [] t = new byte[16];
            	int tl = 16;
            	if (this.name.length < tl) { tl = this.name.length; }
            	System.arraycopy(this.name, 0, t, 0, tl);
            	bb.put(t);
           	} else if (this.name.length == 16) {
           	    bb.put(this.name);
            } else {
           		throw new SerializationError("Field width: this.name.length > 16");
            }

 			// this.t_id of kind u4
            bb.putInt(this.t_id);
 			// this.cmd_state of kind c1
			if (this.cmd_state.length < 1) {
            	byte [] t = new byte[1];
            	int tl = 1;
            	if (this.cmd_state.length < tl) { tl = this.cmd_state.length; }
            	System.arraycopy(this.cmd_state, 0, t, 0, tl);
            	bb.put(t);
           	} else if (this.cmd_state.length == 1) {
           	    bb.put(this.cmd_state);
            } else {
           		throw new SerializationError("Field width: this.cmd_state.length > 1");
            }

 			// this.flags of kind u4
            bb.putInt(this.flags);
 			// this.mid of kind c2
			if (this.mid.length < 2) {
            	byte [] t = new byte[2];
            	int tl = 2;
            	if (this.mid.length < tl) { tl = this.mid.length; }
            	System.arraycopy(this.mid, 0, t, 0, tl);
            	bb.put(t);
           	} else if (this.mid.length == 2) {
           	    bb.put(this.mid);
            } else {
           		throw new SerializationError("Field width: this.mid.length > 2");
            }

 			// this.sfc of kind c1
			if (this.sfc.length < 1) {
            	byte [] t = new byte[1];
            	int tl = 1;
            	if (this.sfc.length < tl) { tl = this.sfc.length; }
            	System.arraycopy(this.sfc, 0, t, 0, tl);
            	bb.put(t);
           	} else if (this.sfc.length == 1) {
           	    bb.put(this.sfc);
            } else {
           		throw new SerializationError("Field width: this.sfc.length > 1");
            }

 			// this.rfu of kind c1
			if (this.rfu.length < 1) {
            	byte [] t = new byte[1];
            	int tl = 1;
            	if (this.rfu.length < tl) { tl = this.rfu.length; }
            	System.arraycopy(this.rfu, 0, t, 0, tl);
            	bb.put(t);
           	} else if (this.rfu.length == 1) {
           	    bb.put(this.rfu);
            } else {
           		throw new SerializationError("Field width: this.rfu.length > 1");
            }

 			// this.retval of kind u4
            bb.putInt(this.retval);
 			// this.iv of kind v1
            if (this.iv == null) {
                this.iv = new byte[0];
            }
            bb.put((byte)(this.iv.length & 0xFF)); 
           	bb.put(this.iv);

 			// this.aad of kind v2
            if (this.aad == null) {
                this.aad = new byte[0];
            }
        bb.putShort((short)(this.aad.length & 0xFFFF));
           	bb.put(this.aad);

 			// this.tag of kind c16
			if (this.tag.length < 16) {
            	byte [] t = new byte[16];
            	int tl = 16;
            	if (this.tag.length < tl) { tl = this.tag.length; }
            	System.arraycopy(this.tag, 0, t, 0, tl);
            	bb.put(t);
           	} else if (this.tag.length == 16) {
           	    bb.put(this.tag);
            } else {
           		throw new SerializationError("Field width: this.tag.length > 16");
            }

 			// this.payload of kind *
            if (this.payload == null) {
                this.payload = new byte[0];
            }
           	bb.put(this.payload);

 
            return bb.array();
        } catch (Exception e) {
            throw new SerializationError();
        }
    }

	public void deserialize (byte [] bfr) throws DeserializationError {
		deserialize(bfr, true);
	}
	
    public void deserialize (byte [] bfr, boolean assumeExactLenBuffer) throws DeserializationError {
        if (bfr.length == 0) { return; }
        ByteBuffer bb = ByteBuffer.wrap(bfr);
        int len = 0;
        try {
 			// this.name of kind c16
			if (this.name == null) { this.name = new byte[16]; }
			bb.get(this.name, 0, this.name.length);
  			// this.t_id of kind u4
			this.t_id = bb.getInt();
  			// this.cmd_state of kind c1
			if (this.cmd_state == null) { this.cmd_state = new byte[1]; }
			bb.get(this.cmd_state, 0, this.cmd_state.length);
  			// this.flags of kind u4
			this.flags = bb.getInt();
  			// this.mid of kind c2
			if (this.mid == null) { this.mid = new byte[2]; }
			bb.get(this.mid, 0, this.mid.length);
  			// this.sfc of kind c1
			if (this.sfc == null) { this.sfc = new byte[1]; }
			bb.get(this.sfc, 0, this.sfc.length);
  			// this.rfu of kind c1
			if (this.rfu == null) { this.rfu = new byte[1]; }
			bb.get(this.rfu, 0, this.rfu.length);
  			// this.retval of kind u4
			this.retval = bb.getInt();
  			// this.iv of kind v1
			len = bb.get();
			this.iv = new byte[len];
			bb.get(this.iv, 0, len);
  			// this.aad of kind v2
			len = bb.getShort();
			this.aad = new byte[len];
			bb.get(this.aad, 0, len);
  			// this.tag of kind c16
			if (this.tag == null) { this.tag = new byte[16]; }
			bb.get(this.tag, 0, this.tag.length);
  			// this.payload of kind *
			len = bb.remaining();
			this.payload = new byte[len];
			bb.get(this.payload, 0, this.payload.length);
  			return;
        } catch (Exception e) {
            throw new DeserializationError();
        } finally {
            if (bb.hasRemaining()) {
            	if (assumeExactLenBuffer) {
	            	throw new DeserializationError();
	            }
            }
        }
     }
        
    public int length () {
        int len = 0;
    
         len += 16; // this.name of kind c16

 		len += 4; // this.t_id of kind u4

         len += 1; // this.cmd_state of kind c1

 		len += 4; // this.flags of kind u4

         len += 2; // this.mid of kind c2

         len += 1; // this.sfc of kind c1

         len += 1; // this.rfu of kind c1

 		len += 4; // this.retval of kind u4

 		len += 1; // this.iv of kind v1
		len += this.iv.length;

 		len += 2; // this.aad of kind v2
		len += this.aad.length;

         len += 16; // this.tag of kind c16

 		len += this.payload.length; // this.payload of kind *

        return len;
    }

	// possible return values, based on module SFC responses for SFC using this as an interface
	public boolean responseAs(I_SdkBuffer buffer) {
	    if (resp == null) { return false; }
	    try {
		    buffer.deserialize(resp);
		    return true;
		} catch (DeserializationError doops) {
		}
		return false;
    }

	public AsynchHSMCmd responseAsAsynchHSMCmd() {
		if (resp == null) { return null; }
		return new AsynchHSMCmd(resp);
	} 

    public String toString() {
        // The 8 means only display the first 8 lines 
        // of the entirely serialized data
        return toString("com.utimaco.cs2.mdl.any.AsynchHSMCmd >", 8);
    }

    public String toString(String note, int maxInitialLines) {
        maxInitialLines++;
        if (this.length() == 0) { return note; }
        try {
            StringBuilder r = new StringBuilder(String.format("Serialized using: '%s'\n", pattern));
            r.append(xtrace(note, this.serialize()));
            String [] strings = r.toString().split("\\n");
            if (strings.length > maxInitialLines) {
                r.setLength(0);
                for (int i = 0; i < maxInitialLines; i++) { r.append(strings[i] + "\n"); }
                r.append("\t\t...\n");
            }

 			if (this.name == null) { 
				r.append("name = {NULL}"); 
			} else {
				r.append("\nname = [Fixed length field (c16)]");
                r.append("\n");
				r.append(xtrace(this.name, 4));
			}

 			r.append(String.format("\nt_id = %d\t\t(0x%0" + (4 * 2) + "x)", this.t_id, this.t_id));

 			if (this.cmd_state == null) { 
				r.append("cmd_state = {NULL}"); 
			} else {
				r.append("\ncmd_state = [Fixed length field (c1)]");
                r.append("\n");
				r.append(xtrace(this.cmd_state, 4));
			}

 			r.append(String.format("\nflags = %d\t\t(0x%0" + (4 * 2) + "x)", this.flags, this.flags));

 			if (this.mid == null) { 
				r.append("mid = {NULL}"); 
			} else {
				r.append("\nmid = [Fixed length field (c2)]");
                r.append("\n");
				r.append(xtrace(this.mid, 4));
			}

 			if (this.sfc == null) { 
				r.append("sfc = {NULL}"); 
			} else {
				r.append("\nsfc = [Fixed length field (c1)]");
                r.append("\n");
				r.append(xtrace(this.sfc, 4));
			}

 			if (this.rfu == null) { 
				r.append("rfu = {NULL}"); 
			} else {
				r.append("\nrfu = [Fixed length field (c1)]");
                r.append("\n");
				r.append(xtrace(this.rfu, 4));
			}

 			r.append(String.format("\nretval = %d\t\t(0x%0" + (4 * 2) + "x)", this.retval, this.retval));

 			if (this.iv == null) { 
				r.append("iv = {NULL}"); 
			} else {
				r.append(String.format("\niv = [Variable length field (v1) of length %d - (0x%x))", this.iv.length, this.iv.length));
                r.append("\n");
				r.append(xtrace(this.iv, 4));
			}

 			if (this.aad == null) { 
				r.append("aad = {NULL}"); 
			} else {
				r.append(String.format("\naad = [Variable length field (v2) of length %d - (0x%x))", this.aad.length, this.aad.length));
                r.append("\n");
				r.append(xtrace(this.aad, 4));
			}

 			if (this.tag == null) { 
				r.append("tag = {NULL}"); 
			} else {
				r.append("\ntag = [Fixed length field (c16)]");
                r.append("\n");
				r.append(xtrace(this.tag, 4));
			}

 			if (this.payload == null) { 
				r.append("payload = {NULL}"); 
			} else {
				r.append(String.format("\npayload = [Bulk Data (*)]"));
                r.append("\n");
				r.append(xtrace(this.payload, 4));
			}

            r.append("\nUUID: " + hexAsciiHash(true) + "\n");
            r.append(String.format("\nTotal length of object: %d (0x%x)\n", length(), length()));

            return r.toString();
        } catch (Exception e) {
            e.printStackTrace();
        }
        return "com.utimaco.cs2.mdl.any.AsynchHSMCmd > exception in data.";
    }

    public String hexAsciiHash(boolean formatted) {
        StringBuilder sb = new StringBuilder("com.utimaco.cs2.mdl.any.AsynchHSMCmd");
            sb.append(pattern); 
            if (this.name != null) { sb.append(new String(this.name)).append(this.name.length); }
            sb.append(this.t_id).append(4);
            if (this.cmd_state != null) { sb.append(new String(this.cmd_state)).append(this.cmd_state.length); }
            sb.append(this.flags).append(4);
            if (this.mid != null) { sb.append(new String(this.mid)).append(this.mid.length); }
            if (this.sfc != null) { sb.append(new String(this.sfc)).append(this.sfc.length); }
            if (this.rfu != null) { sb.append(new String(this.rfu)).append(this.rfu.length); }
            sb.append(this.retval).append(4);
            if (this.iv != null) { sb.append(new String(this.iv)).append(this.iv.length); }
            if (this.aad != null) { sb.append(new String(this.aad)).append(this.aad.length); }
            if (this.tag != null) { sb.append(new String(this.tag)).append(this.tag.length); }
            if (this.payload != null) { sb.append(new String(this.payload)).append(this.payload.length); }

            return hexAsciiHash(sb.toString(), formatted);
    }   
}