package com.utimaco.cs2.mdl;

import java.io.IOException;
import CryptoServerAPI.CryptoServerCluster;
import java.nio.ByteBuffer;


/* Copyright 2018-2024 Utimaco Inc */
/* For use with the SFCBuffers auto-generation tooling. */
/* SFCBuffer Version 0.0.5 */

import CryptoServerAPI.CryptoServerException;
import CryptoServerCXI.CryptoServerCXI;

public abstract class SdkBuffer extends CmdsPattern {
    public byte [] cmd = null;
    public byte [] resp = null;

    protected CryptoServerCXI cxi = null;
    public static int ModuleID = -1;
    public static int SFC      = -1;

    public abstract boolean exec () throws IOException, CryptoServerException;
    public abstract boolean exec (CryptoServerCXI cxi) throws IOException, CryptoServerException;
    public abstract boolean exec (CryptoServerCXI cxi, int mid, int sfc) throws IOException, CryptoServerException;

    protected SdkBuffer () {}

    protected SdkBuffer (int mid, int sfc) {
        ModuleID = mid;
        SFC = sfc;
    }

    protected boolean exec (int mid, int sfc, I_SdkBuffer command)
            throws IOException, CryptoServerException {
        return exec(cxi, mid, sfc, command, null);
    }

    protected boolean exec (int mid, int sfc, I_SdkBuffer command, I_SdkBuffer response)
            throws IOException, CryptoServerException {
        return exec(cxi, mid, sfc, command, response);
    }

    public boolean exec (CryptoServerCXI cxi, int mid, int sfc, I_SdkBuffer command, I_SdkBuffer response)
            throws IOException, CryptoServerException {
        if (cxi == null) {
            System.out.println("No CXI\n");
            return false;
        }
        if ((sfc < 0) || (sfc > 255)) { return false; }
        try {
            cmd = command.serialize();
            resp = cxi.exec(mid, sfc, cmd); // throws
            if (response != null) {
                response.deserialize(resp);
            }
        } catch (SerializationError ex) {
            System.out.println("Unable to serialize command.");
            return false;
        } catch (DeserializationError ex) {
            System.out.println("Unable to deserialize response.");
            return false;
        }
        return true;
    }
    
    public boolean exec (CryptoServerCluster cxi, int mid, int sfc, I_SdkBuffer command, I_SdkBuffer response)
            throws IOException, CryptoServerException {
        if (cxi == null) {
            System.out.println("No CXI\n");
            return false;
        }
        if ((sfc < 0) || (sfc > 255)) { return false; }
        try {
            cmd = command.serialize();
            resp = cxi.exec(mid, sfc, cmd); // throws
            if (response != null) {
                response.deserialize(resp);
            }
        } catch (SerializationError ex) {
            System.out.println("Unable to serialize command.");
            return false;
        } catch (DeserializationError ex) {
            System.out.println("Unable to deserialize response.");
            return false;
        }
        return true;
    }
    
    // untested
    public static ByteBuffer bbseek(byte[] bbuf, byte[] tag, int i) {
    	int loc = 0;
    	for (int p = i; p < bbuf.length - tag.length - 1; p++) {
    		boolean tagged = true;
    		loc = p;
    		for (int t = 0; t < tag.length; t++) {
    			if (bbuf[p+t] != tag[t]) {
    				tagged = false;
    				break;
    			}
    		}
    		if (tagged) {
    			ByteBuffer wr = ByteBuffer.wrap(bbuf);
    			wr.position(loc);
    			return wr;
    		}
    	}
    	return null;
    }
 }
