package com.utimaco.aut;

import java.io.IOException;

import com.utimaco.SimpleArgs;
import com.utimaco.bench.KeyOpts_XMSS;
import com.utimaco.cs2.mdl.SerializationError;
import com.utimaco.cs2.mdl.any.CxiKeyAttributes;
import com.utimaco.cs2.mdl.pqmi.HbsGen;
import com.utimaco.cs2.mdl.pqmi.HbsPubkeyGet;
import com.utimaco.cs2.mdl.pqmi.HbsSign;
import com.utimaco.cs2.mdl.pqmi.HbsVerify;
import com.utimaco.cs2.mdl.pqmi.Pqmi;

import CryptoServerAPI.CryptoServerException;
import CryptoServerCXI.CryptoServerCXI;

public class XmssTest implements AutTest {
	static int module_id = 0xa6; // ;

	static final int sfc_id_gen_xmss = Pqmi.SFC_HBS_KEYGEN;
	static final int sfc_id_getpub_xmss = Pqmi.SFC_HBS_GET_PUBKEY;
	static final int sfc_id_sign_xmss = Pqmi.SFC_HBS_SIGN;
	static final int sfc_id_verf_xmss = Pqmi.SFC_HBS_VERIFY;

	static final int sfc_id_keystore = Pqmi.SFC_KEYSTORE;

	CryptoServerCXI cxi;
	SimpleArgs args;
	boolean ctors;
	int rnd_touse;
	int sto_touse;
	boolean asynch;
	boolean genkeyonly;

	public XmssTest(CryptoServerCXI cxi, SimpleArgs cla) {
		this(cxi, cla, false);
	}
	public XmssTest(CryptoServerCXI cxi, SimpleArgs cla, boolean asynch) {
		this(cxi,cla,asynch,false);
	}
	public XmssTest(CryptoServerCXI cxi, SimpleArgs cla, boolean asynch, boolean genkey) {
		this.cxi = cxi;
		this.args = cla;
		this.ctors = false;
		this.rnd_touse = cla.hasArg("drbg:trng") ? Pqmi.MODE_REAL_RND : Pqmi.MODE_PSEUDO_RND;
		this.sto_touse = Pqmi.KEY_OVERWRITE; //? Pqmi.KEY_EXTERNAL not for HBS keys;
		this.asynch = asynch;
		this.genkeyonly = genkey;

		module_id = AutTest.getModuleId(cxi, "PQMI");

	}

	public boolean go() {
		return gensignverify();
	}
	private boolean gensignverify () {
		boolean res = false;

		// This is the "HSM-aware POJO" used to generate a key.
		HbsGen tobj_ctor = new HbsGen();

		// There are two constructors below, one uses the POJO's full constructor (true) or just calls setters on the empty
		// object above.
		boolean use_ctor = ctors;

		// One of the fields of the generator object is a "packed" CXI Key Attributes template.
		// This is the template, it must be serialized for use, however the parent generator obj 
		// setter can take the object, and will call the object's serializer to get the serialized
		// buffer.  NOTE: This happens on the call, subsequent changes to the attributes template
		// have NO affect on anything that serialized it previously.
		CxiKeyAttributes attributes = new CxiKeyAttributes(); // Field primitive is typed Interface

		// CxiKeyAttributes - typed field attributes
		int flags = 0x0;
		// CXI stores its keys, indexed by the MD5 of the key {NAME||GROUP||SPEC} (|| here means 
		// 'concatenated with', so NAME concatenated with GROUP etc).
		byte [] name = "xmss".getBytes();
		byte [] group = "testseries".getBytes();
		int spec = 0;

		int algo = CryptoServerCXI.KEY_ALGO_RAW;
		int usage = CryptoServerCXI.KEY_USAGE_SIGN | CryptoServerCXI.KEY_USAGE_VERIFY;
		int export = 0; // ALLOW_BACKUP only, no export wrapped

		if (use_ctor) {
			attributes = new CxiKeyAttributes (
					flags,
					name,
					group,
					spec,
					algo,
					usage,
					export, 
					new byte[0]
					);
		} else {
			attributes = new CxiKeyAttributes (cxi);
			attributes.flags (flags);
			attributes.name (name);
			attributes.group (group);
			attributes.spec (spec);
			attributes.algo (algo);
			attributes.usage (usage);
			attributes.export (export);
		}

		System.out.println("XMSS:  Generate Key");

		tobj_ctor.flags(rnd_touse | sto_touse);
		tobj_ctor.type(Pqmi.HBS_XMSS_KT_FLAG);

		Byte levelp = KeyOpts_XMSS.getMTParamFromArgs(args);
		if (levelp == null) {
			System.out.println("No oid found in params.");
			return false;
		}
		tobj_ctor.levels(levelp);

		byte [] params = new byte[1]; 
		params[0] = KeyOpts_XMSS.getOIDParamFromArgs(args);
		tobj_ctor.levelparams(params);

		tobj_ctor.auxdatasz(10000);

		try {
			tobj_ctor.attributes(attributes);

			res = tobj_ctor.exec(cxi, module_id, sfc_id_gen_xmss);
			System.out.println("Key Generated\n");
		} catch (SerializationError e) {
			e.printStackTrace();
			return false;
		} catch (IOException e) {
			e.printStackTrace();
			return false;
		} catch (CryptoServerException e) {
			e.printStackTrace();
			return false;
		}
		
		if (genkeyonly) {
			return true;
		}

		System.out.println("XMSS:  Get Public Key");

		HbsPubkeyGet getter = new HbsPubkeyGet();
		byte [] pubkey = null;
		try {
			getter.basekey(attributes);
			res = getter.exec(cxi, module_id, sfc_id_getpub_xmss);
			pubkey = getter.getResponse();
			System.out.println("Key Retrieved\n");
		} catch (SerializationError e) {
			e.printStackTrace();
			return false;
		} catch (IOException e) {
			e.printStackTrace();
			return false;
		} catch (CryptoServerException e) {
			e.printStackTrace();
			return false;
		}

		String msgOne = "This is my message to be signed.";
		String msgTwo = "Some other message to be signed.";
		byte [] sigOne = null;
		byte [] sigTwo = null;

		System.out.println("\nXMSS Sign - 1");
		HbsSign signer = new HbsSign();
		try {
			signer.basekey(attributes);
			System.out.format("Using '%s'\n", msgOne);
			signer.msg(msgOne); // also has a msg(byte[]) method

			// short message test, flags has hint to key type
			signer.flags(Pqmi.HBS_XMSS_KT_FLAG | Pqmi.FLAG_INIT | Pqmi.FLAG_FINALIZE);
			res = signer.exec(cxi, module_id, sfc_id_sign_xmss);

			sigOne = signer.getResponse(); // getResponse added by hand after interfaces were generated

		} catch (SerializationError e) {
			e.printStackTrace();
			return false;
		} catch (IOException e) {
			e.printStackTrace();
			return false;
		} catch (CryptoServerException e) {
			e.printStackTrace();
			return false;
		}
		System.out.println("\nXMSS Sign - 2");
		try {
			System.out.format("Using '%s'\n", msgTwo);
			signer.msg(msgTwo); // also has a msg(byte[]) method

			// short message test, flags has hint to key type
			signer.flags(Pqmi.HBS_XMSS_KT_FLAG | Pqmi.FLAG_INIT | Pqmi.FLAG_FINALIZE);
			res = signer.exec(cxi, module_id, sfc_id_sign_xmss);

			sigTwo = signer.getResponse(); // getResponse added by hand after interfaces were generated

		} catch (IOException e) {
			e.printStackTrace();
			return false;
		} catch (CryptoServerException e) {
			e.printStackTrace();
			return false;
		}

		System.out.println("XMSS Verify - 1 - Correct Case");
		HbsVerify verifier = new HbsVerify();
		try {
			verifier.flags(Pqmi.HBS_XMSS_KT_FLAG | Pqmi.FLAG_INIT | Pqmi.FLAG_FINALIZE);
			verifier.pubkey(pubkey);
			System.out.format("Using '%s'\n", msgOne);
			verifier.msg(msgOne);
			verifier.sig(sigOne);

			res = verifier.exec(cxi, module_id, sfc_id_verf_xmss);

			System.out.println("Verification succeeded.\n");
		} catch (IOException e) {
			e.printStackTrace();
			return false;
		} catch (CryptoServerException e) {
			e.printStackTrace();
			return false;
		}

		System.out.println("XMSS Verify - 2 - Correct Case");
		try {
			System.out.format("Using '%s'\n", msgTwo);
			verifier.msg(msgTwo);
			verifier.sig(sigTwo);

			res = verifier.exec(cxi, module_id, sfc_id_verf_xmss);

			System.out.println("Verification succeeded.\n");
		} catch (IOException e) {
			e.printStackTrace();
			return false;
		} catch (CryptoServerException e) {
			e.printStackTrace();
			return false;
		}

		System.out.println("XMSS Verify negative case - 1 - bad message or signature (should fail)");
		try {
			verifier.flags(Pqmi.HBS_XMSS_KT_FLAG | Pqmi.FLAG_INIT | Pqmi.FLAG_FINALIZE);
			verifier.pubkey(pubkey);
			System.out.format("Using msgOne ('%s') with sigTwo\n", msgOne);
			verifier.msg(msgOne);
			verifier.sig(sigTwo);

			res = verifier.exec(cxi, module_id, sfc_id_verf_xmss);

			System.out.println("Verification succeeded -- SHOULD NOT HAVE!!!\n");
		} catch (IOException e) {
			e.printStackTrace();
			return false;
		} catch (CryptoServerException e) {
			if (e.ErrorCode != 0xB0680033) {
				e.printStackTrace();
				return false;
			}
			System.out.println("CryptoServer Exception 0xB068033 (Failed to verify).  Invalid input (msg) test correctly fails.\n");
		}

		System.out.println("XMSS Verify negative case - 2 - bad signature (should fail)");
		try {
			System.out.format("Using msgTwo ('%s') with sigOne\n", msgTwo);
			verifier.msg(msgTwo);
			verifier.sig(sigOne);

			res = verifier.exec(cxi, module_id, sfc_id_verf_xmss);

			System.out.println("Verification succeeded -- SHOULD NOT HAVE!!!\n");
		} catch (IOException e) {
			e.printStackTrace();
			return false;
		} catch (CryptoServerException e) {
			if (e.ErrorCode != 0xB0680033) {
				e.printStackTrace();
				return false;
			}
			System.out.println("CryptoServer Exception 0xB068033 (Failed to verify).  Invalid input (msg) test correctly fails.\n");
		}


		System.out.println("Test over\n");
		return res;
	}

}
