package com.utimaco;

/* 
 * 03c autogenerated 2024-09-25T19:40:10.6610769 using 
 * CS_SdkVpl version 0.0.6
 * Template version 0002
 * Source XML Document version asynchops:xmlv.0.1
 * 
 * Copyright (c) 2024 Utimaco Inc
 *
 */

import java.io.File;
// import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HexFormat;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import CryptoServerAPI.CryptoServerException;
import CryptoServerAPI.CryptoServerUtil;
import CryptoServerCXI.CryptoServerCXI;
import com.utimaco.cs2.mdl.*;
import com.utimaco.cs2.mdl.any.AnyErrorList;

// Typed parameters (if any)

import com.utimaco.cs2.mdl.any.AsynchHSMCmd;
import com.utimaco.cs2.mdl.asy.Asy;
import com.utimaco.cs2.mdl.asy.AsyErrorList;
import com.utimaco.cs2.mdl.asy.AsyEx;
import com.utimaco.cs2.mdl.pqmi.HbsGen;
import com.utimaco.cs2.mdl.pqmi.Pqmi;
import com.utimaco.cs2.mdl.pqmi.PqmiErrorList;
import com.utimaco.bench.KeyOpts_XMSS;
import com.utimaco.cs2.mdl.any.CxiKeyAttributes;


public class AsynchHBS {
	static final Random r = new Random();
	static String [] names = "A:B:C:D:E:F:G:H:I:J:K:L:M:N:O:P:Q:R:S:T:U:V:W:X:Y:Z".split(":");
	static final int MAX_SEQ = names.length;

	static boolean dbg = false;

	static AsynchHBS _singleton = new AsynchHBS();
	static boolean test = false;
	
	ByteBuffer retrieveResult = null;

	/***********************************************************************
	 * TEST SPECIFIC
	 **/
	public static void printUsageAndExit() {
		String cn = _singleton.getClass().getName();
		System.out.format(""
				+ "java -cp \"...\" %s -h\n"
				+ "  prints usage and exits.\n"
				+ "java -cp \"...\" %s args\n"
				+ "java -jar <jarfile> %s args\n"
				+ "  User defined.\n"
				+ "Possible args:\n"
				+ "  -dev <device> will override $CRYPTOSERVER env var\n"
				// + "  -file filename\n"
				+ "  -s user,keyspec,pin (repeatable, see JavaCXI logonSign(...))\n"
				+ "  -p user,password (repeatable, see JavaCXI logonPassword(...))\n"
				+ "Optional Args:\n"
				+ "  -v enables (marginally more) verbose output\n"
				// + "  -out <filename> will write output to named file\
				+ "Args specific to this test:\n"
				+ "-asynch_flags (int)\n" 
				+ "-mid (byte [])\n" 
				+ "-sfc (byte [])\n" 
				+ "-rfu (byte [])\n" 
				+ "\n"
				+ "\n  -tname <name>"
				+ "\n  -mid <0x...> - max three nibbles (default 0xA2 - HBS)"
				+ "\n  -sfc <0x..>  - max two nibbles (default 0xB - HBS key gen"
				+ "\n  -rfu <0x..>  - max two nibbles (default 0x0)"
				+ "\n"
				+ "\n  -lms <args>  - generate an lms key"
				+ "\n  -hss <args>  - generate an hss key"
				+ "\n  -xmss \"Scheme\"  - generate an xmss key"
				+ "\n  -poll        - check for state of running asynch tasks"
				+ "\n  -get         - for 'P' tasks (completed, ok) retrieves the result of the task"
				+ "\n"
				+ "\n  -kgs <name>:<group>:<spec>  : formal key identification"
				+ "\n  -kg  <name>:<group>         : formal key identifier, no specifier"
				+ "In general, a byte[] will expect hex ascii.\n"
				+ "", cn,cn,cn);
		System.out.println("");
		printLMSArguments(null);
		printXMSSArguments(null);

		System.exit(0);
	}

	static String concat(String [] args) {
		return concat("", args);
	}
	static String concat(String tag, String [] args) {
		StringBuilder sb = new StringBuilder();
		sb.append(tag).append(": ");
		for (String a : args) {
			sb.append(" ").append(a);
		}
		return sb.toString();
	}

	static int toInt(byte[] in) {
		int r = 0;
		int shift = (in.length - 1) * 8;
		for (int i = 0; i < in.length; i++) {
			r += (in[i] << shift);
			shift >>= 8;
		}
		return r;
	}

	static void printLMSArguments(String [] args) {
		if (args != null) {
			System.out.println(concat(args));
		}
		System.out.println("\nHSS/LMS:"
				+ "\n  -lms | -hss <arguments>"
				+ "\n  -levels <n>      - 1..8 (default 1)"
				+ "\n  -levelparms ...  - {H || Height || W || OTS } per level"
				+ "\n  -auxdatasz <n>   - 1..16384 (default 16384)"
				+ "\n"
				+ "\n  Constructing level params:"
				+ "\n     : ... -hss <string> -ots <string>"
				+ "\n     : The string for HSS is made up of heights in the set "
				+ "\n     :   H5 H10 H15 H20 H25"
				+ "\n     : The string for OTS is made up of Winternitz numbers in the set"
				+ "\n     :   W1 W2 W4 W8"
				+ "\n     : The number of options in -hss must match the number in -ots."
				+ "\n     : Example:"
				+ "\n     :    -hss H5,H5 -ots W4,W2"
				+ "\n     : For N24 variants of -ots, use the additional flag -N24:"
				+ "\n     :    -hss H5,H15 -ots W8,W2 -N24"
				+ "\n  "
				+"\n");
	}

	static byte [] paramsToByteHSS(SimpleArgs cla) {
		boolean arghelp = false;
		if (!cla.hasArg("-hss")) arghelp=true;
		if (!cla.hasArg("-ots")) arghelp=true;

		String [] hss = cla.getArg("-hss", "").split(":");
		String [] ots = cla.getArg("-ots", "").split(":");
		boolean truncated = cla.hasArg("-N24");

		if (hss.length != ots.length) arghelp=true;
		if (hss.length == 0) arghelp=true;
		if (hss.length > 8) arghelp=true;

		ByteBuffer levelparams = ByteBuffer.allocate(hss.length * 2); // levels = 8, two bytes per

		for (int i = 0; i < hss.length; i++) {
			//a("          Example:  -LMS H5,H5,H10 -OTS W2,W2,W8");
			//a("          Example:  -LMS H5,H20 -OTS W8,W8 -N24");
			if (!arghelp) {
				switch (hss[i].toUpperCase()) {
				case "H5":
					levelparams.put((byte)(truncated ? Pqmi.HBS_LMS_SHA256_N24_H5 : Pqmi.HBS_LMS_SHA256_N32_H5));
					break;
				case "H10":
					levelparams.put((byte)(truncated ? Pqmi.HBS_LMS_SHA256_N24_H10 : Pqmi.HBS_LMS_SHA256_N32_H10));
					break;
				case "H15":
					levelparams.put((byte)(truncated ? Pqmi.HBS_LMS_SHA256_N24_H15 : Pqmi.HBS_LMS_SHA256_N32_H15));
					break;
				case "H20":
					levelparams.put((byte)(truncated ? Pqmi.HBS_LMS_SHA256_N24_H20 : Pqmi.HBS_LMS_SHA256_N32_H20));
					break;
				case "H25":
					levelparams.put((byte)(truncated ? Pqmi.HBS_LMS_SHA256_N24_H25 : Pqmi.HBS_LMS_SHA256_N32_H25));
					break;
				default:
					System.out.format("HSS/LMS parameter %s not expected\n", hss[i]);
					arghelp = true;
				}
			}
			if (!arghelp) {
				switch (ots[i].toUpperCase()) {
				case "W1":
					levelparams.put((byte)(truncated ? Pqmi.HBS_LMOTS_SHA256_N24_W1 : Pqmi.HBS_LMOTS_SHA256_N32_W1));
					break;
				case "W2":
					levelparams.put((byte)(truncated ? Pqmi.HBS_LMOTS_SHA256_N24_W2 : Pqmi.HBS_LMOTS_SHA256_N32_W2));
					break;
				case "W4":
					levelparams.put((byte)(truncated ? Pqmi.HBS_LMOTS_SHA256_N24_W4 : Pqmi.HBS_LMOTS_SHA256_N32_W4));
					break;
				case "W8":
					levelparams.put((byte)(truncated ? Pqmi.HBS_LMOTS_SHA256_N24_W8 : Pqmi.HBS_LMOTS_SHA256_N32_W8));
					break;
				default:
					System.out.format("HSS/LMS OTS parameter %s not expected\n", hss[i]);
					arghelp=true;
				}
			}		
		}

		if (arghelp) {
			System.out.println("Usage: ... -hss <string> -ots <string>"
					+ "\n     : The string for HSS is made up of heights in the set "
					+ "\n     :   H5 H10 H15 H20 H25"
					+ "\n     : The string for OTS is made up of Winternitz numbers in the set"
					+ "\n     :   W1 W2 W4 W8"
					+ "\n     : The number of options in -hss must match the number in -ots."
					+ "\n     : Example:"
					+ "\n     :    -hss H5,H5 -ots W4,W2"
					+ "\n     : For N24 variants of -ots, use the additional flag -N24:"
					+ "\n     :    -hss H5,H15 -ots W8,W2 -N24"
					+ "\n");
			return null;
		}
		return levelparams.array();
	}

	static void printXMSSArguments(String [] args) {
		if (args != null) {
			System.out.println(concat(args));
		}
		System.out.println("\nXMSS[-MT]:"
				+ "\n  -xmss \"Scheme\""
				+ "\n  -auxdatasz <n>   - 0..16384 (default 16384)"
				+"\n");
	}

	static String strip0x (String in) {
		if (in.startsWith("0x")) in = in.substring(2);
		if (in.startsWith("0X")) in = in.substring(2);
		Pattern p = Pattern.compile("[0-9a-fA-F]*");
		Matcher m = p.matcher(in);
		if (!m.matches()) {
			System.out.format("Invalid hex value supplied at %s", in);
			System.exit(-2);
		}
		if (in.length() % 2 == 1) in = "0"+in;
		return in;
	}

	/**
	 * 
	 * @param cla2
	 * @param cxi
	 * @return
	 */
	boolean xmss (SimpleArgs cla, CryptoServerCXI cxi) {
		boolean ret = true;
		
		AsynchHSMCmd tobj_ctor = new AsynchHSMCmd();

		HbsGen generator = new HbsGen();
		CxiKeyAttributes katts = new CxiKeyAttributes();
		AsynchHSMCmd response = null;

		int keytype = 0;
		if (cla.hasArg("-xmss")) keytype = Pqmi.HBS_XMSS_KT_FLAG;
		if (keytype == 0) {
			System.out.println("Invalid key type (no -xmss found)");
		}

		int rng = Pqmi.MODE_PSEUDO_RND;
		if (cla.hasArg("-trng")) rng = 0x0;

		boolean overwrite = cla.hasArg("-force");
		if (overwrite) rng |= CryptoServerCXI.FLAG_OVERWRITE;

		byte [] cmd_state = Asy.ASYNCH_CMD_CREATE.getBytes();
		int asynch_flags = cla.getArg("-asynch_flags", 0x0);

		String s_mid = strip0x(cla.getArg("-mid", "0xA2"));
		String s_sfc = strip0x(cla.getArg("-mid", "0xB"));
		String s_rfu = strip0x(cla.getArg("-mid", "0x0"));

		byte [] mid = HexFormat.of().parseHex(s_mid);
		byte [] sfc = HexFormat.of().parseHex(s_sfc);
		byte [] rfu = HexFormat.of().parseHex(s_rfu);
		String tname = cla.getArg("-tname", (String)null);

		if (tname == null) {
			printXMSSArguments(cla.params());
			return false;
		}

		boolean arghelp = false;
		if (!cla.hasArg("-xmss")) arghelp=true;
		// XMSS-SHA2_10_256
	
		/*
		Byte levels = KeyOpts_XMSS.getMTParamFromArgs(cla);
		byte [] levelparam = KeyOpts_XMSS.getOIDParamFromArgs(cla);
		if (levelparam == null) arghelp=true;
		*/
		byte [] levelparams = KeyOpts_XMSS.getParamFromString(cla.getArg("-xmss", (String)null));
		if (levelparams == null) {
			System.out.println("Usage");
			arghelp = true;
		}
		boolean multitree = (levelparams[0] == 1);
		byte scheme = levelparams[1];
		levelparams = new byte[1];
		levelparams[0] = scheme;

		int auxsz = cla.getArg("-auxdatasz", 16384);

		if (arghelp==true) {
			printXMSSArguments(cla.params());
			return false;		
		}
			
		String [] _kgs = getKeyFromArgs(cla);
		String kname = _kgs[0];
		String kgroup = _kgs[1];
		int kspec = Integer.parseInt(_kgs[2]);
		
		// cxikeyattributes
		katts.group(kgroup);
		katts.name(kname);
		katts.spec(kspec);

		generator.type(keytype);
		generator.flags(rng);
		generator.auxdatasz(auxsz);
		
		// xmss levels is 0 or 1 (MT)
		generator.levels(multitree ? 1 : 0);
		generator.levelparams(levelparams);

		try {
			generator.attributes(katts);
		} catch (SerializationError e1) {
			System.out.println("Parameter problem: Failed to serialize -kgs/-kg values.\n");
			System.exit(-8);
		}

		tobj_ctor = new AsynchHSMCmd (cxi);
		tobj_ctor.cmd_state (cmd_state);
		tobj_ctor.name(tname);
		tobj_ctor.flags (asynch_flags);
		tobj_ctor.mid (mid);
		tobj_ctor.sfc (sfc);
		tobj_ctor.rfu (rfu);
		try {
			tobj_ctor.payload(generator.serialize());
		} catch (SerializationError e1) {
			System.out.println("Parameter problem: Failed to serialize generator class, params wrong?\n");
			System.exit(-8);
		}

		/* ************************************* */
		if (ret) {
			ret = false; 
			try {
				// CREATE
				boolean res = tobj_ctor.exec(cxi);
				response = tobj_ctor.responseAsAsynchHSMCmd();
				if (!res || (response.retval() != 0x0)) {
					System.out.format("Response from Create is 0x%08x\n", response.retval());
					return false;
				}
				System.out.format("Response from Create is 'OK', task created\n", response.retval());
			} catch (CryptoServerException e) {
				System.err.format("Exception 0x%08x\n%s\n", e.ErrorCode, e.getMessage());
				return false;
			} catch (Exception e) {
				e.printStackTrace();
				return false;
			}
		}


		return true;
	}

	private static String[] getKeyFromArgs(SimpleArgs cla) {
		boolean isXmss = cla.hasArg("xmss");
		
		String kgs = cla.getArg("-kgs", (String)null);
		if (kgs == null) kgs = cla.getArg("-kg", (String)null);
		if (kgs == null) {
			System.out.println("-kgs or -kg is required to identify the key later\n");
			if (isXmss) printXMSSArguments(cla.params()); else printLMSArguments(cla.params());
			System.exit(-3);
		}
		String [] _kgs = kgs.split("[:;']");
		String [] ret = new String[3];

		switch (_kgs.length) {
		case 1:
			System.out.println("-kgs or -kg format is <name><sep><group>[<sep><spec>], for <sep> can be , ; or :\n");
			System.out.println("Name and Group are strings, spec is a non-negative integer\n");
			if (isXmss) printXMSSArguments(cla.params()); else printLMSArguments(cla.params());
			System.exit(-4);
		case 3:
			ret[0] = _kgs[0];
			ret[1] = _kgs[1];
			try {
				Integer.parseInt(_kgs[2]);
				ret[2] = _kgs[2];
			} catch (NumberFormatException nfe) {
				System.out.println("Spec must be a non-negative integer\n");
				if (isXmss) printXMSSArguments(cla.params()); else printLMSArguments(cla.params());
				System.exit(-5);
			}
		case 2:
			ret[0] = _kgs[0];
			ret[1] = _kgs[1];
			ret[2] = "0";
			break;
		default:
			System.out.println("-kgs or -kg format is <name><sep><group>[<sep><spec>], for <sep> can be , ; or :\n");
			System.out.println("Name and Group are strings, spec is a non-negative integer\n");
			System.out.format("'%s' does not follow this format.\n", kgs);
			if (isXmss) printXMSSArguments(cla.params()); else printLMSArguments(cla.params());
			System.exit(-7);
		}	
		return ret;
	}

	boolean hss (SimpleArgs cla, CryptoServerCXI cxi) {
		boolean ret = true;
		AsynchHSMCmd tobj_ctor = new AsynchHSMCmd();
		HbsGen generator = new HbsGen();
		CxiKeyAttributes katts = new CxiKeyAttributes();
		AsynchHSMCmd response = null;

		int keytype = 0;
		if (cla.hasArg("-lms")) keytype = Pqmi.HBS_LMS_KT_FLAG;
		if (cla.hasArg("-hss")) keytype = Pqmi.HBS_HSS_KT_FLAG;
		if (keytype == 0) {
			System.out.println("Invalid key type (no -lms or -hss found)");
		}

		int rng = Pqmi.MODE_PSEUDO_RND;
		if (cla.hasArg("-trng")) rng = 0x0;
		
		boolean overwrite = cla.hasArg("-force");
		if (overwrite) rng |= CryptoServerCXI.FLAG_OVERWRITE;

		byte [] cmd_state = Asy.ASYNCH_CMD_CREATE.getBytes();
		int asynch_flags = cla.getArg("-asynch_flags", 0x0);

		String s_mid = strip0x(cla.getArg("-mid", "0xA2"));
		String s_sfc = strip0x(cla.getArg("-mid", "0xB"));
		String s_rfu = strip0x(cla.getArg("-mid", "0x0"));

		byte [] mid = HexFormat.of().parseHex(s_mid);
		byte [] sfc = HexFormat.of().parseHex(s_sfc);
		byte [] rfu = HexFormat.of().parseHex(s_rfu);
		String tname = cla.getArg("-tname", (String)null);

		if (tname == null) {
			printLMSArguments(cla.params());
			return false;
		}

		byte [] levelparams = paramsToByteHSS(cla);


		int auxsz = cla.getArg("-auxdatasz", 16384);

		String kgs = cla.getArg("-kgs", (String)null);
		if (kgs == null) kgs = cla.getArg("-kg", (String)null);
		if (kgs == null) {
			System.out.println("-kgs or -kg is required to identify the key later\n");
			printLMSArguments(cla.params());
			System.exit(-3);
		}

		String [] _kgs = getKeyFromArgs(cla);
		String kname = _kgs[0];
		String kgroup = _kgs[1];
		int kspec = Integer.parseInt(_kgs[2]);
		
		// cxikeyattributes
		katts.group(kgroup);
		katts.name(kname);
		katts.spec(kspec);

		generator.type(keytype);
		generator.flags(rng);
		generator.auxdatasz(auxsz);
		generator.levels(levelparams.length/2);
		generator.levelparams(levelparams);
		try {
			generator.attributes(katts);
		} catch (SerializationError e1) {
			System.out.println("Parameter problem: Failed to serialize -kgs/-kg values.\n");
			System.exit(-8);
		}

		tobj_ctor = new AsynchHSMCmd (cxi);
		tobj_ctor.cmd_state (cmd_state);
		tobj_ctor.name(tname);
		tobj_ctor.flags (asynch_flags);
		tobj_ctor.mid (mid);
		tobj_ctor.sfc (sfc);
		tobj_ctor.rfu (rfu);
		try {
			tobj_ctor.payload(generator.serialize());
		} catch (SerializationError e1) {
			System.out.println("Parameter problem: Failed to serialize generator class, params wrong?\n");
			System.exit(-8);
		}

		/* ************************************* */
		if (ret) {
			ret = false; 
			try {
				// CREATE
				boolean res = tobj_ctor.exec(cxi);
				response = tobj_ctor.responseAsAsynchHSMCmd();
				if (!res || (response.retval() != 0x0)) {
					System.out.format("Response from Create is 0x%08x\n", response.retval());
					return false;
				}
				System.out.format("Response from Create is 'OK', task created\n", response.retval());
			} catch (CryptoServerException e) {
				System.err.format("Exception 0x%08x\n%s\n", e.ErrorCode, e.getMessage());
				return false;
			} catch (Exception e) {
				e.printStackTrace();
				return false;
			}
		}


		return true;
	}

	boolean poll (SimpleArgs cla, CryptoServerCXI cxi, StringBuilder sb) {
		boolean ret = true;
		AsynchHSMCmd tobj_ctor = null;
		AsynchHSMCmd response = null;

		byte [] cmd_state = Asy.ASYNCH_CMD_POLL.getBytes();
		int asynch_flags = cla.getArg("-asynch_flags", 0x0);

		String s_mid = strip0x(cla.getArg("-mid", "0xA2"));
		String s_sfc = strip0x(cla.getArg("-mid", "0xB"));
		String s_rfu = strip0x(cla.getArg("-mid", "0x0"));

		byte [] mid = HexFormat.of().parseHex(s_mid);
		byte [] sfc = HexFormat.of().parseHex(s_sfc);
		byte [] rfu = HexFormat.of().parseHex(s_rfu);

		String tname = cla.getArg("-tname", (String)null);

		tobj_ctor = new AsynchHSMCmd (cxi);
		tobj_ctor.cmd_state (cmd_state);
		tobj_ctor.name(tname);

		tobj_ctor.flags (asynch_flags);
		tobj_ctor.mid (mid);
		tobj_ctor.sfc (sfc);
		tobj_ctor.rfu (rfu);

		/* ************************************* */
		if (ret) {
			ret = false; 
			try {
				// CREATE
				boolean res = tobj_ctor.exec(cxi);
				response = tobj_ctor.responseAsAsynchHSMCmd();
				if (!res || (response.retval() != 0x0)) {
					System.out.format("Response from poll is 0x%08x\n", response.retval());
					return false;
				}
			} catch (CryptoServerException e) {
				System.err.println(AnyErrorList.errtext(e.ErrorCode));
				return false;
			} catch (Exception e) {
				e.printStackTrace();
				return false;
			}
		}

		if (sb == null) {
			System.out.format("Poll: t_id     - mmsr     - name                 - [state]\n");
			System.out.format("    : %08x - %04x%02x%02x - %-20s - [%s]\n", response.t_id(), 
				toInt(response.mid()), toInt(response.sfc()), toInt(response.rfu()),
				new String(response.name()), new String(response.cmd_state()));
		} else {
			sb.append(new String(response.cmd_state()));
		}
		return true;
	}

	ByteBuffer getRetrieveResult() {
		return retrieveResult;
	}
	
	boolean retrieve(SimpleArgs cla, CryptoServerCXI cxi) {
		boolean ret = true;
		AsynchHSMCmd tobj_ctor = null;
		AsynchHSMCmd response = null;

		byte [] cmd_state = Asy.ASYNCH_CMD_RETRIEVE.getBytes();
		int asynch_flags = cla.getArg("-asynch_flags", 0x0);

		String s_mid = strip0x(cla.getArg("-mid", "0xA2"));
		String s_sfc = strip0x(cla.getArg("-mid", "0xB"));
		String s_rfu = strip0x(cla.getArg("-mid", "0x0"));

		byte [] mid = HexFormat.of().parseHex(s_mid);
		byte [] sfc = HexFormat.of().parseHex(s_sfc);
		byte [] rfu = HexFormat.of().parseHex(s_rfu);
		String tname = cla.getArg("-tname", (String)null);

		//byte [] iv = new byte[0];
		//byte [] aad = new byte[0];
		//byte [] tag = new byte[0];

		// payload is not used in a polling
		//byte [] payload = new byte[0];

		tobj_ctor = new AsynchHSMCmd (cxi);
		tobj_ctor.cmd_state (cmd_state);
		if (tname != null) tobj_ctor.name(tname);
		tobj_ctor.flags (asynch_flags);
		tobj_ctor.mid (mid);
		tobj_ctor.sfc (sfc);
		tobj_ctor.rfu (rfu);
		//tobj_ctor.retval (retval);
		//tobj_ctor.iv (iv);
		//tobj_ctor.aad (aad);
		//tobj_ctor.tag (tag);
		//tobj_ctor.payload (payload);

		/* ************************************* */
		if (ret) {
			ret = false; 
			try {
				boolean res = tobj_ctor.exec(cxi);
				response = tobj_ctor.responseAsAsynchHSMCmd();
				if (!res || (response.retval() != 0x0)) {
					System.out.format("Response from retrieve is 0x%08x\n", response.retval());
					System.out.format("The state of the task is %s\n", new String(response.cmd_state()));
					return false;
				}
				if ((response.payload() != null) && (response.payload().length > 0)) {
					byte [] result = response.payload();
					byte [] shortr = new byte [64];
					if (result.length > shortr.length) {
						System.arraycopy(result, 0, shortr, 0, shortr.length);
						result = shortr;
					}
					CryptoServerUtil.xtrace("Result", result);
				}
			} catch (CryptoServerException e) {
				System.err.println(AnyErrorList.errtext(e.ErrorCode));
				return false;
			} catch (Exception e) {
				e.printStackTrace();
				return false;
			}
		}

		return true;
	}

	boolean table(SimpleArgs cla, CryptoServerCXI cxi) {
		boolean ret = true;
		AsynchHSMCmd tobj_ctor = null;
		AsynchHSMCmd response = null;

		byte [] cmd_state = Asy.ASYNCH_CMD_LIST.getBytes();
		int asynch_flags = cla.getArg("-asynch_flags", 0x0);

		tobj_ctor = new AsynchHSMCmd (cxi);
		tobj_ctor.cmd_state (cmd_state);
		tobj_ctor.flags (asynch_flags);

		/* ************************************* */
		if (ret) {
			ret = false; 
			try {
				boolean res = tobj_ctor.exec(cxi);
				response = tobj_ctor.responseAsAsynchHSMCmd();
				if (!res || (response.retval() != 0x0)) {
					System.out.format("Response from retrieve is 0x%08x\n", response.retval());
					return false;
				}
				if ((response.payload() != null) && (response.payload().length > 0)) {
					//CryptoServerUtil.xtrace(response.payload());
				}
			} catch (CryptoServerException e) {
				System.err.println(AnyErrorList.errtext(e.ErrorCode));
				return false;
			} catch (Exception e) {
				e.printStackTrace();
				return false;
			}
		}

		if ((response.payload() == null) || (response.payload().length == 0)) {
			System.out.format("NO ACTIVE ASYNCH TASKS\n");
			return false;
		}

		// XML a struct for this.
		// structure of the return is
		// u1 - Number of active records - max MAX_TASKS
		// u1 - MAX_TASKS
		// u1 - Size of one record - 0x20
		// u1 - rfu 
		// c16 - task name
		// u4 - task id
		// u4 - mmsr
		// c1 - state
		// u4 - err
		// u3 - l_payload
		// max len:
		ByteBuffer bb = ByteBuffer.wrap(response.payload());
		int count = bb.get();
		int maxtasks = bb.get();
		/*int szrec = */bb.get();
		/*int rfu = */bb.get();
		System.out.format("ACTIVE ASYNCH TASKS:  %d of %d\n", count, maxtasks);
		System.out.println("-------------------------------------------------------------------------------------------------------");
		System.out.format("%2s | %8s | %16s | %8s | %16s | %10s | %s \n", "N", "TID", "NAME", "mmsr", "state", "err", "len payload");
		System.out.println("-------------------------------------------------------------------------------------------------------");
		for (int i = 0; i < count; i++) {
			byte [] name = new byte[16];
			bb.get(name);
			int tid = bb.getInt();
			int mmsr = bb.getInt();
			int state = bb.get();
			int err = bb.getInt();
			byte [] len_p = new byte[3];
			bb.get(len_p);
			int l_payload = toInt(len_p);
			System.out.format("%2d | %8x | %16s | %8x | %16s | 0x%08x | %d\n", i+1, tid, new String(name), 
					mmsr, AsyEx.stateToString(state), err, l_payload);
		}
		return true;
	}




	/**
	 * END of TEST SPECIFIC
	 **********************************************************************/
	/* Edit below by changing the template, not this file.  
	 * If you decide to edit this file, delete these two lines so others 
	 * know it is no longer stock test code.
	 *
	 * Autogenerated 2024-09-25T19:40:10.6610769 using CS_SdkVpl version 0.0.6
	 */

	public static void main(String[] args) {
		SimpleArgs cla = new SimpleArgs(args);
		
		dbg = (cla.hasArg("-v") ? true : dbg);

		if (cla.hasArg("-h")) { printUsageAndExit(); }
		if (cla.hasArg("-help")) { printUsageAndExit(); }
		if (args.length == 0) { printUsageAndExit(); }

		boolean ret = false;
		if (cla.hasArg("-poll")) {
			ret = true;
		} else if (cla.hasArg("-get")) {
			ret = true;
		} else if (cla.hasArg("-list")) {
			ret = true;
		} else if (cla.hasArg("-lms")) {
			ret = true;
		} else if (cla.hasArg("-hss")) {
			ret = true;
		} else if (cla.hasArg("-xmss")) {
			ret = true;
		}
		if (!ret) {
			printUsageAndExit();
		}

		String device = getDevice(cla, "3001@127.0.0.1");
		//other options for default device = "PCI:0";
		//other options for default device = "288@192.168.4.183";
		// etc

		int c_lgns = 0;
		ArrayList<Login> logins = new ArrayList<Login>();
		Login lgn = null;
		do {
			lgn = _singleton.new Login(args, c_lgns++);
			logins.add(lgn);
		} while (lgn.valid);

		new AnyErrorList();
		new AsyErrorList();
		new PqmiErrorList();


		CryptoServerCXI cxi = null;
		try {
			// create instance of CryptoServerCXI (opens connection to CryptoServer)
			// Note: does not support clusters.
			cxi = new CryptoServerCXI(device, 3000); // connection timeout is 3 seconds

			cxi.setTimeout(360000); // command timeout is 6 minute
			//cxi.setTimeout(60000); // command timeout is 1 minute

			cxi.setKeepSessionAlive(true); // in theory a no-op as the test code doesn't have any waitstates
			cxi.setEndSessionOnShutdown(true); // in theory a no-op as the session is manually closed below

			dbg("Device: " + cxi.getDevice());
			String zeros = "00000000";
			for (Login l : logins) {
				if (!l.valid) { continue; }
				dbg("User: " + l.user);
				l.login(cxi);
				String authstate = zeros + Integer.toHexString(cxi.getAuthState());
				dbg(" -> 0x" + authstate.substring(authstate.length()-8));
			}

			ret = true;
			boolean checkrtc = false;
			if (cla.hasArg("-poll")) {
				ret = _singleton.poll(cla, cxi, null);
			} else if (cla.hasArg("-get")) {
				ret = _singleton.retrieve(cla, cxi);
			} else if (cla.hasArg("-list")) {
				ret = _singleton.table(cla, cxi);
			} else if (cla.hasArg("-lms")) {
				ret = _singleton.hss(cla, cxi);
				checkrtc = true;
			} else if (cla.hasArg("-hss")) {
				ret = _singleton.hss(cla, cxi);
			} else if (cla.hasArg("-xmss")) {
				ret = _singleton.xmss(cla, cxi);
				checkrtc = true;
			} else {
				printUsageAndExit();
			}
			
			boolean retrieve = false;
			int nl = 0;
			if (checkrtc && cla.hasArg("-rtc")) {
				do {
					StringBuilder sb = new StringBuilder();
					ret = _singleton.poll(cla,  cxi,  sb);
					if (sb.toString().compareTo("P") == 0) {
						checkrtc = false;
						retrieve = true;
					} else {
						if (++nl % 80 == 0) {
							System.out.println();
						}
						System.out.print(sb.toString());
					}
					try {
						Thread.sleep(1000);
					} catch (Exception e) { 
						checkrtc = false;
					}
				} while (checkrtc);
			}
			if (retrieve) {
				ret = _singleton.retrieve(cla, cxi);
			}

			//_singleton.test0(args, cxi, false);
		} catch (IOException e) {
			System.out.println("IOException: " + e.getMessage());
		} catch (CryptoServerException cse) {
			System.out.println("CryptoServerException:  0x" + Integer.toHexString(cse.ErrorCode));
			if (cse.ErrorAnswer != null) {
				// do something
			}
		}

		// cleanup
		if (cxi != null) {
			// cxi.logoff();  		// ends authentication on session
			// cxi.endSession();  	// calls .logoff(), terminates session
			cxi.close(); 			// calls .endSession(), terminates connection
			cxi = null;
		}
	}

	private static void dbg (String d) {
		if (dbg) {
			System.out.println(d);
		}
	}

	private static String getDevice (SimpleArgs cla, String def) {
		String cxi = System.getenv("CRYPTOSERVER");
		if (cxi == null) {
			cxi = def;
		}
		if (cla.hasArg("dev")) {
			cxi = cla.getArg("dev", cxi);
		}
		return cxi;
	}

	private class Login {
		String user = null;
		String spec = null;
		String pin = null;

		File file = null;
		boolean valid = false;
		// valid indicates that this /may/ represent a valid credential, not that it /is/ a valid login

		/*		
		user		Name of the user who wants to autenticate to the CryptoServer.
		keyFile		<-- mapped from -cred, or -s or if mistakenly -p with 3 parameters
			Key file user: Path to key file containing user's private key.
			Password user: null.
		password	<-- mapped from -cred, or -p
			Key file user: Password of the key file if using an encrypted file, null otherwise.
			Password user: Password of the user.
		 */
		Login (String [] args, int i) {
			int c = 0;
			boolean getNext = false;
			for (String a : args) {
				if (getNext) {
					getNext = false;
					String[] nkp = a.split(",");
					if (nkp.length == 2) {
						/* either 
						 * -s name,key (unencrypted)
						 * -s name,:cs2...
						 * -p name,pass
						 */
						user = nkp[0];
						spec = nkp[1];  
						pin = nkp[1]; // yes -- 1.  see later check

						file = new File(spec);
						valid = (spec.matches("^:cs2:.{3,4}:.*$")) || file.exists();

					} else if (nkp.length == 3) {
						// * -s name,key,pass (encrypted)
						user = nkp[0];
						spec = nkp[1];
						pin = nkp[2];
						file = new File(spec);
						valid = file.exists();
					}
					/* at this point, valid is true if the file exists, or if the spec is :cs2:...
					 * valid is false if the value isn't a file and the value isn't a PINPad identifier
					 * 
					 * In this case, we assume HMACpwd, if we've made it this far
					 */
					valid = true; // assume it's HMACpwd
					/*
					 * I may find some logic later for pre-determining if this is an hmac
					 * but I can't test it (using the HSM) because it would log everyone out if it was bad.
					 *
					 * For now, we rely on the cxi.logon(...) to bork if it is not a valid logon.
					 */

					if (!valid) { System.out.println("Auth param format invalid for " + a); }
					c++;
				}
				/* deprecated */
				if (a.compareTo("-s") == 0) {
					if (c != i) { c++; continue; }
					getNext = true;
				}
				/* deprecated */
				if (a.compareTo("-p") == 0) {
					if (c != i) { c++; continue; }
					getNext = true;
				}

				if (a.compareTo("-cred") == 0) {
					if (c != i) { c++; continue; }
					getNext = true;
				}
			}
		}

		boolean login (CryptoServerCXI cxi) {
			boolean ret = false;

			try {
				/* change 01g replaced logonpass/logonsign with the simple logon */
				byte [] pinbytes = new byte[0];
				if (pin != null) {
					pinbytes = pin.getBytes();
				}
				byte [] ovrt = new byte[pinbytes.length];
				cxi.logon(user, spec, pinbytes);
				System.arraycopy(ovrt,0,pinbytes,0,pinbytes.length);
				// also have pin to worry about.
				// pin = null;
				// but we don't know when the GC will reap it.
				return true;
			} catch (IOException e) {
				System.out.println(user + " login failed:  " + e.getMessage());
			} catch (CryptoServerException e) {
				System.out.println(user + " login failed:  0x" + Integer.toHexString(e.ErrorCode));
			}
			return ret;
		}
	}

}