/******************************************************************************
 * PKCS11 Reproducer Library
 * -------------------------
 *
 * Copyright (c) 2023 Utimaco Inc
 *
 * This software is covered by the Utimaco Demo License.
 *
 * The software in this library is intended for use by developers who wish
 * to report possible bugs within the Utimaco PKCS11 Libraries/providers, or
 * who have questions about usage.
 *
 * Bug reports are addressed under support and maintenance contract. Without
 * support contracts in place, responses - if provided - are provided under
 * "best effort" rules.
 *
 * Version:  4.55.0
 * Maintainer:  richard.williamson@utimaco.com
 *
 *****************************************************************************/
#include "qptool2.h"

#include <stdio.h>     
#include "cryptoki.h"

void pkcs_err_text(unsigned int errv) {
    char * t = "Unknown error value";

    switch (errv) {
        case CKR_OK                                : t = "CKR_OK"; break;
        case CKR_CANCEL                            : t = "CKR_CANCEL"; break;
        case CKR_HOST_MEMORY                       : t = "CKR_HOST_MEMORY"; break;
        case CKR_SLOT_ID_INVALID                   : t = "CKR_SLOT_ID_INVALID"; break;

        case CKR_GENERAL_ERROR                     : t = "CKR_GENERAL_ERROR"; break;
        case CKR_FUNCTION_FAILED                   : t = "CKR_FUNCTION_FAILED"; break;

        case CKR_ARGUMENTS_BAD                     : t = "CKR_ARGUMENTS_BAD"; break;
        case CKR_NO_EVENT                          : t = "CKR_NO_EVENT"; break;
        case CKR_NEED_TO_CREATE_THREADS            : t = "CKR_NEED_TO_CREATE_THREADS"; break;
        case CKR_CANT_LOCK                         : t = "CKR_CANT_LOCK"; break;

        case CKR_ATTRIBUTE_READ_ONLY               : t = "CKR_ATTRIBUTE_READ_ONLY"; break;
        case CKR_ATTRIBUTE_SENSITIVE               : t = "CKR_ATTRIBUTE_SENSITIVE"; break;
        case CKR_ATTRIBUTE_TYPE_INVALID            : t = "CKR_ATTRIBUTE_TYPE_INVALID"; break;
        case CKR_ATTRIBUTE_VALUE_INVALID           : t = "CKR_ATTRIBUTE_VALUE_INVALID"; break;

        case CKR_ACTION_PROHIBITED                 : t = "CKR_ACTION_PROHIBITED"; break;

        case CKR_DATA_INVALID                      : t = "CKR_DATA_INVALID"; break;
        case CKR_DATA_LEN_RANGE                    : t = "CKR_DATA_LEN_RANGE"; break;
        case CKR_DEVICE_ERROR                      : t = "CKR_DEVICE_ERROR"; break;
        case CKR_DEVICE_MEMORY                     : t = "CKR_DEVICE_MEMORY"; break;
        case CKR_DEVICE_REMOVED                    : t = "CKR_DEVICE_REMOVED"; break;
        case CKR_ENCRYPTED_DATA_INVALID            : t = "CKR_ENCRYPTED_DATA_INVALID"; break;
        case CKR_ENCRYPTED_DATA_LEN_RANGE          : t = "CKR_ENCRYPTED_DATA_LEN_RANGE"; break;
        case CKR_AEAD_DECRYPT_FAILED               : t = "CKR_AEAD_DECRYPT_FAILED"; break;
        case CKR_FUNCTION_CANCELED                 : t = "CKR_FUNCTION_CANCELED"; break;
        case CKR_FUNCTION_NOT_PARALLEL             : t = "CKR_FUNCTION_NOT_PARALLEL"; break;

        case CKR_FUNCTION_NOT_SUPPORTED            : t = "CKR_FUNCTION_NOT_SUPPORTED"; break;

        case CKR_KEY_HANDLE_INVALID                : t = "CKR_KEY_HANDLE_INVALID"; break;

        case CKR_KEY_SIZE_RANGE                    : t = "CKR_KEY_SIZE_RANGE"; break;
        case CKR_KEY_TYPE_INCONSISTENT             : t = "CKR_KEY_TYPE_INCONSISTENT"; break;

        case CKR_KEY_NOT_NEEDED                    : t = "CKR_KEY_NOT_NEEDED"; break;
        case CKR_KEY_CHANGED                       : t = "CKR_KEY_CHANGED"; break;
        case CKR_KEY_NEEDED                        : t = "CKR_KEY_NEEDED"; break;
        case CKR_KEY_INDIGESTIBLE                  : t = "CKR_KEY_INDIGESTIBLE"; break;
        case CKR_KEY_FUNCTION_NOT_PERMITTED        : t = "CKR_KEY_FUNCTION_NOT_PERMITTED"; break;
        case CKR_KEY_NOT_WRAPPABLE                 : t = "CKR_KEY_NOT_WRAPPABLE"; break;
        case CKR_KEY_UNEXTRACTABLE                 : t = "CKR_KEY_UNEXTRACTABLE"; break;

        case CKR_MECHANISM_INVALID                 : t = "CKR_MECHANISM_INVALID"; break;
        case CKR_MECHANISM_PARAM_INVALID           : t = "CKR_MECHANISM_PARAM_INVALID"; break;

        case CKR_OBJECT_HANDLE_INVALID             : t = "CKR_OBJECT_HANDLE_INVALID"; break;
        case CKR_OPERATION_ACTIVE                  : t = "CKR_OPERATION_ACTIVE"; break;
        case CKR_OPERATION_NOT_INITIALIZED         : t = "CKR_OPERATION_NOT_INITIALIZED"; break;
        case CKR_PIN_INCORRECT                     : t = "CKR_PIN_INCORRECT"; break;
        case CKR_PIN_INVALID                       : t = "CKR_PIN_INVALID"; break;
        case CKR_PIN_LEN_RANGE                     : t = "CKR_PIN_LEN_RANGE"; break;

        case CKR_PIN_EXPIRED                       : t = "CKR_PIN_EXPIRED"; break;
        case CKR_PIN_LOCKED                        : t = "CKR_PIN_LOCKED"; break;

        case CKR_SESSION_CLOSED                    : t = "CKR_SESSION_CLOSED"; break;
        case CKR_SESSION_COUNT                     : t = "CKR_SESSION_COUNT"; break;
        case CKR_SESSION_HANDLE_INVALID            : t = "CKR_SESSION_HANDLE_INVALID"; break;
        case CKR_SESSION_PARALLEL_NOT_SUPPORTED    : t = "CKR_SESSION_PARALLEL_NOT_SUPPORTED"; break;
        case CKR_SESSION_READ_ONLY                 : t = "CKR_SESSION_READ_ONLY"; break;
        case CKR_SESSION_EXISTS                    : t = "CKR_SESSION_EXISTS"; break;

        case CKR_SESSION_READ_ONLY_EXISTS          : t = "CKR_SESSION_READ_ONLY_EXISTS"; break;
        case CKR_SESSION_READ_WRITE_SO_EXISTS      : t = "CKR_SESSION_READ_WRITE_SO_EXISTS"; break;

        case CKR_SIGNATURE_INVALID                 : t = "CKR_SIGNATURE_INVALID"; break;
        case CKR_SIGNATURE_LEN_RANGE               : t = "CKR_SIGNATURE_LEN_RANGE"; break;
        case CKR_TEMPLATE_INCOMPLETE               : t = "CKR_TEMPLATE_INCOMPLETE"; break;
        case CKR_TEMPLATE_INCONSISTENT             : t = "CKR_TEMPLATE_INCONSISTENT"; break;
        case CKR_TOKEN_NOT_PRESENT                 : t = "CKR_TOKEN_NOT_PRESENT"; break;
        case CKR_TOKEN_NOT_RECOGNIZED              : t = "CKR_TOKEN_NOT_RECOGNIZED"; break;
        case CKR_TOKEN_WRITE_PROTECTED             : t = "CKR_TOKEN_WRITE_PROTECTED"; break;
        case CKR_UNWRAPPING_KEY_HANDLE_INVALID     : t = "CKR_UNWRAPPING_KEY_HANDLE_INVALID"; break;
        case CKR_UNWRAPPING_KEY_SIZE_RANGE         : t = "CKR_UNWRAPPING_KEY_SIZE_RANGE"; break;
        case CKR_UNWRAPPING_KEY_TYPE_INCONSISTENT  : t = "CKR_UNWRAPPING_KEY_TYPE_INCONSISTENT"; break;
        case CKR_USER_ALREADY_LOGGED_IN            : t = "CKR_USER_ALREADY_LOGGED_IN"; break;
        case CKR_USER_NOT_LOGGED_IN                : t = "CKR_USER_NOT_LOGGED_IN"; break;
        case CKR_USER_PIN_NOT_INITIALIZED          : t = "CKR_USER_PIN_NOT_INITIALIZED"; break;
        case CKR_USER_TYPE_INVALID                 : t = "CKR_USER_TYPE_INVALID"; break;

        case CKR_USER_ANOTHER_ALREADY_LOGGED_IN    : t = "CKR_USER_ANOTHER_ALREADY_LOGGED_IN"; break;
        case CKR_USER_TOO_MANY_TYPES               : t = "CKR_USER_TOO_MANY_TYPES"; break;

        case CKR_WRAPPED_KEY_INVALID               : t = "CKR_WRAPPED_KEY_INVALID"; break;
        case CKR_WRAPPED_KEY_LEN_RANGE             : t = "CKR_WRAPPED_KEY_LEN_RANGE"; break;
        case CKR_WRAPPING_KEY_HANDLE_INVALID       : t = "CKR_WRAPPING_KEY_HANDLE_INVALID"; break;
        case CKR_WRAPPING_KEY_SIZE_RANGE           : t = "CKR_WRAPPING_KEY_SIZE_RANGE"; break;
        case CKR_WRAPPING_KEY_TYPE_INCONSISTENT    : t = "CKR_WRAPPING_KEY_TYPE_INCONSISTENT"; break;
        case CKR_RANDOM_SEED_NOT_SUPPORTED         : t = "CKR_RANDOM_SEED_NOT_SUPPORTED"; break;

        case CKR_RANDOM_NO_RNG                     : t = "CKR_RANDOM_NO_RNG"; break;

        case CKR_DOMAIN_PARAMS_INVALID             : t = "CKR_DOMAIN_PARAMS_INVALID"; break;

        case CKR_CURVE_NOT_SUPPORTED               : t = "CKR_CURVE_NOT_SUPPORTED"; break;

        case CKR_BUFFER_TOO_SMALL                  : t = "CKR_BUFFER_TOO_SMALL"; break;
        case CKR_SAVED_STATE_INVALID               : t = "CKR_SAVED_STATE_INVALID"; break;
        case CKR_INFORMATION_SENSITIVE             : t = "CKR_INFORMATION_SENSITIVE"; break;
        case CKR_STATE_UNSAVEABLE                  : t = "CKR_STATE_UNSAVEABLE"; break;

        case CKR_CRYPTOKI_NOT_INITIALIZED          : t = "CKR_CRYPTOKI_NOT_INITIALIZED"; break;
        case CKR_CRYPTOKI_ALREADY_INITIALIZED      : t = "CKR_CRYPTOKI_ALREADY_INITIALIZED"; break;
        case CKR_MUTEX_BAD                         : t = "CKR_MUTEX_BAD"; break;
        case CKR_MUTEX_NOT_LOCKED                  : t = "CKR_MUTEX_NOT_LOCKED"; break;

        case CKR_NEW_PIN_MODE                      : t = "CKR_NEW_PIN_MODE"; break;
        case CKR_NEXT_OTP                          : t = "CKR_NEXT_OTP"; break;

        case CKR_EXCEEDED_MAX_ITERATIONS           : t = "CKR_EXCEEDED_MAX_ITERATIONS"; break;
        case CKR_FIPS_SELF_TEST_FAILED             : t = "CKR_FIPS_SELF_TEST_FAILED"; break;
        case CKR_LIBRARY_LOAD_FAILED               : t = "CKR_LIBRARY_LOAD_FAILED"; break;
        case CKR_PIN_TOO_WEAK                      : t = "CKR_PIN_TOO_WEAK"; break;
        case CKR_PUBLIC_KEY_INVALID                : t = "CKR_PUBLIC_KEY_INVALID"; break;

        case CKR_FUNCTION_REJECTED                 : t = "CKR_FUNCTION_REJECTED"; break;
        case CKR_TOKEN_RESOURCE_EXCEEDED           : t = "CKR_TOKEN_RESOURCE_EXCEEDED"; break;
        case CKR_OPERATION_CANCEL_FAILED           : t = "CKR_OPERATION_CANCEL_FAILED"; break;

        case CKR_VENDOR_DEFINED                    : t = "CKR_VENDOR_DEFINED"; break;
    }

    printf("0x%08X : %s\n", errv, t);
}
