/*****************************************************************************
 *                                                                           
 *  Filename    : load_store.h                                               
 *                                                                           
 *  Author(s)   : Dipl. Inf. Rainer Herbertz                                 
 *                Utimaco AG                                                 
 *                                                                           
 *  Description : header for load / store functions on host                   
 *                                                                           
 *  History     :                                                            
 *  Date       |                 Action                          |  Author   
 *  -----------|-------------------------------------------------|---------  
 *  17.05.2001 | Creation                                        |  R.H.     
 *****************************************************************************/

#ifndef __LOAD_STORE_H_INCLUDED__
 #define __LOAD_STORE_H_INCLUDED__

#if defined(_MSC_VER)
#define _LD_ST_INLINE _inline
#else
#define _LD_ST_INLINE static inline
#endif

_LD_ST_INLINE void store_int1(unsigned int val,unsigned char *x)
{
    *x   = (unsigned char)val;
}

_LD_ST_INLINE void store_int2(unsigned int val,unsigned char *x)
{
    *x++ = (unsigned char)(val >> 8U);
    *x   = (unsigned char)val;
}

_LD_ST_INLINE void store_int3(unsigned int val,unsigned char *x)
{
    *x++ = (unsigned char)(val >> 16U);
    *x++ = (unsigned char)(val >> 8U);
    *x   = (unsigned char)val;
}

_LD_ST_INLINE void store_int4(unsigned int val,unsigned char *x)
{
    *x++ = (unsigned char)(val >> 24U);
    *x++ = (unsigned char)(val >> 16U);
    *x++ = (unsigned char)(val >> 8U);
    *x   = (unsigned char)val;
}

_LD_ST_INLINE unsigned int load_int1(const unsigned char *x)
{
    return x[0];
}

_LD_ST_INLINE unsigned int load_int2(const unsigned char *x)
{
    return( ((unsigned int)x[0] << 8U) + x[1] );
}

_LD_ST_INLINE unsigned int load_int3(const unsigned char *x)
{
    return( ((unsigned int)x[0] << 16U) + ((unsigned int)x[1] << 8U) + x[2] );
}

_LD_ST_INLINE unsigned int load_int4(const unsigned char *x)
{
    return( ((unsigned int)x[0] << 24U) + ((unsigned int)x[1] << 16U) + ((unsigned int)x[2] << 8U) + x[3] );
}

_LD_ST_INLINE unsigned int load_int(const unsigned char *x, int len)
{
    switch (len)
    {
    case 0:
        return 0;
    case 1:
        return load_int1(x);
    case 2:
        return load_int2(x);
    case 3:
        return load_int3(x);
    case 4:
        return load_int4(x);
    }
    return 0;//or something else that smells like problems
}

#undef _LD_ST_INLINE

#endif /* __LOAD_STORE_H_INCLUDED__ */
