package com.utimaco.cs2.mdl.pqmi;

/* 
 * 03c autogenerated 2024-11-06T12:45:06.503739 using 
 * CS_SdkVpl version 0.0.6
 * Source XML Document version 01d,2024-03-26,riw
 * 
 * Copyright included by reference, please see Utimaco_Demo_License.txt
 *
 */

import com.utimaco.cs2.mdl.I_SdkBuffer;
import java.nio.ByteBuffer;
import java.io.IOException;
import CryptoServerAPI.CryptoServerException;
import CryptoServerCXI.CryptoServerCXI;
import com.utimaco.cs2.mdl.SdkBuffer;
import com.utimaco.cs2.mdl.DeserializationError;
import com.utimaco.cs2.mdl.SerializationError;

// Typed parameters (if any)

/**
 * Pattern: u4u4v2v4v1v4v2
 *
 * Field declarations
 * <pre>
 * flags:  (u4) unsigned int {}
 *   int               flags                          = (int)0x0;           // Flags from  u4

 * type:  (u4) unsigned int {}
 *   int               type                           = (int)0x0;           // key type from  u4

 * key:  (v2) unsigned short + data {}
 *   byte []           key                            = new byte[0];        // For Sign: Private key, for verification: Public key//  v2

 * msg:  (v4) unsigned int + data {}
 *   byte []           msg                            = new byte[0];        // Message to verify//  v4

 * ctxt:  (v1) unsigned byte + data  {}
 *   byte []           ctxt                           = new byte[0];        // For adding contextual information to the signature inputs//  v1
 * state:  (v4) unsigned int + data {}
 *   byte []           state                          = new byte[0];        // State blob for chunked operations//  v4

 * sig:  (v2) unsigned short + data {}
 *   byte []           sig                            = new byte[0];        // Signature to be verified//  v2

 * </pre>
 * @author SFCBUFFERS
 *
 */
public class MLDSA_Verify extends SdkBuffer implements I_SdkBuffer {
    int ModuleID = 0x087; // Default is 'echo' from ADM
    int SFC = 0; // Default is 'echo' from ADM
    protected static final String pattern = "u4u4v2v4v1v4v2"; 

    // Interface specific defined def elements
    public static final int    FLAG_MASK 	=  0xF2040000; 		// ML-DSA Define mask
    public static final int    FLAG_HAS_CTXT 	=  0xF2040000; 		// Signature will include AAD/Context Information
    public static final int    FLAG_PRE_HASH 	=  0xF2040001; 		// Input msg is a hash of the message data
    public static final int    FLAG_SIG_PACKED 	=  0xF2040002; 		// Signature is packed version
    //public static final int    SWALLOW_BAD_VER_EXCEPTION 	=  0xF2040004; 		// Return False instead of verify exception

    // Interface Fields
    int flags = 0x0;
    int type = 0x0;
    byte [] key = new byte[0];
    byte [] msg = new byte[0];
    byte [] ctxt = new byte[0];
    byte [] state = new byte[0];
    byte [] sig = new byte[0];

    // Static constructor stubs.
    //
    // MLDSA_Verify obj = new MLDSA_Verify ();
    // MLDSA_Verify obj = new MLDSA_Verify (cxi); // does not exec
    // MLDSA_Verify obj = new MLDSA_Verify (cxi, _in); // does not exec
    // MLDSA_Verify obj = new MLDSA_Verify (_resp); // decompose buffer received elsewhere
    // MLDSA_Verify obj = new MLDSA_Verify (_resp, boolean); // decompose buffer received elsewhere, which may be longer than expected
    //                                                     // if true, do not accept this and throw SerializationError
    //                                                     // if false, accept this and ignore remaining bytes
    // 

    /** 
     * Instantiate a MLDSA_Verify object (empty)
     */
    public MLDSA_Verify () { super(); }

    /**
     * Instantiate a MLDSA_Verify object, referencing an existing connection 
     * to a CryptoServer
     */
    public MLDSA_Verify (CryptoServerCXI _cxi) {
      this();
      cxi = _cxi;
    }

    /**
     * Instantiate a MLDSA_Verify object, referencing an existing connection 
     * to a CryptoServer, and targeting a specific Module/SFC
     */
    public MLDSA_Verify (CryptoServerCXI _cxi, int mid, int sfc) {
      super(mid, sfc);
      cxi = _cxi;
    }

    /**
     * Instantiate a MLDSA_Verify object, referencing an existing connection 
     * to a CryptoServer, and supplying the input values via deserializable
     * byte buffer.  
     */
    public MLDSA_Verify (CryptoServerCXI _cxi, byte [] _in) {
      this(_cxi);
      try { deserialize(_in); }
      catch (DeserializationError e) { e.printStackTrace(); }
    }

    /**
     * Instantiate a MLDSA_Verify object, without referencing a CryptoServer
     * This method deserializes a byte buffer that was received as the
     * response to an earlier issued command.
     */
    public MLDSA_Verify (byte [] _resp) {
    	this(_resp, true);
    }
    
    /**
     * Instantiate a MLDSA_Verify object, without referencing a CryptoServer
     * This method deserializes a byte buffer that was received as the
     * response to an earlier issued command.  If there are remaining bytes
     * in the _resp array at the end of the interface deserialization, 
     * if assumeExactLenBuffer is true, throws SerializationError, else
     * does not throw.
     */
    public MLDSA_Verify (byte [] _resp, boolean assumeExactLenBuffer) {
      this();
      try { deserialize(_resp, assumeExactLenBuffer); }
      catch (DeserializationError e) { e.printStackTrace(); }
    }

    /**
     * Additional Constructors based on the Interface definition
     */
    // Java "Normal"
    public MLDSA_Verify ( 
        int _flags,
        int _type,
        byte [] _key,
        byte [] _msg,
        byte [] _ctxt,
        byte [] _state,
        byte [] _sig

    ) {
        flags(_flags); 
        type(_type); 
        key(_key); 
        msg(_msg); 
        ctxt(_ctxt); 
        state(_state); 
        sig(_sig); 
    }

    // Java Object

    // Command setters/getters 
    public int      flags() { return flags; } 
    public void     flags (int      _in) { flags = _in; }
    public int      type() { return type; } 
    public void     type (int      _in) { type = _in; }
    public byte []  key() { return key; } 
    public void     key (byte []  _in) { key = _in; }
    public void     keyFrom (byte []  _in) {
        key = new byte[_in.length];
        System.arraycopy(_in, 0, key, 0, _in.length);
    }
    public void     key (String _in) {
        key = _in.getBytes();
    }
    public byte []  msg() { return msg; } 
    public void     msg (byte []  _in) { msg = _in; }
    public void     msgFrom (byte []  _in) {
        msg = new byte[_in.length];
        System.arraycopy(_in, 0, msg, 0, _in.length);
    }
    public void     msg (String _in) {
        msg = _in.getBytes();
    }
    public byte []  ctxt() { return ctxt; } 
    public void     ctxt (byte []  _in) { ctxt = _in; }
    public void     ctxtFrom (byte []  _in) {
        ctxt = new byte[_in.length];
        System.arraycopy(_in, 0, ctxt, 0, _in.length);
    }
    public void     ctxt (String _in) {
        ctxt = _in.getBytes();
    }
    public byte []  state() { return state; } 
    public void     state (byte []  _in) { state = _in; }
    public void     stateFrom (byte []  _in) {
        state = new byte[_in.length];
        System.arraycopy(_in, 0, state, 0, _in.length);
    }
    public void     state (String _in) {
        state = _in.getBytes();
    }
    public byte []  sig() { return sig; } 
    public void     sig (byte []  _in) { sig = _in; }
    public void     sigFrom (byte []  _in) {
        sig = new byte[_in.length];
        System.arraycopy(_in, 0, sig, 0, _in.length);
    }
    public void     sig (String _in) {
        sig = _in.getBytes();
    }

    // Exec
    /**
     * Executes the command to the param-supplied CryptoServer, using
     * using the supplied ModuleID and Sub-function code.
     * <p>
     * This command may result in SerializationError or DeserializationError
     * events, but these are swallowed and returned as 'false'.
     * <p>
     * Note: The subfunction code only supports SFCs in the range 0..255.
     * <p>
     * @param CryptoServerCXI 
     * @param module ID 
     * @param subfunction code to call
     * @return boolean - ok (0x0) otherwise invalid input/ser+deser errors
     * @throws IOException (CryptoServer not available)
     * @throws CryptoServerException (non-zero response from the CryptoServer
     */
    public boolean exec (CryptoServerCXI cxi, int mid, int sfc) throws IOException, CryptoServerException {
        if (cxi == null) {
            System.out.println("No CXI\n");
            return false;
        }
        if ((sfc < 0) || (sfc > 255)) { return false; }

        return exec(cxi, mid, sfc, this, null); // this variant has no return value awareness, just stored
    }

    /**
     * Executes the command to the param-supplied CryptoServer, using
     * using the supplied ModuleID and Sub-function code.
     * <p>
     * This command may result in SerializationError or DeserializationError
     * events, but these are swallowed and returned as 'false'.
     * <p>
     * Note: The subfunction code only supports SFCs in the range 0..255.
     * <p>
     * If an I_SdkBuffer object is supplied as a recipient, and the response from 
     * the CryptoServer is OK, the result buffer will be handed to it and an attempt
     * to deserialize the result will happen.  
     * <p>
     * @param CryptoServerCXI 
     * @param module ID 
     * @param subfunction code to call
     * @param I_SdkBuffer to receive/parse the result into if OK is returned
     * @return boolean - ok (0x0) otherwise invalid input/ser+deser errors
     * @throws IOException (CryptoServer not available)
     * @throws CryptoServerException (non-zero response from the CryptoServer
     * @throws DeserializationError if the result can not be deserialized by this recipient
     */
    public boolean exec (CryptoServerCXI cxi, int mid, int sfc, I_SdkBuffer recvr) throws IOException, CryptoServerException {
        if (cxi == null) {
            System.out.println("No CXI\n");
            return false;
        }
        if ((sfc < 0) || (sfc > 255)) { return false; }

        return exec(cxi, mid, sfc, this, recvr); // this variant tries to deserialize the response into another I_SdkBuffer
    }

    /**
     * Executes the command to the provided CryptoServer, using the
     * compiled in ModuleID and Sub-function code
     * <p>
     * This command may result in SerializationError or DeserializationError
     * events, but these are swallowed and returned as 'false'.
     * <p>
     * @param cxi - CryptoServerCXI for target HSM
     * @return boolean - ok (0x0) otherwise fail
     * @throws IOException (CryptoServer not available)
     * @throws CryptoServerException (non-zero response from the CryptoServer
     */
    public boolean exec (CryptoServerCXI _cxi) throws IOException, CryptoServerException {
        return exec(_cxi, ModuleID, SFC);
    }

    /**
     * Executes the command to the CryptoServer supplied on object
     * instantiation, using the compiled in ModuleID and Sub-function code
     * <p>
     * If this object was instantiated without a cxi object, returns
     * false.
     * <p>
     * This command may result in SerializationError or DeserializationError
     * events, but these are swallowed and returned as 'false'.
     * <p>
     * @return boolean - ok (0x0) otherwise fail
     * @throws IOException (CryptoServer not available)
     * @throws CryptoServerException (non-zero response from the CryptoServer
     */
    public boolean exec () throws IOException, CryptoServerException {
        return exec(cxi, ModuleID, SFC);
    }

    public byte [] serialize () throws SerializationError {
        int len = length();
        if (len == 0) { return new byte[0]; }
        try {
            ByteBuffer bb = ByteBuffer.allocate(len);
 			// this.flags of kind u4
            bb.putInt(this.flags);
 			// this.type of kind u4
            bb.putInt(this.type);
 			// this.key of kind v2
            if (this.key == null) {
                this.key = new byte[0];
            }
        bb.putShort((short)(this.key.length & 0xFFFF));
           	bb.put(this.key);

 			// this.msg of kind v4
            if (this.msg == null) {
                this.msg = new byte[0];
            }
        bb.putInt(this.msg.length);
           	bb.put(this.msg);

 			// this.ctxt of kind v1
            if (this.ctxt == null) {
                this.ctxt = new byte[0];
            }
            bb.put((byte)(this.ctxt.length & 0xFF)); 
           	bb.put(this.ctxt);

 			// this.state of kind v4
            if (this.state == null) {
                this.state = new byte[0];
            }
        bb.putInt(this.state.length);
           	bb.put(this.state);

 			// this.sig of kind v2
            if (this.sig == null) {
                this.sig = new byte[0];
            }
        bb.putShort((short)(this.sig.length & 0xFFFF));
           	bb.put(this.sig);

 
            return bb.array();
        } catch (Exception e) {
            throw new SerializationError();
        }
    }

	public void deserialize (byte [] bfr) throws DeserializationError {
		deserialize(bfr, true);
	}
	
    public void deserialize (byte [] bfr, boolean assumeExactLenBuffer) throws DeserializationError {
        if (bfr.length == 0) { return; }
        ByteBuffer bb = ByteBuffer.wrap(bfr);
        int len = 0;
        try {
 			// this.flags of kind u4
			this.flags = bb.getInt();
  			// this.type of kind u4
			this.type = bb.getInt();
  			// this.key of kind v2
			len = bb.getShort();
			this.key = new byte[len];
			bb.get(this.key, 0, len);
  			// this.msg of kind v4
			len = bb.getInt(); 
			this.msg = new byte[len];
			bb.get(this.msg, 0, len);
  			// this.ctxt of kind v1
			len = bb.get();
			this.ctxt = new byte[len];
			bb.get(this.ctxt, 0, len);
  			// this.state of kind v4
			len = bb.getInt(); 
			this.state = new byte[len];
			bb.get(this.state, 0, len);
  			// this.sig of kind v2
			len = bb.getShort();
			this.sig = new byte[len];
			bb.get(this.sig, 0, len);
  			return;
        } catch (Exception e) {
            throw new DeserializationError();
        } finally {
            if (bb.hasRemaining()) {
            	if (assumeExactLenBuffer) {
	            	throw new DeserializationError();
	            }
            }
        }
     }
        
    public int length () {
        int len = 0;
    
 		len += 4; // this.flags of kind u4

 		len += 4; // this.type of kind u4

 		len += 2; // this.key of kind v2
		len += this.key.length;

 		len += 4; // this.msg of kind v4
		len += this.msg.length;

 		len += 1; // this.ctxt of kind v1
		len += this.ctxt.length;

 		len += 4; // this.state of kind v4
		len += this.state.length;

 		len += 2; // this.sig of kind v2
		len += this.sig.length;

        return len;
    }

	/**
	 * 
	 * @return byte [] copy of response received from cxi.exec call (if available)
	 */
	public byte [] getResponse () {
		if (resp == null) { return null; }
		
		byte [] r = new byte[resp.length];
		System.arraycopy(resp,0,r,0,resp.length);
		return r;
	}
		
	// possible return values, based on module SFC responses for SFC using this as an interface
	/**
	 * Deserialize result into provided SdkBuffer container
	 *
	 * @param buffer (I_SdkBuffer)
	 * @result boolean success
	 */
	public boolean responseAs(I_SdkBuffer buffer) {
	    if (resp == null) { return false; }
	    try {
		    buffer.deserialize(resp);
		    return true;
		} catch (DeserializationError doops) {
		}
		return false;
    }

    public String toString() {
        // The 8 means only display the first 8 lines 
        // of the entirely serialized data
        return toString("com.utimaco.cs2.mdl.pqmi.MLDSA_Verify >", 8);
    }

    public String toString(String note, int maxInitialLines) {
        maxInitialLines++;
        if (this.length() == 0) { return note; }
        try {
            StringBuilder r = new StringBuilder(String.format("Serialized using: '%s'\n", pattern));
            r.append(xtrace(note, this.serialize()));
            String [] strings = r.toString().split("\\n");
            if (strings.length > maxInitialLines) {
                r.setLength(0);
                for (int i = 0; i < maxInitialLines; i++) { r.append(strings[i] + "\n"); }
                r.append("\t\t...\n");
            }

 			r.append(String.format("\nflags = %d\t\t(0x%0" + (4 * 2) + "x)", this.flags, this.flags));

 			r.append(String.format("\ntype = %d\t\t(0x%0" + (4 * 2) + "x)", this.type, this.type));

 			if (this.key == null) { 
				r.append("key = {NULL}"); 
			} else {
				r.append(String.format("\nkey = [Variable length field (v2) of length %d - (0x%x))", this.key.length, this.key.length));
                r.append("\n");
				r.append(xtrace(this.key, 4));
			}

 			if (this.msg == null) { 
				r.append("msg = {NULL}"); 
			} else {
				r.append(String.format("\nmsg = [Variable length field (v4) of length %d - (0x%x))", this.msg.length, this.msg.length));
                r.append("\n");
				r.append(xtrace(this.msg, 4));
			}

 			if (this.ctxt == null) { 
				r.append("ctxt = {NULL}"); 
			} else {
				r.append(String.format("\nctxt = [Variable length field (v1) of length %d - (0x%x))", this.ctxt.length, this.ctxt.length));
                r.append("\n");
				r.append(xtrace(this.ctxt, 4));
			}

 			if (this.state == null) { 
				r.append("state = {NULL}"); 
			} else {
				r.append(String.format("\nstate = [Variable length field (v4) of length %d - (0x%x))", this.state.length, this.state.length));
                r.append("\n");
				r.append(xtrace(this.state, 4));
			}

 			if (this.sig == null) { 
				r.append("sig = {NULL}"); 
			} else {
				r.append(String.format("\nsig = [Variable length field (v2) of length %d - (0x%x))", this.sig.length, this.sig.length));
                r.append("\n");
				r.append(xtrace(this.sig, 4));
			}

            r.append("\nUUID: " + hexAsciiHash(true) + "\n");
            r.append(String.format("\nTotal length of object: %d (0x%x)\n", length(), length()));

            return r.toString();
        } catch (Exception e) {
            e.printStackTrace();
        }
        return "com.utimaco.cs2.mdl.pqmi.MLDSA_Verify > exception in data.";
    }

    public String hexAsciiHash(boolean formatted) {
        StringBuilder sb = new StringBuilder("com.utimaco.cs2.mdl.pqmi.MLDSA_Verify");
            sb.append(pattern); 
            sb.append(this.flags).append(4);
            sb.append(this.type).append(4);
            if (this.key != null) { sb.append(new String(this.key)).append(this.key.length); }
            if (this.msg != null) { sb.append(new String(this.msg)).append(this.msg.length); }
            if (this.ctxt != null) { sb.append(new String(this.ctxt)).append(this.ctxt.length); }
            if (this.state != null) { sb.append(new String(this.state)).append(this.state.length); }
            if (this.sig != null) { sb.append(new String(this.sig)).append(this.sig.length); }

            return hexAsciiHash(sb.toString(), formatted);
    }   
}