package com.utimaco.cs2.mdl.pqmi;

/* 
 * 03c autogenerated 2024-04-01T16:12:59.7534143 using 
 * CS_SdkVpl version 0.0.5
 * Source XML Document version 01d,2024-03-26,riw
 * 
 * Copyright included by reference, please see Utimaco_Demo_License.txt
 */

import java.io.IOException;
import com.utimaco.cs2.mdl.I_SdkBuffer;
import CryptoServerAPI.CryptoServerException;
import CryptoServerCXI.CryptoServerCXI;
import java.nio.ByteBuffer;
import com.utimaco.cs2.mdl.SdkBuffer;
import com.utimaco.cs2.mdl.DeserializationError;
import com.utimaco.cs2.mdl.SerializationError;

// Typed parameters (if any)

/**
 * Pattern: u4v2v4v4v2
 *
 * Field declarations
 * <pre>
 * flags:  (u4) unsigned int[string]{}
 *   int               flags                          = (int)0x0;           // pqmi_FLAG_[INIT|CONT|FINALIZE] from  u4

 * pubkey:  (v2) unsigned short + ...[string]{}
 *   byte []           pubkey                         = new byte[0];        // //  v2

 * msg:  (v4) unsigned int + ...[string]{}
 *   byte []           msg                            = new byte[0];        // //  v4

 * sig:  (v4) unsigned int + ...[string]{}
 *   byte []           sig                            = new byte[0];        // //  v4

 * state:  (v2) unsigned short + ...[string]{}
 *   byte []           state                          = new byte[0];        // //  v2

 * </pre>
 * @author SFCBUFFERS
 *
 */
public class HbsVerify extends SdkBuffer implements I_SdkBuffer {
    int ModuleID = 0x087; // Default is 'echo' from ADM
    int SFC = 0; // Default is 'echo' from ADM
    protected static final String pattern = "u4v2v4v4v2"; 

    // Interface specific defined def elements

    // Interface Fields
    int flags = 0x0;
    byte [] pubkey = new byte[0];
    byte [] msg = new byte[0];
    byte [] sig = new byte[0];
    byte [] state = new byte[0];

    // Static constructor stubs.
    //
    // HbsVerify obj = new HbsVerify ();
    // HbsVerify obj = new HbsVerify (cxi); // does not exec
    // HbsVerify obj = new HbsVerify (cxi, _in); // does not exec
    // HbsVerify obj = new HbsVerify (_resp); // decompose buffer received elsewhere
    // 

    /** 
     * Instantiate a HbsVerify object (empty)
     */
    public HbsVerify () { super(); }

    /**
     * Instantiate a HbsVerify object, referencing an existing connection 
     * to a CryptoServer
     */
    public HbsVerify (CryptoServerCXI _cxi) {
      this();
      cxi = _cxi;
    }

    /**
     * Instantiate a HbsVerify object, referencing an existing connection 
     * to a CryptoServer, and targeting a specific Module/SFC
     */
    public HbsVerify (CryptoServerCXI _cxi, int mid, int sfc) {
      super(mid, sfc);
      cxi = _cxi;
    }

    /**
     * Instantiate a HbsVerify object, referencing an existing connection 
     * to a CryptoServer, and supplying the input values via deserializable
     * byte buffer.  
     */
    public HbsVerify (CryptoServerCXI _cxi, byte [] _in) {
      this(_cxi);
      try { deserialize(_in); }
      catch (DeserializationError e) { e.printStackTrace(); }
    }

    /**
     * Instantiate a HbsVerify object, without referencing a CryptoServer
     * This method deserializes a byte buffer that was received as the
     * response to an earlier issued command.
     */
    public HbsVerify (byte [] _resp) {
      this();
      try { deserialize(_resp); }
      catch (DeserializationError e) { e.printStackTrace(); }
    }

    /**
     * Additional Constructors based on the Interface definition
     */
    // Java "Normal"
    public HbsVerify ( 
        int _flags,
        byte [] _pubkey,
        byte [] _msg,
        byte [] _sig,
        byte [] _state

    ) {
        flags(_flags); 
        pubkey(_pubkey); 
        msg(_msg); 
        sig(_sig); 
        state(_state); 
    }

    // Java Object

    // Command setters/getters 
    public int      flags() { return flags; } 
    public void     flags (int      _in) { flags = _in; }
    public byte []  pubkey() { return pubkey; } 
    public void     pubkey (byte []  _in) { pubkey = _in; }
    public void     pubkeyFrom (byte []  _in) {
        pubkey = new byte[_in.length];
        System.arraycopy(_in, 0, pubkey, 0, _in.length);
    }
    public void     pubkey (String _in) {
        pubkey = _in.getBytes();
    }
    public byte []  msg() { return msg; } 
    public void     msg (byte []  _in) { msg = _in; }
    public void     msgFrom (byte []  _in) {
        msg = new byte[_in.length];
        System.arraycopy(_in, 0, msg, 0, _in.length);
    }
    public void     msg (String _in) {
        msg = _in.getBytes();
    }
    public byte []  sig() { return sig; } 
    public void     sig (byte []  _in) { sig = _in; }
    public void     sigFrom (byte []  _in) {
        sig = new byte[_in.length];
        System.arraycopy(_in, 0, sig, 0, _in.length);
    }
    public void     sig (String _in) {
        sig = _in.getBytes();
    }
    public byte []  state() { return state; } 
    public void     state (byte []  _in) { state = _in; }
    public void     stateFrom (byte []  _in) {
        state = new byte[_in.length];
        System.arraycopy(_in, 0, state, 0, _in.length);
    }
    public void     state (String _in) {
        state = _in.getBytes();
    }

    // Exec
    /**
     * Executes the command to the param-supplied CryptoServer, using
     * using the supplied ModuleID and Sub-function code.
     * <p>
     * This command may result in SerializationError or DeserializationError
     * events, but these are swallowed and returned as 'false'.
     * <p>
     * Note: The subfunction code only supports SFCs in the range 0..255.
     * <p>
     * @param CryptoServerCXI 
     * @param module ID 
     * @param subfunction code to call
     * @return boolean - ok (0x0) otherwise invalid input/ser+deser errors
     * @throws IOException (CryptoServer not available)
     * @throws CryptoServerException (non-zero response from the CryptoServer
     */
    public boolean exec (CryptoServerCXI cxi, int mid, int sfc) throws IOException, CryptoServerException {
        if (cxi == null) {
            System.out.println("No CXI\n");
            return false;
        }
        if ((sfc < 0) || (sfc > 255)) { return false; }

        return exec(cxi, mid, sfc, this, null); // this variant has no return value awareness, just stored
    }

    /**
     * Executes the command to the param-supplied CryptoServer, using
     * using the supplied ModuleID and Sub-function code.
     * <p>
     * This command may result in SerializationError or DeserializationError
     * events, but these are swallowed and returned as 'false'.
     * <p>
     * Note: The subfunction code only supports SFCs in the range 0..255.
     * <p>
     * If an I_SdkBuffer object is supplied as a recipient, and the response from 
     * the CryptoServer is OK, the result buffer will be handed to it and an attempt
     * to deserialize the result will happen.  
     * <p>
     * @param CryptoServerCXI 
     * @param module ID 
     * @param subfunction code to call
     * @param I_SdkBuffer to receive/parse the result into if OK is returned
     * @return boolean - ok (0x0) otherwise invalid input/ser+deser errors
     * @throws IOException (CryptoServer not available)
     * @throws CryptoServerException (non-zero response from the CryptoServer
     * @throws DeserializationError if the result can not be deserialized by this recipient
     */
    public boolean exec (CryptoServerCXI cxi, int mid, int sfc, I_SdkBuffer recvr) throws IOException, CryptoServerException {
        if (cxi == null) {
            System.out.println("No CXI\n");
            return false;
        }
        if ((sfc < 0) || (sfc > 255)) { return false; }

        return exec(cxi, mid, sfc, this, recvr); // this variant tries to deserialize the response into another I_SdkBuffer
    }

    /**
     * Executes the command to the provided CryptoServer, using the
     * compiled in ModuleID and Sub-function code
     * <p>
     * This command may result in SerializationError or DeserializationError
     * events, but these are swallowed and returned as 'false'.
     * <p>
     * @param cxi - CryptoServerCXI for target HSM
     * @return boolean - ok (0x0) otherwise fail
     * @throws IOException (CryptoServer not available)
     * @throws CryptoServerException (non-zero response from the CryptoServer
     */
    public boolean exec (CryptoServerCXI _cxi) throws IOException, CryptoServerException {
        return exec(_cxi, ModuleID, SFC);
    }

    /**
     * Executes the command to the CryptoServer supplied on object
     * instantiation, using the compiled in ModuleID and Sub-function code
     * <p>
     * If this object was instantiated without a cxi object, returns
     * false.
     * <p>
     * This command may result in SerializationError or DeserializationError
     * events, but these are swallowed and returned as 'false'.
     * <p>
     * @return boolean - ok (0x0) otherwise fail
     * @throws IOException (CryptoServer not available)
     * @throws CryptoServerException (non-zero response from the CryptoServer
     */
    public boolean exec () throws IOException, CryptoServerException {
        return exec(cxi, ModuleID, SFC);
    }

    public byte [] serialize () throws SerializationError {
        int len = length();
        if (len == 0) { return new byte[0]; }
        try {
            ByteBuffer bb = ByteBuffer.allocate(len);
 			// this.flags of kind u4
            bb.putInt(this.flags);
 			// this.pubkey of kind v2
            if (this.pubkey == null) {
                this.pubkey = new byte[0];
            }
        bb.putShort((short)(this.pubkey.length & 0xFFFF));
           	bb.put(this.pubkey);

 			// this.msg of kind v4
            if (this.msg == null) {
                this.msg = new byte[0];
            }
        bb.putInt(this.msg.length);
           	bb.put(this.msg);

 			// this.sig of kind v4
            if (this.sig == null) {
                this.sig = new byte[0];
            }
        bb.putInt(this.sig.length);
           	bb.put(this.sig);

 			// this.state of kind v2
            if (this.state == null) {
                this.state = new byte[0];
            }
        bb.putShort((short)(this.state.length & 0xFFFF));
           	bb.put(this.state);

 
            return bb.array();
        } catch (Exception e) {
            throw new SerializationError();
        }
    }

    public void deserialize (byte [] bfr) throws DeserializationError {
        if (bfr.length == 0) { return; }
        ByteBuffer bb = ByteBuffer.wrap(bfr);
        int len = 0;
        try {
 			// this.flags of kind u4
			this.flags = bb.getInt();
  			// this.pubkey of kind v2
			len = bb.getShort();
			this.pubkey = new byte[len];
			bb.get(this.pubkey, 0, len);
  			// this.msg of kind v4
			len = bb.getInt(); 
			this.msg = new byte[len];
			bb.get(this.msg, 0, len);
  			// this.sig of kind v4
			len = bb.getInt(); 
			this.sig = new byte[len];
			bb.get(this.sig, 0, len);
  			// this.state of kind v2
			len = bb.getShort();
			this.state = new byte[len];
			bb.get(this.state, 0, len);
  			return;
        } catch (Exception e) {
            throw new DeserializationError();
        } finally {
            if (bb.hasRemaining()) {
            	throw new DeserializationError();
            }
        }
     }
        
    public int length () {
        int len = 0;
    
 		len += 4; // this.flags of kind u4

 		len += 2; // this.pubkey of kind v2
		len += this.pubkey.length;

 		len += 4; // this.msg of kind v4
		len += this.msg.length;

 		len += 4; // this.sig of kind v4
		len += this.sig.length;

 		len += 2; // this.state of kind v2
		len += this.state.length;

        return len;
    }

	// possible return values, based on module SFC responses for SFC using this as an interface
	public boolean responseAs(I_SdkBuffer buffer) {
	    if (resp == null) { return false; }
	    try {
		    buffer.deserialize(resp);
		    return true;
		} catch (DeserializationError doops) {
		}
		return false;
    }

    public String toString() {
        // The 8 means only display the first 8 lines 
        // of the entirely serialized data
        return toString("com.utimaco.cs2.mdl.pqmi.HbsVerify >", 8);
    }

    public String toString(String note, int maxInitialLines) {
        maxInitialLines++;
        if (this.length() == 0) { return note; }
        try {
            StringBuilder r = new StringBuilder(String.format("Serialized using: '%s'\n", pattern));
            r.append(xtrace(note, this.serialize()));
            String [] strings = r.toString().split("\\n");
            if (strings.length > maxInitialLines) {
                r.setLength(0);
                for (int i = 0; i < maxInitialLines; i++) { r.append(strings[i] + "\n"); }
                r.append("\t\t...\n");
            }

 			r.append(String.format("\nflags = %d\t\t(0x%0" + (4 * 2) + "x)", this.flags, this.flags));

 			if (this.pubkey == null) { 
				r.append("pubkey = {NULL}"); 
			} else {
				r.append(String.format("\npubkey = [Variable length field (v2) of length %d - (0x%x))", this.pubkey.length, this.pubkey.length));
                r.append("\n");
				r.append(xtrace(this.pubkey, 4));
			}

 			if (this.msg == null) { 
				r.append("msg = {NULL}"); 
			} else {
				r.append(String.format("\nmsg = [Variable length field (v4) of length %d - (0x%x))", this.msg.length, this.msg.length));
                r.append("\n");
				r.append(xtrace(this.msg, 4));
			}

 			if (this.sig == null) { 
				r.append("sig = {NULL}"); 
			} else {
				r.append(String.format("\nsig = [Variable length field (v4) of length %d - (0x%x))", this.sig.length, this.sig.length));
                r.append("\n");
				r.append(xtrace(this.sig, 4));
			}

 			if (this.state == null) { 
				r.append("state = {NULL}"); 
			} else {
				r.append(String.format("\nstate = [Variable length field (v2) of length %d - (0x%x))", this.state.length, this.state.length));
                r.append("\n");
				r.append(xtrace(this.state, 4));
			}

            r.append("\nUUID: " + hexAsciiHash(true) + "\n");
            r.append(String.format("\nTotal length of object: %d (0x%x)\n", length(), length()));

            return r.toString();
        } catch (Exception e) {
            e.printStackTrace();
        }
        return "com.utimaco.cs2.mdl.pqmi.HbsVerify > exception in data.";
    }

    public String hexAsciiHash(boolean formatted) {
        StringBuilder sb = new StringBuilder("com.utimaco.cs2.mdl.pqmi.HbsVerify");
            sb.append(pattern); 
            sb.append(this.flags).append(4);
            if (this.pubkey != null) { sb.append(new String(this.pubkey)).append(this.pubkey.length); }
            if (this.msg != null) { sb.append(new String(this.msg)).append(this.msg.length); }
            if (this.sig != null) { sb.append(new String(this.sig)).append(this.sig.length); }
            if (this.state != null) { sb.append(new String(this.state)).append(this.state.length); }

            return SdkBuffer.hexAsciiHash(sb.toString(), formatted);
    }   
}