package com.utimaco.cs2.mdl.pqmi;

/* 
 * 03c autogenerated 2024-04-01T16:12:59.3024814 using 
 * CS_SdkVpl version 0.0.5
 * Source XML Document version 01d,2024-03-26,riw
 * 
 * Copyright included by reference, please see Utimaco_Demo_License.txt
 */

import java.io.IOException;
import com.utimaco.cs2.mdl.I_SdkBuffer;
import CryptoServerAPI.CryptoServerException;
import CryptoServerCXI.CryptoServerCXI;
import java.nio.ByteBuffer;
import com.utimaco.cs2.mdl.SdkBuffer;
import com.utimaco.cs2.mdl.DeserializationError;
import com.utimaco.cs2.mdl.SerializationError;

// Typed parameters (if any)
import com.utimaco.cs2.mdl.any.CxiKeyAttributes;

/**
 * Pattern: v2
 *
 * Field declarations
 * <pre>
 * basekey:  (v2) unsigned short + ...[string]{}
 *   byte []           basekey                        = new byte[0];        // // CxiKeyAttributes v2

 * </pre>
 * @author SFCBUFFERS
 *
 */
public class HbsPubkeyGet extends SdkBuffer implements I_SdkBuffer {
    int ModuleID = 0x087; // Default is 'echo' from ADM
    int SFC = 0; // Default is 'echo' from ADM
    protected static final String pattern = "v2"; 

    // Interface specific defined def elements

    // Interface Fields
    byte [] basekey = new byte[0];

    // Static constructor stubs.
    //
    // HbsPubkeyGet obj = new HbsPubkeyGet ();
    // HbsPubkeyGet obj = new HbsPubkeyGet (cxi); // does not exec
    // HbsPubkeyGet obj = new HbsPubkeyGet (cxi, _in); // does not exec
    // HbsPubkeyGet obj = new HbsPubkeyGet (_resp); // decompose buffer received elsewhere
    // 

    /** 
     * Instantiate a HbsPubkeyGet object (empty)
     */
    public HbsPubkeyGet () { super(); }

    /**
     * Instantiate a HbsPubkeyGet object, referencing an existing connection 
     * to a CryptoServer
     */
    public HbsPubkeyGet (CryptoServerCXI _cxi) {
      this();
      cxi = _cxi;
    }

    /**
     * Instantiate a HbsPubkeyGet object, referencing an existing connection 
     * to a CryptoServer, and targeting a specific Module/SFC
     */
    public HbsPubkeyGet (CryptoServerCXI _cxi, int mid, int sfc) {
      super(mid, sfc);
      cxi = _cxi;
    }

    /**
     * Instantiate a HbsPubkeyGet object, referencing an existing connection 
     * to a CryptoServer, and supplying the input values via deserializable
     * byte buffer.  
     */
    public HbsPubkeyGet (CryptoServerCXI _cxi, byte [] _in) {
      this(_cxi);
      try { deserialize(_in); }
      catch (DeserializationError e) { e.printStackTrace(); }
    }

    /**
     * Instantiate a HbsPubkeyGet object, without referencing a CryptoServer
     * This method deserializes a byte buffer that was received as the
     * response to an earlier issued command.
     */
    public HbsPubkeyGet (byte [] _resp) {
      this();
      try { deserialize(_resp); }
      catch (DeserializationError e) { e.printStackTrace(); }
    }

    /**
     * Additional Constructors based on the Interface definition
     */
    // Java "Normal" except if single field is byte[] which would conflict with above
    public HbsPubkeyGet ( 
        byte [] _basekey, boolean unused
    ) {
        basekey(_basekey); 
    }

    // Java Object
    public HbsPubkeyGet (
        CxiKeyAttributes _basekey
    ) throws SerializationError {
        basekey(_basekey.serialize());
    }

    // Command setters/getters 
    public byte []  basekey() { return basekey; } 
    public void     basekey (byte []  _in) { basekey = _in; }
    public void     basekeyFrom (byte []  _in) {
        basekey = new byte[_in.length];
        System.arraycopy(_in, 0, basekey, 0, _in.length);
    }
    public void     basekey (String _in) {
        basekey = _in.getBytes();
    }
    public void     basekey (CxiKeyAttributes _in) throws SerializationError {
        basekey = _in.serialize();
    }

    // Exec
    /**
     * Executes the command to the param-supplied CryptoServer, using
     * using the supplied ModuleID and Sub-function code.
     * <p>
     * This command may result in SerializationError or DeserializationError
     * events, but these are swallowed and returned as 'false'.
     * <p>
     * Note: The subfunction code only supports SFCs in the range 0..255.
     * <p>
     * @param CryptoServerCXI 
     * @param module ID 
     * @param subfunction code to call
     * @return boolean - ok (0x0) otherwise invalid input/ser+deser errors
     * @throws IOException (CryptoServer not available)
     * @throws CryptoServerException (non-zero response from the CryptoServer
     */
    public boolean exec (CryptoServerCXI cxi, int mid, int sfc) throws IOException, CryptoServerException {
        if (cxi == null) {
            System.out.println("No CXI\n");
            return false;
        }
        if ((sfc < 0) || (sfc > 255)) { return false; }

        return exec(cxi, mid, sfc, this, null); // this variant has no return value awareness, just stored
    }

    /**
     * Executes the command to the param-supplied CryptoServer, using
     * using the supplied ModuleID and Sub-function code.
     * <p>
     * This command may result in SerializationError or DeserializationError
     * events, but these are swallowed and returned as 'false'.
     * <p>
     * Note: The subfunction code only supports SFCs in the range 0..255.
     * <p>
     * If an I_SdkBuffer object is supplied as a recipient, and the response from 
     * the CryptoServer is OK, the result buffer will be handed to it and an attempt
     * to deserialize the result will happen.  
     * <p>
     * @param CryptoServerCXI 
     * @param module ID 
     * @param subfunction code to call
     * @param I_SdkBuffer to receive/parse the result into if OK is returned
     * @return boolean - ok (0x0) otherwise invalid input/ser+deser errors
     * @throws IOException (CryptoServer not available)
     * @throws CryptoServerException (non-zero response from the CryptoServer
     * @throws DeserializationError if the result can not be deserialized by this recipient
     */
    public boolean exec (CryptoServerCXI cxi, int mid, int sfc, I_SdkBuffer recvr) throws IOException, CryptoServerException {
        if (cxi == null) {
            System.out.println("No CXI\n");
            return false;
        }
        if ((sfc < 0) || (sfc > 255)) { return false; }

        return exec(cxi, mid, sfc, this, recvr); // this variant tries to deserialize the response into another I_SdkBuffer
    }

    /**
     * Executes the command to the provided CryptoServer, using the
     * compiled in ModuleID and Sub-function code
     * <p>
     * This command may result in SerializationError or DeserializationError
     * events, but these are swallowed and returned as 'false'.
     * <p>
     * @param cxi - CryptoServerCXI for target HSM
     * @return boolean - ok (0x0) otherwise fail
     * @throws IOException (CryptoServer not available)
     * @throws CryptoServerException (non-zero response from the CryptoServer
     */
    public boolean exec (CryptoServerCXI _cxi) throws IOException, CryptoServerException {
        return exec(_cxi, ModuleID, SFC);
    }

    /**
     * Executes the command to the CryptoServer supplied on object
     * instantiation, using the compiled in ModuleID and Sub-function code
     * <p>
     * If this object was instantiated without a cxi object, returns
     * false.
     * <p>
     * This command may result in SerializationError or DeserializationError
     * events, but these are swallowed and returned as 'false'.
     * <p>
     * @return boolean - ok (0x0) otherwise fail
     * @throws IOException (CryptoServer not available)
     * @throws CryptoServerException (non-zero response from the CryptoServer
     */
    public boolean exec () throws IOException, CryptoServerException {
        return exec(cxi, ModuleID, SFC);
    }

    public byte [] serialize () throws SerializationError {
        int len = length();
        if (len == 0) { return new byte[0]; }
        try {
            ByteBuffer bb = ByteBuffer.allocate(len);
 			// this.basekey of kind v2
            if (this.basekey == null) {
                this.basekey = new byte[0];
            }
        bb.putShort((short)(this.basekey.length & 0xFFFF));
           	bb.put(this.basekey);

 
            return bb.array();
        } catch (Exception e) {
            throw new SerializationError();
        }
    }

    public void deserialize (byte [] bfr) throws DeserializationError {
        if (bfr.length == 0) { return; }
        ByteBuffer bb = ByteBuffer.wrap(bfr);
        int len = 0;
        try {
 			// this.basekey of kind v2
			len = bb.getShort();
			this.basekey = new byte[len];
			bb.get(this.basekey, 0, len);
  			return;
        } catch (Exception e) {
            throw new DeserializationError();
        } finally {
            if (bb.hasRemaining()) {
            	throw new DeserializationError();
            }
        }
     }
        
    public int length () {
        int len = 0;
    
 		len += 2; // this.basekey of kind v2
		len += this.basekey.length;

        return len;
    }

    public byte [] getResponse() {
    	byte [] cpy = new byte[resp.length];
    	System.arraycopy(resp, 0, cpy, 0, resp.length);
    	return cpy;
    }

    // possible return values, based on module SFC responses for SFC using this as an interface
	public boolean responseAs(I_SdkBuffer buffer) {
	    if (resp == null) { return false; }
	    try {
		    buffer.deserialize(resp);
		    return true;
		} catch (DeserializationError doops) {
		}
		return false;
    }

    public String toString() {
        // The 8 means only display the first 8 lines 
        // of the entirely serialized data
        return toString("com.utimaco.cs2.mdl.pqmi.HbsPubkeyGet >", 8);
    }

    public String toString(String note, int maxInitialLines) {
        maxInitialLines++;
        if (this.length() == 0) { return note; }
        try {
            StringBuilder r = new StringBuilder(String.format("Serialized using: '%s'\n", pattern));
            r.append(xtrace(note, this.serialize()));
            String [] strings = r.toString().split("\\n");
            if (strings.length > maxInitialLines) {
                r.setLength(0);
                for (int i = 0; i < maxInitialLines; i++) { r.append(strings[i] + "\n"); }
                r.append("\t\t...\n");
            }

 			if (this.basekey == null) { 
				r.append("basekey = {NULL}"); 
			} else {
				r.append(String.format("\nbasekey = [Variable length field (v2) of length %d - (0x%x))", this.basekey.length, this.basekey.length));
                r.append("\n");
				r.append(xtrace(this.basekey, 4));
			}

            r.append("\nUUID: " + hexAsciiHash(true) + "\n");
            r.append(String.format("\nTotal length of object: %d (0x%x)\n", length(), length()));

            return r.toString();
        } catch (Exception e) {
            e.printStackTrace();
        }
        return "com.utimaco.cs2.mdl.pqmi.HbsPubkeyGet > exception in data.";
    }

    public String hexAsciiHash(boolean formatted) {
        StringBuilder sb = new StringBuilder("com.utimaco.cs2.mdl.pqmi.HbsPubkeyGet");
            sb.append(pattern); 
            if (this.basekey != null) { sb.append(new String(this.basekey)).append(this.basekey.length); }

            return SdkBuffer.hexAsciiHash(sb.toString(), formatted);
    }   
}