package com.utimaco.cs2.mdl.asy;

public class AsyEx extends Asy {
    public static final byte CMD_CREATE      = 'C'; // Create a new asynch task
    public static final byte CMD_RETRIEVE    = 'R'; // Retrieve the result of a completed task
    public static final byte CMD_POLL        = 'U'; // Poll to see if a task has completed
    public static final byte CMD_DELETE      = 'D'; // Delete a task
    public static final byte CMD_CANCEL      = 'X'; // Cancel a task
    public static final byte STATE_NONE      = ' '; // No State
    public static final byte STATE_INIT      = 'I'; // Initialized, not yet on ready queue
    public static final byte STATE_RUNNING   = 'R'; // Task is running
    public static final byte STATE_PENDED    = 'W'; // Waiting for resources
    public static final byte STATE_READY     = 'r'; // On ready queue, waiting for cycles
    public static final byte STATE_CLEANUP   = 'C'; // Task has finished and is performing internal cleanup
    public static final byte STATE_DONE_PASS = 'P'; // Task is complete. Ready for retrieval.
    public static final byte STATE_DONE_FAIL = 'F'; // Task can no longer continue due to preceding errors.
    
    public static int state(String stt) {
    	return (int)(stt.getBytes()[0]);
    }

	public static String stateToString(int state) {
		switch (state) {
		case STATE_NONE: return "  - None";
		case STATE_INIT: return "  - Initializing";
		case STATE_RUNNING: return "  - Running";
		case STATE_PENDED: return "  - Pended";
		case STATE_READY: return "  - Ready";
		case STATE_CLEANUP: return "  - Cleaning up";
		case STATE_DONE_PASS: return "  - Done - OK";
		case STATE_DONE_FAIL: return "  - Done - ERR";
		default:
			return "Invalid State";
		}
	}
	
}
