package com.utimaco.cs2.mdl.any;

/* 
 * 03c autogenerated 2024-11-06T12:45:01.2182582 using 
 * CS_SdkVpl version 0.0.6
 * Source XML Document version 01d,2024-03-26,riw
 * 
 * Copyright included by reference, please see Utimaco_Demo_License.txt
 *
 */

import com.utimaco.cs2.mdl.I_SdkBuffer;
import java.nio.ByteBuffer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import CryptoServerAPI.CryptoServerException;
import CryptoServerCXI.CryptoServerCXI;
import com.utimaco.cs2.mdl.SdkBuffer;
import com.utimaco.cs2.mdl.DeserializationError;
import com.utimaco.cs2.mdl.SerializationError;

// Typed parameters (if any)

/**
 * Pattern: u4v1v1u4u4u4u4v2
 *
 * Field declarations
 * <pre>
 * flags:  (u4) unsigned int {}
 *   int               flags                          = (int)0x0;           // Relevant fields from  u4

 * name:  (v1) unsigned byte + data  {}
 *   byte []           name                           = new byte[0];        // CXI Key Name//  v1
 * group:  (v1) unsigned byte + data  {}
 *   byte []           group                          = new byte[0];        // CXI Key Group//  v1
 * spec:  (u4) unsigned int {}
 *   int               spec                           = (int)0x0;           // CXI Key Specifier from  u4

 * algo:  (u4) unsigned int {}
 *   int               algo                           = (int)0x0;           // CXI Key Algorithm specifier from  u4

 * usage:  (u4) unsigned int {}
 *   int               usage                          = (int)0x0;           // CXI Key Usage specifier from  u4

 * export:  (u4) unsigned int {}
 *   int               export                         = (int)0x0;           // CXI Key Usage specifier from  u4

 * mdata:  (v2) unsigned short + data {}
 *   byte []           mdata                          = new byte[0];        // Additional non-CXI metadata//  v2

 * </pre>
 * @author SFCBUFFERS
 *
 */
public class CxiKeyAttributes extends SdkBuffer implements I_SdkBuffer {
    int ModuleID = 0x087; // Default is 'echo' from ADM
    int SFC = 0; // Default is 'echo' from ADM
    protected static final String pattern = "u4v1v1u4u4u4u4v2"; 

    // Interface specific defined def elements

    // Interface Fields
    int flags = 0x0;
    byte [] name = new byte[0];
    byte [] group = new byte[0];
    int spec = 0x0;
    int algo = 0x0;
    int usage = 0x0;
    int export = 0x0;
    byte [] mdata = new byte[0];

    // Static constructor stubs.
    //
    // CxiKeyAttributes obj = new CxiKeyAttributes ();
    // CxiKeyAttributes obj = new CxiKeyAttributes (cxi); // does not exec
    // CxiKeyAttributes obj = new CxiKeyAttributes (cxi, _in); // does not exec
    // CxiKeyAttributes obj = new CxiKeyAttributes (_resp); // decompose buffer received elsewhere
    // CxiKeyAttributes obj = new CxiKeyAttributes (_resp, boolean); // decompose buffer received elsewhere, which may be longer than expected
    //                                                     // if true, do not accept this and throw SerializationError
    //                                                     // if false, accept this and ignore remaining bytes
    // 

    /** 
     * Instantiate a CxiKeyAttributes object (empty)
     */
    public CxiKeyAttributes () { super(); }

    /**
     * Instantiate a CxiKeyAttributes object, referencing an existing connection 
     * to a CryptoServer
     */
    public CxiKeyAttributes (CryptoServerCXI _cxi) {
      this();
      cxi = _cxi;
    }

    /**
     * Instantiate a CxiKeyAttributes object, referencing an existing connection 
     * to a CryptoServer, and targeting a specific Module/SFC
     */
    public CxiKeyAttributes (CryptoServerCXI _cxi, int mid, int sfc) {
      super(mid, sfc);
      cxi = _cxi;
    }

    /**
     * Instantiate a CxiKeyAttributes object, referencing an existing connection 
     * to a CryptoServer, and supplying the input values via deserializable
     * byte buffer.  
     */
    public CxiKeyAttributes (CryptoServerCXI _cxi, byte [] _in) {
      this(_cxi);
      try { deserialize(_in); }
      catch (DeserializationError e) { e.printStackTrace(); }
    }

    /**
     * Instantiate a CxiKeyAttributes object, without referencing a CryptoServer
     * This method deserializes a byte buffer that was received as the
     * response to an earlier issued command.
     */
    public CxiKeyAttributes (byte [] _resp) {
    	this(_resp, true);
    }
    
    /**
     * Instantiate a CxiKeyAttributes object, without referencing a CryptoServer
     * This method deserializes a byte buffer that was received as the
     * response to an earlier issued command.  If there are remaining bytes
     * in the _resp array at the end of the interface deserialization, 
     * if assumeExactLenBuffer is true, throws SerializationError, else
     * does not throw.
     */
    public CxiKeyAttributes (byte [] _resp, boolean assumeExactLenBuffer) {
      this();
      try { deserialize(_resp, assumeExactLenBuffer); }
      catch (DeserializationError e) { e.printStackTrace(); }
    }

    /**
     * Additional Constructors based on the Interface definition
     */
    // Java "Normal"
    public CxiKeyAttributes ( 
        int _flags,
        byte [] _name,
        byte [] _group,
        int _spec,
        int _algo,
        int _usage,
        int _export,
        byte [] _mdata

    ) {
        flags(_flags); 
        name(_name); 
        group(_group); 
        spec(_spec); 
        algo(_algo); 
        usage(_usage); 
        export(_export); 
        mdata(_mdata); 
    }

    // Java Object

    // Command setters/getters 
    public int      flags() { return flags; } 
    public void     flags (int      _in) { flags = _in; }
    public byte []  name() { return name; } 
    public void     name (byte []  _in) { name = _in; }
    public void     nameFrom (byte []  _in) {
        name = new byte[_in.length];
        System.arraycopy(_in, 0, name, 0, _in.length);
    }
    public void     name (String _in) {
        name = _in.getBytes();
    }
    public byte []  group() { return group; } 
    public void     group (byte []  _in) { group = _in; }
    public void     groupFrom (byte []  _in) {
        group = new byte[_in.length];
        System.arraycopy(_in, 0, group, 0, _in.length);
    }
    public void     group (String _in) {
        group = _in.getBytes();
    }
    public int      spec() { return spec; } 
    public void     spec (int      _in) { spec = _in; }
    public int      algo() { return algo; } 
    public void     algo (int      _in) { algo = _in; }
    public int      usage() { return usage; } 
    public void     usage (int      _in) { usage = _in; }
    public int      export() { return export; } 
    public void     export (int      _in) { export = _in; }
    public byte []  mdata() { return mdata; } 
    public void     mdata (byte []  _in) { mdata = _in; }
    public void     mdataFrom (byte []  _in) {
        mdata = new byte[_in.length];
        System.arraycopy(_in, 0, mdata, 0, _in.length);
    }
    public void     mdata (String _in) {
        mdata = _in.getBytes();
    }

    // Exec
    /**
     * Executes the command to the param-supplied CryptoServer, using
     * using the supplied ModuleID and Sub-function code.
     * <p>
     * This command may result in SerializationError or DeserializationError
     * events, but these are swallowed and returned as 'false'.
     * <p>
     * Note: The subfunction code only supports SFCs in the range 0..255.
     * <p>
     * @param CryptoServerCXI 
     * @param module ID 
     * @param subfunction code to call
     * @return boolean - ok (0x0) otherwise invalid input/ser+deser errors
     * @throws IOException (CryptoServer not available)
     * @throws CryptoServerException (non-zero response from the CryptoServer
     */
    public boolean exec (CryptoServerCXI cxi, int mid, int sfc) throws IOException, CryptoServerException {
        if (cxi == null) {
            System.out.println("No CXI\n");
            return false;
        }
        if ((sfc < 0) || (sfc > 255)) { return false; }

        return exec(cxi, mid, sfc, this, null); // this variant has no return value awareness, just stored
    }

    /**
     * Executes the command to the param-supplied CryptoServer, using
     * using the supplied ModuleID and Sub-function code.
     * <p>
     * This command may result in SerializationError or DeserializationError
     * events, but these are swallowed and returned as 'false'.
     * <p>
     * Note: The subfunction code only supports SFCs in the range 0..255.
     * <p>
     * If an I_SdkBuffer object is supplied as a recipient, and the response from 
     * the CryptoServer is OK, the result buffer will be handed to it and an attempt
     * to deserialize the result will happen.  
     * <p>
     * @param CryptoServerCXI 
     * @param module ID 
     * @param subfunction code to call
     * @param I_SdkBuffer to receive/parse the result into if OK is returned
     * @return boolean - ok (0x0) otherwise invalid input/ser+deser errors
     * @throws IOException (CryptoServer not available)
     * @throws CryptoServerException (non-zero response from the CryptoServer
     * @throws DeserializationError if the result can not be deserialized by this recipient
     */
    public boolean exec (CryptoServerCXI cxi, int mid, int sfc, I_SdkBuffer recvr) throws IOException, CryptoServerException {
        if (cxi == null) {
            System.out.println("No CXI\n");
            return false;
        }
        if ((sfc < 0) || (sfc > 255)) { return false; }

        return exec(cxi, mid, sfc, this, recvr); // this variant tries to deserialize the response into another I_SdkBuffer
    }

    /**
     * Executes the command to the provided CryptoServer, using the
     * compiled in ModuleID and Sub-function code
     * <p>
     * This command may result in SerializationError or DeserializationError
     * events, but these are swallowed and returned as 'false'.
     * <p>
     * @param cxi - CryptoServerCXI for target HSM
     * @return boolean - ok (0x0) otherwise fail
     * @throws IOException (CryptoServer not available)
     * @throws CryptoServerException (non-zero response from the CryptoServer
     */
    public boolean exec (CryptoServerCXI _cxi) throws IOException, CryptoServerException {
        return exec(_cxi, ModuleID, SFC);
    }

    /**
     * Executes the command to the CryptoServer supplied on object
     * instantiation, using the compiled in ModuleID and Sub-function code
     * <p>
     * If this object was instantiated without a cxi object, returns
     * false.
     * <p>
     * This command may result in SerializationError or DeserializationError
     * events, but these are swallowed and returned as 'false'.
     * <p>
     * @return boolean - ok (0x0) otherwise fail
     * @throws IOException (CryptoServer not available)
     * @throws CryptoServerException (non-zero response from the CryptoServer
     */
    public boolean exec () throws IOException, CryptoServerException {
        return exec(cxi, ModuleID, SFC);
    }

    public byte [] serialize () throws SerializationError {
        int len = length();
        if (len == 0) { return new byte[0]; }
        try {
            ByteBuffer bb = ByteBuffer.allocate(len);
 			// this.flags of kind u4
            bb.putInt(this.flags);
 			// this.name of kind v1
            if (this.name == null) {
                this.name = new byte[0];
            }
            bb.put((byte)(this.name.length & 0xFF)); 
           	bb.put(this.name);

 			// this.group of kind v1
            if (this.group == null) {
                this.group = new byte[0];
            }
            bb.put((byte)(this.group.length & 0xFF)); 
           	bb.put(this.group);

 			// this.spec of kind u4
            bb.putInt(this.spec);
 			// this.algo of kind u4
            bb.putInt(this.algo);
 			// this.usage of kind u4
            bb.putInt(this.usage);
 			// this.export of kind u4
            bb.putInt(this.export);
 			// this.mdata of kind v2
            if (this.mdata == null) {
                this.mdata = new byte[0];
            }
        bb.putShort((short)(this.mdata.length & 0xFFFF));
           	bb.put(this.mdata);

 
            return bb.array();
        } catch (Exception e) {
            throw new SerializationError();
        }
    }

	public void deserialize (byte [] bfr) throws DeserializationError {
		deserialize(bfr, true);
	}
	
    public void deserialize (byte [] bfr, boolean assumeExactLenBuffer) throws DeserializationError {
        if (bfr.length == 0) { return; }
        ByteBuffer bb = ByteBuffer.wrap(bfr);
        int len = 0;
        try {
 			// this.flags of kind u4
			this.flags = bb.getInt();
  			// this.name of kind v1
			len = bb.get();
			this.name = new byte[len];
			bb.get(this.name, 0, len);
  			// this.group of kind v1
			len = bb.get();
			this.group = new byte[len];
			bb.get(this.group, 0, len);
  			// this.spec of kind u4
			this.spec = bb.getInt();
  			// this.algo of kind u4
			this.algo = bb.getInt();
  			// this.usage of kind u4
			this.usage = bb.getInt();
  			// this.export of kind u4
			this.export = bb.getInt();
  			// this.mdata of kind v2
			len = bb.getShort();
			this.mdata = new byte[len];
			bb.get(this.mdata, 0, len);
  			return;
        } catch (Exception e) {
            throw new DeserializationError();
        } finally {
            if (bb.hasRemaining()) {
            	if (assumeExactLenBuffer) {
	            	throw new DeserializationError();
	            }
            }
        }
     }
        
    public int length () {
        int len = 0;
    
 		len += 4; // this.flags of kind u4

 		len += 1; // this.name of kind v1
		len += this.name.length;

 		len += 1; // this.group of kind v1
		len += this.group.length;

 		len += 4; // this.spec of kind u4

 		len += 4; // this.algo of kind u4

 		len += 4; // this.usage of kind u4

 		len += 4; // this.export of kind u4

 		len += 2; // this.mdata of kind v2
		len += this.mdata.length;

        return len;
    }

	/**
	 * 
	 * @return byte [] copy of response received from cxi.exec call (if available)
	 */
	public byte [] getResponse () {
		if (resp == null) { return null; }
		
		byte [] r = new byte[resp.length];
		System.arraycopy(resp,0,r,0,resp.length);
		return r;
	}
		
	// possible return values, based on module SFC responses for SFC using this as an interface
	/**
	 * Deserialize result into provided SdkBuffer container
	 *
	 * @param buffer (I_SdkBuffer)
	 * @result boolean success
	 */
	public boolean responseAs(I_SdkBuffer buffer) {
	    if (resp == null) { return false; }
	    try {
		    buffer.deserialize(resp);
		    return true;
		} catch (DeserializationError doops) {
		}
		return false;
    }

    public String toString() {
        // The 8 means only display the first 8 lines 
        // of the entirely serialized data
        return toString("com.utimaco.cs2.mdl.any.CxiKeyAttributes >", 8);
    }

    public String toString(String note, int maxInitialLines) {
        maxInitialLines++;
        if (this.length() == 0) { return note; }
        try {
            StringBuilder r = new StringBuilder(String.format("Serialized using: '%s'\n", pattern));
            r.append(xtrace(note, this.serialize()));
            String [] strings = r.toString().split("\\n");
            if (strings.length > maxInitialLines) {
                r.setLength(0);
                for (int i = 0; i < maxInitialLines; i++) { r.append(strings[i] + "\n"); }
                r.append("\t\t...\n");
            }

 			r.append(String.format("\nflags = %d\t\t(0x%0" + (4 * 2) + "x)", this.flags, this.flags));

 			if (this.name == null) { 
				r.append("name = {NULL}"); 
			} else {
				r.append(String.format("\nname = [Variable length field (v1) of length %d - (0x%x))", this.name.length, this.name.length));
                r.append("\n");
				r.append(xtrace(this.name, 4));
			}

 			if (this.group == null) { 
				r.append("group = {NULL}"); 
			} else {
				r.append(String.format("\ngroup = [Variable length field (v1) of length %d - (0x%x))", this.group.length, this.group.length));
                r.append("\n");
				r.append(xtrace(this.group, 4));
			}

 			r.append(String.format("\nspec = %d\t\t(0x%0" + (4 * 2) + "x)", this.spec, this.spec));

 			r.append(String.format("\nalgo = %d\t\t(0x%0" + (4 * 2) + "x)", this.algo, this.algo));

 			r.append(String.format("\nusage = %d\t\t(0x%0" + (4 * 2) + "x)", this.usage, this.usage));

 			r.append(String.format("\nexport = %d\t\t(0x%0" + (4 * 2) + "x)", this.export, this.export));

 			if (this.mdata == null) { 
				r.append("mdata = {NULL}"); 
			} else {
				r.append(String.format("\nmdata = [Variable length field (v2) of length %d - (0x%x))", this.mdata.length, this.mdata.length));
                r.append("\n");
				r.append(xtrace(this.mdata, 4));
			}

            r.append("\nUUID: " + hexAsciiHash(true) + "\n");
            r.append(String.format("\nTotal length of object: %d (0x%x)\n", length(), length()));

            return r.toString();
        } catch (Exception e) {
            e.printStackTrace();
        }
        return "com.utimaco.cs2.mdl.any.CxiKeyAttributes > exception in data.";
    }

    public String hexAsciiHash(boolean formatted) {
        StringBuilder sb = new StringBuilder("com.utimaco.cs2.mdl.any.CxiKeyAttributes");
            sb.append(pattern); 
            sb.append(this.flags).append(4);
            if (this.name != null) { sb.append(new String(this.name)).append(this.name.length); }
            if (this.group != null) { sb.append(new String(this.group)).append(this.group.length); }
            sb.append(this.spec).append(4);
            sb.append(this.algo).append(4);
            sb.append(this.usage).append(4);
            sb.append(this.export).append(4);
            if (this.mdata != null) { sb.append(new String(this.mdata)).append(this.mdata.length); }

            return hexAsciiHash(sb.toString(), formatted);
    }   
}