package com.utimaco.cs2.mdl.any;

/* 
 * 03c autogenerated 2024-01-10T08:43:11.2483101 using 
 * CS_SdkVpl version 0.0.5
 * 
 * Copyright included by reference, please see Utimaco_Demo_License.txt
 * 
 * Heavily modified to agree with the modifications to make the BB correct per Utimaco definitions
 */

import java.io.IOException;
import com.utimaco.cs2.mdl.I_SdkBuffer;
import CryptoServerAPI.CryptoServerException;
import CryptoServerCXI.CryptoServerCXI;
import java.nio.ByteBuffer;
import com.utimaco.cs2.mdl.SdkBuffer;
import com.utimaco.cs2.mdl.DeserializationError;
import com.utimaco.cs2.mdl.SerializationError;

// Typed parameters (if any)

/**
 * Utimaco BB parser/assembler
 * 
 * Everything is TLV in 2-4-Len, so BB<len:4><data> and data is BI<len:4><info>PL<len:4><properties> etc
 * 
 * Blob types
 * BB<len:4>BI<len:4><info>PL<len:4><properties>[PK<len:4><public key>]IV<len:4><iv>[SK<len:4><secret key>]CV<len:4><checkvalue>
 * KB<len:4>PL<len:4><properties>[PK<len:4><public key>][SK<len:4><secret key>]CV<len:4><checkvalue>
 */
public class BackupBlob_ex extends SdkBuffer implements I_SdkBuffer {
    // Interface specific defined def elements
	private static final String pattern = "hand-coded";
	
    // Interface Fields
    byte [] info = new byte[0];
    byte [] pk = new byte[0];
    byte [] sk = new byte[0];
    byte [] iv = new byte[0];
    int c_properties = 0x0;
    int c_prop_max = 0x0;
    byte [] prop_head = new byte[0];

    // Static constructor stubs.
    //
    // BackupBlob obj = new BackupBlob ();
    // BackupBlob obj = new BackupBlob (cxi); // does not exec
    // BackupBlob obj = new BackupBlob (cxi, _in); // does not exec
    // BackupBlob obj = new BackupBlob (_resp); // decompose buffer received elsewhere
    // 

    /** 
     * Instantiate a BackupBlob object (empty)
     */
    public BackupBlob_ex () { super(); }

    /**
     * Instantiate a BackupBlob object, referencing an existing connection 
     * to a CryptoServer
     */
    public BackupBlob_ex (CryptoServerCXI _cxi) {
      this();
      cxi = _cxi;
    }

    /**
     * Instantiate a BackupBlob object, referencing an existing connection 
     * to a CryptoServer, and targeting a specific Module/SFC
     */
    public BackupBlob_ex (CryptoServerCXI _cxi, int mid, int sfc) {
      super(mid, sfc);
      cxi = _cxi;
    }

    /**
     * Instantiate a BackupBlob object, referencing an existing connection 
     * to a CryptoServer, and supplying the input values via deserializable
     * byte buffer.  
     */
    public BackupBlob_ex (CryptoServerCXI _cxi, byte [] _in) {
      this(_cxi);
      try { deserialize(_in); }
      catch (DeserializationError e) { e.printStackTrace(); }
    }

    /**
     * Instantiate a BackupBlob object, without referencing a CryptoServer
     * This method deserializes a byte buffer that was received as the
     * response to an earlier issued command.
     */
    public BackupBlob_ex (byte [] _resp) {
      this();
      try { deserialize(_resp); }
      catch (DeserializationError e) { e.printStackTrace(); }
    }

    /**
     * Additional Constructors based on the Interface definition
     */
    // Java "Normal"
    public BackupBlob_ex ( 
        byte [] _info,
        byte [] _pk,
        byte [] _sk,
        byte [] _iv,
        int _c_properties,
        int _c_prop_max,
        byte [] _prop_head

    ) {
        info(_info); 
        pk(_pk); 
        sk(_sk); 
        iv(_iv); 
        c_properties(_c_properties); 
        c_prop_max(_c_prop_max); 
        prop_head(_prop_head); 
    }

    // Java Object

    // Command setters/getters 
    public byte []  info() { return info; } 
    public void     info (byte []  _in) { info = _in; }
    public void     infoFrom (byte []  _in) {
        info = new byte[_in.length];
        System.arraycopy(_in, 0, info, 0, _in.length);
    }
    public void     info (String _in) {
        info = _in.getBytes();
    }
    public byte []  pk() { return pk; } 
    public void     pk (byte []  _in) { pk = _in; }
    public void     pkFrom (byte []  _in) {
        pk = new byte[_in.length];
        System.arraycopy(_in, 0, pk, 0, _in.length);
    }
    public void     pk (String _in) {
        pk = _in.getBytes();
    }
    public byte []  sk() { return sk; } 
    public void     sk (byte []  _in) { sk = _in; }
    public void     skFrom (byte []  _in) {
        sk = new byte[_in.length];
        System.arraycopy(_in, 0, sk, 0, _in.length);
    }
    public void     sk (String _in) {
        sk = _in.getBytes();
    }
    public byte []  iv() { return iv; } 
    public void     iv (byte []  _in) { iv = _in; }
    public void     ivFrom (byte []  _in) {
        iv = new byte[_in.length];
        System.arraycopy(_in, 0, iv, 0, _in.length);
    }
    public void     iv (String _in) {
        iv = _in.getBytes();
    }
    public int      c_properties() { return c_properties; } 
    public void     c_properties (int      _in) { c_properties = _in; }
    public int      c_prop_max() { return c_prop_max; } 
    public void     c_prop_max (int      _in) { c_prop_max = _in; }
    public byte []  prop_head() { return prop_head; } 
    public void     prop_head (byte []  _in) { prop_head = _in; }
    public void     prop_headFrom (byte []  _in) {
        prop_head = new byte[_in.length];
        System.arraycopy(_in, 0, prop_head, 0, _in.length);
    }
    public void     prop_head (String _in) {
        prop_head = _in.getBytes();
    }

    // Exec
    /**
     * Executes the command to the param-supplied CryptoServer, using
     * using the supplied ModuleID and Sub-function code.
     * <p>
     * This command may result in SerializationError or DeserializationError
     * events, but these are swallowed and returned as 'false'.
     * <p>
     * Note: The subfunction code only supports SFCs in the range 0..255.
     * <p>
     * @param CryptoServerCXI 
     * @param module ID 
     * @param subfunction code to call
     * @return boolean - ok (0x0) otherwise invalid input/ser+deser errors
     * @throws IOException (CryptoServer not available)
     * @throws CryptoServerException (non-zero response from the CryptoServer
     */
    public boolean exec (CryptoServerCXI cxi, int mid, int sfc) throws IOException, CryptoServerException {
        if (cxi == null) {
            System.out.println("No CXI\n");
            return false;
        }
        if ((sfc < 0) || (sfc > 255)) { return false; }

        return exec(cxi, mid, sfc, this, null); // this variant has no return value awareness, just stored
    }

    /**
     * Executes the command to the param-supplied CryptoServer, using
     * using the supplied ModuleID and Sub-function code.
     * <p>
     * This command may result in SerializationError or DeserializationError
     * events, but these are swallowed and returned as 'false'.
     * <p>
     * Note: The subfunction code only supports SFCs in the range 0..255.
     * <p>
     * If an I_SdkBuffer object is supplied as a recipient, and the response from 
     * the CryptoServer is OK, the result buffer will be handed to it and an attempt
     * to deserialize the result will happen.  
     * <p>
     * @param CryptoServerCXI 
     * @param module ID 
     * @param subfunction code to call
     * @param I_SdkBuffer to receive/parse the result into if OK is returned
     * @return boolean - ok (0x0) otherwise invalid input/ser+deser errors
     * @throws IOException (CryptoServer not available)
     * @throws CryptoServerException (non-zero response from the CryptoServer
     * @throws DeserializationError if the result can not be deserialized by this recipient
     */
    public boolean exec (CryptoServerCXI cxi, int mid, int sfc, I_SdkBuffer recvr) throws IOException, CryptoServerException {
        if (cxi == null) {
            System.out.println("No CXI\n");
            return false;
        }
        if ((sfc < 0) || (sfc > 255)) { return false; }

        return exec(cxi, mid, sfc, this, recvr); // this variant tries to deserialize the response into another I_SdkBuffer
    }

    /**
     * Executes the command to the provided CryptoServer, using the
     * compiled in ModuleID and Sub-function code
     * <p>
     * This command may result in SerializationError or DeserializationError
     * events, but these are swallowed and returned as 'false'.
     * <p>
     * @param cxi - CryptoServerCXI for target HSM
     * @return boolean - ok (0x0) otherwise fail
     * @throws IOException (CryptoServer not available)
     * @throws CryptoServerException (non-zero response from the CryptoServer
     */
    public boolean exec (CryptoServerCXI _cxi) throws IOException, CryptoServerException {
        return exec(_cxi, ModuleID, SFC);
    }

    /**
     * Executes the command to the CryptoServer supplied on object
     * instantiation, using the compiled in ModuleID and Sub-function code
     * <p>
     * If this object was instantiated without a cxi object, returns
     * false.
     * <p>
     * This command may result in SerializationError or DeserializationError
     * events, but these are swallowed and returned as 'false'.
     * <p>
     * @return boolean - ok (0x0) otherwise fail
     * @throws IOException (CryptoServer not available)
     * @throws CryptoServerException (non-zero response from the CryptoServer
     */
    public boolean exec () throws IOException, CryptoServerException {
        return exec(cxi, ModuleID, SFC);
    }

    public byte [] serialize () throws SerializationError {
        int len = length();
        if (len == 0) { return new byte[0]; }
        try {
            ByteBuffer bb = ByteBuffer.allocate(len);
 			// this.info of kind v2
            if (this.info == null) {
                this.info = new byte[0];
            }
        bb.putShort((short)(this.info.length & 0xFFFF));
           	bb.put(this.info);

 			// this.pk of kind v2
            if (this.pk == null) {
                this.pk = new byte[0];
            }
        bb.putShort((short)(this.pk.length & 0xFFFF));
           	bb.put(this.pk);

 			// this.sk of kind v2
            if (this.sk == null) {
                this.sk = new byte[0];
            }
        bb.putShort((short)(this.sk.length & 0xFFFF));
           	bb.put(this.sk);

 			// this.iv of kind v1
            if (this.iv == null) {
                this.iv = new byte[0];
            }
            bb.put((byte)(this.iv.length & 0xFF)); 
           	bb.put(this.iv);

 			// this.c_properties of kind u4
            bb.putInt(this.c_properties);
 			// this.c_prop_max of kind u4
            bb.putInt(this.c_prop_max);
 			// this.prop_head of kind *
            if (this.prop_head == null) {
                this.prop_head = new byte[0];
            }
           	bb.put(this.prop_head);

 
            return bb.array();
        } catch (Exception e) {
            throw new SerializationError();
        }
    }

    public void deserialize (byte [] bfr) throws DeserializationError {
        if (bfr.length == 0) { return; }
        ByteBuffer bb = ByteBuffer.wrap(bfr);
        int len = 0;
        try {
 			// this.info of kind v2
			len = bb.getShort();
			this.info = new byte[len];
			bb.get(this.info, 0, len);
  			// this.pk of kind v2
			len = bb.getShort();
			this.pk = new byte[len];
			bb.get(this.pk, 0, len);
  			// this.sk of kind v2
			len = bb.getShort();
			this.sk = new byte[len];
			bb.get(this.sk, 0, len);
  			// this.iv of kind v1
			len = bb.get();
			this.iv = new byte[len];
			bb.get(this.iv, 0, len);
  			// this.c_properties of kind u4
			this.c_properties = bb.getInt();
  			// this.c_prop_max of kind u4
			this.c_prop_max = bb.getInt();
  			// this.prop_head of kind *
			len = bb.remaining();
			this.prop_head = new byte[len];
			bb.get(this.prop_head, 0, this.prop_head.length);
  			return;
        } catch (Exception e) {
            throw new DeserializationError();
        } finally {
            if (bb.hasRemaining()) {
            	throw new DeserializationError();
            }
        }
     }
        
    public int length () {
        int len = 0;
    
 		len += 2; // this.info of kind v2
		len += this.info.length;

 		len += 2; // this.pk of kind v2
		len += this.pk.length;

 		len += 2; // this.sk of kind v2
		len += this.sk.length;

 		len += 1; // this.iv of kind v1
		len += this.iv.length;

 		len += 4; // this.c_properties of kind u4

 		len += 4; // this.c_prop_max of kind u4

 		len += this.prop_head.length; // this.prop_head of kind *

        return len;
    }

	// possible return values, based on module SFC responses for SFC using this as an interface
	public boolean responseAs(I_SdkBuffer buffer) {
	    if (resp == null) { return false; }
	    try {
		    buffer.deserialize(resp);
		    return true;
		} catch (DeserializationError doops) {
		}
		return false;
    }

    public String toString() {
        // The 8 means only display the first 8 lines 
        // of the entirely serialized data
        return toString("com.utimaco.cs2.mdl.any.BackupBlob >", 8);
    }

    public String toString(String note, int maxInitialLines) {
        maxInitialLines++;
        if (this.length() == 0) { return note; }
        try {
            StringBuilder r = new StringBuilder(String.format("Serialized using: '%s'\n", pattern));
            r.append(xtrace(note, this.serialize()));
            String [] strings = r.toString().split("\\n");
            if (strings.length > maxInitialLines) {
                r.setLength(0);
                for (int i = 0; i < maxInitialLines; i++) { r.append(strings[i] + "\n"); }
                r.append("\t\t...\n");
            }

 			if (this.info == null) { 
				r.append("info = {NULL}"); 
			} else {
				r.append(String.format("\ninfo = [Variable length field (v2) of length %d - (0x%x))", this.info.length, this.info.length));
                r.append("\n");
				r.append(xtrace(this.info, 4));
			}

 			if (this.pk == null) { 
				r.append("pk = {NULL}"); 
			} else {
				r.append(String.format("\npk = [Variable length field (v2) of length %d - (0x%x))", this.pk.length, this.pk.length));
                r.append("\n");
				r.append(xtrace(this.pk, 4));
			}

 			if (this.sk == null) { 
				r.append("sk = {NULL}"); 
			} else {
				r.append(String.format("\nsk = [Variable length field (v2) of length %d - (0x%x))", this.sk.length, this.sk.length));
                r.append("\n");
				r.append(xtrace(this.sk, 4));
			}

 			if (this.iv == null) { 
				r.append("iv = {NULL}"); 
			} else {
				r.append(String.format("\niv = [Variable length field (v1) of length %d - (0x%x))", this.iv.length, this.iv.length));
                r.append("\n");
				r.append(xtrace(this.iv, 4));
			}

 			r.append(String.format("\nc_properties = %d\t\t(0x%0" + (4 * 2) + "x)", this.c_properties, this.c_properties));

 			r.append(String.format("\nc_prop_max = %d\t\t(0x%0" + (4 * 2) + "x)", this.c_prop_max, this.c_prop_max));

 			if (this.prop_head == null) { 
				r.append("prop_head = {NULL}"); 
			} else {
				r.append(String.format("\nprop_head = [Bulk Data (*)]"));
                r.append("\n");
				r.append(xtrace(this.prop_head, 4));
			}

            r.append("\nUUID: " + hexAsciiHash(true) + "\n");
            r.append(String.format("\nTotal length of object: %d (0x%x)\n", length(), length()));

            return r.toString();
        } catch (Exception e) {
            e.printStackTrace();
        }
        return "com.utimaco.cs2.mdl.any.BackupBlob > exception in data.";
    }

    public String hexAsciiHash(boolean formatted) {
        StringBuilder sb = new StringBuilder("com.utimaco.cs2.mdl.any.BackupBlob");
            sb.append(pattern); 
            if (this.info != null) { sb.append(new String(this.info)).append(this.info.length); }
            if (this.pk != null) { sb.append(new String(this.pk)).append(this.pk.length); }
            if (this.sk != null) { sb.append(new String(this.sk)).append(this.sk.length); }
            if (this.iv != null) { sb.append(new String(this.iv)).append(this.iv.length); }
            sb.append(this.c_properties).append(4);
            sb.append(this.c_prop_max).append(4);
            if (this.prop_head != null) { sb.append(new String(this.prop_head)).append(this.prop_head.length); }

            return SdkBuffer.hexAsciiHash(sb.toString(), formatted);
    }   
}