package com.utimaco.cs2.mdl.any;

/* 
 * CS_SdkVpl version 0.0.5
 * 
 * Copyright included by reference, please see Utimaco_Demo_License.txt
 */

import com.utimaco.cs2.mdl.ErrList;

public class AnyErrorList extends ErrList {
    private static final int MID = 0x100; // not used
    
    public static final int E_EXMP_SERIALIZATION =      (0xB0000000 + (MID << 16) + 0x0E00);    
    public static final int E_EXMP_NOT_IMPLEMENTED =    (0xB0000000 + (MID << 16) + 0x0A21);    
    public static final int E_EXMP_NOT_SUPPORTED =      (0xB0000000 + (MID << 16) + 0x0A22);    
    public static final int E_EXMP_PERMISSION_DENIED =  (0xB0000000 + (MID << 16) + 0x0001);    
    public static final int E_EXMP_PARAM =              (0xB0000000 + (MID << 16) + 0x0002);    
    public static final int E_EXMP_PARAM_LEN =          (0xB0000000 + (MID << 16) + 0x0003);    
    public static final int E_EXMP_MALLOC =             (0xB0000000 + (MID << 16) + 0x0004);    
    public static final int E_EXMP_MODE =               (0xB0000000 + (MID << 16) + 0x0005);    
    public static final int E_EXMP_ITEM_NOT_FOUND =     (0xB0000000 + (MID << 16) + 0x0006);    
    public static final int E_EXMP_MODULE_DEP =         (0xB0000000 + (MID << 16) + 0x0007);    
    public static final int E_EXMP_FILE_IO =            (0xB0000000 + (MID << 16) + 0x0008);    
    public static final int E_EXMP_B_EXMP_UNK_KIND =   (0xB0000000 + (MID << 16) + 0x0010);    
    
    public AnyErrorList () {
    	super(MID, "EXMP");
        int module = 0xB0000000 + (MID << 16);

		push(module + 0x0E00, "SERIALIZATION", "buffer martialing error"); 
		push(module + 0x0A21, "NOT_IMPLEMENTED", "function not implemented or is deprecated/removed"); 
		push(module + 0x0A22, "NOT_SUPPORTED", "method/mode/algo/keysize/etc not supported"); 
		push(module + 0x0001, "PERMISSION_DENIED", "permission denied"); 
		push(module + 0x0002, "PARAM", "unexpected param"); 
		push(module + 0x0003, "PARAM_LEN", "param len invalid"); 
		push(module + 0x0004, "MALLOC", "memory allocation error"); 
		push(module + 0x0005, "MODE", "selected mode invalid"); 
		push(module + 0x0006, "ITEM_NOT_FOUND", "item not found"); 
		push(module + 0x0007, "MODULE_DEP", "module dependency not met"); 
		push(module + 0x0008, "FILE_IO", "file IO error"); 
    }
}
