package com.utimaco.cs2.mdl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;

public class ErrList {
	private static final int ID  =0;
	private static final int NAME=1;
	private static final int CMNT=2;
	public static final ConcurrentHashMap<Integer, ArrayList<String>> errlist = new ConcurrentHashMap<>();
	private static final String note = "Use csadm PrintErr";
	
	private static ArrayList<String> popAList(long id, String name, String cmnt) {
		if ((id >= 0) && (id <= 0xFFF)) { 
			id = (id<<16); 
		}
		ArrayList<String> tals = new ArrayList<String>();
		String mid = "0x" + String.format("%08x",  id).replace("ffffffff", "").toUpperCase();
		tals.addAll(Arrays.asList(mid, name, cmnt));
		return tals;
	}
	public ErrList() { 
		if (errlist.size() == 0) {
			errlist.put(0x000, popAList(0x0, "SMOS ", note));
			errlist.put(0x00A, popAList(0x0, "HCE ", note));
			errlist.put(0x00d, popAList(0x0, "EXAR ", note));
			errlist.put(0x050, popAList(0x0, "PK ", note));
			errlist.put(0x061, popAList(0x0, "CTS ", note));
			errlist.put(0x068, popAList(0x0, "CXI ", note));
			errlist.put(0x081, popAList(0x0, "VDES ", note));
			errlist.put(0x082, popAList(0x0, "PP ", note));
			errlist.put(0x083, popAList(0x0, "CMDS ", note));
			errlist.put(0x084, popAList(0x0, "VRSA ", note));
			errlist.put(0x085, popAList(0x0, "SC ", note));
			errlist.put(0x086, popAList(0x0, "UTIL ", note));
			errlist.put(0x087, popAList(0x0, "ADM ", note));
			errlist.put(0x088, popAList(0x0, "DB ", note));
			errlist.put(0x089, popAList(0x0, "HASH ", note));
			errlist.put(0x08b, popAList(0x0, "AES ", note));
			errlist.put(0x08d, popAList(0x0, "DSA ", note));
			errlist.put(0x08e, popAList(0x0, "LNA ", note));
			errlist.put(0x08f, popAList(0x0, "ECA ", note));
			errlist.put(0x091, popAList(0x0, "ASN1 ", note));
			errlist.put(0x096, popAList(0x0, "MBK ", note));
			errlist.put(0x09a, popAList(0x0, "NTP ", note));
			errlist.put(0x09c, popAList(0x0, "ECDSA ", note));
			errlist.put(0x0f5, popAList(0x0, "VDX ", note));

			// A few of the more common annoyances you are likely to see.  Add others here if you want.
			push(0xB083000c, "", "Bad format of command block");
			
		}

	}
	public ErrList(int mid, String mname) {
		this();
		errlist.put(mid, popAList(mid, mname, ""));
	}
	public ErrList(int mid, String mname, String cmnt) {
		this();
		errlist.put(mid, popAList(mid, mname, cmnt));
	}

	public static boolean push(int eid, String etxt, String cmnttxt) {
		boolean res = true;
		if (errlist.containsKey(eid)) {
			System.err.format("com.utimaco.cs2.mdl.errlist overloaded: 0x%x has %s, now %s.\n", eid, errlist.get(eid), etxt);
			res = false;
		}
		errlist.put(eid, popAList(eid, etxt, cmnttxt));
		return res;
	}

	public static String errtext(int eid) {
		int mid = (eid & 0x0FFF0000) >> 16; // strip the '8', leave the MID
		ArrayList<String> tal = errlist.get(eid);
		ArrayList<String> mal = errlist.get(mid);
		if (tal == null) {
			tal = errlist.get(mid);
		}
		if (mal == null) {
			return "Module not registered";
		}
		if (tal != null) {
			String cmnt = tal.get(CMNT);
			if (cmnt.compareTo(note)==0) {
				cmnt = String.format("%s=0x%08X", cmnt, eid);
			}
			String txt = (tal.get(ID).compareTo("00000000") == 0) ? tal.get(ID) : String.format("0x%08X", eid);
			return String.format("CryptoServer Error %s:\n\tModule %s\n\t%s", txt, mal.get(NAME), cmnt);
		}
		return String.format("Error 0x%08X not registered in module %s (%0x03X))\n", eid, mal.get(NAME), mid);
	}
}
