package com.utimaco.cs2.mdl;

import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public abstract class CmdsPattern {
    public static final int STANDALONE_BUFFER = 0x0;
    static final String tab = "  ";

    public abstract int     length ();

    protected CmdsPattern () {}

    /************** Helpers **************/
    static public byte [] maxLenByteArray(String _in, int maxlen) {
        return maxLenByteArray(_in.getBytes(), maxlen);
    }

    static public byte [] maxLenByteArray(byte [] _in, int maxlen) {
        byte [] ret = new byte[maxlen];
        for (int i = 0; i < maxlen; i++) {
            if (i < _in.length) { ret[i] = _in[i]; }
            else ret[i] = (byte)0x0;
        }
        return ret;
    }

    public static String xtrace(byte[] array, int maxCountToDisplay) {
        String res = xtrace("", array);
        String [] strings = res.split("\\n");
        StringBuilder sb = new StringBuilder();
        if (strings.length > 0) {
            for (int i = 1; i < Math.min(maxCountToDisplay, strings.length); i++) {
                sb.append(strings[i] + "\n");
            }
        }
        return sb.toString().substring(0, sb.toString().length()-1);
    }

    public static String xtrace(String note, byte[] data) {
        StringBuilder sb = new StringBuilder();
        StringBuilder se = new StringBuilder();
        sb.append(note + ": \n"+tab+"00: ");
        int i = 0;
        while (i < data.length) {
            if ((i > 8) && (i % 16 == 0)) {
                sb.append(" [ " + se.toString().substring(0, 17) + " ]\n");
                sb.append(tab+Integer.toHexString(i)+": ");
                se.setLength(0);
            }
            String s = Integer.toHexString(data[i] & 0xFF);
            switch (s.length()) {
            case 0: s = "00"; break;
            case 1: s = "0" + s; break;
            }
            sb.append(s);
            if ((data[i] > 0x1F) && (data[i] < 0x7F)) {
                byte [] db = { data[i] }; /* new byte[1];
                db[0] = data[i]; */
                s = new String(db, Charset.forName("ASCII"));
                se.append(s);
            } else {
                se.append(".");
            }
            if (i % 8 == 7) { sb.append(" "); se.append(" "); }
            i++;
        }
        while (i % 16 != 0) {
            sb.append("  ");
            if (i % 8 == 7) { sb.append(" "); }
            i++;
        }
        String trail = (se.toString() + "                  ").substring(0, 17);
        sb.append(" [ " + trail +" ]\n");

        return sb.toString();
    }

    public static String hexAsciiHash(String string) { return hexAsciiHash(string, true); }
    public static String hexAsciiHash(String string, boolean format) {
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("SHA-256");
        } catch (NoSuchAlgorithmException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
        if (md != null) {
            byte [] ret = md.digest(string.getBytes());
            String hex = Utils.convertToHex(ret, false);
            if (format) {
                StringBuilder sb = new StringBuilder();
                int [] ptrn = {8,4,8,12};
                int rn = 0;
                for (int i = 0; i < (ptrn.length-1); i++) {
                    sb.append(hex.substring(rn, rn+ptrn[i])).append("-");
                    rn += ptrn[i];
                }
                sb.append(hex.substring(rn, rn+ptrn[(ptrn.length-1)]));
                int rfcchar = ptrn[0] + 1;
                sb.replace(rfcchar, rfcchar+1, "5");
                hex = sb.toString();
            }
            return hex;
        }
        return null;
    }

}

