package com.utimaco;

import java.util.ArrayList;

public class SimpleArgs {
	String [] args;
	
	public SimpleArgs(String [] a) {
		this.args = a;
	}
	public SimpleArgs(SimpleArgs in) {
		String [] args = in.params();
		String [] cpy = new String[args.length];
		System.arraycopy(args, 0, cpy, 0, args.length);
	}
	
	public String [] setArg (String arg, String val) {

		// look for arg, if not there, add it
		boolean hasit = false;
		for (int i = 0; i < args.length; i++) {
			if (args[i].compareTo(arg) == 0) {
				++i;
				args[i] = val == null ? "" : val;
				hasit = true;
				break;
			}
		}
		if (!hasit) {
			ArrayList<String> ret = new ArrayList<>();
			for (int i = 0; i < args.length; i++) {
				ret.add(args[i]);
			}
			ret.add(arg);
			ret.add(val == null ? "" : val);
			args = new String[ret.size()];
			args = ret.toArray(args);			
		}
		return args;
	}

	public int getArg (String arg, int def) {
		if (arg.contains(":")) {
			String [] splarg = arg.split(":");
			for (String a : splarg) {
				if (hasArg(a)) {
					return (getArg(a, def));
				}
			}
			return def;
		}
		
		String res = getArg(arg, Integer.toString(def));
		int base = 10;
		if (res.toUpperCase().indexOf("0X") == 0) {
			base = 16;
			res = res.substring(2);
		}
		return Integer.parseInt(res, base);
	}

	public String getArg (String arg, String def) {
		if (arg.contains(":")) {
			String [] splarg = arg.split(":");
			for (String a : splarg) {
				if (hasArg(a)) {
					return (getArg(a, def));
				}
			}
			return def;
		}
		
		boolean getnext = false;
		for (String a : args) {
			if (getnext) {
				return a;
			}
			if (a.compareTo(arg) == 0) {
				getnext = true;
			}
			if (a.compareTo("-" + arg) == 0) {  // 01d
				getnext = true;	       // 01d
			}			       // 01d
		}
		return def;
	}

	public byte[] getArg (String arg, byte[] bytes) {
		String inv = getArg(arg, new String(bytes));
		return inv.getBytes();
	}

	public boolean hasArg (String arg) {
		if (arg.contains(":")) {
			String [] splarg = arg.split(":");
			for (String a : splarg) {
				if (hasArg(a)) { return true; }
			}
			return false;
		}
		
		for (String a : args) {
			if (a.compareTo(arg) == 0) {
				return true;
			}
			if (a.compareTo("-" + arg) == 0) {  // 01d
				return true;		  // 01d
			}			       // 01d
		}
		return false;
	}

	public String[] params() {
		return args;
	}
}
