package com.utimaco;

/* 
 * 03c autogenerated 2024-01-08T10:52:06.1294572 using 
 * CS_SdkVpl version 0.0.5
 * 
 * Copyright included by reference, please see Utimaco_Demo_License.txt
 */

import java.io.File;
// import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;

import CryptoServerAPI.CryptoServerException;
import CryptoServerCXI.CryptoServerCXI;

import com.utimaco.aut.AutTest;
import com.utimaco.aut.DilithiumTest;
import com.utimaco.aut.KeystoreTest;
import com.utimaco.aut.KyberTest;
import com.utimaco.aut.MLDSATest;
import com.utimaco.aut.MLKEMTest;
import com.utimaco.aut.XmssTest;
import com.utimaco.cs2.mdl.*;
import com.utimaco.cs2.mdl.pqmi.Pqmi;
import com.utimaco.cs2.mdl.pqmi.PqmiErrorList;

public class GenerateOneKeyForEach {
	static final Random r = new Random();
	static int module_id = 0xa6; //

	// if adding an enum to AUT ...
	static enum AUT { DILITHIUM, MLDSA, KYBER, MLKEM, LMS, HSS, XMSS, KEYSTORE };
	// ... add a false to the end of this list
	static final boolean [] TESTS = { false, false, false, false, false, false, false, false };

	static boolean dbg = true;

	static GenerateOneKeyForEach _singleton = new GenerateOneKeyForEach();
	static boolean test = false;

	/**
	 * END of TEST SPECIFIC
	 **********************************************************************/

	public static void main(String[] args) {
		SimpleArgs cla = new SimpleArgs(args);
		dbg = (cla.hasArg("-v") ? true : dbg);

		String device = getDevice(cla, "3001@127.0.0.1");
		//other options for default device = "PCI:0";
		//other options for default device = "288@192.168.4.183";
		// etc

		if (cla.hasArg("devbuild")) {
			module_id = 0x1A6;
		}
		
		int c_lgns = 0;
		ArrayList<Login> logins = new ArrayList<Login>();
		Login lgn = null;
		do {
			lgn = _singleton.new Login(args, c_lgns++);
			logins.add(lgn);
		} while (lgn.valid);

		new PqmiErrorList();
		//new HbsErrorList();
		//new LatticeErrorList();

		CryptoServerCXI cxi = null;
		try {
			// create instance of CryptoServerCXI (opens connection to CryptoServer)
			// Note: does not support clusters.
			cxi = new CryptoServerCXI(device, 3000); // connection timeout is 3 seconds

			cxi.setTimeout(360000); // command timeout is 6 minute
			//cxi.setTimeout(60000); // command timeout is 1 minute

			cxi.setKeepSessionAlive(true); // in theory a no-op as the test code doesn't have any waitstates
			cxi.setEndSessionOnShutdown(true); // in theory a no-op as the session is manually closed below

			dbg("Device: " + cxi.getDevice());
			String zeros = "00000000";
			for (Login l : logins) {
				if (!l.valid) { continue; }
				dbg("User: " + l.user);
				l.login(cxi);
				String authstate = zeros + Integer.toHexString(cxi.getAuthState());
				dbg(" -> 0x" + authstate.substring(authstate.length()-8));
			}

			if (cla.hasArg("-dil")) TESTS[AUT.DILITHIUM.ordinal()] = true;
			else if (cla.hasArg("-mldsa")) TESTS[AUT.MLDSA.ordinal()] = true;
			else if (cla.hasArg("-kyb")) TESTS[AUT.KYBER.ordinal()] = true;
			else if (cla.hasArg("-mlkem")) TESTS[AUT.MLKEM.ordinal()] = true;
			else if (cla.hasArg("-lms")) TESTS[AUT.LMS.ordinal()] = true;
			else if (cla.hasArg("-hss")) TESTS[AUT.HSS.ordinal()] = true;
			else if (cla.hasArg("-xmss")) TESTS[AUT.XMSS.ordinal()] = true;
			else if (cla.hasArg("-ks")) TESTS[AUT.KEYSTORE.ordinal()] = true;
			
			boolean everything = cla.hasArg("-everything");
			if (everything) {
				cla.setArg("-full", null);
				cla.setArg("-suite", null);
				cla.setArg("-oid", "XMSS-SHA2_10_256");
			}

			AutTest test = null;
			if (everything || TESTS[AUT.DILITHIUM.ordinal()]) {
				test = dilithium(cxi, cla, everything);
				if (test != null) {
					test.go();
				}
				else {
					System.out.println("Test not implemented yet.");
				}
			}
			if (everything || TESTS[AUT.MLDSA.ordinal()]) { 
				test = mldsa(cxi, cla, everything);
				if (test != null) {
					test.go();
				}
				else {
					System.out.println("Test not implemented yet.");
				}
			}
			if (everything || TESTS[AUT.KYBER.ordinal()]) {
				test = kyber(cxi, cla, everything);
				if (test != null) {
					test.go();
				}
				else {
					System.out.println("Test not implemented yet.");
				}
			}
			if (everything || TESTS[AUT.MLKEM.ordinal()]) { 
				test = mlkem(cxi, cla, everything);
				if (test != null) {
					test.go();
				}
				else {
					System.out.println("Test not implemented yet.");
				}
			}
			if (everything || TESTS[AUT.LMS.ordinal()]) { 
				test = lms(cxi, cla, everything);
				if (test != null) {
					test.go();
				}
				else {
					System.out.println("Test not implemented yet.");
				}
			}
			if (everything || TESTS[AUT.HSS.ordinal()]) {
				test = hss(cxi, cla, everything);
				if (test != null) {
					test.go();
				}
				else {
					System.out.println("Test not implemented yet.");
				}
			}
			if (everything || TESTS[AUT.XMSS.ordinal()]) { 
				test = xmss(cxi, cla, everything);
				if (test != null) {
					test.go();
				}
				else {
					System.out.println("Test not implemented yet.");
				}
			}
			if (everything || TESTS[AUT.KEYSTORE.ordinal()]) { 
				test = keystore(cxi, cla, everything);
				if (test != null) {
					test.go();
				}
				else {
					System.out.println("Test not implemented yet.");
				}
			}


		} catch (IOException e) {
			System.out.println("IOException: " + e.getMessage());
		} catch (CryptoServerException cse) {
			System.out.println("CryptoServerException:  0x" + Integer.toHexString(cse.ErrorCode));
			if (cse.ErrorAnswer != null) {
				// do something
			}
		}

		// cleanup
		if (cxi != null) {
			// cxi.logoff();  		// ends authentication on session
			// cxi.endSession();  	// calls .logoff(), terminates session
			cxi.close(); 			// calls .endSession(), terminates connection
			cxi = null;
		}
	}

	private static AutTest keystore(CryptoServerCXI cxi, SimpleArgs cla, boolean everything) {
		System.out.println("KEYSTORE:\n");
		return new KeystoreTest(cxi, cla, false);
	}
	
	private static AutTest xmss(CryptoServerCXI cxi, SimpleArgs cla, boolean everything) {
		System.out.println("XMSS:\n");
		System.out.println(cla.getArg("-oid", "no oid"));
		return new XmssTest(cxi, cla, false, true);
	}

	private static AutTest kyber(CryptoServerCXI cxi, SimpleArgs cla, boolean everything) {
		System.out.println("Kyber:\n");
		return new KyberTest(cxi, cla, false, true);
	}

	private static AutTest lms(CryptoServerCXI cxi, SimpleArgs cla, boolean everything) {
		System.out.println("LMS:\n");
		return null;
	}
	private static AutTest hss(CryptoServerCXI cxi, SimpleArgs cla, boolean everything) {
		System.out.println("HSS:\n");
		return null;
	}
	
	private static AutTest dilithium(CryptoServerCXI cxi, SimpleArgs cla, boolean everything) {
		System.out.println("Dilithium:\n");
		return new DilithiumTest(cxi, cla, false, true);
	}		

	private static AutTest mldsa(CryptoServerCXI cxi, SimpleArgs cla, boolean everything) {
		System.out.println("MLDSA:\n");
		return new MLDSATest(cxi, cla, false, true);
	}

	private static AutTest mlkem(CryptoServerCXI cxi, SimpleArgs cla, boolean everything) {
		System.out.println("MLKEM:\n");
		return new MLKEMTest(cxi, cla, false, true);
	}

	private static void dbg (String d) {
		if (dbg) {
			System.out.println(d);
		}
	}

	private static String getDevice (SimpleArgs args, String def) {
		String cxi = System.getenv("CRYPTOSERVER");
		if (cxi == null) {
			cxi = def;
		}
		if (args.hasArg("dev")) {
			cxi = args.getArg("dev", cxi);
		}
		return cxi;
	}

	private class Login {
		String user = null;
		String spec = null;
		String pin = null;

		File file = null;
		boolean valid = false;
		// valid indicates that this /may/ represent a valid credential, not that it /is/ a valid login

		/*		
		user		Name of the user who wants to autenticate to the CryptoServer.
		keyFile		<-- mapped from -cred, or -s or if mistakenly -p with 3 parameters
			Key file user: Path to key file containing user's private key.
			Password user: null.
		password	<-- mapped from -cred, or -p
			Key file user: Password of the key file if using an encrypted file, null otherwise.
			Password user: Password of the user.
		 */
		Login (String [] args, int i) {
			int c = 0;
			boolean getNext = false;
			for (String a : args) {
				if (getNext) {
					getNext = false;
					String[] nkp = a.split(",");
					if (nkp.length == 2) {
						/* either 
						 * -s name,key (unencrypted)
						 * -s name,:cs2...
						 * -p name,pass
						 */
						user = nkp[0];
						spec = nkp[1];  
						pin = nkp[1]; // yes -- 1.  see later check

						file = new File(spec);
						valid = (spec.matches("^:cs2:.{3,4}:.*$")) || file.exists();

					} else if (nkp.length == 3) {
						// * -s name,key,pass (encrypted)
						user = nkp[0];
						spec = nkp[1];
						pin = nkp[2];
						file = new File(spec);
						valid = file.exists();
					}
					/* at this point, valid is true if the file exists, or if the spec is :cs2:...
					 * valid is false if the value isn't a file and the value isn't a PINPad identifier
					 * 
					 * In this case, we assume HMACpwd, if we've made it this far
					 */
					valid = true; // assume it's HMACpwd
					/*
					 * I may find some logic later for pre-determining if this is an hmac
					 * but I can't test it (using the HSM) because it would log everyone out if it was bad.
					 *
					 * For now, we rely on the cxi.logon(...) to bork if it is not a valid logon.
					 */

					if (!valid) { System.out.println("Auth param format invalid for " + a); }
					c++;
				}
				/* deprecated */
				if (a.compareTo("-s") == 0) {
					if (c != i) { c++; continue; }
					getNext = true;
				}
				/* deprecated */
				if (a.compareTo("-p") == 0) {
					if (c != i) { c++; continue; }
					getNext = true;
				}

				if (a.compareTo("-cred") == 0) {
					if (c != i) { c++; continue; }
					getNext = true;
				}
			}
		}

		boolean login (CryptoServerCXI cxi) {
			boolean ret = false;

			try {
				/* change 01g replaced logonpass/logonsign with the simple logon */
				byte [] pinbytes = new byte[0];
				if (pin != null) {
					pinbytes = pin.getBytes();
				}
				byte [] ovrt = new byte[pinbytes.length];
				cxi.logon(user, spec, pinbytes);
				System.arraycopy(ovrt,0,pinbytes,0,pinbytes.length);
				// also have pin to worry about.
				// pin = null;
				// but we don't know when the GC will reap it.
				return true;
			} catch (IOException e) {
				System.out.println(user + " login failed:  " + e.getMessage());
			} catch (CryptoServerException e) {
				System.out.println(user + " login failed:  0x" + Integer.toHexString(e.ErrorCode));
			}
			return ret;
		}
	}
}
