/* 
 * 03c autogenerated 2024-11-06T12:45:14.3574036 using 
 * CS_SdkVpl version 0.0.6
 * Template version 0002
 * Source XML Document version 01d,2024-03-26,riw
 * 
 * Copyright included by reference, please see Utimaco_Demo_License.txt
 *
 */

/* This is the C implementation for the struct MLKEM_Response_imp */
#include <qsr2mux.h>
#include <MLKEM_Response.h>

#ifdef OS_SMOS
#include <cmds.h>
#include <os_mem.h>
#include <os_str.h>
#include <db.h>
#else
#include <stdlib.h>
#include <memory.h>
#include <stdio.h>
#define cmds_print printf
#define cmds_xprint(string, data, len) printf(string)
#ifndef NO_CSXAPI
#include <csxapi.h>
#endif

#ifdef WIN32
#define os_mem_cpy(d,s,l) memcpy_s(d,l,s,l)
#else
#define os_mem_cpy(d,s,l) memcpy(d,s,l)
#endif
#endif
#ifndef WIN32
#include <stddef.h>
#endif
#include <load_store.h>

//#DEFS_ALLOCATION_METHODS#
//#DEFS_FREE_METHODS#

/*****************************************************************************************
 * mlkem_response_tell - write out current contents if populated (cmds_[x]print)
 */
unsigned int mlkem_response_tell ( const _P_MLKEM_RESPONSE s ) {
    unsigned int len = 0;
#ifdef DEBUG

	cmds_xprint("MLKEM_Response", s, sizeof(MLKEM_RESPONSE));
    
  // flags UINT4_T
  cmds_print("u4->flags = %d [0x%08x]\n", s->flags, s->flags);
  // cyphertext VLEN2_T
  if ((s->l_cyphertext > 0) && (s->p_cyphertext != NULL)) {
    cmds_xprint("v2->p_cyphertext", s->p_cyphertext, s->l_cyphertext);
  }
  else {
    cmds_print("v2->p_cyphertext (not set)\n");
  }  // secret VLEN2_T
  if ((s->l_secret > 0) && (s->p_secret != NULL)) {
    cmds_xprint("v2->p_secret", s->p_secret, s->l_secret);
  }
  else {
    cmds_print("v2->p_secret (not set)\n");
  }
#endif
    return len;
}

/*****************************************************************************************
 * mlkem_response_length - Compute the serialized length of the data in the structure
 */
unsigned int mlkem_response_length(const _P_MLKEM_RESPONSE s) {
    unsigned int len = 0;
    
    len += 4; // flags - u4

    len += 2 + s->l_cyphertext; // v2

    len += 2 + s->l_secret; // v2

    return len;
}

/*****************************************************************************************
 * mlkem_response_serialize - Serialize data in struct for wire-transmittal
 */
unsigned int mlkem_response_serialize (
  const _P_MLKEM_RESPONSE s,
  unsigned int l_answ, 
  unsigned char * p_answ
) {
  
  unsigned int err = 0;
  unsigned int chk = 0;
  unsigned char * pp_answ = p_answ;
  
  // flags UINT4_T
  chk     += 4;
  if (l_answ < chk) return E_PQMI_SERIALIZATION + 1;
  store_int4(s->flags, pp_answ);
  pp_answ += 4; 

  // cyphertext VLEN2_T
  chk     += 2 + s->l_cyphertext;
  if (l_answ < chk) return E_PQMI_SERIALIZATION + 2;
  store_int2(s->l_cyphertext, pp_answ);
  pp_answ += 2;
  os_mem_cpy(pp_answ, s->p_cyphertext, s->l_cyphertext);
  pp_answ += s->l_cyphertext; 

  // secret VLEN2_T
  chk     += 2 + s->l_secret;
  if (l_answ < chk) return E_PQMI_SERIALIZATION + 3;
  store_int2(s->l_secret, pp_answ);
  pp_answ += 2;
  os_mem_cpy(pp_answ, s->p_secret, s->l_secret);
  pp_answ += s->l_secret; 

  return err;
}

/*****************************************************************************************
 * mlkem_response_scanf - Containerized cmds_scanf
 */
unsigned int mlkem_response_scanf (
  _P_MLKEM_RESPONSE s,
  unsigned int l_data, 
  unsigned char *p_data
) {
  int ret = 0x0;

#ifdef OS_SMOS
  os_mem_clr(s, sizeof(MLKEM_RESPONSE));
  
  /* Note: This wraps 'cmds_scanf()', see the mdl_CMDS pdf for more information. */
  ret = cmds_scanf(l_data, p_data, MLKEM_RESPONSE_PATTERN, sizeof(MLKEM_RESPONSE), s);

#else
#ifdef NO_CSXAPI
  ret = 0xB1A0A021;
#else
  /* Note: This wraps csxapi 'cs_scanp()', see the SDK Dev Guide, chapter 2.15
   * for more information.  
   * The scanp method populates a CS_PARAM struct (uint val or len and pointer) for 
   * each field.
   * The data in those structs are then transcribed to the input struct MLKEM_RESPONSE 
   * pointed to by s.
   */

  struct {
    CS_PARAM flags;           // u4
    CS_PARAM cyphertext;           // v2
    CS_PARAM secret;           // v2
  } args;

  if ((ret = cs_scanp(l_data, p_data, MLKEM_RESPONSE_PATTERN, sizeof(args), &args)) != 0x0) 
  {
    return ret;
  }

  s->flags = args.flags.i;

  s->l_cyphertext = args.cyphertext.i;
  s->p_cyphertext = args.cyphertext.p;

  s->l_secret = args.secret.i;
  s->p_secret = args.secret.p;

#endif
#endif

  return ret;     
}

#ifdef OS_SMOS
/*****************************************************************************************
 * mlkem_response_calloc - Copy-Alloc
 * 
 * Takes a pointer to an instance of MLKEM_RESPONSE
 * Allocates space
 * Serializes the instance into the space
 * Returns a pointer to the space.
 *
 * Caller needs to os_mem_del[_set] the pp_data pointed to.
 */
unsigned int mlkem_response_calloc(void * rec, unsigned int *l_data, void **pp_data, unsigned int os_mem_type)
{
    unsigned int err = 0x0;
    unsigned char *p_answ = NULL;
    unsigned int   l_answ = *l_data;

	if (*l_data == 0x0) {
		MLKEM_RESPONSE empty;
		os_mem_set(&empty, 0, sizeof(empty)); // lazily zeroize all v1v2v3v4 fields
		l_answ = mlkem_response_length(&empty);
	}		
	
	p_answ = os_mem_new(l_answ, 
		(os_mem_type == OS_MEM_TYPE_SECURE) ? OS_MEM_TYPE_SECURE : OS_MEM_TYPE_SD
		);
	if (p_answ == 0x0) return E_ANY_MALLOC;
	
	if (*l_data == 0x0) {
		os_mem_set(p_answ, 0, l_answ);
	} else {
		os_mem_cpy(p_answ, *pp_data, l_answ);
	}

	err = mlkem_response_scanf(rec, l_answ, p_answ);
	if (err) return err;
	
	*l_data = l_answ;
	*pp_data = p_answ;		
    
    return err;
}

#ifdef P_DB
/*****************************************************************************************
 * mlkem_response_pdata_store - Write to some DB's public data space
 * 
 * Pointer to an MLKEM_RESPONSE instance
 * Pointer to a DB instance
 * Pointer to a DB Record (ie, the index to use)
 * Pointer to the DB Record _Public_ data
 * unsigned int len of the _Public_ data
 *
 * The record public data is the data passed in.
 * The record private data is the MLKEM_RESPONSE instance.
 *
 * Returns err
 */
unsigned int mlkem_response_pdata_store(
     void * p_rec, void * p_db, unsigned char *db_ndx,
      unsigned int l_pd, unsigned char *p_pd) {
      
    unsigned int err = 0;
	unsigned int l_data = 0;
	unsigned char *p_data = NULL;
	
	err = mlkem_response_calloc(p_rec, &l_data, (void **)&p_data, OS_MEM_TYPE_SECURE);
	if (err) return err;
	
	err = db_insert(p_db, db_ndx, l_pd, p_pd, l_data, p_data);
	switch (err) {
	case E_DB_EXISTS:
		err = db_update(p_db, db_ndx, l_pd, p_pd, l_data, p_data);
		if (err) goto cleanup;
		break;
	case 0x0:
	default:
		break;
	}

cleanup:
    if (p_data != NULL) os_mem_del_set(p_data, 0);
    
    return err;
}

/*****************************************************************************************
 * mlkem_response_sdata_store - Write to some DB's private data space
 * 
 * Pointer to an MLKEM_RESPONSE instance
 * Pointer to a DB instance
 * Pointer to a DB Record (ie, the index to use)
 * Pointer to the DB Record _Secret_ data
 * unsigned int len of the _Secret_ data
 *
 * The record public data is the MLKEM_RESPONSE instance itself.
 * The record private data is the value passed in.
 *
 * Returns err
 */
unsigned int mlkem_response_sdata_store(
     void * p_rec, void * p_db, unsigned char *db_ndx,
      unsigned int l_sk, unsigned char *p_sk) {
      
    unsigned int err = 0;
	unsigned int l_data = 0;
	unsigned char *p_data = NULL;
	
	err = mlkem_response_calloc(p_rec, &l_data, (void **)&p_data, OS_MEM_TYPE_SD);
	if (err) return err;
	
	err = db_insert(p_db, db_ndx, l_data, p_data, l_sk, p_sk);
	switch (err) {
	case E_DB_EXISTS:
		err = db_update(p_db, db_ndx, l_data, p_data, l_sk, p_sk);
		if (err) goto cleanup;
		break;
	case 0x0:
	default:
		break;
	}

cleanup:
    if (p_data != NULL) os_mem_del(p_data);
    
    return err;
}
#endif
    
/*****************************************************************************************
 * mlkem_response_alloc_answ - Containerized cmds_alloc_answ
 */
unsigned int mlkem_response_alloc_answ(void * ctxt, _P_MLKEM_RESPONSE p_obj)
{
    unsigned int err = 0x0;
    unsigned char *p_answ;
    unsigned int   l_answ;

    l_answ = mlkem_response_length(p_obj);
    if ((err = cmds_alloc_answ(ctxt, l_answ, &p_answ)) != 0)
        return err;

    err = mlkem_response_serialize(p_obj, l_answ, p_answ);

    return err;
}
#else

/*****************************************************************************************
 * mlkem_response_pack - serialize into new-allocated space
 *
 * Allocates space, provides pointer via dest parameter 
 *
 * [I ] _P_MLKEM_RESPONSE const p_obj - Pointer to a MLKEM_RESPONSE object
 * [ O] unsigned int *l_dest - Pointer to int, where the length of the data is returned
 * [ O] unsigned char **dest - Handle, will be populated after allocation
 *
 * Returns 0x0 if no error, or -1 if no mem
 */
int mlkem_response_pack (_P_MLKEM_RESPONSE const p_obj, unsigned int *l_dest, unsigned char **dest) {
	int err = 0;
	int sz = mlkem_response_length(p_obj);
	if (sz != 0x0) {
		unsigned char *tgt = malloc(sz);
		if (tgt != 0x0) {
			err = mlkem_response_serialize(p_obj, sz, tgt);
			if (!err) {
				*dest = tgt;
				*l_dest = sz;
			}
        }
        else { return -1; }
	}
	return err;
}

// the Data falls immediately after the struct
typedef struct mlkem_response_CONTAINER {
        MLKEM_RESPONSE obj;
        unsigned int l_buffer;
} c_mlkem_response;
typedef c_mlkem_response * cp_mlkem_response;
unsigned int mlkem_response_new (
    _P_MLKEM_RESPONSE *s,
    unsigned int l_data,
    unsigned char *p_data
) {
    unsigned int err = 0x0;
    cp_mlkem_response container = NULL;
    unsigned char * locator = NULL;
    unsigned int pad_between = 0;

    unsigned int struct_area = sizeof(c_mlkem_response);
    unsigned int total_size = 0;

    pad_between = (4 - (struct_area % 4)) % 4;
    struct_area += pad_between;

    total_size = struct_area + l_data + ((4 - (l_data %4)) % 4);

    container = (cp_mlkem_response)malloc(total_size);
    if (container == 0) { return 0xB1000004; } // E_EXMP_MALLOC 

    container->l_buffer = l_data;
    memset(container, 0x0, struct_area);

    locator = (unsigned char *)container + struct_area;
    memset(locator + l_data - 4, 0x0, 4); 
    memcpy(locator, p_data, l_data);

    err = mlkem_response_scanf(&(container->obj), l_data, locator);
    
    *s = (err == 0x0) ? (_P_MLKEM_RESPONSE)container : NULL;

    return err;
}
unsigned int mlkem_response_raw_len ( _P_MLKEM_RESPONSE s ) {
    if (s == NULL) return 0;
    cp_mlkem_response container = (cp_mlkem_response)s;
    return container->l_buffer;
}
unsigned char * mlkem_response_raw ( _P_MLKEM_RESPONSE s ) {
    if (s == NULL) return NULL;
    unsigned char * locator = (unsigned char *)s;
    unsigned int struct_area = sizeof(c_mlkem_response);
    locator += struct_area + ((4 - (struct_area % 4)) % 4);
    return locator;
}
void mlkem_response_free ( _P_MLKEM_RESPONSE s ) {
    if (s == NULL) { return; }
    free(s);
}
#endif

// #include "exfiles/MLKEM_Response_ex.c"
