/* 
 * 03c autogenerated 2024-11-06T12:45:06.503739 using 
 * CS_SdkVpl version 0.0.6
 * Template version 0002
 * Source XML Document version 01d,2024-03-26,riw
 * 
 * Copyright included by reference, please see Utimaco_Demo_License.txt
 *
 */

/* This is the C implementation for the struct MLDSA_Verify_imp */
#include <qsr2mux.h>
#include <MLDSA_Verify.h>

#define E_ANY_SERIALIZATION E_PQMI_SERIALIZATION

#ifdef OS_SMOS
#include <cmds.h>
#include <os_mem.h>
#include <os_str.h>
#include <db.h>
#else
#include <stdlib.h>
#include <memory.h>
#include <stdio.h>
#define cmds_print printf
#define cmds_xprint(string, data, len) printf(string)
#ifndef NO_CSXAPI
#include <csxapi.h>
#endif

#ifdef WIN32
#define os_mem_cpy(d,s,l) memcpy_s(d,l,s,l)
#else
#define os_mem_cpy(d,s,l) memcpy(d,s,l)
#endif
#endif
#ifndef WIN32
#include <stddef.h>
#endif
#include <load_store.h>

//#DEFS_ALLOCATION_METHODS#
//#DEFS_FREE_METHODS#

/*****************************************************************************************
 * mldsa_verify_tell - write out current contents if populated (cmds_[x]print)
 */
unsigned int mldsa_verify_tell ( const _P_MLDSA_VERIFY s ) {
    unsigned int len = 0;
#ifdef DEBUG

	cmds_xprint("MLDSA_Verify", s, sizeof(MLDSA_VERIFY));
    
  // flags UINT4_T
  cmds_print("u4->flags = %d [0x%08x]\n", s->flags, s->flags);
  // type UINT4_T
  cmds_print("u4->type = %d [0x%08x]\n", s->type, s->type);
  // key VLEN2_T
  if ((s->l_key > 0) && (s->p_key != NULL)) {
    cmds_xprint("v2->p_key", s->p_key, s->l_key);
  }
  else {
    cmds_print("v2->p_key (not set)\n");
  }  // msg VLEN4_T
  if ((s->l_msg > 0) && (s->p_msg != NULL)) {
    cmds_xprint("v4->p_msg", s->p_msg, s->l_msg);
  }
  else {
    cmds_print("v4->p_msg (not set)\n");
  }  // ctxt VLEN1_T
  if ((s->l_ctxt > 0) && (s->p_ctxt != NULL)) {
    cmds_xprint("v1->p_ctxt", s->p_ctxt, s->l_ctxt);
  }
  else {
    cmds_print("v1->p_ctxt (not set)\n");
  }  // state VLEN4_T
  if ((s->l_state > 0) && (s->p_state != NULL)) {
    cmds_xprint("v4->p_state", s->p_state, s->l_state);
  }
  else {
    cmds_print("v4->p_state (not set)\n");
  }  // sig VLEN2_T
  if ((s->l_sig > 0) && (s->p_sig != NULL)) {
    cmds_xprint("v2->p_sig", s->p_sig, s->l_sig);
  }
  else {
    cmds_print("v2->p_sig (not set)\n");
  }
#endif
    return len;
}

/*****************************************************************************************
 * mldsa_verify_length - Compute the serialized length of the data in the structure
 */
unsigned int mldsa_verify_length(const _P_MLDSA_VERIFY s) {
    unsigned int len = 0;
    
    len += 4; // flags - u4

    len += 4; // type - u4

    len += 2 + s->l_key; // v2

    len += 4 + s->l_msg; // v4

    len += 1 + s->l_ctxt; // v1

    len += 4 + s->l_state; // v4

    len += 2 + s->l_sig; // v2

    return len;
}

/*****************************************************************************************
 * mldsa_verify_serialize - Serialize data in struct for wire-transmittal
 */
unsigned int mldsa_verify_serialize (
  const _P_MLDSA_VERIFY s,
  unsigned int l_answ, 
  unsigned char * p_answ
) {
  
  unsigned int err = 0;
  unsigned int chk = 0;
  unsigned char * pp_answ = p_answ;
  
  // flags UINT4_T
  chk     += 4;
  if (l_answ < chk) return E_ANY_SERIALIZATION + 1;
  store_int4(s->flags, pp_answ);
  pp_answ += 4; 

  // type UINT4_T
  chk     += 4;
  if (l_answ < chk) return E_ANY_SERIALIZATION + 2;
  store_int4(s->type, pp_answ);
  pp_answ += 4; 

  // key VLEN2_T
  chk     += 2 + s->l_key;
  if (l_answ < chk) return E_ANY_SERIALIZATION + 3;
  store_int2(s->l_key, pp_answ);
  pp_answ += 2;
  os_mem_cpy(pp_answ, s->p_key, s->l_key);
  pp_answ += s->l_key; 

  // msg VLEN4_T
  chk     += 4 + s->l_msg;
  if (l_answ < chk) return E_ANY_SERIALIZATION + 4;
  store_int4(s->l_msg, pp_answ);
  pp_answ += 4;
  os_mem_cpy(pp_answ, s->p_msg, s->l_msg);
  pp_answ += s->l_msg; 

  // ctxt VLEN1_T
  chk     += 1 + s->l_ctxt;
  if (l_answ < chk) return E_ANY_SERIALIZATION + 5;
  store_int1(s->l_ctxt, pp_answ);
  pp_answ += 1;
  os_mem_cpy(pp_answ, s->p_ctxt, s->l_ctxt);
  pp_answ += s->l_ctxt; 

  // state VLEN4_T
  chk     += 4 + s->l_state;
  if (l_answ < chk) return E_ANY_SERIALIZATION + 6;
  store_int4(s->l_state, pp_answ);
  pp_answ += 4;
  os_mem_cpy(pp_answ, s->p_state, s->l_state);
  pp_answ += s->l_state; 

  // sig VLEN2_T
  chk     += 2 + s->l_sig;
  if (l_answ < chk) return E_ANY_SERIALIZATION + 7;
  store_int2(s->l_sig, pp_answ);
  pp_answ += 2;
  os_mem_cpy(pp_answ, s->p_sig, s->l_sig);
  pp_answ += s->l_sig; 

  return err;
}

/*****************************************************************************************
 * mldsa_verify_scanf - Containerized cmds_scanf
 */
unsigned int mldsa_verify_scanf (
  _P_MLDSA_VERIFY s,
  unsigned int l_data, 
  unsigned char *p_data
) {
  int ret = 0x0;

#ifdef OS_SMOS
  os_mem_clr(s, sizeof(MLDSA_VERIFY));
  
  /* Note: This wraps 'cmds_scanf()', see the mdl_CMDS pdf for more information. */
  ret = cmds_scanf(l_data, p_data, MLDSA_VERIFY_PATTERN, sizeof(MLDSA_VERIFY), s);

#else
#ifdef NO_CSXAPI
  ret = 0xB1A0A021;
#else
  /* Note: This wraps csxapi 'cs_scanp()', see the SDK Dev Guide, chapter 2.15
   * for more information.  
   * The scanp method populates a CS_PARAM struct (uint val or len and pointer) for 
   * each field.
   * The data in those structs are then transcribed to the input struct MLDSA_VERIFY 
   * pointed to by s.
   */

  struct {
    CS_PARAM flags;           // u4
    CS_PARAM type;           // u4
    CS_PARAM key;           // v2
    CS_PARAM msg;           // v4
    CS_PARAM ctxt;           // v1
    CS_PARAM state;           // v4
    CS_PARAM sig;           // v2
  } args;

  if ((ret = cs_scanp(l_data, p_data, MLDSA_VERIFY_PATTERN, sizeof(args), &args)) != 0x0) 
  {
    return ret;
  }

  s->flags = args.flags.i;

  s->type = args.type.i;

  s->l_key = args.key.i;
  s->p_key = args.key.p;

  s->l_msg = args.msg.i;
  s->p_msg = args.msg.p;

  s->l_ctxt = args.ctxt.i;
  s->p_ctxt = args.ctxt.p;

  s->l_state = args.state.i;
  s->p_state = args.state.p;

  s->l_sig = args.sig.i;
  s->p_sig = args.sig.p;

#endif
#endif

  return ret;     
}

#ifdef OS_SMOS
/*****************************************************************************************
 * mldsa_verify_calloc - Copy-Alloc
 * 
 * Takes a pointer to an instance of MLDSA_VERIFY
 * Allocates space
 * Serializes the instance into the space
 * Returns a pointer to the space.
 *
 * Caller needs to os_mem_del[_set] the pp_data pointed to.
 */
unsigned int mldsa_verify_calloc(void * rec, unsigned int *l_data, void **pp_data, unsigned int os_mem_type)
{
    unsigned int err = 0x0;
    unsigned char *p_answ = NULL;
    unsigned int   l_answ = *l_data;

	if (*l_data == 0x0) {
		MLDSA_VERIFY empty;
		os_mem_set(&empty, 0, sizeof(empty)); // lazily zeroize all v1v2v3v4 fields
		l_answ = mldsa_verify_length(&empty);
	}		
	
	p_answ = os_mem_new(l_answ, 
		(os_mem_type == OS_MEM_TYPE_SECURE) ? OS_MEM_TYPE_SECURE : OS_MEM_TYPE_SD
		);
	if (p_answ == 0x0) return E_ANY_MALLOC;
	
	if (*l_data == 0x0) {
		os_mem_set(p_answ, 0, l_answ);
	} else {
		os_mem_cpy(p_answ, *pp_data, l_answ);
	}

	err = mldsa_verify_scanf(rec, l_answ, p_answ);
	if (err) return err;
	
	*l_data = l_answ;
	*pp_data = p_answ;		
    
    return err;
}

#ifdef P_DB
/*****************************************************************************************
 * mldsa_verify_pdata_store - Write to some DB's public data space
 * 
 * Pointer to an MLDSA_VERIFY instance
 * Pointer to a DB instance
 * Pointer to a DB Record (ie, the index to use)
 * Pointer to the DB Record _Public_ data
 * unsigned int len of the _Public_ data
 *
 * The record public data is the data passed in.
 * The record private data is the MLDSA_VERIFY instance.
 *
 * Returns err
 */
unsigned int mldsa_verify_pdata_store(
     void * p_rec, void * p_db, unsigned char *db_ndx,
      unsigned int l_pd, unsigned char *p_pd) {
      
    unsigned int err = 0;
	unsigned int l_data = 0;
	unsigned char *p_data = NULL;
	
	err = mldsa_verify_calloc(p_rec, &l_data, (void **)&p_data, OS_MEM_TYPE_SECURE);
	if (err) return err;
	
	err = db_insert(p_db, db_ndx, l_pd, p_pd, l_data, p_data);
	switch (err) {
	case E_DB_EXISTS:
		err = db_update(p_db, db_ndx, l_pd, p_pd, l_data, p_data);
		if (err) goto cleanup;
		break;
	case 0x0:
	default:
		break;
	}

cleanup:
    if (p_data != NULL) os_mem_del_set(p_data, 0);
    
    return err;
}

/*****************************************************************************************
 * mldsa_verify_sdata_store - Write to some DB's private data space
 * 
 * Pointer to an MLDSA_VERIFY instance
 * Pointer to a DB instance
 * Pointer to a DB Record (ie, the index to use)
 * Pointer to the DB Record _Secret_ data
 * unsigned int len of the _Secret_ data
 *
 * The record public data is the MLDSA_VERIFY instance itself.
 * The record private data is the value passed in.
 *
 * Returns err
 */
unsigned int mldsa_verify_sdata_store(
     void * p_rec, void * p_db, unsigned char *db_ndx,
      unsigned int l_sk, unsigned char *p_sk) {
      
    unsigned int err = 0;
	unsigned int l_data = 0;
	unsigned char *p_data = NULL;
	
	err = mldsa_verify_calloc(p_rec, &l_data, (void **)&p_data, OS_MEM_TYPE_SD);
	if (err) return err;
	
	err = db_insert(p_db, db_ndx, l_data, p_data, l_sk, p_sk);
	switch (err) {
	case E_DB_EXISTS:
		err = db_update(p_db, db_ndx, l_data, p_data, l_sk, p_sk);
		if (err) goto cleanup;
		break;
	case 0x0:
	default:
		break;
	}

cleanup:
    if (p_data != NULL) os_mem_del(p_data);
    
    return err;
}
#endif
    
/*****************************************************************************************
 * mldsa_verify_alloc_answ - Containerized cmds_alloc_answ
 */
unsigned int mldsa_verify_alloc_answ(void * ctxt, _P_MLDSA_VERIFY p_obj)
{
    unsigned int err = 0x0;
    unsigned char *p_answ;
    unsigned int   l_answ;

    l_answ = mldsa_verify_length(p_obj);
    if ((err = cmds_alloc_answ(ctxt, l_answ, &p_answ)) != 0)
        return err;

    err = mldsa_verify_serialize(p_obj, l_answ, p_answ);

    return err;
}
#else

/*****************************************************************************************
 * mldsa_verify_pack - serialize into new-allocated space
 *
 * Allocates space, provides pointer via dest parameter 
 *
 * [I ] _P_MLDSA_VERIFY const p_obj - Pointer to a MLDSA_VERIFY object
 * [ O] unsigned int *l_dest - Pointer to int, where the length of the data is returned
 * [ O] unsigned char **dest - Handle, will be populated after allocation
 *
 * Returns 0x0 if no error, or -1 if no mem
 */
int mldsa_verify_pack (_P_MLDSA_VERIFY const p_obj, unsigned int *l_dest, unsigned char **dest) {
	int err = 0;
	int sz = mldsa_verify_length(p_obj);
	if (sz != 0x0) {
		unsigned char *tgt = malloc(sz);
		if (tgt != 0x0) {
			err = mldsa_verify_serialize(p_obj, sz, tgt);
			if (!err) {
				*dest = tgt;
				*l_dest = sz;
			}
        }
        else { return -1; }
	}
	return err;
}

// the Data falls immediately after the struct
typedef struct mldsa_verify_CONTAINER {
        MLDSA_VERIFY obj;
        unsigned int l_buffer;
} c_mldsa_verify;
typedef c_mldsa_verify * cp_mldsa_verify;
unsigned int mldsa_verify_new (
    _P_MLDSA_VERIFY *s,
    unsigned int l_data,
    unsigned char *p_data
) {
    unsigned int err = 0x0;
    cp_mldsa_verify container = NULL;
    unsigned char * locator = NULL;
    unsigned int pad_between = 0;

    unsigned int struct_area = sizeof(c_mldsa_verify);
    unsigned int total_size = 0;

    pad_between = (4 - (struct_area % 4)) % 4;
    struct_area += pad_between;

    total_size = struct_area + l_data + ((4 - (l_data %4)) % 4);

    container = (cp_mldsa_verify)malloc(total_size);
    if (container == 0) { return 0xB1000004; } // E_EXMP_MALLOC 

    container->l_buffer = l_data;
    memset(container, 0x0, struct_area);

    locator = (unsigned char *)container + struct_area;
    memset(locator + l_data - 4, 0x0, 4); 
    memcpy(locator, p_data, l_data);

    err = mldsa_verify_scanf(&(container->obj), l_data, locator);
    
    *s = (err == 0x0) ? (_P_MLDSA_VERIFY)container : NULL;

    return err;
}
unsigned int mldsa_verify_raw_len ( _P_MLDSA_VERIFY s ) {
    if (s == NULL) return 0;
    cp_mldsa_verify container = (cp_mldsa_verify)s;
    return container->l_buffer;
}
unsigned char * mldsa_verify_raw ( _P_MLDSA_VERIFY s ) {
    if (s == NULL) return NULL;
    unsigned char * locator = (unsigned char *)s;
    unsigned int struct_area = sizeof(c_mldsa_verify);
    locator += struct_area + ((4 - (struct_area % 4)) % 4);
    return locator;
}
void mldsa_verify_free ( _P_MLDSA_VERIFY s ) {
    if (s == NULL) { return; }
    free(s);
}
#endif

// #include "exfiles/MLDSA_Verify_ex.c"
