#ifndef __P11TOOL3_H__
#define __P11TOOL3_H__

#ifdef OSYS_win
#include <windows.h>        // used functions:  LoadLibrary(), GetProcAddress(), FreeLibrary()
#else
#include <dlfcn.h>          // used functions:  dlopen(), dlsym(), dlclose()
#endif
#include <stdio.h>         
#include <stdlib.h>
#include <string.h>
#include "cryptoki.h"
#include "pkcs11t_cs.h"

#define CKA_UTI_CUSTOM_DATA                0x80D00001       // Public attribute containing key data

#define DILITHIUM 0xD171
#define LMS       0x0735
#define HSS       0x0455
#define XMSS      0x7355
#define KYBER     0xCBE4
#define MLDSA     0xF203
#define MLKEM     0xF204

#define MECH_LATTICE_VDM    ((0xC << 28) | (0xA3 << 16))
#define MECH_ML_VDM         ((0xC << 28) | (0xA5 << 16))
#define MECH_HBS_VDM        ((0xC << 28) | (0xA2 << 16))
#ifndef MECH_VDM_GEN
#define MECH_VDM_GEN        0x0
#define MECH_VDM_ENCRYPT    (0x1 << 12)
#define MECH_VDM_DECRYPT    (0x2 << 12)
#define MECH_VDM_SIGN        (0x3 << 12)
#define MECH_VDM_VERIFY        (0x4 << 12)
#define MECH_VDM_WRAP        (0x5 << 12)
#define MECH_VDM_UNWRAP        (0x6 << 12)
#define MECH_VDM_DERIVE        (0x9 << 12)
#define MECH_VDM_DIGEST        (0xD << 12)
#define MECH_VDM_DELETE        (0xF << 12)
#endif

#define CKM_MECH_DILITHIUM_GENKEY   (MECH_LATTICE_VDM | MECH_VDM_GEN | 1)
#define CKM_MECH_KYBER_GENKEY       (MECH_LATTICE_VDM | MECH_VDM_GEN | 2)

// the 1 here does not interfere with the above, since domain separation 
// is gained by MECH_LATTICE_VDM vs MECH_ML_VDM
#define CKM_MECH_MLDSA_GENKEY       (MECH_ML_VDM | MECH_VDM_GEN | 1)
#define CKM_MECH_MLKEM_GENKEY       (MECH_ML_VDM | MECH_VDM_GEN | 2)

#define CKM_MECH_DILITHIUM_SIGN     (MECH_LATTICE_VDM | MECH_VDM_SIGN | 1)
#define CKM_MECH_DILITHIUM_VERIFY   (MECH_LATTICE_VDM | MECH_VDM_VERIFY | 1)     

#define CKM_MECH_MLDSA_SIGN         (MECH_ML_VDM | MECH_VDM_SIGN | 1)
#define CKM_MECH_MLDSA_EXTMU_SIGN   (MECH_ML_VDM | MECH_VDM_SIGN | 5)
#define CKM_MECH_MLDSA_VERIFY       (MECH_ML_VDM | MECH_VDM_VERIFY | 1)     
#define CKM_MECH_MLDSA_EXTMU_VERIFY (MECH_ML_VDM | MECH_VDM_VERIFY | 5)     

#define CKM_MECH_KYBER_ENCAP        (MECH_LATTICE_VDM | MECH_VDM_DERIVE | 1)
#define CKM_MECH_KYBER_DECAP        (MECH_LATTICE_VDM | MECH_VDM_DERIVE | 2)

#define CKM_MECH_MLKEM_ENCAP        (MECH_ML_VDM | MECH_VDM_DERIVE | 1)
#define CKM_MECH_MLKEM_DECAP        (MECH_ML_VDM | MECH_VDM_DERIVE | 2)

#define CKM_MECH_MLDSA_WRAP_AESKWP  (MECH_ML_VDM | MECH_VDM_WRAP | 1)
#define CKM_MECH_MLDSA_UWRAP_AESKWP (MECH_ML_VDM | MECH_VDM_UNWRAP | 1)

#define CKM_MECH_MLDSA_EXPORT_PUBKEY      (MECH_ML_VDM | MECH_VDM_DERIVE | 3)
#define CKM_MECH_MLKEM_EXPORT_PUBKEY      (MECH_ML_VDM | MECH_VDM_DERIVE | 4)

#define CKM_MECH_MLDSA_SHAKE256           (MECH_ML_VDM | MECH_VDM_DIGEST | 1)


#define CKK_VENDOR_UTI_DILITHIUM_KT     CKM_MECH_DILITHIUM_GENKEY
#define CKK_VENDOR_UTI_KYBER_KT         CKM_MECH_KYBER_GENKEY
#define CKK_VENDOR_UTI_MLDSA_KT         CKM_MECH_MLDSA_GENKEY
#define CKK_VENDOR_UTI_MLKEM_KT         CKM_MECH_MLKEM_GENKEY

#define ML_MODE_STORE_SK        0x00000010  
#define ML_MODE_STORE_SEED      0x00000020

struct PPARMS {
    unsigned long curvedes;
    unsigned long astoken;
    unsigned long keytype;
    unsigned long r3_variant;
    unsigned long gen;
    unsigned long sign;
    unsigned long verify;
    unsigned long signverify;
    unsigned long encap;
    unsigned long decap;
    unsigned long encdec;
    unsigned long loopcount;
};

#ifdef OSYS_win
int Initialize(CK_FUNCTION_LIST_PTR_PTR  ppFunctions,
               HMODULE                   *phModule,
               char                      *libraryPath);
#else
int Initialize(CK_FUNCTION_LIST_PTR_PTR  ppFunctions,
               void                      **lib_handle,
               char                      *libraryPath);    
#endif


void entry(char *t);
void exuent(char *t, unsigned int err);
void cs_xprint(char *txt, void *data, int len);

int EnsureUserExistence(CK_FUNCTION_LIST_PTR  pFunctions,
                        char                  *userPIN, 
                        CK_ULONG              slotID);
int GenerateRSAKeyPair(CK_FUNCTION_LIST_PTR  pFunctions,
                    CK_SESSION_HANDLE     hSession,
                    CK_OBJECT_HANDLE_PTR  phPublicKey,
                    CK_OBJECT_HANDLE_PTR  phPrivateKey,
                    CK_ULONG              noisy);
int DeleteKeyPair    (CK_FUNCTION_LIST_PTR  pFunctions,
                     CK_SESSION_HANDLE     hSession,
                     CK_OBJECT_HANDLE      pPublicKey,
                     CK_OBJECT_HANDLE       pPrivateKey,
                     CK_ULONG               noisy);
int SignDataRSAPKCS(CK_FUNCTION_LIST_PTR  pFunctions,
             CK_SESSION_HANDLE     hSession, 
             CK_OBJECT_HANDLE      hPrivateKey, 
             CK_BYTE               *Data, 
             CK_ULONG              lenData, 
             CK_BYTE               **signature, 
             CK_ULONG              *lenSignature,
             CK_ULONG                noisy);
int VerifySignedDataRSAPKCS(CK_FUNCTION_LIST_PTR  pFunctions,
                     CK_SESSION_HANDLE     hSession, 
                     CK_OBJECT_HANDLE      hPublicKey, 
                     CK_BYTE               *Data, 
                     CK_ULONG              lenData, 
                     CK_BYTE               *signature, 
                     CK_ULONG              lenSignature,
                      CK_ULONG                noisy);



int dilithium_vdx_test(CK_FUNCTION_LIST_PTR pFunctions, CK_SESSION_HANDLE hSession,
    unsigned long gentest,
    unsigned long signtest,
    unsigned long verifytest,
    unsigned long signverifytest,
    unsigned long dilithium_keytype,
    unsigned long dilithium_variant,
    unsigned long asToken,
    unsigned long count
);

int mldsa_vdx_test(CK_FUNCTION_LIST_PTR pFunctions, CK_SESSION_HANDLE hSession,
    unsigned long gentest,
    unsigned long signtest,
    unsigned long verifytest,
    unsigned long signverifytest,
    unsigned long mldsa_keytype,
    unsigned long asToken,
    unsigned long count
);

int lms_vdx_test(CK_FUNCTION_LIST_PTR pFunctions, CK_SESSION_HANDLE hSession,
    unsigned long gentest,
    unsigned long signtest,
    unsigned long verifytest,
    unsigned long signverifytest,
    unsigned long keytype,
    unsigned long asToken,
    unsigned long count
);

int hss_vdx_test(CK_FUNCTION_LIST_PTR pFunctions, CK_SESSION_HANDLE hSession,
    unsigned long gentest,
    unsigned long signtest,
    unsigned long verifytest,
    unsigned long signverifytest,
    unsigned long keytype,
    unsigned long asToken,
    unsigned long count
);

int xmss_vdx_test(CK_FUNCTION_LIST_PTR pFunctions, CK_SESSION_HANDLE hSession,
    unsigned long gentest,
    unsigned long signtest,
    unsigned long verifytest,
    unsigned long signverifytest,
    unsigned long keytype,
    unsigned long asToken,
    unsigned long count
);
int mlkem_vdx_test(CK_FUNCTION_LIST_PTR pFunctions, CK_SESSION_HANDLE hSession,
    unsigned long gentest,
    unsigned long enctest,
    unsigned long dectest,
    unsigned long encdectest,
    unsigned long mlkem_keytype,
    unsigned long asToken,
    unsigned long count
);

int kyber_vdx_test(CK_FUNCTION_LIST_PTR pFunctions, CK_SESSION_HANDLE hSession,
    unsigned long gentest,
    unsigned long encaptest,
    unsigned long decaptest,
    unsigned long encapdecaptest,
    unsigned long kyber_keytype,
    unsigned long kyber_variant,
    unsigned long asToken,
    unsigned long count
);

int util_get_attribute_value(
    CK_FUNCTION_LIST_PTR pFunctions, CK_SESSION_HANDLE hSession,
    CK_OBJECT_HANDLE pubKeyHandle,
    CK_ULONG attribute,
    unsigned char **p_pk,
    unsigned long *l_pk
);

#endif
