#if !defined( HBS_DEFS_H )
#define HBS_DEFS_H

/*
 * These are defintions for the LMS implementation that are common throughout
 * the system (and so are collected in one place)
 */

#include <stdint.h>
#include <stdbool.h>
#include "qptool2.h"

#define MAX_HASH   32 /* Length of the largest hash we support */

/* The I (Merkle tree identifier) value is 16 bytes long */
#define I_LEN               16

/* The maximum height of a Merkle tree */
#define MAX_MERKLE_HEIGHT       25

/* The mininum height of a Merkle tree.  Some of our update logic assumes */
/* this isn't too small */
#define MIN_MERKLE_HEIGHT        5

/* The minimum/maximum number of levels of Merkle trees within an HSS trees */
#define MIN_HSS_LEVELS 1    /* Minumum levels we allow */
#define MAX_HSS_LEVELS 8    /* Maximum levels we allow */

/* This is the length of our internal seed values */
#define MAX_SEED_LEN 32     /* Enough to make Grover's infeasible */

/* Selectors for PRNG vs DRBG */
#define HBS_RNG_TYPE_PSEUDO				0
#define HBS_RNG_TYPE_REAL				1


/* Defined LM parameter sets */
#define LMS_SHA256_N32_H5  0x00000005
#define LMS_SHA256_N32_H10 0x00000006
#define LMS_SHA256_N32_H15 0x00000007
#define LMS_SHA256_N32_H20 0x00000008
#define LMS_SHA256_N32_H25 0x00000009
#define LMS_SHA256_N24_H5  0x0000000a
#define LMS_SHA256_N24_H10 0x0000000b
#define LMS_SHA256_N24_H15 0x0000000c
#define LMS_SHA256_N24_H20 0x0000000d
#define LMS_SHA256_N24_H25 0x0000000e
#define LMS_SHAKE256_N32_H5  0x0000000f
#define LMS_SHAKE256_N32_H10 0x00000010
#define LMS_SHAKE256_N32_H15 0x00000011
#define LMS_SHAKE256_N32_H20 0x00000012
#define LMS_SHAKE256_N32_H25 0x00000013
#define LMS_SHAKE256_N24_H5  0x00000014
#define LMS_SHAKE256_N24_H10 0x00000015
#define LMS_SHAKE256_N24_H15 0x00000016
#define LMS_SHAKE256_N24_H20 0x00000017
#define LMS_SHAKE256_N24_H25 0x00000018


/* LM-OTS registry */
#define LMOTS_SHA256_N32_W1 0x00000001
#define LMOTS_SHA256_N32_W2 0x00000002
#define LMOTS_SHA256_N32_W4 0x00000003
#define LMOTS_SHA256_N32_W8 0x00000004
#define LMOTS_SHA256_N24_W1 0x00000005
#define LMOTS_SHA256_N24_W2 0x00000006
#define LMOTS_SHA256_N24_W4 0x00000007
#define LMOTS_SHA256_N24_W8 0x00000008
#define LMOTS_SHAKE256_N32_W1 0x00000009
#define LMOTS_SHAKE256_N32_W2 0x0000000a
#define LMOTS_SHAKE256_N32_W4 0x0000000b
#define LMOTS_SHAKE256_N32_W8 0x0000000c
#define LMOTS_SHAKE256_N24_W1 0x0000000d
#define LMOTS_SHAKE256_N24_W2 0x0000000e
#define LMOTS_SHAKE256_N24_W4 0x0000000f
#define LMOTS_SHAKE256_N24_W8 0x00000010

#define HBS_MECH_HSS_GENKEY             0xC0010101 /* DEPRECATED */
#define CKM_HBS_HSS_GENKEY              (MECH_HBS_VDM | MECH_VDM_GEN | 1)
#define HBS_MECH_HSS_GENKEY_SEED        0xC0010102 /* DEPRECATED */
#define CKM_HBS_HSS_GENKEY_SEED         (MECH_HBS_VDM | MECH_VDM_GEN | 2)
#define HBS_MECH_XMSS_GENKEY            0xC0010103 /* DEPRECATED */
#define CKM_HBS_XMSS_GENKEY             (MECH_HBS_VDM | MECH_VDM_GEN | 3)
#define HBS_MECH_XMSS_GENKEY_SEED       0xC0010104 /* DEPRECATED */
#define CKM_HBS_XMSS_GENKEY_SEED        (MECH_HBS_VDM | MECH_VDM_GEN | 4)
#define CKM_HBS_LMS_GENKEY              (MECH_HBS_VDM | MECH_VDM_GEN | 5)
#define CKM_HBS_LMS_GENKEY_SEED         (MECH_HBS_VDM | MECH_VDM_GEN | 6)

#define HBS_MECH_HSS_GET_PUBKEY         0xC0010201 /* DEPRECATED */
#define CKM_HBS_HSS_GET_PUBKEY          (MECH_HBS_VDM | MECH_VDM_DERIVE | 1)
#define HBS_MECH_XMSS_GET_PUBKEY        0xC0010202 /* DEPRECATED */
#define CKM_HBS_XMSS_GET_PUBKEY         (MECH_HBS_VDM | MECH_VDM_DERIVE | 2)
#define CKM_HBS_LMS_GET_PUBKEY          (MECH_HBS_VDM | MECH_VDM_DERIVE | 3)

#define HBS_MECH_HSS_SIGN               0xC0010301 /* DEPRECATED */
#define CKM_HBS_HSS_SIGN                (MECH_HBS_VDM | MECH_VDM_SIGN | 1)
#define HBS_MECH_XMSS_SIGN              0xC0010302 /* DEPRECATED */
#define CKM_HBS_XMSS_SIGN               (MECH_HBS_VDM | MECH_VDM_SIGN | 2)
#define CKM_HBS_LMS_SIGN                (MECH_HBS_VDM | MECH_VDM_SIGN | 3)

#define HBS_MECH_HSS_VERIFY             0xC0010401 /* DEPRECATED */
#define CKM_HBS_HSS_VERIFY              (MECH_HBS_VDM | MECH_VDM_VERIFY | 1)
#define HBS_MECH_XMSS_VERIFY            0xC0010402 /* DEPRECATED */
#define CKM_HBS_XMSS_VERIFY             (MECH_HBS_VDM | MECH_VDM_VERIFY | 2)
#define CKM_HBS_LMS_VERIFY              (MECH_HBS_VDM | MECH_VDM_VERIFY | 3)

#define HBS_MECH_EXPORT_STATE               0xC0010501
#define HBS_MECH_IMPORT_STATE               0xC0010502
#define HBS_MECH_EXPORT_KEY                 0xC0010503
#define HBS_MECH_IMPORT_LMS_KEY             0xC0010504
#define HBS_MECH_IMPORT_XMSS_KEY            0xC0010505
#define HBS_MECH_BACKUP_KEY                 0xC0010506
#define HBS_MECH_RESTORE_LMS_KEY            0xC0010507
#define HBS_MECH_RESTORE_XMSS_KEY           0xC0010508
#define HBS_MECH_DELETE_KEY                 0xC0010509
#define HBS_MECH_INFO                       0xC001050A

#define HBS_MECH_SET_HSM_ID                 0xC0010601
#define HBS_MECH_REMOVE_HSM_ID              0xC0010602
#define HBS_MECH_GET_HSM_ID                 0xC0010603
#define HBS_MECH_ADD_TRUSTED_HSM_ID         0xC0010607
#define HBS_MECH_REMOVE_TRUSTED_HSM_ID      0xC0010608
#define HBS_MECH_GET_TRUSTED_HSM_ID         0xC0010609
#define HBS_MECH_GET_NEXT_TRUSTED_HSM_ID    0xC001060A



/*          OTHER           */
#define HBS_VERIFY_SUCCESS              0x00000000
#define HBS_VERIFY_FAILED               0x000000C0UL

/*          CONSTANTS       */

#define MAX_AUX_SIZE                                    16384

#define HBS_CONFIG_KEYTYPE_LMS                  0
#define HBS_CONFIG_KEYTYPE_XMSS                 1

#endif /* HBS_DEFS_H */
