/* 
 * 
 * Copyright included by reference, please see Utimaco_Demo_License.txt
 *
 */

/* This is the C implementation for the struct MLXXX_KeyWrap_imp */

#ifndef _mlxxx_keywrap_h_0_0_0_0
  #define _mlxxx_keywrap_h_0_0_0_0

/* Defines -------------------------------------------------------------- */

/*
::IFDEF:: DECS_ALLOCATION_METHODS
#DECS_ALLOCATION_METHODS#
#DECS_FREE_METHODS#
::ENDIF::
*/

/* Declarations for Pattern u4u4 */
typedef struct mlxxx_keywrap { 
    unsigned int    flags;		// u4
    unsigned int    type;		// u4
} MLXXX_KEYWRAP;
#define mlxxx_keywrap_PATTERN u4u4
#define MLXXX_KEYWRAP_PATTERN "u4u4"
typedef MLXXX_KEYWRAP * _P_MLXXX_KEYWRAP;
#define MLXXX_KEYWRAP_SER_LEN_MAX 262143

#ifdef DEBUG
/*****************************************************************************************
 * mlxxx_keywrap_tell - Output the current state of SEED variable, if set
 * ------------------
 * Pattern: u4u4
 * ------------------
 *
 * const _P_MLXXX_KEYWRAP * s   | I
 * 
 * Returns: void.  Output goes to cmds_[x]print, ONLY IN DEBUG MODE
 */
unsigned int mlxxx_keywrap_tell ( const _P_MLXXX_KEYWRAP s );
#endif

/*****************************************************************************************
 * mlxxx_keywrap_length - Compute the serialized length of the data in the structure
 * ------------------
 * Pattern: u4u4
 * ------------------
 *
 * 
 * const _P_MLXXX_KEYWRAP * s   | I
 * 
 * Returns: unsigned int, wire-length of the data in the struct pointed to.
 */
unsigned int mlxxx_keywrap_length ( const _P_MLXXX_KEYWRAP );

/*****************************************************************************************
 * mlxxx_keywrap_serialize - Serialize data in struct for wire-transmittal
 * ------------------
 * Pattern: u4u4
 * ------------------
 *
 * 
 * MLXXX_KEYWRAP * s   | I
 * unsigned int   l_answ    | I Length of destination buffer provided
 * unsigned char *p_answ    | I Destination buffer for serialized data
 *
 * Returns: 0x0, or 
 * Errors:  E_PQMI_SERIALIZATION -- 
 */
 unsigned int mlxxx_keywrap_serialize (
  const _P_MLXXX_KEYWRAP, 
  unsigned int, 
  unsigned char *
);

/*****************************************************************************************
 * mlxxx_keywrap_scanf - Containerized cmds_scanf
 * ------------------
 * Pattern: u4u4
 * ------------------
 *
 * 
 * _P_MLXXX_KEYWRAP * s             | I 
 * const unsigned int l_data          | I 
 * const unsigned char *p_data        | I 
 *
 * Returns: unsigned int, 0x0 or Error:
 * - (as returned by cmds_scanf)
 */
unsigned int mlxxx_keywrap_scanf (
  _P_MLXXX_KEYWRAP, 
  unsigned int, 
  unsigned char *
);
#define mlxxx_keywrap_deserialize mlxxx_keywrap_scanf

#ifdef OS_SMOS
/*****************************************************************************************
 * mlxxx_keywrap_calloc - Copy-Alloc
 * ----------------------------
 *
 * Provided an object and a pointer to serialized data (ie, via l_cmd/p_cmd), this
 * method will allocate a new buffer, copy the data over, and then deserialize the
 * copy.  On output, the pp_data will be updated to point at the new buffer.
 *
 * if l_data is provided as 0x0, space will be allocated and zeroized.  Additionally:
 *
 * * u fields initialized to 0
 * * c field values point to a zeroized space of the correct width
 * * v and * field lengths are set to 0 and pointers to NULL
 *
 * Under normal conditions, caller is responsible for de-allocating the new buffer 
 * once finished with it.
 *
 * In the event this method will return non-zero, the value originally pointed to
 * is not changed.  If a NULL was passed in, the value is still NULL.  If a pointer
 * to an existing buffer (to be copied) was passed in, then that pointer still points
 * at the existing data. This may require changes to error handling in the caller.
 *
 *
 * _P_MLXXX_KEYWRAP rec;
 * unsigned int l_data = l_cmd;
 * unsigned char *pp_data = p_cmd;
 * 
 * os_mem_set(&rec, 0, sizeof(rec));
 * err = mlxxx_keywrap_calloc(&rec, &l_data, &pp_data);
 * if (err == 0x0) {
 *     // use rec ...
 *     // u fields can be get/set directly
 *     // c fields can be get/set directly, space is reserved and pointed to
 *     // v and * fields must be handled carefully
 *     //   existing data can be used as is
 *     //   if new data is supplied, (ie l_/p_ fields updated), the alloc/dealloc 
 *     //     of that data must be handled separately.
 * }
 * if (pp_data != NULL) os_mem_del(pp_data);
 * 
 * _P_MLXXX_KEYWRAP * s             		| I
 * unsigned int   *l_data       | IO 
 * unsigned char **pp_data      | IO
 * unsigned int    os_mem_type  | I one of OS_MEM_TYPE_* or 0 (default OS_MEM_TYPE_SD)
 *
 * Returns: unsigned int, 0x0 or Error:
 * - (as returned by cmds_scanf) 
 *    or E_QSR2MUX_MALLOC
 */
unsigned int mlxxx_keywrap_calloc(void *, unsigned int *, void **, unsigned int);

/*****************************************************************************************
 * mlxxx_keywrap_sdata_store - serialize data and store in some db record, in secret area
 * ----------------------------
 *
 * _P_MLXXX_KEYWRAP * s             		| I
 * DB *                         | I 
 * unsigned char  *index        | I - used as is, make sure it matches the DB's index length
 * unsigned int    l_secret     | I - Note: The associated SECRET data
 * unsigned char  *p_secret     | I - Note: The associated SECRET data
 *
 * Returns: unsigned int, 0x0 or Error:
 * - (as returned by db module) 
 *    or E_QSR2MUX_MALLOC
 */
unsigned int mlxxx_keywrap_pdata_store(
     void * p_rec, void * p_db, unsigned char *db_ndx,
     unsigned int l_secret, unsigned char *p_secret);

/*****************************************************************************************
 * mlxxx_keywrap_pdata_store - serialize data and store in some db record, in public area
 * ----------------------------
 *
 * _P_MLXXX_KEYWRAP * s             		| I
 * DB *                         | I 
 * unsigned char  *index        | I - used as is, make sure it matches the DB's index length
 * unsigned int    l_public     | I - Note: The associated PUBLIC data
 * unsigned char  *p_public     | I - Note: The associated PUBLIC data
 *
 * Returns: unsigned int, 0x0 or Error:
 * - (as returned by db module) 
 *    or E_QSR2MUX_MALLOC
 */
unsigned int mlxxx_keywrap_pdata_store(
     void * p_rec, void * p_db, unsigned char *db_ndx,
     unsigned int l_public, unsigned char *p_public);

/*****************************************************************************************
 * mlxxx_keywrap_alloc_answ - Containerized cmds_alloc_answ
 * ----------------------------
 *
 * void *       ctxt | I 
 * _P_MLXXX_KEYWRAP p_obj    | I
 *
 * Returns: unsigned int, 0x0 or Error:
 *    from cmds
 *    or E_QSR2MUX_MALLOC
 */
unsigned int mlxxx_keywrap_alloc_answ ( void *, _P_MLXXX_KEYWRAP);
#else
unsigned int mlxxx_keywrap_new (
    _P_MLXXX_KEYWRAP *,
    unsigned int,
    unsigned char *
); 
unsigned int    mlxxx_keywrap_raw_len   ( _P_MLXXX_KEYWRAP );
unsigned char * mlxxx_keywrap_raw       ( _P_MLXXX_KEYWRAP );
int mlxxx_keywrap_pack(_P_MLXXX_KEYWRAP const p_obj, unsigned int *l_dest, unsigned char **dest);

void mlxxx_keywrap_free ( _P_MLXXX_KEYWRAP );
#endif

/***********************************************************************
 * Non-autogenerated methods follow.
 */

//  "exfiles/mlxxx_keywrap_ex.h"
#endif