/* 
 * 03c autogenerated 2024-11-06T12:45:11.6556093 using 
 * CS_SdkVpl version 0.0.6
 * Template version 0002
 * Source XML Document version 01d,2024-03-26,riw
 * 
 * Copyright included by reference, please see Utimaco_Demo_License.txt
 *
 */

/* This is the C implementation for the struct MLKEM_Decap_imp */

#ifndef _mlkem_decap_h_0_0_0_0
  #define _mlkem_decap_h_0_0_0_0

/* Defines -------------------------------------------------------------- */

#define MLKEM_FLAG_MASK 0xF2030000 /* ML-KEM Define mask */
#define MLKEM_FLAG_BLOB 0xF2030000 /* Return secret as external blob (MBK encrypted) */
#define MLKEM_FLAG_KH 0xF2040001 /* Return handle to internally stored generated secret */

/*
::IFDEF:: DECS_ALLOCATION_METHODS
#DECS_ALLOCATION_METHODS#
#DECS_FREE_METHODS#
::ENDIF::
*/

/* Declarations for Pattern u4u4v2v2 */
typedef struct mlkem_decap { 
    unsigned int    flags;		// u4
    unsigned int    type;		// u4
    unsigned int    l_privatekey;		// v2
    unsigned char * p_privatekey; 
    unsigned int    l_cyphertext;		// v2
    unsigned char * p_cyphertext; 
} MLKEM_DECAP;
#define mlkem_decap_PATTERN u4u4v2v2
#define MLKEM_DECAP_PATTERN "u4u4v2v2"
typedef MLKEM_DECAP * _P_MLKEM_DECAP;
#define MLKEM_DECAP_SER_LEN_MAX 131080

#ifdef DEBUG
/*****************************************************************************************
 * mlkem_decap_tell - Output the current state of CYPHERTEXT variable, if set
 * ------------------
 * Pattern: u4u4v2v2
 * ------------------
 *
 * const _P_MLKEM_DECAP * s   | I
 * 
 * Returns: void.  Output goes to cmds_[x]print, ONLY IN DEBUG MODE
 */
unsigned int mlkem_decap_tell ( const _P_MLKEM_DECAP s );
#endif

/*****************************************************************************************
 * mlkem_decap_length - Compute the serialized length of the data in the structure
 * ------------------
 * Pattern: u4u4v2v2
 * ------------------
 *
 * 
 * const _P_MLKEM_DECAP * s   | I
 * 
 * Returns: unsigned int, wire-length of the data in the struct pointed to.
 */
unsigned int mlkem_decap_length ( const _P_MLKEM_DECAP );

/*****************************************************************************************
 * mlkem_decap_serialize - Serialize data in struct for wire-transmittal
 * ------------------
 * Pattern: u4u4v2v2
 * ------------------
 *
 * 
 * MLKEM_DECAP * s   | I
 * unsigned int   l_answ    | I Length of destination buffer provided
 * unsigned char *p_answ    | I Destination buffer for serialized data
 *
 * Returns: 0x0, or 
 * Errors:  E_PQMI_SERIALIZATION -- 
 */
 unsigned int mlkem_decap_serialize (
  const _P_MLKEM_DECAP, 
  unsigned int, 
  unsigned char *
);

/*****************************************************************************************
 * mlkem_decap_scanf - Containerized cmds_scanf
 * ------------------
 * Pattern: u4u4v2v2
 * ------------------
 *
 * 
 * _P_MLKEM_DECAP * s             | I 
 * const unsigned int l_data          | I 
 * const unsigned char *p_data        | I 
 *
 * Returns: unsigned int, 0x0 or Error:
 * - (as returned by cmds_scanf)
 */
unsigned int mlkem_decap_scanf (
  _P_MLKEM_DECAP, 
  unsigned int, 
  unsigned char *
);
#define mlkem_decap_deserialize mlkem_decap_scanf

#ifdef OS_SMOS
/*****************************************************************************************
 * mlkem_decap_calloc - Copy-Alloc
 * ----------------------------
 *
 * Provided an object and a pointer to serialized data (ie, via l_cmd/p_cmd), this
 * method will allocate a new buffer, copy the data over, and then deserialize the
 * copy.  On output, the pp_data will be updated to point at the new buffer.
 *
 * if l_data is provided as 0x0, space will be allocated and zeroized.  Additionally:
 *
 * * u fields initialized to 0
 * * c field values point to a zeroized space of the correct width
 * * v and * field lengths are set to 0 and pointers to NULL
 *
 * Under normal conditions, caller is responsible for de-allocating the new buffer 
 * once finished with it.
 *
 * In the event this method will return non-zero, the value originally pointed to
 * is not changed.  If a NULL was passed in, the value is still NULL.  If a pointer
 * to an existing buffer (to be copied) was passed in, then that pointer still points
 * at the existing data. This may require changes to error handling in the caller.
 *
 *
 * _P_MLKEM_DECAP rec;
 * unsigned int l_data = l_cmd;
 * unsigned char *pp_data = p_cmd;
 * 
 * os_mem_set(&rec, 0, sizeof(rec));
 * err = mlkem_decap_calloc(&rec, &l_data, &pp_data);
 * if (err == 0x0) {
 *     // use rec ...
 *     // u fields can be get/set directly
 *     // c fields can be get/set directly, space is reserved and pointed to
 *     // v and * fields must be handled carefully
 *     //   existing data can be used as is
 *     //   if new data is supplied, (ie l_/p_ fields updated), the alloc/dealloc 
 *     //     of that data must be handled separately.
 * }
 * if (pp_data != NULL) os_mem_del(pp_data);
 * 
 * _P_MLKEM_DECAP * s             		| I
 * unsigned int   *l_data       | IO 
 * unsigned char **pp_data      | IO
 * unsigned int    os_mem_type  | I one of OS_MEM_TYPE_* or 0 (default OS_MEM_TYPE_SD)
 *
 * Returns: unsigned int, 0x0 or Error:
 * - (as returned by cmds_scanf) 
 *    or E_QSR2MUX_MALLOC
 */
unsigned int mlkem_decap_calloc(void *, unsigned int *, void **, unsigned int);

/*****************************************************************************************
 * mlkem_decap_sdata_store - serialize data and store in some db record, in secret area
 * ----------------------------
 *
 * _P_MLKEM_DECAP * s             		| I
 * DB *                         | I 
 * unsigned char  *index        | I - used as is, make sure it matches the DB's index length
 * unsigned int    l_secret     | I - Note: The associated SECRET data
 * unsigned char  *p_secret     | I - Note: The associated SECRET data
 *
 * Returns: unsigned int, 0x0 or Error:
 * - (as returned by db module) 
 *    or E_QSR2MUX_MALLOC
 */
unsigned int mlkem_decap_pdata_store(
     void * p_rec, void * p_db, unsigned char *db_ndx,
     unsigned int l_secret, unsigned char *p_secret);

/*****************************************************************************************
 * mlkem_decap_pdata_store - serialize data and store in some db record, in public area
 * ----------------------------
 *
 * _P_MLKEM_DECAP * s             		| I
 * DB *                         | I 
 * unsigned char  *index        | I - used as is, make sure it matches the DB's index length
 * unsigned int    l_public     | I - Note: The associated PUBLIC data
 * unsigned char  *p_public     | I - Note: The associated PUBLIC data
 *
 * Returns: unsigned int, 0x0 or Error:
 * - (as returned by db module) 
 *    or E_QSR2MUX_MALLOC
 */
unsigned int mlkem_decap_pdata_store(
     void * p_rec, void * p_db, unsigned char *db_ndx,
     unsigned int l_public, unsigned char *p_public);

/*****************************************************************************************
 * mlkem_decap_alloc_answ - Containerized cmds_alloc_answ
 * ----------------------------
 *
 * void *       ctxt | I 
 * _P_MLKEM_DECAP p_obj    | I
 *
 * Returns: unsigned int, 0x0 or Error:
 *    from cmds
 *    or E_QSR2MUX_MALLOC
 */
unsigned int mlkem_decap_alloc_answ ( void *, _P_MLKEM_DECAP);
#else
unsigned int mlkem_decap_new (
    _P_MLKEM_DECAP *,
    unsigned int,
    unsigned char *
); 
unsigned int    mlkem_decap_raw_len   ( _P_MLKEM_DECAP );
unsigned char * mlkem_decap_raw       ( _P_MLKEM_DECAP );

int mlkem_decap_pack(_P_MLKEM_DECAP const p_obj, unsigned int *l_dest, unsigned char **dest);

void mlkem_decap_free ( _P_MLKEM_DECAP );
#endif

/***********************************************************************
 * Non-autogenerated methods follow.
 */

//  "exfiles/mlkem_decap_ex.h"
#endif
