package com.utimaco.cs2.mdl.pqmi;

/*
 * 03c autogenerated %DATE% using
 * gatherErrCodes.pl
 * from SdkVPL generated source
 *
 * Copyright included by reference, please see Utimaco_Demo_License_2025.pdf
 */

import com.utimaco.cs2.mdl.ErrList;
import java.util.ArrayList;
import java.util.Arrays;

public class PqmiErrorList extends ErrList {
    private static final int PQMI_USK =         0xA6; // Utimaco signed modules
    private static final int PQMI_AMSK =        0x1A0; // Alt Mdl Signing Key
    private static final int ML_USK =   0xA5; // Utimaco signed modules
    private static final int ML_AMSK =  0x1A5; // Alt Mdl Signing Key
    private static final int LATTICE_USK =      0xA3; // Utimaco signed modules
    private static final int LATTICE_AMSK =     0x1A3; // Alt Mdl Signing Key
    private static final int HBS_USK =  0xA2; // Utimaco signed modules
    private static final int HBS_AMSK =         0x1A2; // Alt Mdl Signing Key


    public static final int E_PQMI_PERMISSION_DENIED            =       0xB1A10001;     // permission denied
    public static final int E_PQMI_PARAM                =       0xB1A10002;     // invalid parameter
    public static final int E_PQMI_PARAM_LEN            =       0xB1A10003;     // invalid parameter length
    public static final int E_PQMI_MALLOC               =       0xB1A10004;     // memory allocation failed
    public static final int E_PQMI_MODE         =       0xB1A10005;     // invalid mode
    public static final int E_PQMI_ITEM_NOT_FOUND               =       0xB1A10006;     // item not found
    public static final int E_PQMI_MODULE_DEP           =       0xB1A10007;     // unresolved module dependency
    public static final int E_PQMI_FILE_IO              =       0xB1A10008;     // file I/O error
    public static final int E_PQMI_SERIALIZATION                =       0xBA00E00;      /* buffer martialing error */
    public static final int E_PQMI_SERIALIZAT_IN                =       0xBA00E01;      /* buffer deserialization error */
    public static final int E_PQMI_SERIALIZAT_OUT               =       0xBA00E02;      /* buffer serialization error */
    public static final int E_PQMI_NOT_IMPLEMENTED              =       0xBA00A21;      /* function not implemented or is deprecated/removed */
    public static final int E_PQMI_NOT_SUPPORTED                =       0xBA00A22;      /* method/mode/algo/keysize/etc not supported */
    public static final int E_PQMI_DEPRECATED_REMOVED           =       0xBA00A23;      /* method removed, see docs for new methods */
    public static final int E_PQMI_MEM          =       0xBA00001;      /* memory allocation error */
    public static final int E_PQMI_INV_FLAG             =       0xBA00002;      /* invalid flag parameter value */
    public static final int E_PQMI_INV_KEY_TYPE         =       0xBA00003;      /* invalid key type parameter value */
    public static final int E_PQMI_BUFFER_TOO_SMALL             =       0xBA00004;      /* Length of output buffer too small */
    public static final int E_PQMI_INV_SEED             =       0xBA00005;      /* Invalid seed length or seed not set */
    public static final int E_PQMI_INV_KEY_LEN          =       0xBA00006;      /* Invalid key length */
    public static final int E_PQMI_INV_PARAM            =       0xBA00007;      /* Invalid Parameter */
    public static final int E_PQMI_INV_SIGNATURE                =       0xBA00008;      /* Invalid Signature */
    public static final int E_PQMI_INV_CHECKSUM         =       0xBA00009;      /* Invalid checksum on backup blob */
    public static final int E_PQMI_GENERAL_ERR          =       0xBA00A00;      /* undifferentiated error thrown by this module. Contact Development. */
    public static final int E_ML_MEM            =       0xB0A50001;     /* Cannot allocate memory                        */
    public static final int E_ML_INV_FLAG               =       0xB0A50002;     /* Invalid parameter value in flags              */
    public static final int E_ML_INV_KEY_TYPE           =       0xB0A50003;     /* Invalid parameter value in key_type           */
    public static final int E_ML_BUFFER_TOO_SMALL               =       0xB0A50004;     /* Length of output buffer is too small          */
    public static final int E_ML_INV_SEED               =       0xB0A50005;     /* Invalid seed length or seed not set           */
    public static final int E_ML_INV_KEY_LEN            =       0xB0A50006;     /* Invalid key length                            */
    public static final int E_ML_INV_PARAM              =       0xB0A50007;     /* Invalid parameter                             */
    public static final int E_ML_INV_SIGNATURE          =       0xB0A50008;     /* Invalid signature                             */
    public static final int E_ML_DECRYPT_ERROR          =       0xB0A50009;     /* Decrypt error                                 */
    public static final int E_LATTICE_MEM               =       0xB0A30001;     /* Cannot allocate memory                        */
    public static final int E_LATTICE_INV_FLAG          =       0xB0A30002;     /* Invalid parameter value in æflagsÆ            */
    public static final int E_LATTICE_INV_KEY_TYPE              =       0xB0A30003;     /* Invalid parameter value in ækey_typeÆ         */
    public static final int E_LATTICE_BUFFER_TOO_SMALL          =       0xB0A30004;     /* Length of output buffer is too small          */
    public static final int E_LATTICE_INV_SEED          =       0xB0A30005;     /* Invalid seed length or seed not set           */
    public static final int E_LATTICE_INV_KEY_LEN               =       0xB0A30006;     /* Invalid key length                            */
    public static final int E_LATTICE_INV_PARAM         =       0xB0A30007;     /* Invalid parameter                             */
    public static final int E_LATTICE_INV_SIGNATURE             =       0xB0A30008;     /* Invalid signature                             */
    public static final int E_LATTICE_DECRYPT_ERROR             =       0xB0A30009;     /* Decrypt error                                 */
    public static final int E_HBS_GENERAL               =       0xB0A20000;     // HBS general error
    public static final int E_HBS_INTERNAL              =       0xB0A20001;     // internal error
    public static final int E_HBS_MALLOC                =       0xB0A20002;     // memory allocation error
    public static final int E_HBS_INVALID_MECH_PARAMS           =       0xB0A20003;     // invalid mechanism parameters size
    public static final int E_HBS_INVALID_PARAM_VALUE           =       0xB0A20004;     // invalid algorithm pararameters
    public static final int E_HBS_GENKEY_FAILED         =       0xB0A20005;     // key generation failed
    public static final int E_HBS_INVALID_PRIV_KEY              =       0xB0A20006;     // invalid key
    public static final int E_HBS_SIGN_ERROR            =       0xB0A20007;     // signature error
    public static final int E_HBS_VERIFY_ERROR          =       0xB0A20008;     // verification error
    public static final int E_HBS_SIGNATURE_REQUIRED            =       0xB0A20009;     // signature required at init
    public static final int E_HBS_DB_INSERT_FAILED              =       0xB0A2000A;     // unable to save data to HBS datatbase
    public static final int E_HBS_BUFFER_TOO_SMALL              =       0xB0A2000B;     // buffer too small
    public static final int E_HBS_INVALID_TAG_LEN               =       0xB0A2000C;     // invalid TLV tag length
    public static final int E_HBS_INVALID_TAG           =       0xB0A2000D;     // invalid TLV tag
    public static final int E_HBS_OUT_OF_TAG_SPACE              =       0xB0A2000E;     // not enough memory for TLV
    public static final int E_HBS_BLOB_FORMAT           =       0xB0A2000F;     // invalid format of BLOB
    public static final int E_HBS_BLOB_CV               =       0xB0A20010;     // control value of BLOB failed
    public static final int E_HBS_INVALID_KEY           =       0xB0A20011;     // invalid key
    public static final int E_HBS_NO_KEYS_LEFT          =       0xB0A20100;     // all key indexes used
    public static final int E_HBS_INVALID_INTERVALS             =       0xB0A20101;     // invalid intervals database
    public static final int E_HBS_INTERVALS_BUFFER_LEN          =       0xB0A20102;     // out of memory for intervals
    public static final int E_HBS_KEYS_NOT_AVAILABLE            =       0xB0A20103;     // no key index available
    public static final int E_HBS_INTERVALS_OVERLAP             =       0xB0A20104;     // error joining two intervals
    public static final int E_HBS_EXCEEDED_INTERVALS_LIMIT              =       0xB0A20105;     // to many intervals
    public static final int E_HBS_PERMISSION_DENIED             =       0xB0A20106;     // permission denied
    public static final int E_HBS_VERSION_NOT_SUPPORTED         =       0xB0A20107;     // version not supported
    public static final int E_HBS_IMPORT_NOT_ALLOWED            =       0xB0A20108;     // import not allowed
    public static final int E_HBS_INIT_SEM_FAILED               =       0xB0A20109;     // initialization of database locking failed
    public static final int E_HBS_REQ_SEM_FAILED                =       0xB0A2010A;     // database locking failed
    public static final int E_HBS_INVALID_HSM_ID                =       0xB0A20200;     // invalid HSM ID
    public static final int E_HBS_CORRUPTED_HSM_ID              =       0xB0A20201;     // corrupted HSM ID
    public static final int E_HBS_UNSUPPORTED_HSM_ID            =       0xB0A20202;     // HSM ID not supported
    public static final int E_HBS_HSM_ID_EXISTS         =       0xB0A20203;     // HSM ID already exists
    public static final int E_HBS_HSM_ID_NOT_FOUND              =       0xB0A20204;     // HSM ID not found
    public static final int E_HBS_INVALID_TRUSTED_HSM_ID                =       0xB0A2020A;     // invalid trusted HSM ID
    public static final int E_HBS_CORRUPTED_TRUSTED_HSM_ID              =       0xB0A2020B;     // corrupted trusted HSM ID
    public static final int E_HBS_UNSUPPORTED_TRUSTED_HSM_ID            =       0xB0A2020C;     // trusted HSM ID not supported
    public static final int E_HBS_TRUSTED_HSM_ID_EXISTS         =       0xB0A2020D;     // trusted HSM ID already exists
    public static final int E_HBS_TRUSTED_HSM_ID_NOT_FOUND              =       0xB0A2020E;     // trusted HSM ID not found
    public static final int E_HBS_INVALID_COUNTER_RECORD                =       0xB0A2020F;     // invalid counter record
    public static final int E_HBS_CORRUPTED_COUNTER_RECORD              =       0xB0A20210;     // corrupted counter record
    public static final int E_HBS_UNSUPPORTED_COUNTER_RECORD            =       0xB0A20211;     // counter record not supported
    public static final int E_HBS_COUNTER_RECORD_EXISTS         =       0xB0A20212;     // counter record already exists
    public static final int E_HBS_INVALID_DB_RECORD             =       0xB0A20213;     // invalid database record
    public static final int E_HBS_CORRUPTED_DB_RECORD           =       0xB0A20214;     // corrupted database record
    public static final int E_HBS_UNSUPPORTED_DB_RECORD         =       0xB0A20215;     // database record not supported
    public static final int E_HBS_COUNTER_OVERFLOW              =       0xB0A20216;     // counter overflow
    public static final int E_HBS_INVALID_MESSAGE               =       0xB0A20217;     // invalid message
    public static final int E_HBS_CORRUPTED_MESSAGE             =       0xB0A20218;     // corrupted message
    public static final int E_HBS_UNSUPPORTED_MESSAGE           =       0xB0A20219;     // message not supported
    public static final int E_HBS_INVALID_RECEIVER_HSM_ID               =       0xB0A2021A;     // invalid receiver HSM ID
    public static final int E_HBS_INVALID_KEY_REFERENCE         =       0xB0A2021B;     // invalid key reference
    public static final int E_HBS_MESSAGE_EXPIRED               =       0xB0A2021C;     // message expired
    public static final int E_HBS_INVALID_COUNTERS_SIZE         =       0xB0A2021D;     // invalid counter size
    public static final int E_HBS_INVALID_KEYTYPE               =       0xB0A2021E;     // invalid key type


    private static ArrayList<String> popAList(long id, String name, String cmnt) {
        if ((id >= 0) && (id <= 0xFFF)) {
            id = (id<<16);
        }
        ArrayList<String> tals = new ArrayList<String>();
        String mid = "0x" + String.format("%08x",  id).replace("ffffffff", "").toUpperCase();
        tals.addAll(Arrays.asList(mid, name, cmnt));
        return tals;
    }

    public PqmiErrorList () {
        errlist.put(0xA6, popAList(PQMI_USK, "PQMI_USK", ""));
        errlist.put(0x1A0, popAList(PQMI_AMSK, "PQMI_AMSK", ""));
        errlist.put(0xA5, popAList(ML_USK, "ML_USK", ""));
        errlist.put(0x1A5, popAList(ML_AMSK, "ML_AMSK", ""));
        errlist.put(0xA3, popAList(LATTICE_USK, "LATTICE_USK", ""));
        errlist.put(0x1A3, popAList(LATTICE_AMSK, "LATTICE_AMSK", ""));
        errlist.put(0xA2, popAList(HBS_USK, "HBS_USK", ""));
        errlist.put(0x1A2, popAList(HBS_AMSK, "HBS_AMSK", ""));

            push(0xB1A10001, "PERMISSION_DENIED", "permission denied");
        push(0xB1A10002, "PARAM", "invalid parameter");
        push(0xB1A10003, "PARAM_LEN", "invalid parameter length");
        push(0xB1A10004, "MALLOC", "memory allocation failed");
        push(0xB1A10005, "MODE", "invalid mode");
        push(0xB1A10006, "ITEM_NOT_FOUND", "item not found");
        push(0xB1A10007, "MODULE_DEP", "unresolved module dependency");
        push(0xB1A10008, "FILE_IO", "file I/O error");
        push(0xBA00E00, "E_PQMI_SERIALIZATION", "buffer martialing error");
        push(0xBA00E01, "E_PQMI_SERIALIZAT_IN", "buffer deserialization error");
        push(0xBA00E02, "E_PQMI_SERIALIZAT_OUT", "buffer serialization error");
        push(0xBA00A21, "E_PQMI_NOT_IMPLEMENTED", "function not implemented or is deprecated/removed");
        push(0xBA00A22, "E_PQMI_NOT_SUPPORTED", "method/mode/algo/keysize/etc not supported");
        push(0xBA00A23, "E_PQMI_DEPRECATED_REMOVED", "method removed, see docs for new methods");
        push(0xBA00001, "E_PQMI_MEM", "memory allocation error");
        push(0xBA00002, "E_PQMI_INV_FLAG", "invalid flag parameter value");
        push(0xBA00003, "E_PQMI_INV_KEY_TYPE", "invalid key type parameter value");
        push(0xBA00004, "E_PQMI_BUFFER_TOO_SMALL", "Length of output buffer too small");
        push(0xBA00005, "E_PQMI_INV_SEED", "Invalid seed length or seed not set");
        push(0xBA00006, "E_PQMI_INV_KEY_LEN", "Invalid key length");
        push(0xBA00007, "E_PQMI_INV_PARAM", "Invalid Parameter");
        push(0xBA00008, "E_PQMI_INV_SIGNATURE", "Invalid Signature");
        push(0xBA00009, "E_PQMI_INV_CHECKSUM", "Invalid checksum on backup blob");
        push(0xBA00A00, "E_PQMI_GENERAL_ERR", "undifferentiated error thrown by this module. Contact Development.");
        push(0xB0A50001, "MEM", "Cannot allocate memory");
        push(0xB0A50002, "INV_FLAG", "Invalid parameter value in flags");
        push(0xB0A50003, "INV_KEY_TYPE", "Invalid parameter value in key_type");
        push(0xB0A50004, "BUFFER_TOO_SMALL", "Length of output buffer is too small");
        push(0xB0A50005, "INV_SEED", "Invalid seed length or seed not set");
        push(0xB0A50006, "INV_KEY_LEN", "Invalid key length");
        push(0xB0A50007, "INV_PARAM", "Invalid parameter");
        push(0xB0A50008, "INV_SIGNATURE", "Invalid signature");
        push(0xB0A50009, "DECRYPT_ERROR", "Decrypt error");
        push(0xB0A30001, "MEM", "Cannot allocate memory");
        push(0xB0A30002, "INV_FLAG", "Invalid parameter value in æflagsÆ");
        push(0xB0A30003, "INV_KEY_TYPE", "Invalid parameter value in ækey_typeÆ");
        push(0xB0A30004, "BUFFER_TOO_SMALL", "Length of output buffer is too small");
        push(0xB0A30005, "INV_SEED", "Invalid seed length or seed not set");
        push(0xB0A30006, "INV_KEY_LEN", "Invalid key length");
        push(0xB0A30007, "INV_PARAM", "Invalid parameter");
        push(0xB0A30008, "INV_SIGNATURE", "Invalid signature");
        push(0xB0A30009, "DECRYPT_ERROR", "Decrypt error");
        push(0xB0A20000, "GENERAL", "HBS general error");
        push(0xB0A20001, "INTERNAL", "internal error");
        push(0xB0A20002, "MALLOC", "memory allocation error");
        push(0xB0A20003, "INVALID_MECH_PARAMS", "invalid mechanism parameters size ");
        push(0xB0A20004, "INVALID_PARAM_VALUE", "invalid algorithm pararameters");
        push(0xB0A20005, "GENKEY_FAILED", "key generation failed");
        push(0xB0A20006, "INVALID_PRIV_KEY", "invalid key");
        push(0xB0A20007, "SIGN_ERROR", "signature error");
        push(0xB0A20008, "VERIFY_ERROR", "verification error");
        push(0xB0A20009, "SIGNATURE_REQUIRED", "signature required at init");
        push(0xB0A2000A, "DB_INSERT_FAILED", "unable to save data to HBS datatbase");
        push(0xB0A2000B, "BUFFER_TOO_SMALL", "buffer too small");
        push(0xB0A2000C, "INVALID_TAG_LEN", "invalid TLV tag length   ");
        push(0xB0A2000D, "INVALID_TAG", "invalid TLV tag");
        push(0xB0A2000E, "OUT_OF_TAG_SPACE", "not enough memory for TLV");
        push(0xB0A2000F, "BLOB_FORMAT", "invalid format of BLOB");
        push(0xB0A20010, "BLOB_CV", "control value of BLOB failed");
        push(0xB0A20011, "INVALID_KEY", "invalid key");
        push(0xB0A20100, "NO_KEYS_LEFT", "all key indexes used");
        push(0xB0A20101, "INVALID_INTERVALS", "invalid intervals database");
        push(0xB0A20102, "INTERVALS_BUFFER_LEN", "out of memory for intervals");
        push(0xB0A20103, "KEYS_NOT_AVAILABLE", "no key index available");
        push(0xB0A20104, "INTERVALS_OVERLAP", "error joining two intervals");
        push(0xB0A20105, "EXCEEDED_INTERVALS_LIMIT", "to many intervals");
        push(0xB0A20106, "PERMISSION_DENIED", "permission denied");
        push(0xB0A20107, "VERSION_NOT_SUPPORTED", "version not supported");
        push(0xB0A20108, "IMPORT_NOT_ALLOWED", "import not allowed");
        push(0xB0A20109, "INIT_SEM_FAILED", "initialization of database locking failed");
        push(0xB0A2010A, "REQ_SEM_FAILED", "database locking failed");
        push(0xB0A20200, "INVALID_HSM_ID", "invalid HSM ID");
        push(0xB0A20201, "CORRUPTED_HSM_ID", "corrupted HSM ID");
        push(0xB0A20202, "UNSUPPORTED_HSM_ID", "HSM ID not supported");
        push(0xB0A20203, "HSM_ID_EXISTS", "HSM ID already exists");
        push(0xB0A20204, "HSM_ID_NOT_FOUND", "HSM ID not found");
        push(0xB0A2020A, "INVALID_TRUSTED_HSM_ID", "invalid trusted HSM ID");
        push(0xB0A2020B, "CORRUPTED_TRUSTED_HSM_ID", "corrupted trusted HSM ID");
        push(0xB0A2020C, "UNSUPPORTED_TRUSTED_HSM_ID", "trusted HSM ID not supported");
        push(0xB0A2020D, "TRUSTED_HSM_ID_EXISTS", "trusted HSM ID already exists");
        push(0xB0A2020E, "TRUSTED_HSM_ID_NOT_FOUND", "trusted HSM ID not found");
        push(0xB0A2020F, "INVALID_COUNTER_RECORD", "invalid counter record");
        push(0xB0A20210, "CORRUPTED_COUNTER_RECORD", "corrupted counter record");
        push(0xB0A20211, "UNSUPPORTED_COUNTER_RECORD", "counter record not supported");
        push(0xB0A20212, "COUNTER_RECORD_EXISTS", "counter record already exists");
        push(0xB0A20213, "INVALID_DB_RECORD", "invalid database record");
        push(0xB0A20214, "CORRUPTED_DB_RECORD", "corrupted database record");
        push(0xB0A20215, "UNSUPPORTED_DB_RECORD", "database record not supported");
        push(0xB0A20216, "COUNTER_OVERFLOW", "counter overflow");
        push(0xB0A20217, "INVALID_MESSAGE", "invalid message");
        push(0xB0A20218, "CORRUPTED_MESSAGE", "corrupted message");
        push(0xB0A20219, "UNSUPPORTED_MESSAGE", "message not supported");
        push(0xB0A2021A, "INVALID_RECEIVER_HSM_ID", "invalid receiver HSM ID");
        push(0xB0A2021B, "INVALID_KEY_REFERENCE", "invalid key reference");
        push(0xB0A2021C, "MESSAGE_EXPIRED", "message expired ");
        push(0xB0A2021D, "INVALID_COUNTERS_SIZE", "invalid counter size");
        push(0xB0A2021E, "INVALID_KEYTYPE", "invalid key type");

    }
}
