package com.utimaco.cs2.mdl.pqmi;
/* 
 * 03c autogenerated 2024-04-01T16:12:58.7893534 using 
 * CS_SdkVpl version 0.0.5
 * Source XML Document version 01d,2024-03-26,riw
 * 
 * Copyright included by reference, please see Utimaco_Demo_License.txt
 */

import java.nio.ByteBuffer;

import com.utimaco.cs2.mdl.SdkSequence;
import com.utimaco.cs2.mdl.DeserializationError;
import com.utimaco.cs2.mdl.SerializationError;
import com.utimaco.cs2.mdl.Utils;

public class HbsPubInfoSeq extends SdkSequence {
    private static final int HbsPubInfoSq_MAGIC = 0x6ffe5193;
    
    // Auto-generated constructor stubs
    public HbsPubInfoSeq (int maxSeqSize) {
        super(maxSeqSize);
    }
    
    public HbsPubInfo get(int n) {
        try {
            HbsPubInfo obj = (HbsPubInfo)super.get(n);
            return obj;
        } catch (IndexOutOfBoundsException oob) { }
        return null;
    }
    
    public HbsPubInfo get(String n) {
        return (HbsPubInfo)super.get(n);
    }
    
    public boolean add(String n, HbsPubInfo obj) {
        return super.add(n, obj);
    }
    
    public boolean deserialize (byte [] bff) throws DeserializationError {
        if (!seqSet(bff, HbsPubInfoSq_MAGIC)) {
            throw new DeserializationError("Not a(n) HbsPubInfoSeq (bad magic)");
        }
        int n = 0;
        ByteBuffer r = null;

        clear();
        while ((r = seqRec(n++)) != null) {
            byte uuidlen = r.get();
            byte [] uuid = new byte[uuidlen];
            r.get(uuid, 0, uuidlen);
            byte [] arr = r.slice().array();
            HbsPubInfo obj = new HbsPubInfo(arr);
            String uuidchk = obj.hexAsciiHash(false);
            String uuidstr = Utils.convertToHex(uuid);
            if (uuidchk.compareToIgnoreCase(uuidstr) == 0) {
                add(uuidchk, obj);
            }
        }
        return true;
    }
    
    public int getMaxSerLen () {
        int mlx = 0;
        for (int i = 0; i < count(); i++) {
            int len = ((HbsPubInfo)get(i)).length();
            if (len > mlx) { mlx = len; }
        }
        return mlx;
    }
    
    public byte [] serialize () throws SerializationError {
        ByteBuffer seq = seqPrep(HbsPubInfoSq_MAGIC);
        for (int i = 0; i < count(); i++) {
            HbsPubInfo obj = get(i);
            String hexascii = obj.hexAsciiHash(false);
            seq.put(hexascii.getBytes());
            seq.put(obj.serialize());
        }
        return seq.array();
    }
}