package com.utimaco.cs2.mdl.pqmi;

/* 
 * 03c autogenerated 2024-04-01T16:12:59.946479 using 
 * CS_SdkVpl version 0.0.5
 * Source XML Document version 01d,2024-03-26,riw
 * 
 * Copyright included by reference, please see Utimaco_Demo_License.txt
 */

import java.io.IOException;
import com.utimaco.cs2.mdl.I_SdkBuffer;
import CryptoServerAPI.CryptoServerException;
import CryptoServerCXI.CryptoServerCXI;
import java.nio.ByteBuffer;
import com.utimaco.cs2.mdl.SdkBuffer;
import com.utimaco.cs2.mdl.DeserializationError;
import com.utimaco.cs2.mdl.SerializationError;

// Typed parameters (if any)
import com.utimaco.cs2.mdl.any.CxiKeyAttributes;

/**
 * Pattern: u4v1v1v2v2*
 *
 * Field declarations
 * <pre>
 * flags:  (u4) unsigned int[string]{}
 *   int               flags                          = (int)0x0;           // Used for state machine/define block contents from  u4

 * source_id:  (v1) unsigned byte + ...[string]{}
 *   byte []           source_id                      = new byte[0];        // Trusted Name of source HSM (if needed)//  v1
 * dest_id:  (v1) unsigned byte + ...[string]{}
 *   byte []           dest_id                        = new byte[0];        // Trusted Name of destination HSM (if needed)//  v1
 * keydata:  (v2) unsigned short + ...[string]{}
 *   byte []           keydata                        = new byte[0];        // Reference key attributes// CxiKeyAttributes v2

 * source_key:  (v2) unsigned short + ...[string]{}
 *   byte []           source_key                     = new byte[0];        // Reference key attributes//  v2

 * chunk:  (*) additional bytes of unfixed length[string]{}
 *   byte []           chunk                          = new byte[0];        // Use depends on SFC called and direction in or out//  *

 * </pre>
 * @author SFCBUFFERS
 *
 */
public class HbsInfoBlock extends SdkBuffer implements I_SdkBuffer {
    int ModuleID = 0x087; // Default is 'echo' from ADM
    int SFC = 0; // Default is 'echo' from ADM
    protected static final String pattern = "u4v1v1v2v2*"; 

    // Interface specific defined def elements
    public static final int    HBS_BLOCK_LIST 	=  0x1; 		// Retrieve key blob from source HSM
    public static final int    HBS_BLOCK_RETRIEVE 	=  0x10; 		// Retrieve key blob from source HSM
    public static final int    HBS_BLOCK_INJECT 	=  0x20; 		// Inject key blob into destination HSM
    public static final int    HBS_BLOCK_PULL 	=  0x100; 		// Retrieve state chunk from source HSM for destination HSM
    public static final int    HBS_BLOCK_PUSH 	=  0x200; 		// Inject state chunk into destination HSM

    // Interface Fields
    int flags = 0x0;
    byte [] source_id = new byte[0];
    byte [] dest_id = new byte[0];
    byte [] keydata = new byte[0];
    byte [] source_key = new byte[0];
    byte [] chunk = new byte[0];

    // Static constructor stubs.
    //
    // HbsInfoBlock obj = new HbsInfoBlock ();
    // HbsInfoBlock obj = new HbsInfoBlock (cxi); // does not exec
    // HbsInfoBlock obj = new HbsInfoBlock (cxi, _in); // does not exec
    // HbsInfoBlock obj = new HbsInfoBlock (_resp); // decompose buffer received elsewhere
    // 

    /** 
     * Instantiate a HbsInfoBlock object (empty)
     */
    public HbsInfoBlock () { super(); }

    /**
     * Instantiate a HbsInfoBlock object, referencing an existing connection 
     * to a CryptoServer
     */
    public HbsInfoBlock (CryptoServerCXI _cxi) {
      this();
      cxi = _cxi;
    }

    /**
     * Instantiate a HbsInfoBlock object, referencing an existing connection 
     * to a CryptoServer, and targeting a specific Module/SFC
     */
    public HbsInfoBlock (CryptoServerCXI _cxi, int mid, int sfc) {
      super(mid, sfc);
      cxi = _cxi;
    }

    /**
     * Instantiate a HbsInfoBlock object, referencing an existing connection 
     * to a CryptoServer, and supplying the input values via deserializable
     * byte buffer.  
     */
    public HbsInfoBlock (CryptoServerCXI _cxi, byte [] _in) {
      this(_cxi);
      try { deserialize(_in); }
      catch (DeserializationError e) { e.printStackTrace(); }
    }

    /**
     * Instantiate a HbsInfoBlock object, without referencing a CryptoServer
     * This method deserializes a byte buffer that was received as the
     * response to an earlier issued command.
     */
    public HbsInfoBlock (byte [] _resp) {
      this();
      try { deserialize(_resp); }
      catch (DeserializationError e) { e.printStackTrace(); }
    }

    /**
     * Additional Constructors based on the Interface definition
     */
    // Java "Normal"
    public HbsInfoBlock ( 
        int _flags,
        byte [] _source_id,
        byte [] _dest_id,
        byte [] _keydata,
        byte [] _source_key,
        byte [] _chunk

    ) {
        flags(_flags); 
        source_id(_source_id); 
        dest_id(_dest_id); 
        keydata(_keydata); 
        source_key(_source_key); 
        chunk(_chunk); 
    }

    // Java Object
    public HbsInfoBlock (
        int _flags, byte [] _source_id, byte [] _dest_id, CxiKeyAttributes _keydata, byte [] _source_key, byte [] _chunk
    ) throws SerializationError {
        flags(_flags);
        source_id(_source_id);
        dest_id(_dest_id);
        keydata(_keydata.serialize());
        source_key(_source_key);
        chunk(_chunk);
    }

    // Command setters/getters 
    public int      flags() { return flags; } 
    public void     flags (int      _in) { flags = _in; }
    public byte []  source_id() { return source_id; } 
    public void     source_id (byte []  _in) { source_id = _in; }
    public void     source_idFrom (byte []  _in) {
        source_id = new byte[_in.length];
        System.arraycopy(_in, 0, source_id, 0, _in.length);
    }
    public void     source_id (String _in) {
        source_id = _in.getBytes();
    }
    public byte []  dest_id() { return dest_id; } 
    public void     dest_id (byte []  _in) { dest_id = _in; }
    public void     dest_idFrom (byte []  _in) {
        dest_id = new byte[_in.length];
        System.arraycopy(_in, 0, dest_id, 0, _in.length);
    }
    public void     dest_id (String _in) {
        dest_id = _in.getBytes();
    }
    public byte []  keydata() { return keydata; } 
    public void     keydata (byte []  _in) { keydata = _in; }
    public void     keydataFrom (byte []  _in) {
        keydata = new byte[_in.length];
        System.arraycopy(_in, 0, keydata, 0, _in.length);
    }
    public void     keydata (String _in) {
        keydata = _in.getBytes();
    }
    public void     keydata (CxiKeyAttributes _in) throws SerializationError {
        keydata = _in.serialize();
    }
    public byte []  source_key() { return source_key; } 
    public void     source_key (byte []  _in) { source_key = _in; }
    public void     source_keyFrom (byte []  _in) {
        source_key = new byte[_in.length];
        System.arraycopy(_in, 0, source_key, 0, _in.length);
    }
    public void     source_key (String _in) {
        source_key = _in.getBytes();
    }
    public byte []  chunk() { return chunk; } 
    public void     chunk (byte []  _in) { chunk = _in; }
    public void     chunkFrom (byte []  _in) {
        chunk = new byte[_in.length];
        System.arraycopy(_in, 0, chunk, 0, _in.length);
    }
    public void     chunk (String _in) {
        chunk = _in.getBytes();
    }

    // Exec
    /**
     * Executes the command to the param-supplied CryptoServer, using
     * using the supplied ModuleID and Sub-function code.
     * <p>
     * This command may result in SerializationError or DeserializationError
     * events, but these are swallowed and returned as 'false'.
     * <p>
     * Note: The subfunction code only supports SFCs in the range 0..255.
     * <p>
     * @param CryptoServerCXI 
     * @param module ID 
     * @param subfunction code to call
     * @return boolean - ok (0x0) otherwise invalid input/ser+deser errors
     * @throws IOException (CryptoServer not available)
     * @throws CryptoServerException (non-zero response from the CryptoServer
     */
    public boolean exec (CryptoServerCXI cxi, int mid, int sfc) throws IOException, CryptoServerException {
        if (cxi == null) {
            System.out.println("No CXI\n");
            return false;
        }
        if ((sfc < 0) || (sfc > 255)) { return false; }

        return exec(cxi, mid, sfc, this, null); // this variant has no return value awareness, just stored
    }

    /**
     * Executes the command to the param-supplied CryptoServer, using
     * using the supplied ModuleID and Sub-function code.
     * <p>
     * This command may result in SerializationError or DeserializationError
     * events, but these are swallowed and returned as 'false'.
     * <p>
     * Note: The subfunction code only supports SFCs in the range 0..255.
     * <p>
     * If an I_SdkBuffer object is supplied as a recipient, and the response from 
     * the CryptoServer is OK, the result buffer will be handed to it and an attempt
     * to deserialize the result will happen.  
     * <p>
     * @param CryptoServerCXI 
     * @param module ID 
     * @param subfunction code to call
     * @param I_SdkBuffer to receive/parse the result into if OK is returned
     * @return boolean - ok (0x0) otherwise invalid input/ser+deser errors
     * @throws IOException (CryptoServer not available)
     * @throws CryptoServerException (non-zero response from the CryptoServer
     * @throws DeserializationError if the result can not be deserialized by this recipient
     */
    public boolean exec (CryptoServerCXI cxi, int mid, int sfc, I_SdkBuffer recvr) throws IOException, CryptoServerException {
        if (cxi == null) {
            System.out.println("No CXI\n");
            return false;
        }
        if ((sfc < 0) || (sfc > 255)) { return false; }

        return exec(cxi, mid, sfc, this, recvr); // this variant tries to deserialize the response into another I_SdkBuffer
    }

    /**
     * Executes the command to the provided CryptoServer, using the
     * compiled in ModuleID and Sub-function code
     * <p>
     * This command may result in SerializationError or DeserializationError
     * events, but these are swallowed and returned as 'false'.
     * <p>
     * @param cxi - CryptoServerCXI for target HSM
     * @return boolean - ok (0x0) otherwise fail
     * @throws IOException (CryptoServer not available)
     * @throws CryptoServerException (non-zero response from the CryptoServer
     */
    public boolean exec (CryptoServerCXI _cxi) throws IOException, CryptoServerException {
        return exec(_cxi, ModuleID, SFC);
    }

    /**
     * Executes the command to the CryptoServer supplied on object
     * instantiation, using the compiled in ModuleID and Sub-function code
     * <p>
     * If this object was instantiated without a cxi object, returns
     * false.
     * <p>
     * This command may result in SerializationError or DeserializationError
     * events, but these are swallowed and returned as 'false'.
     * <p>
     * @return boolean - ok (0x0) otherwise fail
     * @throws IOException (CryptoServer not available)
     * @throws CryptoServerException (non-zero response from the CryptoServer
     */
    public boolean exec () throws IOException, CryptoServerException {
        return exec(cxi, ModuleID, SFC);
    }

    public byte [] serialize () throws SerializationError {
        int len = length();
        if (len == 0) { return new byte[0]; }
        try {
            ByteBuffer bb = ByteBuffer.allocate(len);
 			// this.flags of kind u4
            bb.putInt(this.flags);
 			// this.source_id of kind v1
            if (this.source_id == null) {
                this.source_id = new byte[0];
            }
            bb.put((byte)(this.source_id.length & 0xFF)); 
           	bb.put(this.source_id);

 			// this.dest_id of kind v1
            if (this.dest_id == null) {
                this.dest_id = new byte[0];
            }
            bb.put((byte)(this.dest_id.length & 0xFF)); 
           	bb.put(this.dest_id);

 			// this.keydata of kind v2
            if (this.keydata == null) {
                this.keydata = new byte[0];
            }
        bb.putShort((short)(this.keydata.length & 0xFFFF));
           	bb.put(this.keydata);

 			// this.source_key of kind v2
            if (this.source_key == null) {
                this.source_key = new byte[0];
            }
        bb.putShort((short)(this.source_key.length & 0xFFFF));
           	bb.put(this.source_key);

 			// this.chunk of kind *
            if (this.chunk == null) {
                this.chunk = new byte[0];
            }
           	bb.put(this.chunk);

 
            return bb.array();
        } catch (Exception e) {
            throw new SerializationError();
        }
    }

    public void deserialize (byte [] bfr) throws DeserializationError {
        if (bfr.length == 0) { return; }
        ByteBuffer bb = ByteBuffer.wrap(bfr);
        int len = 0;
        try {
 			// this.flags of kind u4
			this.flags = bb.getInt();
  			// this.source_id of kind v1
			len = bb.get();
			this.source_id = new byte[len];
			bb.get(this.source_id, 0, len);
  			// this.dest_id of kind v1
			len = bb.get();
			this.dest_id = new byte[len];
			bb.get(this.dest_id, 0, len);
  			// this.keydata of kind v2
			len = bb.getShort();
			this.keydata = new byte[len];
			bb.get(this.keydata, 0, len);
  			// this.source_key of kind v2
			len = bb.getShort();
			this.source_key = new byte[len];
			bb.get(this.source_key, 0, len);
  			// this.chunk of kind *
			len = bb.remaining();
			this.chunk = new byte[len];
			bb.get(this.chunk, 0, this.chunk.length);
  			return;
        } catch (Exception e) {
            throw new DeserializationError();
        } finally {
            if (bb.hasRemaining()) {
            	throw new DeserializationError();
            }
        }
     }
        
    public int length () {
        int len = 0;
    
 		len += 4; // this.flags of kind u4

 		len += 1; // this.source_id of kind v1
		len += this.source_id.length;

 		len += 1; // this.dest_id of kind v1
		len += this.dest_id.length;

 		len += 2; // this.keydata of kind v2
		len += this.keydata.length;

 		len += 2; // this.source_key of kind v2
		len += this.source_key.length;

 		len += this.chunk.length; // this.chunk of kind *

        return len;
    }

	// possible return values, based on module SFC responses for SFC using this as an interface
	public boolean responseAs(I_SdkBuffer buffer) {
	    if (resp == null) { return false; }
	    try {
		    buffer.deserialize(resp);
		    return true;
		} catch (DeserializationError doops) {
		}
		return false;
    }

    public String toString() {
        // The 8 means only display the first 8 lines 
        // of the entirely serialized data
        return toString("com.utimaco.cs2.mdl.pqmi.HbsInfoBlock >", 8);
    }

    public String toString(String note, int maxInitialLines) {
        maxInitialLines++;
        if (this.length() == 0) { return note; }
        try {
            StringBuilder r = new StringBuilder(String.format("Serialized using: '%s'\n", pattern));
            r.append(xtrace(note, this.serialize()));
            String [] strings = r.toString().split("\\n");
            if (strings.length > maxInitialLines) {
                r.setLength(0);
                for (int i = 0; i < maxInitialLines; i++) { r.append(strings[i] + "\n"); }
                r.append("\t\t...\n");
            }

 			r.append(String.format("\nflags = %d\t\t(0x%0" + (4 * 2) + "x)", this.flags, this.flags));

 			if (this.source_id == null) { 
				r.append("source_id = {NULL}"); 
			} else {
				r.append(String.format("\nsource_id = [Variable length field (v1) of length %d - (0x%x))", this.source_id.length, this.source_id.length));
                r.append("\n");
				r.append(xtrace(this.source_id, 4));
			}

 			if (this.dest_id == null) { 
				r.append("dest_id = {NULL}"); 
			} else {
				r.append(String.format("\ndest_id = [Variable length field (v1) of length %d - (0x%x))", this.dest_id.length, this.dest_id.length));
                r.append("\n");
				r.append(xtrace(this.dest_id, 4));
			}

 			if (this.keydata == null) { 
				r.append("keydata = {NULL}"); 
			} else {
				r.append(String.format("\nkeydata = [Variable length field (v2) of length %d - (0x%x))", this.keydata.length, this.keydata.length));
                r.append("\n");
				r.append(xtrace(this.keydata, 4));
			}

 			if (this.source_key == null) { 
				r.append("source_key = {NULL}"); 
			} else {
				r.append(String.format("\nsource_key = [Variable length field (v2) of length %d - (0x%x))", this.source_key.length, this.source_key.length));
                r.append("\n");
				r.append(xtrace(this.source_key, 4));
			}

 			if (this.chunk == null) { 
				r.append("chunk = {NULL}"); 
			} else {
				r.append(String.format("\nchunk = [Bulk Data (*)]"));
                r.append("\n");
				r.append(xtrace(this.chunk, 4));
			}

            r.append("\nUUID: " + hexAsciiHash(true) + "\n");
            r.append(String.format("\nTotal length of object: %d (0x%x)\n", length(), length()));

            return r.toString();
        } catch (Exception e) {
            e.printStackTrace();
        }
        return "com.utimaco.cs2.mdl.pqmi.HbsInfoBlock > exception in data.";
    }

    public String hexAsciiHash(boolean formatted) {
        StringBuilder sb = new StringBuilder("com.utimaco.cs2.mdl.pqmi.HbsInfoBlock");
            sb.append(pattern); 
            sb.append(this.flags).append(4);
            if (this.source_id != null) { sb.append(new String(this.source_id)).append(this.source_id.length); }
            if (this.dest_id != null) { sb.append(new String(this.dest_id)).append(this.dest_id.length); }
            if (this.keydata != null) { sb.append(new String(this.keydata)).append(this.keydata.length); }
            if (this.source_key != null) { sb.append(new String(this.source_key)).append(this.source_key.length); }
            if (this.chunk != null) { sb.append(new String(this.chunk)).append(this.chunk.length); }

            return SdkBuffer.hexAsciiHash(sb.toString(), formatted);
    }   
}