package com.utimaco.cs2.mdl.pqmi;

/* 
 * 03c autogenerated 2024-04-01T16:12:59.0637922 using 
 * CS_SdkVpl version 0.0.5
 * Source XML Document version 01d,2024-03-26,riw
 * 
 * Copyright included by reference, please see Utimaco_Demo_License.txt
 */

import java.io.IOException;
import com.utimaco.cs2.mdl.I_SdkBuffer;
import CryptoServerAPI.CryptoServerException;
import CryptoServerCXI.CryptoServerCXI;
import java.nio.ByteBuffer;
import com.utimaco.cs2.mdl.SdkBuffer;
import com.utimaco.cs2.mdl.DeserializationError;
import com.utimaco.cs2.mdl.SerializationError;

// Typed parameters (if any)
import com.utimaco.cs2.mdl.any.CxiKeyAttributes;

/**
 * Pattern: u4u4v2u1c16u2
 *
 * Field declarations
 * <pre>
 * flags:  (u4) unsigned int[string]{}
 *   int               flags                          = (int)0x0;           // Flags from  u4

 * type:  (u4) unsigned int[string]{}
 *   int               type                           = (int)0x0;           // Select type of key, LMS, HSS or XMSS from  u4

 * attributes:  (v2) unsigned short + ...[string]{}
 *   byte []           attributes                     = new byte[0];        // Generated key metadata// CxiKeyAttributes v2

 * levels:  (u1) unsigned byte[string]{}
 *   byte              levels                         = (byte)0x0;          // If LMS/HSS, number of levels. If XMSS, single or multi-tree//  u1

 * levelparams:  (c) octet array of fixed length[string]{}
 *   byte []           levelparams                    = new byte[0];        // If LMS/HSS, array of level params. If XMSS, OID of scheme//  c16

 * auxdatasz:  (u2) unsigned short[string]{}
 *   short             auxdatasz                      = (short)0x0;         // LMS/HSS Only.  Size of the aux data space, 1..16384 bytes//  u2

 * </pre>
 * @author SFCBUFFERS
 *
 */
public class HbsGen extends SdkBuffer implements I_SdkBuffer {
    int ModuleID = 0x087; // Default is 'echo' from ADM
    int SFC = 0; // Default is 'echo' from ADM
    protected static final String pattern = "u4u4v2u1c16u2"; 

    // Interface specific defined def elements

    // Interface Fields
    int flags = 0x0;
    int type = 0x0;
    byte [] attributes = new byte[0];
    byte levels = (byte)0x0;
    protected static final int _CLEN_LEVELPARAMS = 16; // c16
    byte [] levelparams = new byte[_CLEN_LEVELPARAMS];
    short auxdatasz = (short)0x0;

    // Static constructor stubs.
    //
    // HbsGen obj = new HbsGen ();
    // HbsGen obj = new HbsGen (cxi); // does not exec
    // HbsGen obj = new HbsGen (cxi, _in); // does not exec
    // HbsGen obj = new HbsGen (_resp); // decompose buffer received elsewhere
    // 

    /** 
     * Instantiate a HbsGen object (empty)
     */
    public HbsGen () { super(); }

    /**
     * Instantiate a HbsGen object, referencing an existing connection 
     * to a CryptoServer
     */
    public HbsGen (CryptoServerCXI _cxi) {
      this();
      cxi = _cxi;
    }

    /**
     * Instantiate a HbsGen object, referencing an existing connection 
     * to a CryptoServer, and targeting a specific Module/SFC
     */
    public HbsGen (CryptoServerCXI _cxi, int mid, int sfc) {
      super(mid, sfc);
      cxi = _cxi;
    }

    /**
     * Instantiate a HbsGen object, referencing an existing connection 
     * to a CryptoServer, and supplying the input values via deserializable
     * byte buffer.  
     */
    public HbsGen (CryptoServerCXI _cxi, byte [] _in) {
      this(_cxi);
      try { deserialize(_in); }
      catch (DeserializationError e) { e.printStackTrace(); }
    }

    /**
     * Instantiate a HbsGen object, without referencing a CryptoServer
     * This method deserializes a byte buffer that was received as the
     * response to an earlier issued command.
     */
    public HbsGen (byte [] _resp) {
      this();
      try { deserialize(_resp); }
      catch (DeserializationError e) { e.printStackTrace(); }
    }

    /**
     * Additional Constructors based on the Interface definition
     */
    // Java "Normal"
    public HbsGen ( 
        int _flags,
        int _type,
        byte [] _attributes,
        byte _levels,
        byte [] _levelparams,
        short _auxdatasz

    ) {
        flags(_flags); 
        type(_type); 
        attributes(_attributes); 
        levels(_levels); 
        levelparams(_levelparams); 
        auxdatasz(_auxdatasz); 
    }

    // Java Object
    public HbsGen (
        int _flags, int _type, CxiKeyAttributes _attributes, byte _levels, byte [] _levelparams, short _auxdatasz
    ) throws SerializationError {
        flags(_flags);
        type(_type);
        attributes(_attributes.serialize());
        levels(_levels);
        levelparams(_levelparams);
        auxdatasz(_auxdatasz);
    }

    // Command setters/getters 
    public int      flags() { return flags; } 
    public void     flags (int      _in) { flags = _in; }
    public int      type() { return type; } 
    public void     type (int      _in) { type = _in; }
    public byte []  attributes() { return attributes; } 
    public void     attributes (byte []  _in) { attributes = _in; }
    public void     attributesFrom (byte []  _in) {
        attributes = new byte[_in.length];
        System.arraycopy(_in, 0, attributes, 0, _in.length);
    }
    public void     attributes (String _in) {
        attributes = _in.getBytes();
    }
    public void     attributes (CxiKeyAttributes _in) throws SerializationError {
        attributes = _in.serialize();
    }
    public byte     levels() { return levels; } 
    public void     levels (byte     _in) { levels = _in; }
    public void    levels (int _in) { levels = ( byte     )_in; }    public byte []  levelparams() { return levelparams; } 
    public void     levelparams (byte []  _in) { levelparams = _in; }
    public void     levelparamsFrom (byte []  _in) {
        levelparams = new byte[_in.length];
        System.arraycopy(_in, 0, levelparams, 0, _in.length);
    }
    public void     levelparams (String _in) {
        levelparams = _in.getBytes();
    }
    public short    auxdatasz() { return auxdatasz; } 
    public void     auxdatasz (short    _in) { auxdatasz = _in; }
    public void    auxdatasz (int _in) { auxdatasz = ( short    )_in; }
    // Exec
    /**
     * Executes the command to the param-supplied CryptoServer, using
     * using the supplied ModuleID and Sub-function code.
     * <p>
     * This command may result in SerializationError or DeserializationError
     * events, but these are swallowed and returned as 'false'.
     * <p>
     * Note: The subfunction code only supports SFCs in the range 0..255.
     * <p>
     * @param CryptoServerCXI 
     * @param module ID 
     * @param subfunction code to call
     * @return boolean - ok (0x0) otherwise invalid input/ser+deser errors
     * @throws IOException (CryptoServer not available)
     * @throws CryptoServerException (non-zero response from the CryptoServer
     */
    public boolean exec (CryptoServerCXI cxi, int mid, int sfc) throws IOException, CryptoServerException {
        if (cxi == null) {
            System.out.println("No CXI\n");
            return false;
        }
        if ((sfc < 0) || (sfc > 255)) { return false; }

        return exec(cxi, mid, sfc, this, null); // this variant has no return value awareness, just stored
    }

    /**
     * Executes the command to the param-supplied CryptoServer, using
     * using the supplied ModuleID and Sub-function code.
     * <p>
     * This command may result in SerializationError or DeserializationError
     * events, but these are swallowed and returned as 'false'.
     * <p>
     * Note: The subfunction code only supports SFCs in the range 0..255.
     * <p>
     * If an I_SdkBuffer object is supplied as a recipient, and the response from 
     * the CryptoServer is OK, the result buffer will be handed to it and an attempt
     * to deserialize the result will happen.  
     * <p>
     * @param CryptoServerCXI 
     * @param module ID 
     * @param subfunction code to call
     * @param I_SdkBuffer to receive/parse the result into if OK is returned
     * @return boolean - ok (0x0) otherwise invalid input/ser+deser errors
     * @throws IOException (CryptoServer not available)
     * @throws CryptoServerException (non-zero response from the CryptoServer
     * @throws DeserializationError if the result can not be deserialized by this recipient
     */
    public boolean exec (CryptoServerCXI cxi, int mid, int sfc, I_SdkBuffer recvr) throws IOException, CryptoServerException {
        if (cxi == null) {
            System.out.println("No CXI\n");
            return false;
        }
        if ((sfc < 0) || (sfc > 255)) { return false; }

        return exec(cxi, mid, sfc, this, recvr); // this variant tries to deserialize the response into another I_SdkBuffer
    }

    /**
     * Executes the command to the provided CryptoServer, using the
     * compiled in ModuleID and Sub-function code
     * <p>
     * This command may result in SerializationError or DeserializationError
     * events, but these are swallowed and returned as 'false'.
     * <p>
     * @param cxi - CryptoServerCXI for target HSM
     * @return boolean - ok (0x0) otherwise fail
     * @throws IOException (CryptoServer not available)
     * @throws CryptoServerException (non-zero response from the CryptoServer
     */
    public boolean exec (CryptoServerCXI _cxi) throws IOException, CryptoServerException {
        return exec(_cxi, ModuleID, SFC);
    }

    /**
     * Executes the command to the CryptoServer supplied on object
     * instantiation, using the compiled in ModuleID and Sub-function code
     * <p>
     * If this object was instantiated without a cxi object, returns
     * false.
     * <p>
     * This command may result in SerializationError or DeserializationError
     * events, but these are swallowed and returned as 'false'.
     * <p>
     * @return boolean - ok (0x0) otherwise fail
     * @throws IOException (CryptoServer not available)
     * @throws CryptoServerException (non-zero response from the CryptoServer
     */
    public boolean exec () throws IOException, CryptoServerException {
        return exec(cxi, ModuleID, SFC);
    }

    public byte [] serialize () throws SerializationError {
        int len = length();
        if (len == 0) { return new byte[0]; }
        try {
            ByteBuffer bb = ByteBuffer.allocate(len);
 			// this.flags of kind u4
            bb.putInt(this.flags);
 			// this.type of kind u4
            bb.putInt(this.type);
 			// this.attributes of kind v2
            if (this.attributes == null) {
                this.attributes = new byte[0];
            }
        bb.putShort((short)(this.attributes.length & 0xFFFF));
           	bb.put(this.attributes);

 			// this.levels of kind u1
            bb.put(this.levels);
 			// this.levelparams of kind c16
			if (this.levelparams.length < 16) {
            	byte [] t = new byte[16];
            	int tl = 16;
            	if (this.levelparams.length < tl) { tl = this.levelparams.length; }
            	System.arraycopy(this.levelparams, 0, t, 0, tl);
            	bb.put(t);
           	} else if (this.levelparams.length == 16) {
           	    bb.put(this.levelparams);
            } else {
           		throw new SerializationError("Field width: this.levelparams.length > 16");
            }

 			// this.auxdatasz of kind u2
            bb.putShort(this.auxdatasz);
 
            return bb.array();
        } catch (Exception e) {
            throw new SerializationError();
        }
    }

    public void deserialize (byte [] bfr) throws DeserializationError {
        if (bfr.length == 0) { return; }
        ByteBuffer bb = ByteBuffer.wrap(bfr);
        int len = 0;
        try {
 			// this.flags of kind u4
			this.flags = bb.getInt();
  			// this.type of kind u4
			this.type = bb.getInt();
  			// this.attributes of kind v2
			len = bb.getShort();
			this.attributes = new byte[len];
			bb.get(this.attributes, 0, len);
  			// this.levels of kind u1
			this.levels = bb.get();
  			// this.levelparams of kind c16
			if (this.levelparams == null) { this.levelparams = new byte[16]; }
			bb.get(this.levelparams, 0, this.levelparams.length);
  			// this.auxdatasz of kind u2
			this.auxdatasz = bb.getShort();
  			return;
        } catch (Exception e) {
            throw new DeserializationError();
        } finally {
            if (bb.hasRemaining()) {
            	throw new DeserializationError();
            }
        }
     }
        
    public int length () {
        int len = 0;
    
 		len += 4; // this.flags of kind u4

 		len += 4; // this.type of kind u4

 		len += 2; // this.attributes of kind v2
		len += this.attributes.length;

 		len += 1; // this.levels of kind u1

         len += 16; // this.levelparams of kind c16

 		len += 2; // this.auxdatasz of kind u2

        return len;
    }

	// possible return values, based on module SFC responses for SFC using this as an interface
	public boolean responseAs(I_SdkBuffer buffer) {
	    if (resp == null) { return false; }
	    try {
		    buffer.deserialize(resp);
		    return true;
		} catch (DeserializationError doops) {
		}
		return false;
    }

    public String toString() {
        // The 8 means only display the first 8 lines 
        // of the entirely serialized data
        return toString("com.utimaco.cs2.mdl.pqmi.HbsGen >", 8);
    }

    public String toString(String note, int maxInitialLines) {
        maxInitialLines++;
        if (this.length() == 0) { return note; }
        try {
            StringBuilder r = new StringBuilder(String.format("Serialized using: '%s'\n", pattern));
            r.append(xtrace(note, this.serialize()));
            String [] strings = r.toString().split("\\n");
            if (strings.length > maxInitialLines) {
                r.setLength(0);
                for (int i = 0; i < maxInitialLines; i++) { r.append(strings[i] + "\n"); }
                r.append("\t\t...\n");
            }

 			r.append(String.format("\nflags = %d\t\t(0x%0" + (4 * 2) + "x)", this.flags, this.flags));

 			r.append(String.format("\ntype = %d\t\t(0x%0" + (4 * 2) + "x)", this.type, this.type));

 			if (this.attributes == null) { 
				r.append("attributes = {NULL}"); 
			} else {
				r.append(String.format("\nattributes = [Variable length field (v2) of length %d - (0x%x))", this.attributes.length, this.attributes.length));
                r.append("\n");
				r.append(xtrace(this.attributes, 4));
			}

 			r.append(String.format("\nlevels = %d\t\t(0x%0" + (1 * 2) + "x)", this.levels, this.levels));

 			if (this.levelparams == null) { 
				r.append("levelparams = {NULL}"); 
			} else {
				r.append("\nlevelparams = [Fixed length field (c16)]");
                r.append("\n");
				r.append(xtrace(this.levelparams, 4));
			}

 			r.append(String.format("\nauxdatasz = %d\t\t(0x%0" + (2 * 2) + "x)", this.auxdatasz, this.auxdatasz));

            r.append("\nUUID: " + hexAsciiHash(true) + "\n");
            r.append(String.format("\nTotal length of object: %d (0x%x)\n", length(), length()));

            return r.toString();
        } catch (Exception e) {
            e.printStackTrace();
        }
        return "com.utimaco.cs2.mdl.pqmi.HbsGen > exception in data.";
    }

    public String hexAsciiHash(boolean formatted) {
        StringBuilder sb = new StringBuilder("com.utimaco.cs2.mdl.pqmi.HbsGen");
            sb.append(pattern); 
            sb.append(this.flags).append(4);
            sb.append(this.type).append(4);
            if (this.attributes != null) { sb.append(new String(this.attributes)).append(this.attributes.length); }
            sb.append(this.levels).append(1);
            if (this.levelparams != null) { sb.append(new String(this.levelparams)).append(this.levelparams.length); }
            sb.append(this.auxdatasz).append(2);

            return SdkBuffer.hexAsciiHash(sb.toString(), formatted);
    }   
}