package com.utimaco.cs2.mdl.any;

/* 
 * 03c autogenerated 2024-11-06T12:45:15.4456134 using 
 * CS_SdkVpl version 0.0.6
 * Source XML Document version 01d,2024-03-26,riw
 * 
 * Copyright included by reference, please see Utimaco_Demo_License.txt
 *
 */

import com.utimaco.cs2.mdl.I_SdkBuffer;
import java.nio.ByteBuffer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import CryptoServerAPI.CryptoServerException;
import CryptoServerCXI.CryptoServerCXI;
import com.utimaco.cs2.mdl.SdkBuffer;
import com.utimaco.cs2.mdl.DeserializationError;
import com.utimaco.cs2.mdl.SerializationError;

// Typed parameters (if any)

/**
 * Pattern: c16v2v2v2v1u4u4c16*
 *
 * Field declarations
 * <pre>
 * RFU0:  (c) octet array of fixed length{}
 *   byte []           RFU0                           = new byte[0];        // //  c16

 * info:  (v2) unsigned short + data {}
 *   byte []           info                           = new byte[0];        // BI Field//  v2

 * pk:  (v2) unsigned short + data {}
 *   byte []           pk                             = new byte[0];        // Public Key//  v2

 * sk:  (v2) unsigned short + data {}
 *   byte []           sk                             = new byte[0];        // Private Key (will encrypt)//  v2

 * iv:  (v1) unsigned byte + data  {}
 *   byte []           iv                             = new byte[0];        // IV for sk encryption//  v1
 * c_properties:  (u4) unsigned int {}
 *   int               c_properties                   = (int)0x0;           // RFU from  u4

 * c_prop_max:  (u4) unsigned int {}
 *   int               c_prop_max                     = (int)0x0;           // RFU from  u4

 * chksm:  (c) octet array of fixed length{}
 *   byte []           chksm                          = new byte[0];        // checksum//  c16

 * prop_head:  (*) additional bytes of unfixed length{}
 *   byte []           prop_head                      = new byte[0];        // RFU//  *

 * </pre>
 * @author SFCBUFFERS
 *
 */
public class BackupBlob extends SdkBuffer implements I_SdkBuffer {
    int ModuleID = 0x087; // Default is 'echo' from ADM
    int SFC = 0; // Default is 'echo' from ADM
    protected static final String pattern = "c16v2v2v2v1u4u4c16*"; 

    // Interface specific defined def elements

    // Interface Fields
    protected static final int _CLEN_RFU0 = 16; // c16
    byte [] RFU0 = new byte[_CLEN_RFU0];
    byte [] info = new byte[0];
    byte [] pk = new byte[0];
    byte [] sk = new byte[0];
    byte [] iv = new byte[0];
    int c_properties = 0x0;
    int c_prop_max = 0x0;
    protected static final int _CLEN_CHKSM = 16; // c16
    byte [] chksm = new byte[_CLEN_CHKSM];
    byte [] prop_head = new byte[0];

    // Static constructor stubs.
    //
    // BackupBlob obj = new BackupBlob ();
    // BackupBlob obj = new BackupBlob (cxi); // does not exec
    // BackupBlob obj = new BackupBlob (cxi, _in); // does not exec
    // BackupBlob obj = new BackupBlob (_resp); // decompose buffer received elsewhere
    // BackupBlob obj = new BackupBlob (_resp, boolean); // decompose buffer received elsewhere, which may be longer than expected
    //                                                     // if true, do not accept this and throw SerializationError
    //                                                     // if false, accept this and ignore remaining bytes
    // 

    /** 
     * Instantiate a BackupBlob object (empty)
     */
    public BackupBlob () { super(); }

    /**
     * Instantiate a BackupBlob object, referencing an existing connection 
     * to a CryptoServer
     */
    public BackupBlob (CryptoServerCXI _cxi) {
      this();
      cxi = _cxi;
    }

    /**
     * Instantiate a BackupBlob object, referencing an existing connection 
     * to a CryptoServer, and targeting a specific Module/SFC
     */
    public BackupBlob (CryptoServerCXI _cxi, int mid, int sfc) {
      super(mid, sfc);
      cxi = _cxi;
    }

    /**
     * Instantiate a BackupBlob object, referencing an existing connection 
     * to a CryptoServer, and supplying the input values via deserializable
     * byte buffer.  
     */
    public BackupBlob (CryptoServerCXI _cxi, byte [] _in) {
      this(_cxi);
      try { deserialize(_in); }
      catch (DeserializationError e) { e.printStackTrace(); }
    }

    /**
     * Instantiate a BackupBlob object, without referencing a CryptoServer
     * This method deserializes a byte buffer that was received as the
     * response to an earlier issued command.
     */
    public BackupBlob (byte [] _resp) {
    	this(_resp, true);
    }
    
    /**
     * Instantiate a BackupBlob object, without referencing a CryptoServer
     * This method deserializes a byte buffer that was received as the
     * response to an earlier issued command.  If there are remaining bytes
     * in the _resp array at the end of the interface deserialization, 
     * if assumeExactLenBuffer is true, throws SerializationError, else
     * does not throw.
     */
    public BackupBlob (byte [] _resp, boolean assumeExactLenBuffer) {
      this();
      try { deserialize(_resp, assumeExactLenBuffer); }
      catch (DeserializationError e) { e.printStackTrace(); }
    }

    /**
     * Additional Constructors based on the Interface definition
     */
    // Java "Normal"
    public BackupBlob ( 
        byte [] _RFU0,
        byte [] _info,
        byte [] _pk,
        byte [] _sk,
        byte [] _iv,
        int _c_properties,
        int _c_prop_max,
        byte [] _chksm,
        byte [] _prop_head

    ) {
        RFU0(_RFU0); 
        info(_info); 
        pk(_pk); 
        sk(_sk); 
        iv(_iv); 
        c_properties(_c_properties); 
        c_prop_max(_c_prop_max); 
        chksm(_chksm); 
        prop_head(_prop_head); 
    }

    // Java Object

    // Command setters/getters 
    public byte []  RFU0() { return RFU0; } 
    public void     RFU0 (byte []  _in) { RFU0 = _in; }
    public void     RFU0From (byte []  _in) {
        RFU0 = new byte[_in.length];
        System.arraycopy(_in, 0, RFU0, 0, _in.length);
    }
    public void     RFU0 (String _in) {
        RFU0 = _in.getBytes();
    }
    public byte []  info() { return info; } 
    public void     info (byte []  _in) { info = _in; }
    public void     infoFrom (byte []  _in) {
        info = new byte[_in.length];
        System.arraycopy(_in, 0, info, 0, _in.length);
    }
    public void     info (String _in) {
        info = _in.getBytes();
    }
    public byte []  pk() { return pk; } 
    public void     pk (byte []  _in) { pk = _in; }
    public void     pkFrom (byte []  _in) {
        pk = new byte[_in.length];
        System.arraycopy(_in, 0, pk, 0, _in.length);
    }
    public void     pk (String _in) {
        pk = _in.getBytes();
    }
    public byte []  sk() { return sk; } 
    public void     sk (byte []  _in) { sk = _in; }
    public void     skFrom (byte []  _in) {
        sk = new byte[_in.length];
        System.arraycopy(_in, 0, sk, 0, _in.length);
    }
    public void     sk (String _in) {
        sk = _in.getBytes();
    }
    public byte []  iv() { return iv; } 
    public void     iv (byte []  _in) { iv = _in; }
    public void     ivFrom (byte []  _in) {
        iv = new byte[_in.length];
        System.arraycopy(_in, 0, iv, 0, _in.length);
    }
    public void     iv (String _in) {
        iv = _in.getBytes();
    }
    public int      c_properties() { return c_properties; } 
    public void     c_properties (int      _in) { c_properties = _in; }
    public int      c_prop_max() { return c_prop_max; } 
    public void     c_prop_max (int      _in) { c_prop_max = _in; }
    public byte []  chksm() { return chksm; } 
    public void     chksm (byte []  _in) { chksm = _in; }
    public void     chksmFrom (byte []  _in) {
        chksm = new byte[_in.length];
        System.arraycopy(_in, 0, chksm, 0, _in.length);
    }
    public void     chksm (String _in) {
        chksm = _in.getBytes();
    }
    public byte []  prop_head() { return prop_head; } 
    public void     prop_head (byte []  _in) { prop_head = _in; }
    public void     prop_headFrom (byte []  _in) {
        prop_head = new byte[_in.length];
        System.arraycopy(_in, 0, prop_head, 0, _in.length);
    }
    public void     prop_head (String _in) {
        prop_head = _in.getBytes();
    }

    // Exec
    /**
     * Executes the command to the param-supplied CryptoServer, using
     * using the supplied ModuleID and Sub-function code.
     * <p>
     * This command may result in SerializationError or DeserializationError
     * events, but these are swallowed and returned as 'false'.
     * <p>
     * Note: The subfunction code only supports SFCs in the range 0..255.
     * <p>
     * @param CryptoServerCXI 
     * @param module ID 
     * @param subfunction code to call
     * @return boolean - ok (0x0) otherwise invalid input/ser+deser errors
     * @throws IOException (CryptoServer not available)
     * @throws CryptoServerException (non-zero response from the CryptoServer
     */
    public boolean exec (CryptoServerCXI cxi, int mid, int sfc) throws IOException, CryptoServerException {
        if (cxi == null) {
            System.out.println("No CXI\n");
            return false;
        }
        if ((sfc < 0) || (sfc > 255)) { return false; }

        return exec(cxi, mid, sfc, this, null); // this variant has no return value awareness, just stored
    }

    /**
     * Executes the command to the param-supplied CryptoServer, using
     * using the supplied ModuleID and Sub-function code.
     * <p>
     * This command may result in SerializationError or DeserializationError
     * events, but these are swallowed and returned as 'false'.
     * <p>
     * Note: The subfunction code only supports SFCs in the range 0..255.
     * <p>
     * If an I_SdkBuffer object is supplied as a recipient, and the response from 
     * the CryptoServer is OK, the result buffer will be handed to it and an attempt
     * to deserialize the result will happen.  
     * <p>
     * @param CryptoServerCXI 
     * @param module ID 
     * @param subfunction code to call
     * @param I_SdkBuffer to receive/parse the result into if OK is returned
     * @return boolean - ok (0x0) otherwise invalid input/ser+deser errors
     * @throws IOException (CryptoServer not available)
     * @throws CryptoServerException (non-zero response from the CryptoServer
     * @throws DeserializationError if the result can not be deserialized by this recipient
     */
    public boolean exec (CryptoServerCXI cxi, int mid, int sfc, I_SdkBuffer recvr) throws IOException, CryptoServerException {
        if (cxi == null) {
            System.out.println("No CXI\n");
            return false;
        }
        if ((sfc < 0) || (sfc > 255)) { return false; }

        return exec(cxi, mid, sfc, this, recvr); // this variant tries to deserialize the response into another I_SdkBuffer
    }

    /**
     * Executes the command to the provided CryptoServer, using the
     * compiled in ModuleID and Sub-function code
     * <p>
     * This command may result in SerializationError or DeserializationError
     * events, but these are swallowed and returned as 'false'.
     * <p>
     * @param cxi - CryptoServerCXI for target HSM
     * @return boolean - ok (0x0) otherwise fail
     * @throws IOException (CryptoServer not available)
     * @throws CryptoServerException (non-zero response from the CryptoServer
     */
    public boolean exec (CryptoServerCXI _cxi) throws IOException, CryptoServerException {
        return exec(_cxi, ModuleID, SFC);
    }

    /**
     * Executes the command to the CryptoServer supplied on object
     * instantiation, using the compiled in ModuleID and Sub-function code
     * <p>
     * If this object was instantiated without a cxi object, returns
     * false.
     * <p>
     * This command may result in SerializationError or DeserializationError
     * events, but these are swallowed and returned as 'false'.
     * <p>
     * @return boolean - ok (0x0) otherwise fail
     * @throws IOException (CryptoServer not available)
     * @throws CryptoServerException (non-zero response from the CryptoServer
     */
    public boolean exec () throws IOException, CryptoServerException {
        return exec(cxi, ModuleID, SFC);
    }

    public byte [] serialize () throws SerializationError {
        int len = length();
        if (len == 0) { return new byte[0]; }
        try {
            ByteBuffer bb = ByteBuffer.allocate(len);
 			// this.RFU0 of kind c16
			if (this.RFU0.length < 16) {
            	byte [] t = new byte[16];
            	int tl = 16;
            	if (this.RFU0.length < tl) { tl = this.RFU0.length; }
            	System.arraycopy(this.RFU0, 0, t, 0, tl);
            	bb.put(t);
           	} else if (this.RFU0.length == 16) {
           	    bb.put(this.RFU0);
            } else {
           		throw new SerializationError("Field width: this.RFU0.length > 16");
            }

 			// this.info of kind v2
            if (this.info == null) {
                this.info = new byte[0];
            }
        bb.putShort((short)(this.info.length & 0xFFFF));
           	bb.put(this.info);

 			// this.pk of kind v2
            if (this.pk == null) {
                this.pk = new byte[0];
            }
        bb.putShort((short)(this.pk.length & 0xFFFF));
           	bb.put(this.pk);

 			// this.sk of kind v2
            if (this.sk == null) {
                this.sk = new byte[0];
            }
        bb.putShort((short)(this.sk.length & 0xFFFF));
           	bb.put(this.sk);

 			// this.iv of kind v1
            if (this.iv == null) {
                this.iv = new byte[0];
            }
            bb.put((byte)(this.iv.length & 0xFF)); 
           	bb.put(this.iv);

 			// this.c_properties of kind u4
            bb.putInt(this.c_properties);
 			// this.c_prop_max of kind u4
            bb.putInt(this.c_prop_max);
 			// this.chksm of kind c16
			if (this.chksm.length < 16) {
            	byte [] t = new byte[16];
            	int tl = 16;
            	if (this.chksm.length < tl) { tl = this.chksm.length; }
            	System.arraycopy(this.chksm, 0, t, 0, tl);
            	bb.put(t);
           	} else if (this.chksm.length == 16) {
           	    bb.put(this.chksm);
            } else {
           		throw new SerializationError("Field width: this.chksm.length > 16");
            }

 			// this.prop_head of kind *
            if (this.prop_head == null) {
                this.prop_head = new byte[0];
            }
           	bb.put(this.prop_head);

 
            return bb.array();
        } catch (Exception e) {
            throw new SerializationError();
        }
    }

	public void deserialize (byte [] bfr) throws DeserializationError {
		deserialize(bfr, true);
	}
	
    public void deserialize (byte [] bfr, boolean assumeExactLenBuffer) throws DeserializationError {
        if (bfr.length == 0) { return; }
        ByteBuffer bb = ByteBuffer.wrap(bfr);
        int len = 0;
        try {
 			// this.RFU0 of kind c16
			if (this.RFU0 == null) { this.RFU0 = new byte[16]; }
			bb.get(this.RFU0, 0, this.RFU0.length);
  			// this.info of kind v2
			len = bb.getShort();
			this.info = new byte[len];
			bb.get(this.info, 0, len);
  			// this.pk of kind v2
			len = bb.getShort();
			this.pk = new byte[len];
			bb.get(this.pk, 0, len);
  			// this.sk of kind v2
			len = bb.getShort();
			this.sk = new byte[len];
			bb.get(this.sk, 0, len);
  			// this.iv of kind v1
			len = bb.get();
			this.iv = new byte[len];
			bb.get(this.iv, 0, len);
  			// this.c_properties of kind u4
			this.c_properties = bb.getInt();
  			// this.c_prop_max of kind u4
			this.c_prop_max = bb.getInt();
  			// this.chksm of kind c16
			if (this.chksm == null) { this.chksm = new byte[16]; }
			bb.get(this.chksm, 0, this.chksm.length);
  			// this.prop_head of kind *
			len = bb.remaining();
			this.prop_head = new byte[len];
			bb.get(this.prop_head, 0, this.prop_head.length);
  			return;
        } catch (Exception e) {
            throw new DeserializationError();
        } finally {
            if (bb.hasRemaining()) {
            	if (assumeExactLenBuffer) {
	            	throw new DeserializationError();
	            }
            }
        }
     }
        
    public int length () {
        int len = 0;
    
         len += 16; // this.RFU0 of kind c16

 		len += 2; // this.info of kind v2
		len += this.info.length;

 		len += 2; // this.pk of kind v2
		len += this.pk.length;

 		len += 2; // this.sk of kind v2
		len += this.sk.length;

 		len += 1; // this.iv of kind v1
		len += this.iv.length;

 		len += 4; // this.c_properties of kind u4

 		len += 4; // this.c_prop_max of kind u4

         len += 16; // this.chksm of kind c16

 		len += this.prop_head.length; // this.prop_head of kind *

        return len;
    }

	/**
	 * 
	 * @return byte [] copy of response received from cxi.exec call (if available)
	 */
	public byte [] getResponse () {
		if (resp == null) { return null; }
		
		byte [] r = new byte[resp.length];
		System.arraycopy(resp,0,r,0,resp.length);
		return r;
	}
		
	// possible return values, based on module SFC responses for SFC using this as an interface
	/**
	 * Deserialize result into provided SdkBuffer container
	 *
	 * @param buffer (I_SdkBuffer)
	 * @result boolean success
	 */
	public boolean responseAs(I_SdkBuffer buffer) {
	    if (resp == null) { return false; }
	    try {
		    buffer.deserialize(resp);
		    return true;
		} catch (DeserializationError doops) {
		}
		return false;
    }

    public String toString() {
        // The 8 means only display the first 8 lines 
        // of the entirely serialized data
        return toString("com.utimaco.cs2.mdl.any.BackupBlob >", 8);
    }

    public String toString(String note, int maxInitialLines) {
        maxInitialLines++;
        if (this.length() == 0) { return note; }
        try {
            StringBuilder r = new StringBuilder(String.format("Serialized using: '%s'\n", pattern));
            r.append(xtrace(note, this.serialize()));
            String [] strings = r.toString().split("\\n");
            if (strings.length > maxInitialLines) {
                r.setLength(0);
                for (int i = 0; i < maxInitialLines; i++) { r.append(strings[i] + "\n"); }
                r.append("\t\t...\n");
            }

 			if (this.RFU0 == null) { 
				r.append("RFU0 = {NULL}"); 
			} else {
				r.append("\nRFU0 = [Fixed length field (c16)]");
                r.append("\n");
				r.append(xtrace(this.RFU0, 4));
			}

 			if (this.info == null) { 
				r.append("info = {NULL}"); 
			} else {
				r.append(String.format("\ninfo = [Variable length field (v2) of length %d - (0x%x))", this.info.length, this.info.length));
                r.append("\n");
				r.append(xtrace(this.info, 4));
			}

 			if (this.pk == null) { 
				r.append("pk = {NULL}"); 
			} else {
				r.append(String.format("\npk = [Variable length field (v2) of length %d - (0x%x))", this.pk.length, this.pk.length));
                r.append("\n");
				r.append(xtrace(this.pk, 4));
			}

 			if (this.sk == null) { 
				r.append("sk = {NULL}"); 
			} else {
				r.append(String.format("\nsk = [Variable length field (v2) of length %d - (0x%x))", this.sk.length, this.sk.length));
                r.append("\n");
				r.append(xtrace(this.sk, 4));
			}

 			if (this.iv == null) { 
				r.append("iv = {NULL}"); 
			} else {
				r.append(String.format("\niv = [Variable length field (v1) of length %d - (0x%x))", this.iv.length, this.iv.length));
                r.append("\n");
				r.append(xtrace(this.iv, 4));
			}

 			r.append(String.format("\nc_properties = %d\t\t(0x%0" + (4 * 2) + "x)", this.c_properties, this.c_properties));

 			r.append(String.format("\nc_prop_max = %d\t\t(0x%0" + (4 * 2) + "x)", this.c_prop_max, this.c_prop_max));

 			if (this.chksm == null) { 
				r.append("chksm = {NULL}"); 
			} else {
				r.append("\nchksm = [Fixed length field (c16)]");
                r.append("\n");
				r.append(xtrace(this.chksm, 4));
			}

 			if (this.prop_head == null) { 
				r.append("prop_head = {NULL}"); 
			} else {
				r.append(String.format("\nprop_head = [Bulk Data (*)]"));
                r.append("\n");
				r.append(xtrace(this.prop_head, 4));
			}

            r.append("\nUUID: " + hexAsciiHash(true) + "\n");
            r.append(String.format("\nTotal length of object: %d (0x%x)\n", length(), length()));

            return r.toString();
        } catch (Exception e) {
            e.printStackTrace();
        }
        return "com.utimaco.cs2.mdl.any.BackupBlob > exception in data.";
    }

    public String hexAsciiHash(boolean formatted) {
        StringBuilder sb = new StringBuilder("com.utimaco.cs2.mdl.any.BackupBlob");
            sb.append(pattern); 
            if (this.RFU0 != null) { sb.append(new String(this.RFU0)).append(this.RFU0.length); }
            if (this.info != null) { sb.append(new String(this.info)).append(this.info.length); }
            if (this.pk != null) { sb.append(new String(this.pk)).append(this.pk.length); }
            if (this.sk != null) { sb.append(new String(this.sk)).append(this.sk.length); }
            if (this.iv != null) { sb.append(new String(this.iv)).append(this.iv.length); }
            sb.append(this.c_properties).append(4);
            sb.append(this.c_prop_max).append(4);
            if (this.chksm != null) { sb.append(new String(this.chksm)).append(this.chksm.length); }
            if (this.prop_head != null) { sb.append(new String(this.prop_head)).append(this.prop_head.length); }

            return hexAsciiHash(sb.toString(), formatted);
    }   
}