package com.utimaco.bench;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;

import com.utimaco.SimpleArgs;
import com.utimaco.cs2.mdl.pqmi.Pqmi;

/* 
 * 03c autogenerated 2024-03-11T16:14:51.6947894 using 
 * CS_SdkVpl version 0.0.5
 * Source XML Document version 01c,2024-03-11,riw
 * 
 * Copyright included by reference, please see Utimaco_Demo_License.txt
 */

// import java.io.FileOutputStream;
import CryptoServerCXI.CryptoServerCXI;

public class KeyOpts_XMSS extends com.utimaco.Benchmarks {
	String [] args;

	public KeyOpts_XMSS(String[] args, CryptoServerCXI cxi) {
		this.args = args;
	}

	public KeyOpts_XMSS(String [] args) {
		this(args, null);
	}

	public int process(String[] args, CryptoServerCXI cxi) {
		KeyOpts_XMSS ops = new KeyOpts_XMSS(args, cxi);
		return ops.go();
	}

	public int go() {
		String [] list = 
				("XMSS-SHA2_10_256 XMSS-SHA2_16_256 XMSS-SHA2_20_256 XMSS-SHA2_10_512 "
						+"    XMSS-SHA2_16_512 XMSS-SHA2_20_512 XMSS-SHAKE_10_256 XMSS-SHAKE_16_256"
						+"    XMSS-SHAKE_20_256 XMSS-SHAKE_10_512 XMSS-SHAKE_16_512"
						+"    XMSS-SHAKE_20_512 XMSS-SHA2_10_192 XMSS-SHA2_16_192 XMSS-SHA2_20_192"
						+"    XMSS-SHAKE256_10_256 XMSS-SHAKE256_16_256 XMSS-SHAKE256_20_256"
						+"    XMSS-SHAKE256_10_192 XMSS-SHAKE256_16_192 XMSS-SHAKE256_20_192"
						+"    XMSSMT-SHA2_20/2_256 XMSSMT-SHA2_20/4_256 XMSSMT-SHA2_40/2_256"
						+"    XMSSMT-SHA2_40/4_256 XMSSMT-SHA2_40/8_256 XMSSMT-SHA2_60/3_256"
						+"    XMSSMT-SHA2_60/6_256 XMSSMT-SHA2_60/12_256 XMSSMT-SHA2_20/2_512"
						+"    XMSSMT-SHA2_20/4_512 XMSSMT-SHA2_40/2_512 XMSSMT-SHA2_40/4_512"
						+"    XMSSMT-SHA2_40/8_512 XMSSMT-SHA2_60/3_512 XMSSMT-SHA2_60/6_512"
						+"    XMSSMT-SHA2_60/12_512 XMSSMT-SHAKE_20/2_256 XMSSMT-SHAKE_20/4_256"
						+"    XMSSMT-SHAKE_40/2_256 XMSSMT-SHAKE_40/4_256 XMSSMT-SHAKE_40/8_256"
						+"    XMSSMT-SHAKE_60/3_256 XMSSMT-SHAKE_60/6_256 XMSSMT-SHAKE_60/12_256"
						+"    XMSSMT-SHAKE_20/2_512 XMSSMT-SHAKE_20/4_512 XMSSMT-SHAKE_40/2_512"
						+"    XMSSMT-SHAKE_40/4_512 XMSSMT-SHAKE_40/8_512 XMSSMT-SHAKE_60/3_512"
						+"    XMSSMT-SHAKE_60/6_512 XMSSMT-SHAKE_60/12_512 XMSSMT-SHA2_20/2_192"
						+"    XMSSMT-SHA2_20/4_192 XMSSMT-SHA2_40/2_192 XMSSMT-SHA2_40/4_192"
						+"    XMSSMT-SHA2_40/8_192 XMSSMT-SHA2_60/3_192 XMSSMT-SHA2_60/6_192"
						+"    XMSSMT-SHA2_60/12_192 XMSSMT-SHAKE256_20/2_256"
						+"    XMSSMT-SHAKE256_20/4_256 XMSSMT-SHAKE256_40/2_256"
						+"    XMSSMT-SHAKE256_40/4_256 XMSSMT-SHAKE256_40/8_256"
						+"    XMSSMT-SHAKE256_60/3_256 XMSSMT-SHAKE256_60/6_256"
						+"    XMSSMT-SHAKE256_60/12_256 XMSSMT-SHAKE256_20/2_192"
						+"    XMSSMT-SHAKE256_20/4_192 XMSSMT-SHAKE256_40/2_192"
						+"    XMSSMT-SHAKE256_40/4_192 XMSSMT-SHAKE256_40/8_192"
						+"    XMSSMT-SHAKE256_60/3_192 XMSSMT-SHAKE256_60/6_192"
						+"    XMSSMT-SHAKE256_60/12_192").split("\\s+");

		String mat = getArg(args, "paramset", "");
		if (mat.length() == 0) {
			List<String> addall = Arrays.asList(list);
			output(addall);
			return 0;
		}
		ArrayList<String> adder = new ArrayList<>();
		for (String s : list) {
			if (Pattern.matches(mat, s)) { 
				adder.add(s);
			}
		}
		output(adder);
		return 0;
	}

	void output (List<String> list) {
		for (String s: list) {
			System.out.format("> %s\n", s);
		}
	}
	
	public static Byte getMTParamFromArgs(SimpleArgs args) {
		for (String t : args.params()) {
			byte[]oid = getParamFromString(t);
			if (oid != null) { 
				return oid[0]; 
			}
		}
		if (args.hasArg("-xmss")) { return 0x0; }
		if (args.hasArg("-xmssmt")) { return 0x1; }
		return null;
	}
	
	public static Byte getOIDParamFromArgs(SimpleArgs args) {
		for (String t : args.params()) {
			byte [] boid = getParamFromString(t);
			if (boid != null) { 
				return boid[1];
			}
		}
		if (args.hasArg("-xmss")) { 
			byte t = (byte)(args.getArg("-xmss", 0) & 0xFF);
			if (getSchemeFromOid(t, false) == null) { return null; }
			return t;
		}
		if (args.hasArg("-xmssmt")) { 
			byte t = (byte)(args.getArg("-xmss", 0) & 0xFF);
			if (getSchemeFromOid(t, true) == null) { return null; }
			return t;
		}
		return null;
	}
	
	
	/**
	 * Method converts strings like XMSSMT-SHAKE256_60/12_192 to its single byte representation.
	 * Returns null if not found/not supported.
	 * 
	 * return is two bytes, first byte is the MT mark, if 0x0 not MT, if 0x1 then MT
	 * Second byte is the oid within XMSS or XMSSMT
	 * 
	 * @param xmss
	 * @return byte[2]
	 */
	public static byte[] getParamFromString(String xmss) {
		byte [] ret = new byte[2];
		switch (xmss.toUpperCase()) {
		case "XMSS-SHA2_10_256": ret[0] = (byte)0x0; ret[1] = (byte)Pqmi.HBS_XMSS_SHA2_10_256; break;
		case "XMSS-SHA2_16_256": ret[0] = (byte)0x0; ret[1] = (byte)Pqmi.HBS_XMSS_SHA2_16_256; break;
		case "XMSS-SHA2_20_256": ret[0] = (byte)0x0; ret[1] = (byte)Pqmi.HBS_XMSS_SHA2_20_256; break;
		case "XMSS-SHA2_10_512": ret[0] = (byte)0x0; ret[1] = (byte)Pqmi.HBS_XMSS_SHA2_10_512; break;
		case "XMSS-SHA2_16_512": ret[0] = (byte)0x0; ret[1] = (byte)Pqmi.HBS_XMSS_SHA2_16_512; break;
		case "XMSS-SHA2_20_512": ret[0] = (byte)0x0; ret[1] = (byte)Pqmi.HBS_XMSS_SHA2_20_512; break;
		case "XMSS-SHAKE_10_256": ret[0] = (byte)0x0; ret[1] = (byte)Pqmi.HBS_XMSS_SHAKE_10_256; break;
		case "XMSS-SHAKE_16_256": ret[0] = (byte)0x0; ret[1] = (byte)Pqmi.HBS_XMSS_SHAKE_16_256; break;
		case "XMSS-SHAKE_20_256": ret[0] = (byte)0x0; ret[1] = (byte)Pqmi.HBS_XMSS_SHAKE_20_256; break;
		case "XMSS-SHAKE_10_512": ret[0] = (byte)0x0; ret[1] = (byte)Pqmi.HBS_XMSS_SHAKE_10_512; break;
		case "XMSS-SHAKE_16_512": ret[0] = (byte)0x0; ret[1] = (byte)Pqmi.HBS_XMSS_SHAKE_16_512; break;
		case "XMSS-SHAKE_20_512": ret[0] = (byte)0x0; ret[1] = (byte)Pqmi.HBS_XMSS_SHAKE_20_512; break;
		case "XMSS-SHA2_10_192": ret[0] = (byte)0x0; ret[1] = (byte)Pqmi.HBS_XMSS_SHA2_10_192; break;
		case "XMSS-SHA2_16_192": ret[0] = (byte)0x0; ret[1] = (byte)Pqmi.HBS_XMSS_SHA2_16_192; break;
		case "XMSS-SHA2_20_192": ret[0] = (byte)0x0; ret[1] = (byte)Pqmi.HBS_XMSS_SHA2_20_192; break;
		case "XMSS-SHAKE256_10_256": ret[0] = (byte)0x0; ret[1] = (byte)Pqmi.HBS_XMSS_SHAKE256_10_256; break; 
		case "XMSS-SHAKE256_16_256": ret[0] = (byte)0x0; ret[1] = (byte)Pqmi.HBS_XMSS_SHAKE256_16_256; break; 
		case "XMSS-SHAKE256_20_256": ret[0] = (byte)0x0; ret[1] = (byte)Pqmi.HBS_XMSS_SHAKE256_20_256; break;
		case "XMSS-SHAKE256_10_192": ret[0] = (byte)0x0; ret[1] = (byte)Pqmi.HBS_XMSS_SHAKE256_10_192; break; 
		case "XMSS-SHAKE256_16_192": ret[0] = (byte)0x0; ret[1] = (byte)Pqmi.HBS_XMSS_SHAKE256_16_192; break; 
		case "XMSS-SHAKE256_20_192": ret[0] = (byte)0x0; ret[1] = (byte)Pqmi.HBS_XMSS_SHAKE256_20_192; break;
		case "XMSSMT-SHA2_20/2_256": ret[0] = (byte)0x1; ret[1] = (byte)Pqmi.HBS_XMSSMT_SHA2_20_2_256; break; 
		case "XMSSMT-SHA2_20/4_256": ret[0] = (byte)0x1; ret[1] = (byte)Pqmi.HBS_XMSSMT_SHA2_20_4_256; break; 
		case "XMSSMT-SHA2_40/2_256": ret[0] = (byte)0x1; ret[1] = (byte)Pqmi.HBS_XMSSMT_SHA2_40_2_256; break;
		case "XMSSMT-SHA2_40/4_256": ret[0] = (byte)0x1; ret[1] = (byte)Pqmi.HBS_XMSSMT_SHA2_40_4_256; break; 
		case "XMSSMT-SHA2_40/8_256": ret[0] = (byte)0x1; ret[1] = (byte)Pqmi.HBS_XMSSMT_SHA2_40_8_256; break; 
		case "XMSSMT-SHA2_60/3_256": ret[0] = (byte)0x1; ret[1] = (byte)Pqmi.HBS_XMSSMT_SHA2_60_3_256; break;
		case "XMSSMT-SHA2_60/6_256": ret[0] = (byte)0x1; ret[1] = (byte)Pqmi.HBS_XMSSMT_SHA2_60_6_256; break; 
		case "XMSSMT-SHA2_60/12_256": ret[0] = (byte)0x1; ret[1] = (byte)Pqmi.HBS_XMSSMT_SHA2_60_12_256; break; 
		case "XMSSMT-SHA2_20/2_512": ret[0] = (byte)0x1; ret[1] = (byte)Pqmi.HBS_XMSSMT_SHA2_20_2_512; break;
		case "XMSSMT-SHA2_20/4_512": ret[0] = (byte)0x1; ret[1] = (byte)Pqmi.HBS_XMSSMT_SHA2_20_4_512; break; 
		case "XMSSMT-SHA2_40/2_512": ret[0] = (byte)0x1; ret[1] = (byte)Pqmi.HBS_XMSSMT_SHA2_40_2_512; break; 
		case "XMSSMT-SHA2_40/4_512": ret[0] = (byte)0x1; ret[1] = (byte)Pqmi.HBS_XMSSMT_SHA2_40_4_512; break;
		case "XMSSMT-SHA2_40/8_512": ret[0] = (byte)0x1; ret[1] = (byte)Pqmi.HBS_XMSSMT_SHA2_40_8_512; break; 
		case "XMSSMT-SHA2_60/3_512": ret[0] = (byte)0x1; ret[1] = (byte)Pqmi.HBS_XMSSMT_SHA2_60_3_512; break; 
		case "XMSSMT-SHA2_60/6_512": ret[0] = (byte)0x1; ret[1] = (byte)Pqmi.HBS_XMSSMT_SHA2_60_6_512; break;
		case "XMSSMT-SHA2_60/12_512": ret[0] = (byte)0x1; ret[1] = (byte)Pqmi.HBS_XMSSMT_SHA2_60_12_512; break; 
		case "XMSSMT-SHAKE_20/2_256": ret[0] = (byte)0x1; ret[1] = (byte)Pqmi.HBS_XMSSMT_SHAKE_20_2_256; break; 
		case "XMSSMT-SHAKE_20/4_256": ret[0] = (byte)0x1; ret[1] = (byte)Pqmi.HBS_XMSSMT_SHAKE_20_4_256; break;
		case "XMSSMT-SHAKE_40/2_256": ret[0] = (byte)0x1; ret[1] = (byte)Pqmi.HBS_XMSSMT_SHAKE_40_2_256; break; 
		case "XMSSMT-SHAKE_40/4_256": ret[0] = (byte)0x1; ret[1] = (byte)Pqmi.HBS_XMSSMT_SHAKE_40_4_256; break; 
		case "XMSSMT-SHAKE_40/8_256": ret[0] = (byte)0x1; ret[1] = (byte)Pqmi.HBS_XMSSMT_SHAKE_40_8_256; break;
		case "XMSSMT-SHAKE_60/3_256": ret[0] = (byte)0x1; ret[1] = (byte)Pqmi.HBS_XMSSMT_SHAKE_60_3_256; break; 
		case "XMSSMT-SHAKE_60/6_256": ret[0] = (byte)0x1; ret[1] = (byte)Pqmi.HBS_XMSSMT_SHAKE_60_6_256; break; 
		case "XMSSMT-SHAKE_60/12_256": ret[0] = (byte)0x1; ret[1] = (byte)Pqmi.HBS_XMSSMT_SHAKE_60_12_256; break;
		case "XMSSMT-SHAKE_20/2_512": ret[0] = (byte)0x1; ret[1] = (byte)Pqmi.HBS_XMSSMT_SHAKE_20_2_512; break; 
		case "XMSSMT-SHAKE_20/4_512": ret[0] = (byte)0x1; ret[1] = (byte)Pqmi.HBS_XMSSMT_SHAKE_20_4_512; break; 
		case "XMSSMT-SHAKE_40/2_512": ret[0] = (byte)0x1; ret[1] = (byte)Pqmi.HBS_XMSSMT_SHAKE_40_2_512; break;
		case "XMSSMT-SHAKE_40/4_512": ret[0] = (byte)0x1; ret[1] = (byte)Pqmi.HBS_XMSSMT_SHAKE_40_4_512; break; 
		case "XMSSMT-SHAKE_40/8_512": ret[0] = (byte)0x1; ret[1] = (byte)Pqmi.HBS_XMSSMT_SHAKE_40_8_512; break; 
		case "XMSSMT-SHAKE_60/3_512": ret[0] = (byte)0x1; ret[1] = (byte)Pqmi.HBS_XMSSMT_SHAKE_60_3_512; break;
		case "XMSSMT-SHAKE_60/6_512": ret[0] = (byte)0x1; ret[1] = (byte)Pqmi.HBS_XMSSMT_SHAKE_60_6_512; break; 
		case "XMSSMT-SHAKE_60/12_512": ret[0] = (byte)0x1; ret[1] = (byte)Pqmi.HBS_XMSSMT_SHAKE_60_12_512; break; 
		case "XMSSMT-SHA2_20/2_192": ret[0] = (byte)0x1; ret[1] = (byte)Pqmi.HBS_XMSSMT_SHA2_20_2_192; break;
		case "XMSSMT-SHA2_20/4_192": ret[0] = (byte)0x1; ret[1] = (byte)Pqmi.HBS_XMSSMT_SHA2_20_4_192; break; 
		case "XMSSMT-SHA2_40/2_192": ret[0] = (byte)0x1; ret[1] = (byte)Pqmi.HBS_XMSSMT_SHA2_40_2_192; break; 
		case "XMSSMT-SHA2_40/4_192": ret[0] = (byte)0x1; ret[1] = (byte)Pqmi.HBS_XMSSMT_SHA2_40_4_192; break;
		case "XMSSMT-SHA2_40/8_192": ret[0] = (byte)0x1; ret[1] = (byte)Pqmi.HBS_XMSSMT_SHA2_40_8_192; break; 
		case "XMSSMT-SHA2_60/3_192": ret[0] = (byte)0x1; ret[1] = (byte)Pqmi.HBS_XMSSMT_SHA2_60_3_192; break; 
		case "XMSSMT-SHA2_60/6_192": ret[0] = (byte)0x1; ret[1] = (byte)Pqmi.HBS_XMSSMT_SHA2_60_6_192; break;
		case "XMSSMT-SHA2_60/12_192": ret[0] = (byte)0x1; ret[1] = (byte)Pqmi.HBS_XMSSMT_SHA2_60_12_192; break; 
		case "XMSSMT-SHAKE256_20/2_256": ret[0] = (byte)0x1; ret[1] = (byte)Pqmi.HBS_XMSSMT_SHAKE256_20_2_256; break;
		case "XMSSMT-SHAKE256_20/4_256": ret[0] = (byte)0x1; ret[1] = (byte)Pqmi.HBS_XMSSMT_SHAKE256_20_4_256; break; 
		case "XMSSMT-SHAKE256_40/2_256": ret[0] = (byte)0x1; ret[1] = (byte)Pqmi.HBS_XMSSMT_SHAKE256_40_2_256; break;
		case "XMSSMT-SHAKE256_40/4_256": ret[0] = (byte)0x1; ret[1] = (byte)Pqmi.HBS_XMSSMT_SHAKE256_40_4_256; break; 
		case "XMSSMT-SHAKE256_40/8_256": ret[0] = (byte)0x1; ret[1] = (byte)Pqmi.HBS_XMSSMT_SHAKE256_40_8_256; break;
		case "XMSSMT-SHAKE256_60/3_256": ret[0] = (byte)0x1; ret[1] = (byte)Pqmi.HBS_XMSSMT_SHAKE256_60_3_256; break; 
		case "XMSSMT-SHAKE256_60/6_256": ret[0] = (byte)0x1; ret[1] = (byte)Pqmi.HBS_XMSSMT_SHAKE256_60_6_256; break;
		case "XMSSMT-SHAKE256_60/12_256": ret[0] = (byte)0x1; ret[1] = (byte)Pqmi.HBS_XMSSMT_SHAKE256_60_12_256; break; 
		case "XMSSMT-SHAKE256_20/2_192": ret[0] = (byte)0x1; ret[1] = (byte)Pqmi.HBS_XMSSMT_SHAKE256_20_2_192; break;
		case "XMSSMT-SHAKE256_20/4_192": ret[0] = (byte)0x1; ret[1] = (byte)Pqmi.HBS_XMSSMT_SHAKE256_20_4_192; break; 
		case "XMSSMT-SHAKE256_40/2_192": ret[0] = (byte)0x1; ret[1] = (byte)Pqmi.HBS_XMSSMT_SHAKE256_40_2_192; break;
		case "XMSSMT-SHAKE256_40/4_192": ret[0] = (byte)0x1; ret[1] = (byte)Pqmi.HBS_XMSSMT_SHAKE256_40_4_192; break; 
		case "XMSSMT-SHAKE256_40/8_192": ret[0] = (byte)0x1; ret[1] = (byte)Pqmi.HBS_XMSSMT_SHAKE256_40_8_192; break;
		case "XMSSMT-SHAKE256_60/3_192": ret[0] = (byte)0x1; ret[1] = (byte)Pqmi.HBS_XMSSMT_SHAKE256_60_3_192; break; 
		case "XMSSMT-SHAKE256_60/6_192": ret[0] = (byte)0x1; ret[1] = (byte)Pqmi.HBS_XMSSMT_SHAKE256_60_6_192; break;
		case "XMSSMT-SHAKE256_60/12_192": ret[0] = (byte)0x1; ret[1] = (byte)Pqmi.HBS_XMSSMT_SHAKE256_60_12_192; break;
		default:
			return null;
		}

		return ret;
	}

	public static String getSchemeFromOid(byte oid, boolean mt) {
		byte [] t = new byte[1];
		t[0] = oid;
		return getSchemeFromOid(t, mt);
	}
	
	public static String getSchemeFromOid(byte[] boid, boolean mt) {
		String ret = null;
		
		if (!mt) {
			switch (boid[0]) {
			case (byte)Pqmi.HBS_XMSS_SHA2_10_256: ret = "XMSS-SHA2_10_256"; break;
			case (byte)Pqmi.HBS_XMSS_SHA2_16_256: ret = "XMSS-SHA2_16_256"; break;
			case (byte)Pqmi.HBS_XMSS_SHA2_20_256: ret = "XMSS-SHA2_20_256"; break;
			case (byte)Pqmi.HBS_XMSS_SHA2_10_512: ret = "XMSS-SHA2_10_512"; break;
			case (byte)Pqmi.HBS_XMSS_SHA2_16_512: ret = "XMSS-SHA2_16_512"; break;
			case (byte)Pqmi.HBS_XMSS_SHA2_20_512: ret =  "XMSS-SHA2_20_512"; break;
			case (byte)Pqmi.HBS_XMSS_SHAKE_10_256: ret =  "XMSS-SHAKE_10_256"; break;
			case (byte)Pqmi.HBS_XMSS_SHAKE_16_256: ret =  "XMSS-SHAKE_16_256"; break;
			case (byte)Pqmi.HBS_XMSS_SHAKE_20_256: ret =  "XMSS-SHAKE_20_256"; break;
			case (byte)Pqmi.HBS_XMSS_SHAKE_10_512: ret =  "XMSS-SHAKE_10_512"; break;
			case (byte)Pqmi.HBS_XMSS_SHAKE_16_512: ret =  "XMSS-SHAKE_16_512"; break;
			case (byte)Pqmi.HBS_XMSS_SHAKE_20_512: ret =  "XMSS-SHAKE_20_512"; break;
			case (byte)Pqmi.HBS_XMSS_SHA2_10_192: ret =  "XMSS-SHA2_10_192"; break;
			case (byte)Pqmi.HBS_XMSS_SHA2_16_192: ret =  "XMSS-SHA2_16_192"; break;
			case (byte)Pqmi.HBS_XMSS_SHA2_20_192: ret =  "XMSS-SHA2_20_192"; break;
			case (byte)Pqmi.HBS_XMSS_SHAKE256_10_256: ret =  "XMSS-SHAKE256_10_256"; break; 
			case (byte)Pqmi.HBS_XMSS_SHAKE256_16_256: ret =  "XMSS-SHAKE256_16_256"; break; 
			case (byte)Pqmi.HBS_XMSS_SHAKE256_20_256: ret =  "XMSS-SHAKE256_20_256"; break;
			case (byte)Pqmi.HBS_XMSS_SHAKE256_10_192: ret =  "XMSS-SHAKE256_10_192"; break; 
			case (byte)Pqmi.HBS_XMSS_SHAKE256_16_192: ret =  "XMSS-SHAKE256_16_192"; break; 
			case (byte)Pqmi.HBS_XMSS_SHAKE256_20_192: ret =  "XMSS-SHAKE256_20_192"; break;
			default:
				return null;
			}
		} else {		

			switch (boid[0]) {
			case (byte)Pqmi.HBS_XMSSMT_SHA2_20_2_256: ret =  "XMSSMT-SHA2_20/2_256"; break; 
			case (byte)Pqmi.HBS_XMSSMT_SHA2_20_4_256: ret =  "XMSSMT-SHA2_20/4_256"; break; 
			case (byte)Pqmi.HBS_XMSSMT_SHA2_40_2_256: ret =  "XMSSMT-SHA2_40/2_256"; break;
			case (byte)Pqmi.HBS_XMSSMT_SHA2_40_4_256: ret =  "XMSSMT-SHA2_40/4_256"; break; 
			case (byte)Pqmi.HBS_XMSSMT_SHA2_40_8_256: ret =  "XMSSMT-SHA2_40/8_256"; break; 
			case (byte)Pqmi.HBS_XMSSMT_SHA2_60_3_256: ret =  "XMSSMT-SHA2_60/3_256"; break;
			case (byte)Pqmi.HBS_XMSSMT_SHA2_60_6_256: ret =  "XMSSMT-SHA2_60/6_256"; break; 
			case (byte)Pqmi.HBS_XMSSMT_SHA2_60_12_256: ret =  "XMSSMT-SHA2_60/12_256"; break; 
			case (byte)Pqmi.HBS_XMSSMT_SHA2_20_2_512: ret =  "XMSSMT-SHA2_20/2_512"; break;
			case (byte)Pqmi.HBS_XMSSMT_SHA2_20_4_512: ret =  "XMSSMT-SHA2_20/4_512"; break; 
			case (byte)Pqmi.HBS_XMSSMT_SHA2_40_2_512: ret =  "XMSSMT-SHA2_40/2_512"; break; 
			case (byte)Pqmi.HBS_XMSSMT_SHA2_40_4_512: ret =  "XMSSMT-SHA2_40/4_512"; break;
			case (byte)Pqmi.HBS_XMSSMT_SHA2_40_8_512: ret =  "XMSSMT-SHA2_40/8_512"; break; 
			case (byte)Pqmi.HBS_XMSSMT_SHA2_60_3_512: ret =  "XMSSMT-SHA2_60/3_512"; break; 
			case (byte)Pqmi.HBS_XMSSMT_SHA2_60_6_512: ret =  "XMSSMT-SHA2_60/6_512"; break;
			case (byte)Pqmi.HBS_XMSSMT_SHA2_60_12_512: ret =  "XMSSMT-SHA2_60/12_512"; break; 
			case (byte)Pqmi.HBS_XMSSMT_SHAKE_20_2_256: ret =  "XMSSMT-SHAKE_20/2_256"; break; 
			case (byte)Pqmi.HBS_XMSSMT_SHAKE_20_4_256: ret =  "XMSSMT-SHAKE_20/4_256"; break;
			case (byte)Pqmi.HBS_XMSSMT_SHAKE_40_2_256: ret =  "XMSSMT-SHAKE_40/2_256"; break; 
			case (byte)Pqmi.HBS_XMSSMT_SHAKE_40_4_256: ret =  "XMSSMT-SHAKE_40/4_256"; break; 
			case (byte)Pqmi.HBS_XMSSMT_SHAKE_40_8_256: ret =  "XMSSMT-SHAKE_40/8_256"; break;
			case (byte)Pqmi.HBS_XMSSMT_SHAKE_60_3_256: ret =  "XMSSMT-SHAKE_60/3_256"; break; 
			case (byte)Pqmi.HBS_XMSSMT_SHAKE_60_6_256: ret =  "XMSSMT-SHAKE_60/6_256"; break; 
			case (byte)Pqmi.HBS_XMSSMT_SHAKE_60_12_256: ret =  "XMSSMT-SHAKE_60/12_256"; break;
			case (byte)Pqmi.HBS_XMSSMT_SHAKE_20_2_512: ret =  "XMSSMT-SHAKE_20/2_512"; break; 
			case (byte)Pqmi.HBS_XMSSMT_SHAKE_20_4_512: ret =  "XMSSMT-SHAKE_20/4_512"; break; 
			case (byte)Pqmi.HBS_XMSSMT_SHAKE_40_2_512: ret =  "XMSSMT-SHAKE_40/2_512"; break;
			case (byte)Pqmi.HBS_XMSSMT_SHAKE_40_4_512: ret =  "XMSSMT-SHAKE_40/4_512"; break; 
			case (byte)Pqmi.HBS_XMSSMT_SHAKE_40_8_512: ret =  "XMSSMT-SHAKE_40/8_512"; break; 
			case (byte)Pqmi.HBS_XMSSMT_SHAKE_60_3_512: ret =  "XMSSMT-SHAKE_60/3_512"; break;
			case (byte)Pqmi.HBS_XMSSMT_SHAKE_60_6_512: ret =  "XMSSMT-SHAKE_60/6_512"; break; 
			case (byte)Pqmi.HBS_XMSSMT_SHAKE_60_12_512: ret =  "XMSSMT-SHAKE_60/12_512"; break; 
			case (byte)Pqmi.HBS_XMSSMT_SHA2_20_2_192: ret =  "XMSSMT-SHA2_20/2_192"; break;
			case (byte)Pqmi.HBS_XMSSMT_SHA2_20_4_192: ret =  "XMSSMT-SHA2_20/4_192"; break; 
			case (byte)Pqmi.HBS_XMSSMT_SHA2_40_2_192: ret =  "XMSSMT-SHA2_40/2_192"; break; 
			case (byte)Pqmi.HBS_XMSSMT_SHA2_40_4_192: ret =  "XMSSMT-SHA2_40/4_192"; break;
			case (byte)Pqmi.HBS_XMSSMT_SHA2_40_8_192: ret =  "XMSSMT-SHA2_40/8_192"; break; 
			case (byte)Pqmi.HBS_XMSSMT_SHA2_60_3_192: ret =  "XMSSMT-SHA2_60/3_192"; break; 
			case (byte)Pqmi.HBS_XMSSMT_SHA2_60_6_192: ret =  "XMSSMT-SHA2_60/6_192"; break;
			case (byte)Pqmi.HBS_XMSSMT_SHA2_60_12_192: ret =  "XMSSMT-SHA2_60/12_192"; break; 
			case (byte)Pqmi.HBS_XMSSMT_SHAKE256_20_2_256: ret =  "XMSSMT-SHAKE256_20/2_256"; break;
			case (byte)Pqmi.HBS_XMSSMT_SHAKE256_20_4_256: ret =  "XMSSMT-SHAKE256_20/4_256"; break; 
			case (byte)Pqmi.HBS_XMSSMT_SHAKE256_40_2_256: ret =  "XMSSMT-SHAKE256_40/2_256"; break;
			case (byte)Pqmi.HBS_XMSSMT_SHAKE256_40_4_256: ret =  "XMSSMT-SHAKE256_40/4_256"; break; 
			case (byte)Pqmi.HBS_XMSSMT_SHAKE256_40_8_256: ret =  "XMSSMT-SHAKE256_40/8_256"; break;
			case (byte)Pqmi.HBS_XMSSMT_SHAKE256_60_3_256: ret =  "XMSSMT-SHAKE256_60/3_256"; break; 
			case (byte)Pqmi.HBS_XMSSMT_SHAKE256_60_6_256: ret =  "XMSSMT-SHAKE256_60/6_256"; break;
			case (byte)Pqmi.HBS_XMSSMT_SHAKE256_60_12_256: ret =  "XMSSMT-SHAKE256_60/12_256"; break; 
			case (byte)Pqmi.HBS_XMSSMT_SHAKE256_20_2_192: ret =  "XMSSMT-SHAKE256_20/2_192"; break;
			case (byte)Pqmi.HBS_XMSSMT_SHAKE256_20_4_192: ret =  "XMSSMT-SHAKE256_20/4_192"; break; 
			case (byte)Pqmi.HBS_XMSSMT_SHAKE256_40_2_192: ret =  "XMSSMT-SHAKE256_40/2_192"; break;
			case (byte)Pqmi.HBS_XMSSMT_SHAKE256_40_4_192: ret =  "XMSSMT-SHAKE256_40/4_192"; break; 
			case (byte)Pqmi.HBS_XMSSMT_SHAKE256_40_8_192: ret =  "XMSSMT-SHAKE256_40/8_192"; break;
			case (byte)Pqmi.HBS_XMSSMT_SHAKE256_60_3_192: ret =  "XMSSMT-SHAKE256_60/3_192"; break; 
			case (byte)Pqmi.HBS_XMSSMT_SHAKE256_60_6_192: ret =  "XMSSMT-SHAKE256_60/6_192"; break;
			case (byte)Pqmi.HBS_XMSSMT_SHAKE256_60_12_192: ret =  "XMSSMT-SHAKE256_60/12_192"; break;
			default:
				return null;
			}
		}
		return ret;
	}


}
