package com.utimaco.bench;

import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Random;
import com.utimaco.Benchmarks;
import com.utimaco.cs2.mdl.Utils;
import com.utimaco.cs2.mdl.pqmi.Pqmi;

public class Bench {
	static final Random r = new Random();
	static int module_id = 0xa6; // ;

	static int sfc_id_gen_dil = Pqmi.SFC_DILITHIUM_KEYGEN; // Until you change it.
	static int sfc_id_sign_dil = Pqmi.SFC_DILITHIUM_SIGN; // Until you change it.
	static int sfc_id_verf_dil = Pqmi.SFC_DILITHIUM_VERIFY; // Until you change it.
	static int sfc_id_gen_kyb = Pqmi.SFC_KYBER_KEYGEN; // 5
	static int sfc_id_enc_kyb = Pqmi.SFC_KYBER_ENC; // 6
	static int sfc_id_dec_kyb = Pqmi.SFC_KYBER_DEC; // 7

	static int sfc_id_keystore = Pqmi.SFC_KEYSTORE; // until you change it.
	
	static int E_OPERATION_INVALID_KEYTYPE = 0xB1A20004;

	static boolean dbg = false;

	static Benchmarks _singleton = new Benchmarks();
	static boolean test = false;

	protected static void announce(String format) {
		System.out.format("\n---------------------------------------------------------------------------\n%s\n\n", format);
	}
	
	/***********************************************************************
	 * TEST SPECIFIC
	 **/

	// infra
	static public Instant timehack() {
		return 
				Instant                // Represent a moment in UTC. 
				.now()                 // Capture the current moment. Returns a `Instant` object. 
				.truncatedTo(          // Lop off the finer part of this moment. 
						ChronoUnit.MICROS  // Granularity to which we are truncating. 
						);                     // Returns another `Instant` object rather than changing the original, per the immutable objects pattern. 
	}

	static public Double report(String[] args, Instant s, Instant e, int countpth, int count, String tag) {
		System.out.format("%s:\n    Count:  %d\n  Counter:  %d\n", tag, countpth, count);
		for(String a : args) { System.out.format("%s ", a); }
		System.out.print("\n\n");

		Duration dur = Duration.between(s, e);
		String dn = (int)(dur.toMinutesPart()*60.0) + dur.toSecondsPart() + "." + dur.toMillisPart();
		Double dd = Double.parseDouble(dn);
		if (dd != 0x0) {
			System.out.format("    Duration:  %s\n         TPS:  %.04f\n", dn, count/dd);
		}
		System.out.print("\n");
		System.out.println(s);
		System.out.println(e);
		System.out.print("\n");

		return dd;
	}

	public static byte[] getMsg(String[] args) {
		byte [] msga = null;
		
		String msg = Benchmarks.getArg(args, "msg", (String)null);
		if (msg != null) {
			if (Utils.isHex(msg)) 
				msga = Utils.convertToByteArray(msg);
			else 
				try {
					msga = Utils.b64decode(msg);
				} catch (IllegalArgumentException e) {
					msga = msg.getBytes();
				}
		}
		if (msga == null) {
			msg = Benchmarks.getArg(args, "artifact", (String)null);
			try {
				msga = Utils.readFileAsBytes(msg);
			} catch (IOException e) {
				System.out.printf("-artifact %s not readable.\n", msg);
			}
		}
		return msga;
	}
	
}
