package com.utimaco.aut;

import java.io.IOException;
import java.nio.ByteBuffer;

import com.utimaco.SimpleArgs;
import com.utimaco.cs2.mdl.SerializationError;
import com.utimaco.cs2.mdl.any.CxiKeyAttributes;
import com.utimaco.cs2.mdl.pqmi.HbsGen;
import com.utimaco.cs2.mdl.pqmi.HbsPubkeyGet;
import com.utimaco.cs2.mdl.pqmi.HbsSign;
import com.utimaco.cs2.mdl.pqmi.HbsVerify;
import com.utimaco.cs2.mdl.pqmi.Pqmi;

import CryptoServerAPI.CryptoServerException;
//import CryptoServerAPI.CryptoServerUtil;
import CryptoServerCXI.CryptoServerCXI;

public class LmsTest implements AutTest {
	static int module_id = 0xa6; // Access is via 0xa6 (pqmi), not 0xa3 (HBS)

	static final int sfc_id_gen_lms = Pqmi.SFC_HBS_KEYGEN;
	static final int sfc_id_getpub_lms = Pqmi.SFC_HBS_GET_PUBKEY;
	static final int sfc_id_sign_lms = Pqmi.SFC_HBS_SIGN;
	static final int sfc_id_verf_lms = Pqmi.SFC_HBS_VERIFY;

	static final int sfc_id_keystore = Pqmi.SFC_KEYSTORE;
	
	CryptoServerCXI cxi;
	SimpleArgs args;
	boolean ctors;
	int rnd_touse;
	int sto_touse;
	boolean asynch;
	
	public LmsTest(CryptoServerCXI cxi, SimpleArgs cla) {
		this(cxi, cla, false);
	}
	public LmsTest(CryptoServerCXI cxi, SimpleArgs cla, boolean asynch) {
		this.cxi = cxi;
		this.args = cla;
		this.ctors = false;
		this.rnd_touse = cla.hasArg("drbg:trng") ? Pqmi.MODE_REAL_RND : Pqmi.MODE_PSEUDO_RND;
		this.sto_touse = Pqmi.KEY_OVERWRITE; //? Pqmi.KEY_EXTERNAL not for HBS keys;
		this.asynch = asynch;

		module_id = AutTest.getModuleId(cxi, "PQMI");

	}

	public boolean go() {
		return gensignverify();
	}

	/*
	static boolean lms_gen() {
		// flags is a mush of rng, and keystore info
		int outerflags = rnd | sto | (sto == Pqmi.KEY_EXTERNAL ? 0 : Pqmi.KEY_OVERWRITE);

		CxiKeyAttributes attributes = new CxiKeyAttributes(); // Field primitive is typed Interface

		// cxikeyattributes
		attributes.group("lms_key");
		attributes.name("testseries");
		attributes.spec(0);

		// The CxiKeyAttributes mdata (metadata) field is optional, it allows the architect to 
		// insert locally relevant info into the key, where supported.  Use of this field is 
		// not recommended due to the 'where supported' caveat, and as it may not be part of 
		// the migration strategy for future implementations of SecurityServer.  It is a 
		// proof of concept idea.
		/star
		byte [] dtg = Instant.now().toString().getBytes(Charset.forName("US-ASCII"));
		ByteBuffer mdata = ByteBuffer.allocate(1 + 2 + 2 + dtg.length);
		mdata.put(oid[0]);
		mdata.put("DC".getBytes());
		mdata.putShort((short) dtg.length);
		mdata.put(dtg);
		attributes.mdata(mdata.array());
		star/

		try {
			HbsGen opn = new HbsGen();
			opn.flags(outerflags);
			opn.type(Pqmi.HBS_LMS_KEYTYPE);
			opn.attributes(attributes);
			
			// levels == 1 (LMS) or 2..8 (HSS)
            int levels = 1;
            ByteBuffer oid = ByteBuffer.allocate(2 * levels);
            oid.put((byte)(Pqmi.HBS_LMS_SHA256_N32_H5 & 0xFF));
            oid.put((byte)(Pqmi.HBS_LMOTS_SHA256_N32_W4 & 0xFF));

			opn.levels(levels);
			opn.levelparams(oid.array());
			opn.auxdatasz(10916);  // per the doc, this is the max size needed for this buffer
                                   // high == fewer keys, low == longer times

			opn.exec(cxi, module_id, sfc_id_gen_hbs);

			byte [] result = opn.resp;
			CryptoServerUtil.xtrace("Result", result);
			return true;
		} catch (CryptoServerException cse) {
			System.err.println(cse.getLocalizedMessage());
		} catch (SerializationError e) {
			System.err.println("Serialization error");
		} catch (IOException e) {
			e.printStackTrace();
		}

		return false;
	}
	*/

	
	private boolean gensignverify () {
		boolean res = false;
		
		// This is the "HSM-aware POJO" used to generate a key.
		HbsGen tobj_ctor = new HbsGen();

		// There are two constructors below, one uses the POJO's full constructor (true) or just calls setters on the empty
		// object above.
		boolean use_ctor = ctors;

		// One of the fields of the generator object is a "packed" CXI Key Attributes template.
		// This is the template, it must be serialized for use, however the parent generator obj 
		// setter can take the object, and will call the object's serializer to get the serialized
		// buffer.  NOTE: This happens on the call, subsequent changes to the attributes template
		// have NO affect on anything that serialized it previously.
		CxiKeyAttributes attributes = new CxiKeyAttributes(); // Field primitive is typed Interface

		// CxiKeyAttributes - typed field attributes
		int flags = 0x0;
		// CXI stores its keys, indexed by the MD5 of the key {NAME||GROUP||SPEC} (|| here means 
		// 'concatenated with', so NAME concatenated with GROUP etc).
		byte [] name = "lms".getBytes();
		byte [] group = "testseries".getBytes();
		int spec = 0;

		int algo = CryptoServerCXI.KEY_ALGO_RAW;
		int usage = CryptoServerCXI.KEY_USAGE_SIGN | CryptoServerCXI.KEY_USAGE_VERIFY;
		int export = 0; // ALLOW_BACKUP only, no export wrapped

		if (use_ctor) {
			attributes = new CxiKeyAttributes (
					flags,
					name,
					group,
					spec,
					algo,
					usage,
					export, 
					new byte[0]
					);
		} else {
			attributes = new CxiKeyAttributes (cxi);
			attributes.flags (flags);
			attributes.name (name);
			attributes.group (group);
			attributes.spec (spec);
			attributes.algo (algo);
			attributes.usage (usage);
			attributes.export (export);
		}

		System.out.println("LMS:  Generate Key");

		tobj_ctor.flags(rnd_touse | sto_touse);
		tobj_ctor.type(Pqmi.HBS_LMS_KT_FLAG);
		
		Byte levelp = 1; // 1..8, 1 == LMS, >1 = HSS
		tobj_ctor.levels(levelp);

        ByteBuffer oid = ByteBuffer.allocate(2 * levelp);
        // each pair is an LMS and an LMOTS type
        oid.put((byte)(Pqmi.HBS_LMS_SHA256_N32_H5 & 0xFF));
        oid.put((byte)(Pqmi.HBS_LMOTS_SHA256_N32_W4 & 0xFF));

        tobj_ctor.levelparams(oid.array());

        tobj_ctor.auxdatasz(10916);  	// per the doc, this is the max size needed for this buffer
        								// high == fewer keys, low == longer times
		
		try {
			tobj_ctor.attributes(attributes);

			res = tobj_ctor.exec(cxi, module_id, sfc_id_gen_lms);
			System.out.println("Key Generated\n");
		} catch (SerializationError e) {
			e.printStackTrace();
			return false;
		} catch (IOException e) {
			e.printStackTrace();
			return false;
		} catch (CryptoServerException e) {
			e.printStackTrace();
			return false;
		}

		System.out.println("LMS:  Get Public Key");
		
		HbsPubkeyGet getter = new HbsPubkeyGet();
		byte [] pubkey = null;
		try {
			getter.basekey(attributes);
			res = getter.exec(cxi, module_id, sfc_id_getpub_lms);
			pubkey = getter.getResponse();
			System.out.println("Key Retrieved\n");
		} catch (SerializationError e) {
			e.printStackTrace();
			return false;
		} catch (IOException e) {
			e.printStackTrace();
			return false;
		} catch (CryptoServerException e) {
			e.printStackTrace();
			return false;
		}

		String msg = "This is my message to be signed.";
		String bad_msg = "This is NOT MY MESSAGE!";

		for (int i = 0; i < 3; i++) {
			System.out.println("LMS Sign");
			HbsSign signer = new HbsSign();
			byte [] signature = null;
			try {
				signer.basekey(attributes);
				System.out.format("Using '%s'\n", msg);
				signer.msg(msg); // also has a msg(byte[]) method
				
				// short message test, flags has hint to key type
				signer.flags(Pqmi.HBS_LMS_KT_FLAG | Pqmi.FLAG_INIT | Pqmi.FLAG_FINALIZE);
				res = signer.exec(cxi, module_id, sfc_id_sign_lms);

				signature = signer.getResponse(); // getResponse added by hand after interfaces were generated

			} catch (SerializationError e) {
				e.printStackTrace();
				return false;
			} catch (IOException e) {
				e.printStackTrace();
				return false;
			} catch (CryptoServerException e) {
				e.printStackTrace();
				return false;
			}

			System.out.println("LMS Verify");
			HbsVerify verifier = new HbsVerify();
			try {
				verifier.flags(Pqmi.HBS_LMS_KT_FLAG | Pqmi.FLAG_INIT | Pqmi.FLAG_FINALIZE);
				verifier.pubkey(pubkey);
				System.out.format("Using '%s'\n", msg);
				verifier.msg(msg);
				verifier.sig(signature);

				res = verifier.exec(cxi, module_id, sfc_id_verf_lms);

				System.out.println("Verification succeeded.\n");
			} catch (IOException e) {
				e.printStackTrace();
				return false;
			} catch (CryptoServerException e) {
				e.printStackTrace();
				return false;
			}
			System.out.println("LMS Verify negative case (should fail)");
			try {
				verifier.flags(Pqmi.HBS_LMS_KT_FLAG | Pqmi.FLAG_INIT | Pqmi.FLAG_FINALIZE);
				verifier.pubkey(pubkey);
				System.out.format("Using '%s'\n", bad_msg);
				verifier.msg(bad_msg);
				verifier.sig(signature);

				res = verifier.exec(cxi, module_id, sfc_id_verf_lms);

				System.out.println("Verification succeeded -- SHOULD NOT HAVE!!!\n");
			} catch (IOException e) {
				e.printStackTrace();
				return false;
			} catch (CryptoServerException e) {
				if (e.ErrorCode != 0xB0680033) {
					e.printStackTrace();
					return false;
				}
				System.out.println("Invalid input (msg) test passed.");
			}
		}		

		System.out.println("Test over\n");
		return res;
	}

}
