package com.utimaco.aut;

import java.io.IOException;
import java.nio.ByteBuffer;

import com.utimaco.cs2.mdl.pqmi.Pqmi;

import CryptoServerAPI.CryptoServerException;
import CryptoServerCXI.CryptoServerCXI;


public interface AutTest {
	boolean go();
	
	static void announce(String format) {
		System.out.format("%n---------------------------------------------------------------------------%n%s%n%n", format);
	}
	
	static String storageType(int type) {
		String store = "Internal";
		
		switch (type) {
		case Pqmi.KEY_EXTERNAL + Pqmi.KEY_OVERWRITE:
			store = "External+Overwrite"; break;
		case Pqmi.KEY_EXTERNAL:
			store = "External"; break;
		case Pqmi.KEY_OVERWRITE:
			store = "Internal+Overwrite"; break;
		default:
			break;
		}
		return store;
	}
	
	/**
	 * kt should be supplied as security parameter set level, ie 2, 3 or 5
	 * 
	 * @param kt
	 * @param aes
	 * @return
	 */
	public static int getDilithiumKeytype(int kt, boolean aes) {
		int keytype = Pqmi.DILITHIUM_KT_FLAG;
		int ikt = kt - 1 + (aes ? 1 : 0);

		switch (ikt) {
		case 0: keytype |= Pqmi.DILITHIUM_4X4_R3; break;
		case 1: keytype |= Pqmi.DILITHIUM_4X4_AES_R3; break;
		case 2: keytype |= Pqmi.DILITHIUM_6X5_R3; break;
		case 3: keytype |= Pqmi.DILITHIUM_6X5_AES_R3; break;
		case 4: keytype |= Pqmi.DILITHIUM_8X7_R3; break;
		case 5: keytype |= Pqmi.DILITHIUM_8X7_AES_R3; break;
		default:
			System.out.println("Invalid Dilithium key type, please supply 1 3 or 5");
			System.exit(-1);
		}
		return keytype;
	}
	
	/**
	 * kt should be supplied as security parameter set level, ie 2, 3 or 5
	 * 
	 * @param kt
	 * @param aes
	 * @return
	 */
	public static int getMLDSAKeytype(int kt) {
		int keytype = Pqmi.ML_DSA_KT_FLAG;

		switch (kt) {
		case 1, 2, 44:
			keytype |= Pqmi.ML_DSA_KT_44; 
			break;
		case 3, 65: 
			keytype |= Pqmi.ML_DSA_KT_65; 
			break;
		case 5, 87: 
			keytype |= Pqmi.ML_DSA_KT_87; 
			break;
		default:
			System.out.println("Invalid MLDSA key type, please supply 2 3 or 5, or 44 65 or 87");
			System.exit(-1);
		}
		return keytype;
	}
	
	public static int getModuleId(CryptoServerCXI cxi, String mdlName) {
		int mid = 0x0a6;
		try {
			int adm = 0x087; // ADM module
			int lma = 5; // ListModulesActive
			byte [] resp = cxi.exec(adm, lma, new byte[0]);
			ByteBuffer answ = ByteBuffer.wrap(resp);
			short objlen = answ.getShort();
			boolean found = false;
			while (!found && answ.hasRemaining()) {
				byte [] chunk = new byte[objlen];
				ByteBuffer module = answ.get(chunk);
				short mdlId = module.getShort();
				byte [] name = new byte[mdlName.length()]; // yes, it's hardwired
				module.get(name);
				String checkName = new String(name);
				if (mdlName.compareToIgnoreCase(checkName) == 0) {
					mid = mdlId;
					found = true;
				}
				module.position(module.position() + (12 - name.length));
				// int mdlVersion = module.getInt();
				module.position(module.position() + 4);
				// int mdlState = module.getInt();
				module.position(module.position() + 4);
				// short cpuType = module.getShort();
				module.position(module.position() + 2);
			}
		} catch (CryptoServerException e) {
			System.err.println("CryptoServerCXI Error: Could not list active modules.");
		} catch (IOException e) {
			System.err.println("IO Exception: Could not list active modules.");
		}
		return mid;
	}
}
